/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ui;

import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.functor.ArgsConfigurationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsConfigurable;
import de.intarsys.tools.ui.IUIComponent;
import de.intarsys.tools.ui.UIComponent;
import java.util.ArrayList;
import java.util.List;

public abstract class UIWizard<M extends INotificationSupport, C, T>
extends UIComponent<M, C, T> {
    private List<IUIComponent<M, C, T>> pages = new ArrayList<IUIComponent<M, C, T>>();
    private IUIComponent<M, C, T> currentPage;

    public UIWizard(IUIComponent iUIComponent) {
        super(iUIComponent);
        this.initPages();
    }

    protected void activatePage(IUIComponent<M, C, T> iUIComponent) {
        if (iUIComponent == this.currentPage) {
            return;
        }
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        this.currentPage = iUIComponent;
        this.currentPage.setObservable(this.getObservable());
        this.currentPage.createComponent(this.getComponent());
    }

    protected void addPage(IUIComponent<M, C, T> iUIComponent) {
        this.pages.add(iUIComponent);
    }

    @Override
    public void configure(IArgs iArgs) throws ArgsConfigurationException {
        super.configure(iArgs);
        for (IUIComponent<M, C, T> iUIComponent : this.pages) {
            if (!(iUIComponent instanceof IArgsConfigurable)) continue;
            ((IArgsConfigurable)((Object)iUIComponent)).configure(iArgs);
        }
    }

    @Override
    public void dispose() {
        if (this.currentPage != null) {
            this.currentPage.dispose();
        }
        super.dispose();
    }

    public IUIComponent<M, C, T> getCurrentPage() {
        return this.currentPage;
    }

    protected void initPages() {
    }

    public boolean isNextEnabled() {
        return this.selectNextPage() != this.currentPage;
    }

    public boolean isPreviousEnabled() {
        return this.selectPreviousPage() != this.currentPage;
    }

    public void onNextPressed() {
        this.activatePage(this.selectNextPage());
    }

    public void onPreviousPressed() {
        this.activatePage(this.selectPreviousPage());
    }

    protected IUIComponent<M, C, T> selectInitialPage() {
        if (this.currentPage == null) {
            return this.pages.get(0);
        }
        return this.currentPage;
    }

    protected IUIComponent<M, C, T> selectNextPage() {
        int n = this.pages.indexOf(this.currentPage);
        if (n == -1) {
            return this.currentPage;
        }
        if (n + 1 == this.pages.size()) {
            return this.currentPage;
        }
        return this.pages.get(n + 1);
    }

    protected IUIComponent<M, C, T> selectPreviousPage() {
        int n = this.pages.indexOf(this.currentPage);
        if (n == -1) {
            return this.currentPage;
        }
        if (n == 0) {
            return this.currentPage;
        }
        return this.pages.get(n - 1);
    }

    protected void setCurrentPage(IUIComponent<M, C, T> iUIComponent) {
        this.currentPage = iUIComponent;
    }

    @Override
    public void setObservable(M m) {
        if (this.currentPage != null) {
            this.currentPage.setObservable(m);
        }
        super.setObservable(m);
    }

    @Override
    protected void updateView(Event event) {
        super.updateView(event);
        if (this.currentPage == null) {
            IUIComponent<M, C, T> iUIComponent = this.selectInitialPage();
            this.activatePage(iUIComponent);
        }
    }
}

