/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.console.business.pdf.bookmarks;

import com.lowagie.text.pdf.SimpleBookmark;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class BookmarksProcessor {
    private List bookmarks;
    private int numberOfPages;

    public BookmarksProcessor(List bookmarks, int numberOfPages) {
        if (bookmarks != null) {
            this.bookmarks = Collections.unmodifiableList(bookmarks);
        }
        this.numberOfPages = numberOfPages;
    }

    public List processBookmarks(int startPage, int endPage, int pageOffset) {
        List books = null;
        if (this.bookmarks != null) {
            books = this.getCopyBookmarks(this.bookmarks);
            if (endPage < this.numberOfPages) {
                SimpleBookmark.eliminatePages((List)books, (int[])new int[]{endPage + 1, this.numberOfPages});
            }
            if (startPage > 1) {
                SimpleBookmark.eliminatePages((List)books, (int[])new int[]{1, startPage - 1});
                SimpleBookmark.shiftPageNumbers((List)books, (int)(-(startPage - 1)), null);
            }
            if (pageOffset != 0) {
                SimpleBookmark.shiftPageNumbers((List)books, (int)pageOffset, null);
            }
        }
        return books;
    }

    public List processBookmarks(int startPage, int endPage) {
        return this.processBookmarks(startPage, endPage, 0);
    }

    private List getCopyBookmarks(List inputBook) {
        ArrayList<HashMap> retVal = new ArrayList<HashMap>();
        ListIterator it = inputBook.listIterator();
        while (it.hasNext()) {
            HashMap map = (HashMap)it.next();
            retVal.add(this.getCopyMap(map));
        }
        return retVal;
    }

    private HashMap getCopyMap(HashMap map) {
        HashMap retVal = new HashMap();
        if (map != null) {
            Set entries = map.entrySet();
            Iterator it = entries.iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                if (entry.getValue() instanceof List) {
                    retVal.put(entry.getKey(), this.getCopyBookmarks((List)entry.getValue()));
                    continue;
                }
                retVal.put(entry.getKey(), (List<Object>)entry.getValue());
            }
        }
        return retVal;
    }
}

