/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.StandardSecurityHandler;
import de.intarsys.pdf.pd.AbstractBitFlags;

public class PermissionFlags
extends AbstractBitFlags {
    public static int Bit_Print = 4;
    public static int Bit_Modify = 8;
    public static int Bit_Copy = 16;
    public static int Bit_ModifyAnnotation = 32;
    public static int Bit_FillForm = 256;
    public static int Bit_Extract = 512;
    public static int Bit_Assemble = 1024;
    public static int Bit_PrintHighQuality = 2048;
    protected StandardSecurityHandler handler;

    public PermissionFlags(int n) {
        super(n);
    }

    public PermissionFlags(StandardSecurityHandler standardSecurityHandler) {
        super(standardSecurityHandler.getEncryption(), null);
        this.handler = standardSecurityHandler;
    }

    public StandardSecurityHandler getHandler() {
        return this.handler;
    }

    @Override
    protected int getValueInObject() {
        return this.getHandler().basicGetPermissionFlags();
    }

    public boolean mayAssemble() {
        return this.isSetAnd(Bit_Assemble);
    }

    public boolean mayCopy() {
        return this.isSetAnd(Bit_Copy);
    }

    public boolean mayExtract() {
        return this.isSetAnd(Bit_Extract);
    }

    public boolean mayFillForm() {
        return this.isSetAnd(Bit_FillForm);
    }

    public boolean mayModify() {
        return this.isSetAnd(Bit_Modify);
    }

    public boolean mayModifyAnnotation() {
        return this.isSetAnd(Bit_ModifyAnnotation);
    }

    public boolean mayPrint() {
        return this.isSetAnd(Bit_Print);
    }

    public boolean mayPrintHighQuality() {
        return this.isSetAnd(Bit_PrintHighQuality);
    }

    public void setMayAssemble(boolean bl) {
        this.set(Bit_Assemble, bl);
    }

    public void setMayCopy(boolean bl) {
        this.set(Bit_Copy, bl);
    }

    public void setMayExtract(boolean bl) {
        this.set(Bit_Extract, bl);
    }

    public void setMayFillForm(boolean bl) {
        this.set(Bit_FillForm, bl);
    }

    public void setMayModify(boolean bl) {
        this.set(Bit_Modify, bl);
    }

    public void setMayModifyAnnotation(boolean bl) {
        this.set(Bit_ModifyAnnotation, bl);
    }

    public void setMayPrint(boolean bl) {
        this.set(Bit_Print, bl);
    }

    public void setMayPrintHighQuality(boolean bl) {
        this.set(Bit_PrintHighQuality, bl);
    }

    @Override
    protected void setValueInObject(int n) {
        try {
            this.getHandler().basicSetPermissionFlags(n);
        }
        catch (COSSecurityException cOSSecurityException) {
            throw new SecurityException("security exception", cOSSecurityException);
        }
    }
}

