/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.LoaderBase;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import com.sun.j3d.loaders.SceneBase;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.IndexedLineArray;
import javax.media.j3d.IndexedLineStripArray;
import javax.media.j3d.Link;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.SharedGroup;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DAELoader
extends LoaderBase
implements Loader {
    private Boolean useCaches;

    public void setUseCaches(Boolean bl) {
        this.useCaches = (boolean)bl;
    }

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        URL uRL;
        try {
            uRL = this.basePath != null ? new File(this.basePath).toURI().toURL() : new File(string).toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException(string);
        }
        return this.load(new BufferedInputStream(new FileInputStream(string)), uRL);
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        InputStream inputStream;
        URL uRL2 = this.baseUrl;
        if (this.baseUrl == null) {
            uRL2 = uRL;
        }
        try {
            inputStream = this.openStream(uRL);
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Can't read " + uRL);
        }
        return this.load(new BufferedInputStream(inputStream), uRL2);
    }

    private InputStream openStream(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        if (this.useCaches != null) {
            uRLConnection.setUseCaches(this.useCaches);
        }
        return uRLConnection.getInputStream();
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        throw new UnsupportedOperationException();
    }

    private Scene load(InputStream inputStream, URL uRL) throws FileNotFoundException {
        try {
            Scene scene = this.parseXMLStream(inputStream, uRL);
            return scene;
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new ParsingErrorException(iOException.getMessage());
            }
        }
    }

    private Scene parseXMLStream(InputStream inputStream, URL uRL) throws IOException {
        try {
            SceneBase sceneBase = new SceneBase();
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputStream, (DefaultHandler)new DAEHandler(sceneBase, uRL));
            return sceneBase;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException("Can't parse XML stream");
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException("Can't parse XML stream");
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DAEHandler
    extends DefaultHandler {
        private final SceneBase scene;
        private final URL baseUrl;
        private final Stack<Group> parentGroups = new Stack();
        private final Stack<String> parentElements = new Stack();
        private final StringBuilder buffer = new StringBuilder();
        private final List<Runnable> postProcessingBinders = new ArrayList<Runnable>();
        private final Map<String, Texture> textures = new HashMap<String, Texture>();
        private final Map<String, Appearance> effectAppearances = new HashMap<String, Appearance>();
        private final Map<String, String> materialEffects = new HashMap<String, String>();
        private final Map<String, String> materialNames = new HashMap<String, String>();
        private final Map<String, String> surface2DIds = new HashMap<String, String>();
        private final Map<String, String> sampler2DIds = new HashMap<String, String>();
        private final Map<String, List<Geometry>> geometries = new HashMap<String, List<Geometry>>();
        private final Map<String, float[]> sources = new HashMap<String, float[]>();
        private final Map<String, float[]> positions = new HashMap<String, float[]>();
        private final Map<String, float[]> normals = new HashMap<String, float[]>();
        private final Map<String, float[]> textureCoordinates = new HashMap<String, float[]>();
        private final Map<String, float[]> floatArrays = new HashMap<String, float[]>();
        private final Map<float[], Integer> sourceAccessorStrides = new HashMap<float[], Integer>();
        private final Map<Geometry, String> geometryAppearances = new HashMap<Geometry, String>();
        private final List<int[]> facesAndLinesPrimitives = new ArrayList<int[]>();
        private final List<int[]> polygonsPrimitives = new ArrayList<int[]>();
        private final List<List<int[]>> polygonsHoles = new ArrayList<List<int[]>>();
        private final Map<String, TransformGroup> nodes = new HashMap<String, TransformGroup>();
        private final Map<String, SharedGroup> instantiatedNodes = new HashMap<String, SharedGroup>();
        private final Map<String, TransformGroup> visualScenes = new HashMap<String, TransformGroup>();
        private TransformGroup visualScene;
        private float[] floats;
        private float[] geometryVertices;
        private float[] geometryNormals;
        private float[] geometryTextureCoordinates;
        private int[] vcount;
        private float[] transparentColor;
        private Float transparency;
        private boolean inRootAsset;
        private boolean reverseTransparency;
        private String imageId;
        private String materialId;
        private String effectId;
        private String newParamSid;
        private boolean inSurface2D;
        private boolean inPhongBlinnOrLambert;
        private String techniqueProfile;
        private boolean inConstant;
        private String geometryId;
        private String meshSourceId;
        private String verticesId;
        private String floatArrayId;
        private String geometryAppearance;
        private int geometryVertexOffset;
        private int geometryNormalOffset;
        private int geometryTextureCoordinatesOffset;
        private String axis;
        private float meterScale = 1.0f;
        private float floatValue;
        private String opaque;
        private int inputCount;

        public DAEHandler(SceneBase sceneBase, URL uRL) {
            this.scene = sceneBase;
            this.baseUrl = uRL;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            String string5;
            this.buffer.setLength(0);
            String string6 = string5 = this.parentElements.isEmpty() ? null : this.parentElements.peek();
            if (string5 == null && !"COLLADA".equals(string3)) {
                throw new SAXException("Expected COLLADA element");
            }
            if ("COLLADA".equals(string3)) {
                String string7 = attributes.getValue("version");
                if (!string7.startsWith("1.4")) {
                    throw new SAXException("Version " + string7 + " not supported");
                }
            } else if ("COLLADA".equals(string5) && "asset".equals(string3)) {
                this.inRootAsset = true;
            } else if ("asset".equals(string5) && "unit".equals(string3)) {
                String string8 = attributes.getValue("meter");
                if (string8 != null) {
                    this.meterScale = Float.parseFloat(string8);
                }
            } else if ("image".equals(string3)) {
                this.imageId = attributes.getValue("id");
            } else if ("material".equals(string3)) {
                this.materialId = attributes.getValue("id");
                this.materialNames.put(this.materialId, attributes.getValue("name"));
            } else if ("material".equals(string5) && "instance_effect".equals(string3)) {
                String string9 = attributes.getValue("url");
                if (string9.startsWith("#")) {
                    String string10 = string9.substring(1);
                    this.materialEffects.put(this.materialId, string10);
                }
            } else if ("effect".equals(string3)) {
                this.effectId = attributes.getValue("id");
                this.effectAppearances.put(this.effectId, new Appearance());
            } else if (this.effectId != null) {
                if ("profile_COMMON".equals(string5) && "newparam".equals(string3)) {
                    this.newParamSid = attributes.getValue("sid");
                } else if ("newparam".equals(string5) && "surface".equals(string3) && "2D".equals(attributes.getValue("type"))) {
                    this.inSurface2D = true;
                } else if ("extra".equals(string5) && "technique".equals(string3)) {
                    this.techniqueProfile = attributes.getValue("profile");
                } else if ("phong".equals(string3) || "blinn".equals(string3)) {
                    this.inPhongBlinnOrLambert = true;
                } else if ("lambert".equals(string3)) {
                    this.inPhongBlinnOrLambert = true;
                    this.getAppearanceMaterial(this.effectId).setSpecularColor(0.0f, 0.0f, 0.0f);
                    this.getAppearanceMaterial(this.effectId).setShininess(1.0f);
                } else if ("constant".equals(string3)) {
                    this.inConstant = true;
                } else if (this.inConstant || this.inPhongBlinnOrLambert && "transparent".equals(string3)) {
                    this.opaque = attributes.getValue("opaque");
                    if (this.opaque == null) {
                        this.opaque = "A_ONE";
                    }
                } else if ("texture".equals(string3) && "diffuse".equals(string5)) {
                    final String string11 = this.surface2DIds.get(this.sampler2DIds.get(attributes.getValue("texture")));
                    final Appearance appearance = this.effectAppearances.get(this.effectId);
                    this.postProcessingBinders.add(new Runnable(){

                        public void run() {
                            appearance.setTexture((Texture)DAEHandler.this.textures.get(string11));
                        }
                    });
                }
            } else if ("geometry".equals(string3)) {
                this.geometryId = attributes.getValue("id");
                this.geometries.put(this.geometryId, new ArrayList());
            } else if (this.geometryId != null) {
                if ("mesh".equals(string5) && "source".equals(string3)) {
                    this.meshSourceId = attributes.getValue("id");
                } else if ("mesh".equals(string5) && "vertices".equals(string3)) {
                    this.verticesId = attributes.getValue("id");
                } else if (this.meshSourceId != null) {
                    if ("float_array".equals(string3)) {
                        this.floatArrayId = attributes.getValue("id");
                    } else if ("technique_common".equals(string5) && "accessor".equals(string3)) {
                        String string12 = attributes.getValue("source").substring(1);
                        String string13 = attributes.getValue("stride");
                        this.sourceAccessorStrides.put(this.floatArrays.get(string12), string13 != null ? Integer.valueOf(string13) : 1);
                    }
                } else if (this.verticesId != null && "input".equals(string3)) {
                    String string14 = attributes.getValue("source").substring(1);
                    if ("POSITION".equals(attributes.getValue("semantic"))) {
                        this.positions.put(this.verticesId, this.sources.get(string14));
                    } else if ("NORMAL".equals(attributes.getValue("semantic"))) {
                        this.normals.put(this.verticesId, this.sources.get(string14));
                    } else if ("TEXCOORD".equals(attributes.getValue("semantic"))) {
                        this.textureCoordinates.put(this.verticesId, this.sources.get(string14));
                    }
                } else if (this.verticesId == null && "input".equals(string3)) {
                    String string15 = attributes.getValue("source").substring(1);
                    int n = Integer.parseInt(attributes.getValue("offset"));
                    if (this.inputCount < n + 1) {
                        this.inputCount = n + 1;
                    }
                    if ("VERTEX".equals(attributes.getValue("semantic"))) {
                        this.geometryVertices = this.positions.get(string15);
                        this.geometryVertexOffset = n;
                        if (this.geometryNormals == null) {
                            this.geometryNormals = this.normals.get(string15);
                            this.geometryNormalOffset = n;
                        }
                        if (this.geometryTextureCoordinates == null) {
                            this.geometryTextureCoordinates = this.textureCoordinates.get(string15);
                            this.geometryTextureCoordinatesOffset = n;
                        }
                    } else if ("NORMAL".equals(attributes.getValue("semantic"))) {
                        this.geometryNormals = this.sources.get(string15);
                        this.geometryNormalOffset = n;
                    } else if ("TEXCOORD".equals(attributes.getValue("semantic"))) {
                        this.geometryTextureCoordinates = this.sources.get(string15);
                        this.geometryTextureCoordinatesOffset = n;
                    }
                } else if ("triangles".equals(string3) || "trifans".equals(string3) || "tristrips".equals(string3) || "polylist".equals(string3) || "polygons".equals(string3) || "lines".equals(string3) || "linestrips".equals(string3)) {
                    this.geometryAppearance = attributes.getValue("material");
                    this.inputCount = 0;
                    this.facesAndLinesPrimitives.clear();
                    this.polygonsPrimitives.clear();
                    this.polygonsHoles.clear();
                    this.vcount = null;
                }
            } else if ("visual_scene".equals(string3)) {
                TransformGroup transformGroup = new TransformGroup();
                this.parentGroups.push((Group)transformGroup);
                this.visualScenes.put(attributes.getValue("id"), transformGroup);
            } else if ("node".equals(string3)) {
                TransformGroup transformGroup = new TransformGroup();
                if (this.parentGroups.size() > 0) {
                    this.parentGroups.peek().addChild((Node)transformGroup);
                }
                this.parentGroups.push((Group)transformGroup);
                this.nodes.put(attributes.getValue("id"), transformGroup);
                String string16 = attributes.getValue("name");
                if (string16 != null) {
                    this.scene.addNamedObject(string16, (Object)transformGroup);
                }
            } else if ("node".equals(string5) && "instance_geometry".equals(string3)) {
                String string17 = attributes.getValue("url");
                if (string17.startsWith("#")) {
                    final String string18 = string17.substring(1);
                    final String string19 = attributes.getValue("name");
                    final Group group = new Group();
                    this.parentGroups.peek().addChild((Node)group);
                    this.parentGroups.push(group);
                    this.postProcessingBinders.add(new Runnable(){

                        public void run() {
                            int n = 0;
                            for (Geometry geometry : (List)DAEHandler.this.geometries.get(string18)) {
                                Shape3D shape3D = new Shape3D(geometry);
                                group.addChild((Node)shape3D);
                                if (string19 == null) continue;
                                if (n == 0) {
                                    DAEHandler.this.scene.addNamedObject(string19, (Object)shape3D);
                                } else {
                                    DAEHandler.this.scene.addNamedObject(string19 + "_" + n, (Object)shape3D);
                                }
                                ++n;
                            }
                        }
                    });
                }
            } else if ("instance_node".equals(string3)) {
                String string20 = attributes.getValue("url");
                if (string20.startsWith("#")) {
                    final String string21 = string20.substring(1);
                    final Group group = this.parentGroups.peek();
                    this.postProcessingBinders.add(new Runnable(){

                        public void run() {
                            SharedGroup sharedGroup = (SharedGroup)DAEHandler.this.instantiatedNodes.get(string21);
                            if (sharedGroup == null) {
                                sharedGroup = new SharedGroup();
                                sharedGroup.addChild((Node)DAEHandler.this.nodes.get(string21));
                                DAEHandler.this.instantiatedNodes.put(string21, sharedGroup);
                            }
                            group.addChild((Node)new Link(sharedGroup));
                        }
                    });
                }
            } else if ("instance_material".equals(string3) && !this.parentGroups.empty()) {
                String string22 = attributes.getValue("target");
                if (string22.startsWith("#")) {
                    final String string23 = string22.substring(1);
                    final String string24 = attributes.getValue("symbol");
                    final Group group = this.parentGroups.peek();
                    this.postProcessingBinders.add(new Runnable(){

                        public void run() {
                            Appearance appearance = (Appearance)DAEHandler.this.effectAppearances.get(DAEHandler.this.materialEffects.get(string23));
                            this.updateShapeAppearance((Node)group, appearance);
                            try {
                                appearance.setName((String)DAEHandler.this.materialNames.get(string23));
                            }
                            catch (NoSuchMethodError noSuchMethodError) {
                                // empty catch block
                            }
                        }

                        private void updateShapeAppearance(Node node, Appearance appearance) {
                            if (node instanceof Group) {
                                Enumeration enumeration = ((Group)node).getAllChildren();
                                while (enumeration.hasMoreElements()) {
                                    this.updateShapeAppearance((Node)enumeration.nextElement(), appearance);
                                }
                            } else if (node instanceof Link) {
                                this.updateShapeAppearance((Node)((Link)node).getSharedGroup(), appearance);
                            } else if (node instanceof Shape3D && string24.equals(DAEHandler.this.geometryAppearances.get(((Shape3D)node).getGeometry()))) {
                                ((Shape3D)node).setAppearance(appearance);
                            }
                        }
                    });
                }
            } else if ("instance_visual_scene".equals(string3) && (string4 = attributes.getValue("url")).startsWith("#")) {
                final String string25 = string4.substring(1);
                this.postProcessingBinders.add(new Runnable(){

                    public void run() {
                        DAEHandler.this.visualScene = (TransformGroup)DAEHandler.this.visualScenes.get(string25);
                    }
                });
            }
            this.parentElements.push(string3);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.buffer.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            Transform3D transform3D;
            String string4;
            this.parentElements.pop();
            String string5 = string4 = this.parentElements.isEmpty() ? null : this.parentElements.peek();
            if ("color".equals(string3) || "float_array".equals(string3) || "matrix".equals(string3) || "rotate".equals(string3) || "scale".equals(string3) || "translate".equals(string3)) {
                transform3D = this.getCharacters().split("\\s");
                this.floats = new float[((String[])transform3D).length];
                int n = 0;
                for (int i = 0; i < ((String[])transform3D).length; ++i) {
                    float f;
                    if (transform3D[i].length() <= 0) continue;
                    try {
                        f = Float.parseFloat(transform3D[i]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        f = 0.0f;
                    }
                    this.floats[n++] = f;
                }
                if (n != ((String[])transform3D).length) {
                    float[] fArray = new float[n];
                    System.arraycopy(this.floats, 0, fArray, 0, n);
                    this.floats = fArray;
                }
                if (this.floatArrayId != null) {
                    this.floatArrays.put(this.floatArrayId, this.floats);
                    this.floatArrayId = null;
                }
            } else if ("float".equals(string3)) {
                this.floatValue = Float.parseFloat(this.getCharacters());
            }
            if (this.inRootAsset) {
                this.handleRootAssetElementsEnd(string3);
            } else if ("image".equals(string3)) {
                this.imageId = null;
            } else if (this.imageId != null) {
                this.handleImageElementsEnd(string3);
            } else if ("material".equals(string3)) {
                this.materialId = null;
            } else if ("effect".equals(string3)) {
                this.effectId = null;
            } else if (this.effectId != null) {
                this.handleEffectElementsEnd(string3, string4);
            } else if ("geometry".equals(string3)) {
                this.geometryId = null;
            }
            if (this.geometryId != null) {
                this.handleGeometryElementsEnd(string3, string4);
            } else if ("visual_scene".equals(string3) || "node".equals(string3) || "node".equals(string4) && "instance_geometry".equals(string3)) {
                this.parentGroups.pop();
            } else if ("matrix".equals(string3)) {
                this.mulTransformGroup(new Transform3D(this.floats));
            } else if ("node".equals(string4) && "rotate".equals(string3)) {
                transform3D = new Transform3D();
                transform3D.setRotation(new AxisAngle4f(this.floats[0], this.floats[1], this.floats[2], (float)Math.toRadians(this.floats[3])));
                this.mulTransformGroup(transform3D);
            } else if ("scale".equals(string3)) {
                transform3D = new Transform3D();
                transform3D.setScale(new Vector3d((double)this.floats[0], (double)this.floats[1], (double)this.floats[2]));
                this.mulTransformGroup(transform3D);
            } else if ("node".equals(string4) && "translate".equals(string3)) {
                transform3D = new Transform3D();
                transform3D.setTranslation(new Vector3f(this.floats[0], this.floats[1], this.floats[2]));
                this.mulTransformGroup(transform3D);
            }
        }

        private String getCharacters() {
            return this.buffer.toString().trim();
        }

        private void handleRootAssetElementsEnd(String string) {
            String string2;
            String string3;
            if ("asset".equals(string)) {
                this.inRootAsset = false;
            } else if ("up_axis".equals(string)) {
                this.axis = this.getCharacters();
            } else if ("subject".equals(string)) {
                this.scene.addDescription(this.getCharacters());
            } else if ("authoring_tool".equals(string) && (string3 = this.getCharacters()).startsWith("Google SketchUp") && (string2 = string3.substring("Google SketchUp".length()).trim()).length() > 0) {
                int n = string2.indexOf(46);
                String string4 = n == -1 ? string2 : string2.substring(0, n);
                try {
                    int n2 = Integer.parseInt(string4);
                    if (n2 < 7 || n2 == 7 && (n >= string2.length() - 1 || string2.charAt(n + 1) < '1')) {
                        this.reverseTransparency = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void handleImageElementsEnd(String string) throws SAXException {
            if ("init_from".equals(string)) {
                InputStream inputStream = null;
                try {
                    URL uRL = new URL(this.baseUrl, this.getCharacters().replace("#", "%23"));
                    inputStream = DAELoader.this.openStream(uRL);
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    if (bufferedImage == null) return;
                    TextureLoader textureLoader = new TextureLoader(bufferedImage);
                    Texture texture = textureLoader.getTexture();
                    texture.setUserData((Object)uRL);
                    this.textures.put(this.imageId, texture);
                    return;
                }
                catch (IOException iOException) {
                    if (inputStream == null) return;
                    try {
                        inputStream.close();
                        return;
                    }
                    catch (IOException iOException2) {
                        throw new SAXException("Issue while closing stream", iOException2);
                    }
                }
                catch (RuntimeException runtimeException) {
                    if (!runtimeException.getClass().getName().equals("com.sun.j3d.utils.image.ImageException")) throw runtimeException;
                    return;
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            throw new SAXException("Issue while closing stream", iOException);
                        }
                    }
                }
            }
            if (!"data".equals(string)) return;
            throw new SAXException("<data> not supported");
        }

        private void handleEffectElementsEnd(String string, String string2) {
            if ("profile_COMMON".equals(string2) && "newparam".equals(string)) {
                this.newParamSid = null;
            } else if ("newparam".equals(string2) && "surface".equals(string)) {
                this.inSurface2D = false;
            } else if (this.newParamSid != null) {
                if (this.inSurface2D && "init_from".equals(string)) {
                    this.surface2DIds.put(this.newParamSid, this.getCharacters());
                } else if ("sampler2D".equals(string2) && "source".equals(string)) {
                    this.sampler2DIds.put(this.newParamSid, this.getCharacters());
                }
            } else if ("extra".equals(string2) && "technique".equals(string)) {
                this.techniqueProfile = null;
            } else if ("phong".equals(string) || "blinn".equals(string) || "lambert".equals(string) || "constant".equals(string)) {
                float f;
                if (this.transparentColor != null) {
                    if ("RGB_ZERO".equals(this.opaque)) {
                        f = this.transparentColor[0] * 0.212671f + this.transparentColor[1] * 0.71516f + this.transparentColor[2] * 0.072169f;
                        if (this.transparency != null) {
                            f *= this.transparency.floatValue();
                        }
                    } else {
                        f = this.transparency != null ? 1.0f - this.transparentColor[3] * this.transparency.floatValue() : 1.0f - this.transparentColor[3];
                        if (this.reverseTransparency) {
                            f = 1.0f - f;
                        }
                    }
                } else {
                    f = 0.0f;
                }
                Appearance appearance = this.effectAppearances.get(this.effectId);
                if (f > 0.0f) {
                    appearance.setTransparencyAttributes(new TransparencyAttributes(1, f));
                } else {
                    Color3f color3f = new Color3f();
                    if (appearance.getMaterial() == null) {
                        appearance.setMaterial(new Material(color3f, color3f, color3f, color3f, 1.0f));
                        appearance.setColoringAttributes(new ColoringAttributes(color3f, 3));
                    }
                }
                this.transparentColor = null;
                this.transparency = null;
                this.inPhongBlinnOrLambert = false;
                this.inConstant = false;
            } else if (this.inConstant || this.inPhongBlinnOrLambert) {
                if ("color".equals(string)) {
                    if ("emission".equals(string2)) {
                        if (this.inPhongBlinnOrLambert) {
                            this.getAppearanceMaterial(this.effectId).setEmissiveColor(this.floats[0], this.floats[1], this.floats[2]);
                        } else {
                            this.effectAppearances.get(this.effectId).setColoringAttributes(new ColoringAttributes(this.floats[0], this.floats[1], this.floats[2], 3));
                        }
                    } else if ("ambient".equals(string2)) {
                        this.getAppearanceMaterial(this.effectId).setAmbientColor(this.floats[0], this.floats[1], this.floats[2]);
                    } else if ("diffuse".equals(string2)) {
                        this.getAppearanceMaterial(this.effectId).setDiffuseColor(this.floats[0], this.floats[1], this.floats[2], this.floats[3]);
                        this.effectAppearances.get(this.effectId).setColoringAttributes(new ColoringAttributes(this.floats[0], this.floats[1], this.floats[2], 3));
                    } else if ("specular".equals(string2)) {
                        this.getAppearanceMaterial(this.effectId).setSpecularColor(this.floats[0], this.floats[1], this.floats[2]);
                    } else if ("transparent".equals(string2)) {
                        this.transparentColor = this.floats;
                    }
                } else if ("float".equals(string)) {
                    if ("shininess".equals(string2)) {
                        this.getAppearanceMaterial(this.effectId).setShininess(this.floatValue);
                    } else if ("transparency".equals(string2)) {
                        this.transparency = Float.valueOf(this.floatValue);
                    }
                }
            } else if ("double_sided".equals(string) && "1".equals(this.getCharacters()) && ("GOOGLEEARTH".equals(this.techniqueProfile) || "MAX3D".equals(this.techniqueProfile) || "MAYA".equals(this.techniqueProfile))) {
                this.effectAppearances.get(this.effectId).setPolygonAttributes(new PolygonAttributes(2, 0, 0.0f));
            }
        }

        private Material getAppearanceMaterial(String string) {
            Appearance appearance = this.effectAppearances.get(string);
            Material material = appearance.getMaterial();
            if (material == null) {
                material = new Material();
                appearance.setMaterial(material);
            }
            return material;
        }

        private void handleGeometryElementsEnd(String string, String string2) {
            if ("mesh".equals(string2) && "source".equals(string)) {
                this.sources.put(this.meshSourceId, this.floats);
                this.meshSourceId = null;
            } else if ("mesh".equals(string2) && "vertices".equals(string)) {
                this.verticesId = null;
            } else if ("p".equals(string) || "h".equals(string) || "vcount".equals(string)) {
                String[] stringArray = this.getCharacters().split("\\s");
                int[] nArray = new int[stringArray.length];
                int n = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() <= 0) continue;
                    nArray[n++] = Integer.parseInt(stringArray[i]);
                }
                if (n != stringArray.length) {
                    int[] nArray2 = new int[n];
                    System.arraycopy(nArray, 0, nArray2, 0, n);
                    nArray = nArray2;
                }
                if (!"ph".equals(string2) && "p".equals(string)) {
                    this.facesAndLinesPrimitives.add(nArray);
                } else if ("vcount".equals(string)) {
                    this.vcount = nArray;
                } else if ("ph".equals(string2)) {
                    if ("p".equals(string)) {
                        this.polygonsPrimitives.add(nArray);
                    } else if ("h".equals(string)) {
                        if (this.polygonsPrimitives.size() > this.polygonsHoles.size()) {
                            this.polygonsHoles.add(new ArrayList());
                        }
                        this.polygonsHoles.get(this.polygonsPrimitives.size() - 1).add(nArray);
                    }
                }
            } else if (("triangles".equals(string) || "trifans".equals(string) || "tristrips".equals(string) || "polylist".equals(string) || "polygons".equals(string) || "lines".equals(string) || "linestrips".equals(string)) && this.geometryVertices != null) {
                Geometry geometry = "lines".equals(string) || "linestrips".equals(string) ? this.getLinesGeometry(string) : this.getFacesGeometry(string);
                if (geometry != null) {
                    this.geometries.get(this.geometryId).add(geometry);
                    if (this.geometryAppearance != null) {
                        this.geometryAppearances.put(geometry, this.geometryAppearance);
                    }
                }
                this.geometryAppearance = null;
                this.geometryVertices = null;
                this.geometryNormals = null;
                this.geometryTextureCoordinates = null;
                this.facesAndLinesPrimitives.clear();
                this.polygonsPrimitives.clear();
                this.polygonsHoles.clear();
                this.vcount = null;
            }
        }

        private Geometry getFacesGeometry(String string) {
            int n;
            Object object;
            Object object2;
            int n2 = "triangles".equals(string) ? 1 : ("trifans".equals(string) ? 3 : ("tristrips".equals(string) ? 4 : 5));
            GeometryInfo geometryInfo = new GeometryInfo(n2);
            geometryInfo.setCoordinates(this.geometryVertices);
            geometryInfo.setCoordinateIndices(this.getIndices(this.geometryVertexOffset));
            if (this.geometryNormals != null) {
                geometryInfo.setNormals(this.geometryNormals);
                geometryInfo.setNormalIndices(this.getIndices(this.geometryNormalOffset));
            }
            if (this.geometryTextureCoordinates != null) {
                object2 = this.sourceAccessorStrides.get(this.geometryTextureCoordinates);
                if ((Integer)object2 > 2) {
                    object = new float[this.geometryTextureCoordinates.length / (Integer)object2 * 2];
                    int n3 = 0;
                    for (n = 0; n < this.geometryTextureCoordinates.length; n += ((Integer)object2).intValue()) {
                        object[n3++] = this.geometryTextureCoordinates[n];
                        object[n3++] = this.geometryTextureCoordinates[n + 1];
                    }
                } else {
                    object = this.geometryTextureCoordinates;
                }
                geometryInfo.setTextureCoordinateParams(1, 2);
                geometryInfo.setTextureCoordinates(0, object);
                geometryInfo.setTextureCoordinateIndices(0, this.getIndices(this.geometryTextureCoordinatesOffset));
            }
            if ("trifans".equals(string) || "tristrips".equals(string)) {
                object2 = new int[this.facesAndLinesPrimitives.size()];
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    object2[i] = this.facesAndLinesPrimitives.get(i).length / this.inputCount;
                }
                geometryInfo.setStripCounts((int[])object2);
            } else if ("polylist".equals(string)) {
                geometryInfo.setStripCounts(this.vcount);
            } else if ("polygons".equals(string)) {
                int n4;
                int n5 = 0;
                object = this.polygonsHoles.iterator();
                while (object.hasNext()) {
                    List list = (List)object.next();
                    n5 += list.size();
                }
                object = new int[this.facesAndLinesPrimitives.size() + this.polygonsPrimitives.size() + n5];
                int[] nArray = new int[this.facesAndLinesPrimitives.size() + this.polygonsPrimitives.size()];
                n = 0;
                int n6 = 0;
                for (n4 = 0; n4 < this.facesAndLinesPrimitives.size(); ++n4) {
                    object[n++] = this.facesAndLinesPrimitives.get(n4).length / this.inputCount;
                    nArray[n6++] = 1;
                }
                for (n4 = 0; n4 < this.polygonsPrimitives.size(); ++n4) {
                    object[n++] = this.polygonsPrimitives.get(n4).length / this.inputCount;
                    List<int[]> list = this.polygonsHoles.get(n4);
                    for (int i = 0; i < list.size(); ++i) {
                        object[n++] = list.get(i).length / this.inputCount;
                    }
                    nArray[n6++] = 1 + list.size();
                }
                geometryInfo.setStripCounts((int[])object);
                geometryInfo.setContourCounts(nArray);
            }
            if (this.geometryNormals == null) {
                new NormalGenerator(1.5707963267948966).generateNormals(geometryInfo);
            }
            return geometryInfo.getGeometryArray(true, true, false);
        }

        private Geometry getLinesGeometry(String string) {
            int[] nArray;
            int n = 1;
            if (this.geometryNormals != null) {
                n |= 2;
            }
            if (this.geometryTextureCoordinates != null) {
                n |= 0x20;
            }
            if ((nArray = this.getIndices(this.geometryVertexOffset)).length != 0) {
                IndexedLineArray indexedLineArray;
                if ("lines".equals(string)) {
                    indexedLineArray = new IndexedLineArray(this.geometryVertices.length / 3, n, nArray.length);
                } else {
                    int[] nArray2 = new int[this.facesAndLinesPrimitives.size()];
                    for (int i = 0; i < nArray2.length; ++i) {
                        nArray2[i] = this.facesAndLinesPrimitives.get(i).length / this.inputCount;
                    }
                    indexedLineArray = new IndexedLineStripArray(this.geometryVertices.length / 3, n, nArray.length, nArray2);
                }
                indexedLineArray.setCoordinates(0, this.geometryVertices);
                indexedLineArray.setCoordinateIndices(0, nArray);
                if (this.geometryNormals != null) {
                    indexedLineArray.setNormals(0, this.geometryNormals);
                    indexedLineArray.setNormalIndices(0, this.getIndices(this.geometryNormalOffset));
                }
                if (this.geometryTextureCoordinates != null) {
                    indexedLineArray.setTextureCoordinates(0, 0, this.geometryTextureCoordinates);
                    indexedLineArray.setTextureCoordinateIndices(0, 0, this.getIndices(this.geometryTextureCoordinatesOffset));
                }
                return indexedLineArray;
            }
            return null;
        }

        private int[] getIndices(int n) {
            if (this.facesAndLinesPrimitives.size() == 1 && this.polygonsPrimitives.size() == 1 && this.inputCount == 1) {
                return this.facesAndLinesPrimitives.get(0);
            }
            int n2 = this.getIndexCount(this.facesAndLinesPrimitives);
            n2 += this.getIndexCount(this.polygonsPrimitives);
            for (List<int[]> list : this.polygonsHoles) {
                n2 += this.getIndexCount(list);
            }
            Object object = new int[n2 / this.inputCount];
            int n3 = 0;
            for (int[] nArray : this.facesAndLinesPrimitives) {
                for (int i = n; i < nArray.length; i += this.inputCount) {
                    object[n3++] = nArray[i];
                }
            }
            for (int i = 0; i < this.polygonsPrimitives.size(); ++i) {
                int[] nArray;
                nArray = this.polygonsPrimitives.get(i);
                for (int j = n; j < nArray.length; j += this.inputCount) {
                    object[n3++] = nArray[j];
                }
                for (int[] nArray2 : this.polygonsHoles.get(i)) {
                    for (int j = n; j < nArray2.length; j += this.inputCount) {
                        object[n3++] = nArray2[j];
                    }
                }
            }
            return object;
        }

        private int getIndexCount(List<int[]> list) {
            int n = 0;
            for (int[] nArray : list) {
                n += nArray.length;
            }
            return n;
        }

        private void mulTransformGroup(Transform3D transform3D) {
            TransformGroup transformGroup = (TransformGroup)this.parentGroups.peek();
            Transform3D transform3D2 = new Transform3D();
            transformGroup.getTransform(transform3D2);
            transform3D2.mul(transform3D);
            transformGroup.setTransform(transform3D2);
        }

        @Override
        public void endDocument() throws SAXException {
            for (Runnable runnable : this.postProcessingBinders) {
                runnable.run();
            }
            if (this.visualScene != null) {
                Transform3D transform3D;
                Point3d point3d;
                Runnable runnable;
                Transform3D transform3D2 = new Transform3D();
                this.visualScene.getTransform(transform3D2);
                runnable = new BoundingBox(new Point3d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), new Point3d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY));
                this.computeBounds((Node)this.visualScene, (BoundingBox)runnable, new Transform3D());
                Point3d point3d2 = new Point3d();
                runnable.getLower(point3d2);
                if (point3d2.x != Double.POSITIVE_INFINITY) {
                    point3d = new Point3d();
                    runnable.getUpper(point3d);
                    transform3D = new Transform3D();
                    transform3D.setTranslation(new Vector3d(-point3d2.x - (point3d.x - point3d2.x) / 2.0, -point3d2.y - (point3d.y - point3d2.y) / 2.0, -point3d2.z - (point3d.z - point3d2.z) / 2.0));
                    transform3D.mul(transform3D2);
                    transform3D2 = transform3D;
                }
                point3d = new Transform3D();
                point3d.setScale((double)(this.meterScale * 100.0f));
                point3d.mul(transform3D2);
                transform3D = new Transform3D();
                if ("Z_UP".equals(this.axis)) {
                    transform3D.rotX(-1.5707963267948966);
                } else if ("X_UP".equals(this.axis)) {
                    transform3D.rotZ(1.5707963267948966);
                }
                transform3D.mul((Transform3D)point3d);
                this.visualScene.setTransform(transform3D);
                BranchGroup branchGroup = new BranchGroup();
                this.scene.setSceneGroup(branchGroup);
                branchGroup.addChild((Node)this.visualScene);
            }
        }

        private void computeBounds(Node node, BoundingBox boundingBox, Transform3D transform3D) {
            if (node instanceof Group) {
                Enumeration enumeration;
                if (node instanceof TransformGroup) {
                    transform3D = new Transform3D(transform3D);
                    enumeration = new Transform3D();
                    ((TransformGroup)node).getTransform((Transform3D)enumeration);
                    transform3D.mul((Transform3D)enumeration);
                }
                enumeration = ((Group)node).getAllChildren();
                while (enumeration.hasMoreElements()) {
                    this.computeBounds((Node)enumeration.nextElement(), boundingBox, transform3D);
                }
            } else if (node instanceof Link) {
                this.computeBounds((Node)((Link)node).getSharedGroup(), boundingBox, transform3D);
            } else if (node instanceof Shape3D) {
                Bounds bounds = ((Shape3D)node).getBounds();
                bounds.transform(transform3D);
                boundingBox.combine(bounds);
            }
        }
    }
}

