/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.ControllerAction;
import com.eteks.sweethome3d.swing.ResourceAction;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.HelpController;
import com.eteks.sweethome3d.viewcontroller.HelpView;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;

public class HelpPane
extends JRootPane
implements HelpView {
    private final UserPreferences preferences;
    private JFrame frame;
    private JLabel searchLabel;
    private JTextField searchTextField;
    private JEditorPane helpEditorPane;

    public HelpPane(UserPreferences userPreferences, final HelpController helpController) {
        this.preferences = userPreferences;
        this.createActions(userPreferences, helpController);
        this.createComponents(userPreferences, helpController);
        this.setMnemonics(userPreferences);
        this.layoutComponents();
        this.addLanguageListener(userPreferences);
        if (helpController != null) {
            this.addHyperlinkListener(helpController);
            this.installKeyboardActions();
        }
        this.setPage(helpController.getHelpPage());
        helpController.addPropertyChangeListener(HelpController.Property.HELP_PAGE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HelpPane.this.setPage(helpController.getHelpPage());
                HelpPane.this.highlightText(helpController.getHighlightedText());
            }
        });
        helpController.addPropertyChangeListener(HelpController.Property.BROWSER_PAGE, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingTools.showDocumentInBrowser(helpController.getBrowserPage());
            }
        });
    }

    private void createActions(UserPreferences userPreferences, final HelpController helpController) {
        ActionMap actionMap = this.getActionMap();
        try {
            final ControllerAction controllerAction = new ControllerAction(userPreferences, HelpPane.class, ActionType.SHOW_PREVIOUS.name(), helpController, "showPrevious", new Object[0]);
            controllerAction.setEnabled(helpController.isPreviousPageEnabled());
            helpController.addPropertyChangeListener(HelpController.Property.PREVIOUS_PAGE_ENABLED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    controllerAction.setEnabled(helpController.isPreviousPageEnabled());
                }
            });
            actionMap.put((Object)ActionType.SHOW_PREVIOUS, controllerAction);
            final ControllerAction controllerAction2 = new ControllerAction(userPreferences, HelpPane.class, ActionType.SHOW_NEXT.name(), helpController, "showNext", new Object[0]);
            controllerAction2.setEnabled(helpController.isNextPageEnabled());
            helpController.addPropertyChangeListener(HelpController.Property.NEXT_PAGE_ENABLED, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    controllerAction2.setEnabled(helpController.isNextPageEnabled());
                }
            });
            actionMap.put((Object)ActionType.SHOW_NEXT, controllerAction2);
            actionMap.put((Object)ActionType.SEARCH, new ResourceAction(userPreferences, HelpPane.class, ActionType.SEARCH.name()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(ActionEvent actionEvent) {
                    Cursor cursor = HelpPane.this.getCursor();
                    HelpPane.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        String string = HelpPane.this.searchTextField.getText().trim();
                        if (string.length() > 0) {
                            helpController.search(string);
                        }
                    }
                    finally {
                        HelpPane.this.setCursor(cursor);
                    }
                }
            });
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        actionMap.put((Object)ActionType.CLOSE, new ResourceAction(userPreferences, HelpPane.class, ActionType.CLOSE.name(), true){

            public void actionPerformed(ActionEvent actionEvent) {
                HelpPane.this.frame.setVisible(false);
            }
        });
    }

    private void addLanguageListener(UserPreferences userPreferences) {
        userPreferences.addPropertyChangeListener(UserPreferences.Property.LANGUAGE, new LanguageChangeListener(this));
    }

    private void createComponents(UserPreferences userPreferences, final HelpController helpController) {
        this.searchLabel = new JLabel(SwingTools.getLocalizedLabelText(userPreferences, HelpPane.class, "searchLabel.text", new Object[0]));
        this.searchTextField = new JTextField(12);
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            this.searchTextField.putClientProperty("JTextField.variant", "search");
            this.searchTextField.putClientProperty("JTextField.Search.FindAction", this.getActionMap().get((Object)ActionType.SEARCH));
        }
        this.searchTextField.addActionListener(this.getActionMap().get((Object)ActionType.SEARCH));
        this.searchTextField.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                HelpPane.this.getActionMap().get((Object)ActionType.SEARCH).setEnabled(HelpPane.this.searchTextField.getText().trim().length() > 0);
                helpController.setHighlightedText(HelpPane.this.searchTextField.getText());
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.changedUpdate(documentEvent);
            }
        });
        this.helpEditorPane = new JEditorPane();
        this.helpEditorPane.setBorder(null);
        this.helpEditorPane.setEditable(false);
        this.helpEditorPane.setContentType("text/html");
        this.helpEditorPane.putClientProperty("JEditorPane.w3cLengthUnits", Boolean.TRUE);
        this.helpEditorPane.setHighlighter(new DefaultHighlighter());
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HelpPane.this.highlightText(helpController.getHighlightedText());
            }
        };
        helpController.addPropertyChangeListener(HelpController.Property.HIGHLIGHTED_TEXT, propertyChangeListener);
        this.helpEditorPane.addPropertyChangeListener("page", propertyChangeListener);
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            public Component getDefaultComponent(Container container) {
                return HelpPane.this.helpEditorPane;
            }
        });
    }

    private void highlightText(String string) {
        DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(new Color(255, 204, 51));
        this.helpEditorPane.getHighlighter().removeAllHighlights();
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : string.split("\\s")) {
                if (string2.length() <= 0) continue;
                arrayList.add(string2);
            }
            this.highlightWords(this.helpEditorPane.getDocument().getDefaultRootElement(), arrayList.toArray(new String[arrayList.size()]), defaultHighlightPainter);
        }
    }

    private void highlightWords(Element element, String[] stringArray, Highlighter.HighlightPainter highlightPainter) {
        if (element.isLeaf()) {
            int n = element.getStartOffset();
            try {
                String string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - n).toLowerCase();
                for (String string2 : stringArray) {
                    for (int i = 0; i < string.length() - 1 && (i = string.indexOf(string2, i)) >= 0; i += string2.length() + 1) {
                        this.helpEditorPane.getHighlighter().addHighlight(n + i, n + i + string2.length(), highlightPainter);
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        } else {
            int n = element.getElementCount();
            for (int i = 0; i < n; ++i) {
                this.highlightWords(element.getElement(i), stringArray, highlightPainter);
            }
        }
    }

    private void setMnemonics(UserPreferences userPreferences) {
        if (!OperatingSystem.isMacOSX()) {
            this.searchLabel.setDisplayedMnemonic(KeyStroke.getKeyStroke(userPreferences.getLocalizedString(HelpPane.class, "searchLabel.mnemonic", new Object[0])).getKeyCode());
            this.searchLabel.setLabelFor(this.searchTextField);
        }
    }

    private void layoutComponents() {
        final JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setLayout(new GridBagLayout());
        ActionMap actionMap = this.getActionMap();
        final JButton jButton = new JButton(actionMap.get((Object)ActionType.SHOW_PREVIOUS));
        final JButton jButton2 = new JButton(actionMap.get((Object)ActionType.SHOW_NEXT));
        jToolBar.add(jButton);
        jToolBar.add(jButton2);
        this.layoutToolBarButtons(jToolBar, jButton, jButton2);
        jToolBar.addPropertyChangeListener("componentOrientation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HelpPane.this.layoutToolBarButtons(jToolBar, jButton, jButton2);
            }
        });
        jToolBar.add((Component)new JLabel(), new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            jToolBar.add((Component)this.searchLabel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 5), 0, 0));
        }
        jToolBar.add((Component)this.searchTextField, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.searchTextField.setMaximumSize(this.searchTextField.getPreferredSize());
        if (!OperatingSystem.isMacOSXLeopardOrSuperior()) {
            jToolBar.add((Component)new JButton(actionMap.get((Object)ActionType.SEARCH)), new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 0), 0, 0));
        }
        int n = jToolBar.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = jToolBar.getComponent(i);
            if (!(component instanceof JButton)) continue;
            component.setFocusable(false);
        }
        this.getContentPane().add((Component)jToolBar, "North");
        this.getContentPane().add((Component)new JScrollPane(this.helpEditorPane), "Center");
    }

    private void layoutToolBarButtons(JToolBar jToolBar, JButton jButton, JButton jButton2) {
        int n;
        int n2;
        if (OperatingSystem.isMacOSXLeopardOrSuperior() && OperatingSystem.isJavaVersionGreaterOrEqual("1.7")) {
            n2 = 6;
            n = -2;
        } else {
            n2 = 0;
            n = 0;
        }
        ComponentOrientation componentOrientation = jToolBar.getComponentOrientation();
        GridBagLayout gridBagLayout = (GridBagLayout)jToolBar.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(n, 0, n, 0), 0, n2);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(n, 0, n, 5), 0, n2);
        gridBagLayout.setConstraints(componentOrientation.isLeftToRight() ? jButton : jButton2, gridBagConstraints);
        gridBagLayout.setConstraints(componentOrientation.isLeftToRight() ? jButton2 : jButton, gridBagConstraints2);
        if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
            jButton.putClientProperty("JButton.buttonType", "segmentedTextured");
            jButton.putClientProperty("JButton.segmentPosition", "first");
            jButton2.putClientProperty("JButton.buttonType", "segmentedTextured");
            jButton2.putClientProperty("JButton.segmentPosition", "last");
        }
        jToolBar.revalidate();
    }

    private void addHyperlinkListener(final HelpController helpController) {
        this.helpEditorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    helpController.showPage(hyperlinkEvent.getURL());
                }
            }
        });
    }

    private void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap(1);
        inputMap.put((KeyStroke)actionMap.get((Object)ActionType.SHOW_PREVIOUS).getValue("AcceleratorKey"), (Object)ActionType.SHOW_PREVIOUS);
        inputMap.put((KeyStroke)actionMap.get((Object)ActionType.SHOW_NEXT).getValue("AcceleratorKey"), (Object)ActionType.SHOW_NEXT);
        inputMap.put((KeyStroke)actionMap.get((Object)ActionType.CLOSE).getValue("AcceleratorKey"), (Object)ActionType.CLOSE);
        inputMap.put((KeyStroke)actionMap.get((Object)ActionType.SEARCH).getValue("AcceleratorKey"), (Object)ActionType.SEARCH);
    }

    public void displayView() {
        if (this.frame == null) {
            this.frame = new JFrame(){
                {
                    this.setRootPane(HelpPane.this);
                }
            };
            this.frame.setIconImage(new ImageIcon(HelpPane.class.getResource(this.preferences.getLocalizedString(HelpPane.class, "helpFrame.icon", new Object[0]))).getImage());
            this.frame.setTitle(this.preferences.getLocalizedString(HelpPane.class, "helpFrame.title", new Object[0]));
            this.frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
            this.computeFrameBounds(this.frame);
            this.frame.setDefaultCloseOperation(1);
        }
        this.frame.setVisible(true);
        this.frame.setState(0);
        this.frame.toFront();
    }

    private void computeFrameBounds(JFrame jFrame) {
        jFrame.setLocationByPlatform(true);
        Dimension dimension = this.getToolkit().getScreenSize();
        Insets insets = this.getToolkit().getScreenInsets(this.getGraphicsConfiguration());
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.top + insets.bottom;
        jFrame.setSize(Math.min(2 * dimension.width / 3, 800), dimension.height * 4 / 5);
    }

    private void setPage(URL uRL) {
        try {
            this.helpEditorPane.setPage(uRL);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static class LanguageChangeListener
    implements PropertyChangeListener {
        private WeakReference<HelpPane> helpPane;

        public LanguageChangeListener(HelpPane helpPane) {
            this.helpPane = new WeakReference<HelpPane>(helpPane);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HelpPane helpPane = (HelpPane)this.helpPane.get();
            UserPreferences userPreferences = (UserPreferences)propertyChangeEvent.getSource();
            if (helpPane == null) {
                userPreferences.removePropertyChangeListener(UserPreferences.Property.LANGUAGE, this);
            } else {
                if (helpPane.frame != null) {
                    helpPane.frame.setTitle(userPreferences.getLocalizedString(HelpPane.class, "helpFrame.title", new Object[0]));
                    helpPane.frame.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
                }
                helpPane.searchLabel.setText(SwingTools.getLocalizedLabelText(userPreferences, HelpPane.class, "searchLabel.text", new Object[0]));
                helpPane.searchTextField.setText("");
                helpPane.setMnemonics(userPreferences);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ActionType {
        SHOW_PREVIOUS,
        SHOW_NEXT,
        SEARCH,
        CLOSE;

    }
}

