/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKColorChooserPanel;
import com.sun.java.swing.plaf.gtk.GTKColorType;
import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKFileChooserUI;
import com.sun.java.swing.plaf.gtk.GTKIconFactory;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.GTKStyle;
import com.sun.java.swing.plaf.gtk.GTKStyleFactory;
import com.sun.java.swing.plaf.gtk.PangoFonts;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthLookAndFeel;
import sun.awt.OSInfo;
import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;
import sun.java2d.SunGraphicsEnvironment;
import sun.security.action.GetPropertyAction;
import sun.swing.DefaultLayoutStyle;
import sun.swing.SwingLazyValue;
import sun.swing.SwingUtilities2;

public class GTKLookAndFeel
extends SynthLookAndFeel {
    private static final boolean IS_22;
    static Object aaTextInfo;
    private static boolean isSunCJK;
    private static boolean gtkAAFontSettingsCond;
    private Font fallbackFont;
    private boolean inInitialize;
    private boolean pclInstalled;
    private GTKStyleFactory styleFactory;
    private static String gtkThemeName;
    static ReferenceQueue<GTKLookAndFeel> queue;

    static boolean is2_2() {
        return IS_22;
    }

    static GTKConstants.PositionType SwingOrientationConstantToGTK(int side) {
        switch (side) {
            case 2: {
                return GTKConstants.PositionType.LEFT;
            }
            case 4: {
                return GTKConstants.PositionType.RIGHT;
            }
            case 1: {
                return GTKConstants.PositionType.TOP;
            }
            case 3: {
                return GTKConstants.PositionType.BOTTOM;
            }
        }
        assert (false) : "Unknown orientation: " + side;
        return GTKConstants.PositionType.TOP;
    }

    static GTKConstants.StateType synthStateToGTKStateType(int state) {
        GTKConstants.StateType result;
        switch (state) {
            case 4: {
                result = GTKConstants.StateType.ACTIVE;
                break;
            }
            case 2: {
                result = GTKConstants.StateType.PRELIGHT;
                break;
            }
            case 512: {
                result = GTKConstants.StateType.SELECTED;
                break;
            }
            case 8: {
                result = GTKConstants.StateType.INSENSITIVE;
                break;
            }
            default: {
                result = GTKConstants.StateType.NORMAL;
            }
        }
        return result;
    }

    static int synthStateToGTKState(Region region, int state) {
        state = (state & 4) != 0 ? (region == Region.RADIO_BUTTON || region == Region.CHECK_BOX || region == Region.MENU || region == Region.MENU_ITEM || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.SPLIT_PANE ? 2 : 4) : (region == Region.TABBED_PANE_TAB ? ((state & 8) != 0 ? 8 : ((state & 0x200) != 0 ? 1 : 4)) : ((state & 0x200) != 0 ? (region == Region.MENU ? 2 : (region == Region.RADIO_BUTTON || region == Region.TOGGLE_BUTTON || region == Region.RADIO_BUTTON_MENU_ITEM || region == Region.CHECK_BOX_MENU_ITEM || region == Region.CHECK_BOX || region == Region.BUTTON ? ((state & 8) != 0 ? 8 : ((state & 2) != 0 ? 2 : 4)) : 512)) : ((state & 2) != 0 ? 2 : ((state & 8) != 0 ? 8 : (region == Region.SLIDER_TRACK ? 4 : 1)))));
        return state;
    }

    static boolean isText(Region region) {
        return region == Region.TEXT_FIELD || region == Region.FORMATTED_TEXT_FIELD || region == Region.LIST || region == Region.PASSWORD_FIELD || region == Region.SPINNER || region == Region.TABLE || region == Region.TEXT_AREA || region == Region.TEXT_FIELD || region == Region.TEXT_PANE || region == Region.TREE;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = super.getDefaults();
        table.put("TabbedPane.isTabRollover", Boolean.FALSE);
        table.put("Synth.doNotSetTextAA", (Object)true);
        this.initResourceBundle(table);
        this.initSystemColorDefaults(table);
        this.initComponentDefaults(table);
        this.installPropertyChangeListeners();
        return table;
    }

    private void installPropertyChangeListeners() {
        if (!this.pclInstalled) {
            Toolkit kit = Toolkit.getDefaultToolkit();
            WeakPCL pcl = new WeakPCL(this, kit, "gnome.Net/ThemeName");
            kit.addPropertyChangeListener(pcl.getKey(), pcl);
            pcl = new WeakPCL(this, kit, "gnome.Gtk/FontName");
            kit.addPropertyChangeListener(pcl.getKey(), pcl);
            pcl = new WeakPCL(this, kit, "gnome.Xft/DPI");
            kit.addPropertyChangeListener(pcl.getKey(), pcl);
            GTKLookAndFeel.flushUnreferenced();
            this.pclInstalled = true;
        }
    }

    private void initResourceBundle(UIDefaults table) {
        table.addResourceBundle("com.sun.java.swing.plaf.gtk.resources.gtk");
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        Boolean order;
        super.initComponentDefaults(table);
        Integer zero = 0;
        SwingLazyValue zeroBorder = new SwingLazyValue("javax.swing.plaf.BorderUIResource$EmptyBorderUIResource", new Object[]{zero, zero, zero, zero});
        GTKStyle.GTKLazyValue focusBorder = new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder", "getUnselectedCellBorder");
        GTKStyle.GTKLazyValue focusSelectedBorder = new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder", "getSelectedCellBorder");
        GTKStyle.GTKLazyValue noFocusBorder = new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKPainter$ListTableFocusBorder", "getNoFocusCellBorder");
        GTKStyleFactory factory = (GTKStyleFactory)GTKLookAndFeel.getStyleFactory();
        GTKStyle tableStyle = (GTKStyle)factory.getStyle(null, Region.TREE);
        Color tableBg = tableStyle.getGTKColor(1, GTKColorType.TEXT_BACKGROUND);
        Color tableFocusCellBg = tableStyle.getGTKColor(1, GTKColorType.BACKGROUND);
        Color tableFocusCellFg = tableStyle.getGTKColor(1, GTKColorType.FOREGROUND);
        GTKStyle progStyle = (GTKStyle)factory.getStyle(null, Region.PROGRESS_BAR);
        int progXThickness = progStyle.getXThickness();
        int progYThickness = progStyle.getYThickness();
        int hProgWidth = 150 - progXThickness * 2;
        int hProgHeight = 20 - progYThickness * 2;
        int vProgWidth = 22 - progXThickness * 2;
        int vProgHeight = 80 - progYThickness * 2;
        Integer caretBlinkRate = 500;
        InsetsUIResource zeroInsets = new InsetsUIResource(0, 0, 0, 0);
        Double defaultCaretAspectRatio = new Double(0.025);
        Color caretColor = table.getColor("caretColor");
        Color controlText = table.getColor("controlText");
        UIDefaults.LazyInputMap fieldInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        UIDefaults.LazyInputMap passwordInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-begin-line", "ctrl KP_LEFT", "caret-begin-line", "ctrl RIGHT", "caret-end-line", "ctrl KP_RIGHT", "caret-end-line", "ctrl shift LEFT", "selection-begin-line", "ctrl shift KP_LEFT", "selection-begin-line", "ctrl shift RIGHT", "selection-end-line", "ctrl shift KP_RIGHT", "selection-end-line", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation"});
        InsetsUIResource editorMargin = new InsetsUIResource(3, 3, 3, 3);
        UIDefaults.LazyInputMap multilineInputMap = new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "UP", "caret-up", "KP_UP", "caret-up", "DOWN", "caret-down", "KP_DOWN", "caret-down", "PAGE_UP", "page-up", "PAGE_DOWN", "page-down", "shift PAGE_UP", "selection-page-up", "shift PAGE_DOWN", "selection-page-down", "ctrl shift PAGE_UP", "selection-page-left", "ctrl shift PAGE_DOWN", "selection-page-right", "shift UP", "selection-up", "shift KP_UP", "selection-up", "shift DOWN", "selection-down", "shift KP_DOWN", "selection-down", "ENTER", "insert-break", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "TAB", "insert-tab", "ctrl BACK_SLASH", "unselect", "ctrl HOME", "caret-begin", "ctrl END", "caret-end", "ctrl shift HOME", "selection-begin", "ctrl shift END", "selection-end", "ctrl T", "next-link-action", "ctrl shift T", "previous-link-action", "ctrl SPACE", "activate-link-action", "control shift O", "toggle-componentOrientation"});
        Boolean buttonOrder = Boolean.TRUE;
        Object orderSetting = GTKEngine.INSTANCE.getSetting(GTKEngine.Settings.GTK_BUTTON_ORDER);
        if (orderSetting instanceof Boolean && Boolean.TRUE.equals(order = (Boolean)orderSetting)) {
            buttonOrder = Boolean.FALSE;
        }
        class FontLazyValue
        implements UIDefaults.LazyValue {
            private Region region;

            FontLazyValue(Region region) {
                this.region = region;
            }

            @Override
            public Object createValue(UIDefaults table) {
                GTKStyleFactory factory = (GTKStyleFactory)SynthLookAndFeel.getStyleFactory();
                GTKStyle style = (GTKStyle)factory.getStyle(null, this.region);
                return style.getFontForState(null);
            }
        }
        Object[] defaults = new Object[]{"ArrowButton.size", 13, "Button.defaultButtonFollowsFocus", Boolean.FALSE, "Button.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "ENTER", "pressed", "released ENTER", "released"}), "Button.font", new FontLazyValue(Region.BUTTON), "Button.margin", zeroInsets, "CheckBox.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "CheckBox.icon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxIcon"), "CheckBox.font", new FontLazyValue(Region.CHECK_BOX), "CheckBox.margin", zeroInsets, "CheckBoxMenuItem.arrowIcon", null, "CheckBoxMenuItem.checkIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getCheckBoxMenuItemCheckIcon"), "CheckBoxMenuItem.font", new FontLazyValue(Region.CHECK_BOX_MENU_ITEM), "CheckBoxMenuItem.margin", zeroInsets, "CheckBoxMenuItem.alignAcceleratorText", Boolean.FALSE, "ColorChooser.showPreviewPanelText", Boolean.FALSE, "ColorChooser.panels", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new AbstractColorChooserPanel[]{new GTKColorChooserPanel()};
            }
        }, "ColorChooser.font", new FontLazyValue(Region.COLOR_CHOOSER), "ComboBox.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "hidePopup", "PAGE_UP", "pageUpPassThrough", "PAGE_DOWN", "pageDownPassThrough", "HOME", "homePassThrough", "END", "endPassThrough", "DOWN", "selectNext", "KP_DOWN", "selectNext", "alt DOWN", "togglePopup", "alt KP_DOWN", "togglePopup", "alt UP", "togglePopup", "alt KP_UP", "togglePopup", "SPACE", "spacePopup", "ENTER", "enterPressed", "UP", "selectPrevious", "KP_UP", "selectPrevious"}), "ComboBox.font", new FontLazyValue(Region.COMBO_BOX), "ComboBox.isEnterSelectablePopup", Boolean.TRUE, "EditorPane.caretForeground", caretColor, "EditorPane.caretAspectRatio", defaultCaretAspectRatio, "EditorPane.caretBlinkRate", caretBlinkRate, "EditorPane.margin", editorMargin, "EditorPane.focusInputMap", multilineInputMap, "EditorPane.font", new FontLazyValue(Region.EDITOR_PANE), "FileChooser.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancelSelection", "ctrl ENTER", "approveSelection"}), "FileChooserUI", "com.sun.java.swing.plaf.gtk.GTKLookAndFeel", "FormattedTextField.caretForeground", caretColor, "FormattedTextField.caretAspectRatio", defaultCaretAspectRatio, "FormattedTextField.caretBlinkRate", caretBlinkRate, "FormattedTextField.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy-to-clipboard", "ctrl V", "paste-from-clipboard", "ctrl X", "cut-to-clipboard", "COPY", "copy-to-clipboard", "PASTE", "paste-from-clipboard", "CUT", "cut-to-clipboard", "control INSERT", "copy-to-clipboard", "shift INSERT", "paste-from-clipboard", "shift DELETE", "cut-to-clipboard", "shift LEFT", "selection-backward", "shift KP_LEFT", "selection-backward", "shift RIGHT", "selection-forward", "shift KP_RIGHT", "selection-forward", "ctrl LEFT", "caret-previous-word", "ctrl KP_LEFT", "caret-previous-word", "ctrl RIGHT", "caret-next-word", "ctrl KP_RIGHT", "caret-next-word", "ctrl shift LEFT", "selection-previous-word", "ctrl shift KP_LEFT", "selection-previous-word", "ctrl shift RIGHT", "selection-next-word", "ctrl shift KP_RIGHT", "selection-next-word", "ctrl A", "select-all", "HOME", "caret-begin-line", "END", "caret-end-line", "shift HOME", "selection-begin-line", "shift END", "selection-end-line", "BACK_SPACE", "delete-previous", "shift BACK_SPACE", "delete-previous", "ctrl H", "delete-previous", "DELETE", "delete-next", "ctrl DELETE", "delete-next-word", "ctrl BACK_SPACE", "delete-previous-word", "RIGHT", "caret-forward", "LEFT", "caret-backward", "KP_RIGHT", "caret-forward", "KP_LEFT", "caret-backward", "ENTER", "notify-field-accept", "ctrl BACK_SLASH", "unselect", "control shift O", "toggle-componentOrientation", "ESCAPE", "reset-field-edit", "UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "FormattedTextField.font", new FontLazyValue(Region.FORMATTED_TEXT_FIELD), "InternalFrameTitlePane.titlePaneLayout", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.Metacity", "getTitlePaneLayout"), "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "InternalFrame.layoutTitlePaneAtOrigin", Boolean.TRUE, "InternalFrame.useTaskBar", Boolean.TRUE, "InternalFrameTitlePane.iconifyButtonOpacity", null, "InternalFrameTitlePane.maximizeButtonOpacity", null, "InternalFrameTitlePane.closeButtonOpacity", null, "Label.font", new FontLazyValue(Region.LABEL), "List.background", tableBg, "List.focusCellHighlightBorder", focusBorder, "List.focusSelectedCellHighlightBorder", focusSelectedBorder, "List.noFocusBorder", noFocusBorder, "List.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "HOME", "selectFirstRow", "shift HOME", "selectFirstRowExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRowChangeLead", "END", "selectLastRow", "shift END", "selectLastRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRowChangeLead", "PAGE_UP", "scrollUp", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDown", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "List.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl shift LEFT", "selectNextColumnExtendSelection", "ctrl shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl LEFT", "selectNextColumnChangeLead", "ctrl KP_LEFT", "selectNextColumnChangeLead", "RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift KP_RIGHT", "selectPreviousColumnExtendSelection", "ctrl RIGHT", "selectPreviousColumnChangeLead", "ctrl KP_RIGHT", "selectPreviousColumnChangeLead"}), "List.font", new FontLazyValue(Region.LIST), "List.rendererUseUIBorder", Boolean.FALSE, "Menu.arrowIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getMenuArrowIcon"), "Menu.checkIcon", null, "Menu.font", new FontLazyValue(Region.MENU), "Menu.margin", zeroInsets, "Menu.cancelMode", "hideMenuTree", "Menu.alignAcceleratorText", Boolean.FALSE, "Menu.useMenuBarForTopLevelMenus", Boolean.TRUE, "MenuBar.windowBindings", new Object[]{"F10", "takeFocus"}, "MenuBar.font", new FontLazyValue(Region.MENU_BAR), "MenuItem.arrowIcon", null, "MenuItem.checkIcon", null, "MenuItem.font", new FontLazyValue(Region.MENU_ITEM), "MenuItem.margin", zeroInsets, "MenuItem.alignAcceleratorText", Boolean.FALSE, "OptionPane.setButtonMargin", Boolean.FALSE, "OptionPane.sameSizeButtons", Boolean.TRUE, "OptionPane.buttonOrientation", new Integer(4), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.buttonPadding", new Integer(10), "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.buttonClickThreshhold", new Integer(500), "OptionPane.isYesLast", buttonOrder, "OptionPane.font", new FontLazyValue(Region.OPTION_PANE), "Panel.font", new FontLazyValue(Region.PANEL), "PasswordField.caretForeground", caretColor, "PasswordField.caretAspectRatio", defaultCaretAspectRatio, "PasswordField.caretBlinkRate", caretBlinkRate, "PasswordField.margin", zeroInsets, "PasswordField.focusInputMap", passwordInputMap, "PasswordField.font", new FontLazyValue(Region.PASSWORD_FIELD), "PopupMenu.consumeEventOnClose", Boolean.TRUE, "PopupMenu.selectedWindowInputMapBindings", new Object[]{"ESCAPE", "cancel", "DOWN", "selectNext", "KP_DOWN", "selectNext", "UP", "selectPrevious", "KP_UP", "selectPrevious", "LEFT", "selectParent", "KP_LEFT", "selectParent", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "ENTER", "return", "SPACE", "return"}, "PopupMenu.selectedWindowInputMapBindings.RightToLeft", new Object[]{"LEFT", "selectChild", "KP_LEFT", "selectChild", "RIGHT", "selectParent", "KP_RIGHT", "selectParent"}, "PopupMenu.font", new FontLazyValue(Region.POPUP_MENU), "ProgressBar.horizontalSize", new DimensionUIResource(hProgWidth, hProgHeight), "ProgressBar.verticalSize", new DimensionUIResource(vProgWidth, vProgHeight), "ProgressBar.font", new FontLazyValue(Region.PROGRESS_BAR), "RadioButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released", "RETURN", "pressed"}), "RadioButton.icon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getRadioButtonIcon"), "RadioButton.font", new FontLazyValue(Region.RADIO_BUTTON), "RadioButton.margin", zeroInsets, "RadioButtonMenuItem.arrowIcon", null, "RadioButtonMenuItem.checkIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getRadioButtonMenuItemCheckIcon"), "RadioButtonMenuItem.font", new FontLazyValue(Region.RADIO_BUTTON_MENU_ITEM), "RadioButtonMenuItem.margin", zeroInsets, "RadioButtonMenuItem.alignAcceleratorText", Boolean.FALSE, "RootPane.defaultButtonWindowKeyBindings", new Object[]{"ENTER", "press", "released ENTER", "release", "ctrl ENTER", "press", "ctrl released ENTER", "release"}, "ScrollBar.squareButtons", Boolean.FALSE, "ScrollBar.thumbHeight", 14, "ScrollBar.width", 16, "ScrollBar.minimumThumbSize", new Dimension(8, 8), "ScrollBar.maximumThumbSize", new Dimension(4096, 4096), "ScrollBar.allowsAbsolutePositioning", Boolean.TRUE, "ScrollBar.alwaysShowThumb", Boolean.TRUE, "ScrollBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "positiveUnitIncrement", "KP_DOWN", "positiveUnitIncrement", "PAGE_DOWN", "positiveBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "negativeUnitIncrement", "KP_UP", "negativeUnitIncrement", "PAGE_UP", "negativeBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "ScrollBar.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}), "Spinner.disableOnBoundaryValues", Boolean.TRUE, "ScrollPane.fillUpperCorner", Boolean.TRUE, "ScrollPane.fillLowerCorner", Boolean.TRUE, "ScrollPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "unitScrollRight", "KP_RIGHT", "unitScrollRight", "DOWN", "unitScrollDown", "KP_DOWN", "unitScrollDown", "LEFT", "unitScrollLeft", "KP_LEFT", "unitScrollLeft", "UP", "unitScrollUp", "KP_UP", "unitScrollUp", "PAGE_UP", "scrollUp", "PAGE_DOWN", "scrollDown", "ctrl PAGE_UP", "scrollLeft", "ctrl PAGE_DOWN", "scrollRight", "ctrl HOME", "scrollHome", "ctrl END", "scrollEnd"}), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"ctrl PAGE_UP", "scrollRight", "ctrl PAGE_DOWN", "scrollLeft"}), "ScrollPane.font", new FontLazyValue(Region.SCROLL_PANE), "Separator.insets", zeroInsets, "Separator.thickness", 2, "Slider.paintValue", Boolean.TRUE, "Slider.thumbWidth", 30, "Slider.thumbHeight", 14, "Slider.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "positiveUnitIncrement", "KP_RIGHT", "positiveUnitIncrement", "DOWN", "negativeUnitIncrement", "KP_DOWN", "negativeUnitIncrement", "PAGE_DOWN", "negativeBlockIncrement", "LEFT", "negativeUnitIncrement", "KP_LEFT", "negativeUnitIncrement", "UP", "positiveUnitIncrement", "KP_UP", "positiveUnitIncrement", "PAGE_UP", "positiveBlockIncrement", "HOME", "minScroll", "END", "maxScroll"}), "Slider.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "negativeUnitIncrement", "KP_RIGHT", "negativeUnitIncrement", "LEFT", "positiveUnitIncrement", "KP_LEFT", "positiveUnitIncrement"}), "Slider.onlyLeftMouseButtonDrag", Boolean.FALSE, "Spinner.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "increment", "KP_UP", "increment", "DOWN", "decrement", "KP_DOWN", "decrement"}), "Spinner.font", new FontLazyValue(Region.SPINNER), "Spinner.editorAlignment", 10, "SplitPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "negativeIncrement", "DOWN", "positiveIncrement", "LEFT", "negativeIncrement", "RIGHT", "positiveIncrement", "KP_UP", "negativeIncrement", "KP_DOWN", "positiveIncrement", "KP_LEFT", "negativeIncrement", "KP_RIGHT", "positiveIncrement", "HOME", "selectMin", "END", "selectMax", "F8", "startResize", "F6", "toggleFocus", "ctrl TAB", "focusOutForward", "ctrl shift TAB", "focusOutBackward"}), "SplitPane.size", 7, "SplitPane.oneTouchOffset", 2, "SplitPane.oneTouchButtonSize", 5, "SplitPane.supportsOneTouchButtons", Boolean.FALSE, "TabbedPane.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "navigateRight", "KP_RIGHT", "navigateRight", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "ctrl DOWN", "requestFocusForVisibleComponent", "ctrl KP_DOWN", "requestFocusForVisibleComponent", "SPACE", "selectTabWithFocus"}), "TabbedPane.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl TAB", "navigateNext", "ctrl shift TAB", "navigatePrevious", "ctrl PAGE_DOWN", "navigatePageDown", "ctrl PAGE_UP", "navigatePageUp", "ctrl UP", "requestFocus", "ctrl KP_UP", "requestFocus"}), "TabbedPane.labelShift", 3, "TabbedPane.selectedLabelShift", 3, "TabbedPane.font", new FontLazyValue(Region.TABBED_PANE), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(2, 2, 0, 1), "Table.scrollPaneBorder", zeroBorder, "Table.background", tableBg, "Table.focusCellBackground", tableFocusCellBg, "Table.focusCellForeground", tableFocusCellFg, "Table.focusCellHighlightBorder", focusBorder, "Table.focusSelectedCellHighlightBorder", focusSelectedBorder, "Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl shift RIGHT", "selectNextColumnExtendSelection", "ctrl shift KP_RIGHT", "selectNextColumnExtendSelection", "ctrl RIGHT", "selectNextColumnChangeLead", "ctrl KP_RIGHT", "selectNextColumnChangeLead", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl shift LEFT", "selectPreviousColumnExtendSelection", "ctrl shift KP_LEFT", "selectPreviousColumnExtendSelection", "ctrl LEFT", "selectPreviousColumnChangeLead", "ctrl KP_LEFT", "selectPreviousColumnChangeLead", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "ctrl shift DOWN", "selectNextRowExtendSelection", "ctrl shift KP_DOWN", "selectNextRowExtendSelection", "ctrl DOWN", "selectNextRowChangeLead", "ctrl KP_DOWN", "selectNextRowChangeLead", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "ctrl shift UP", "selectPreviousRowExtendSelection", "ctrl shift KP_UP", "selectPreviousRowExtendSelection", "ctrl UP", "selectPreviousRowChangeLead", "ctrl KP_UP", "selectPreviousRowChangeLead", "HOME", "selectFirstColumn", "shift HOME", "selectFirstColumnExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl HOME", "selectFirstRow", "END", "selectLastColumn", "shift END", "selectLastColumnExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "ctrl END", "selectLastRow", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollLeftExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollRightExtendSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "ENTER", "selectNextRowCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ESCAPE", "cancel", "F2", "startEditing", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo", "F8", "focusHeader"}), "Table.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectPreviousColumn", "KP_RIGHT", "selectPreviousColumn", "shift RIGHT", "selectPreviousColumnExtendSelection", "shift KP_RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift RIGHT", "selectPreviousColumnExtendSelection", "ctrl shift KP_RIGHT", "selectPreviousColumnExtendSelection", "shift RIGHT", "selectPreviousColumnChangeLead", "shift KP_RIGHT", "selectPreviousColumnChangeLead", "LEFT", "selectNextColumn", "KP_LEFT", "selectNextColumn", "shift LEFT", "selectNextColumnExtendSelection", "shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl shift LEFT", "selectNextColumnExtendSelection", "ctrl shift KP_LEFT", "selectNextColumnExtendSelection", "ctrl LEFT", "selectNextColumnChangeLead", "ctrl KP_LEFT", "selectNextColumnChangeLead", "ctrl PAGE_UP", "scrollRightChangeSelection", "ctrl PAGE_DOWN", "scrollLeftChangeSelection", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection"}), "Table.font", new FontLazyValue(Region.TABLE), "Table.ascendingSortIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getAscendingSortIcon"), "Table.descendingSortIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getDescendingSortIcon"), "TableHeader.font", new FontLazyValue(Region.TABLE_HEADER), "TableHeader.alignSorterArrow", Boolean.TRUE, "TextArea.caretForeground", caretColor, "TextArea.caretAspectRatio", defaultCaretAspectRatio, "TextArea.caretBlinkRate", caretBlinkRate, "TextArea.margin", zeroInsets, "TextArea.focusInputMap", multilineInputMap, "TextArea.font", new FontLazyValue(Region.TEXT_AREA), "TextField.caretForeground", caretColor, "TextField.caretAspectRatio", defaultCaretAspectRatio, "TextField.caretBlinkRate", caretBlinkRate, "TextField.margin", zeroInsets, "TextField.focusInputMap", fieldInputMap, "TextField.font", new FontLazyValue(Region.TEXT_FIELD), "TextPane.caretForeground", caretColor, "TextPane.caretAspectRatio", defaultCaretAspectRatio, "TextPane.caretBlinkRate", caretBlinkRate, "TextPane.margin", editorMargin, "TextPane.focusInputMap", multilineInputMap, "TextPane.font", new FontLazyValue(Region.TEXT_PANE), "TitledBorder.titleColor", controlText, "TitledBorder.border", new UIDefaults.LazyValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return new GTKPainter.TitledBorder();
            }
        }, "ToggleButton.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"}), "ToggleButton.font", new FontLazyValue(Region.TOGGLE_BUTTON), "ToggleButton.margin", zeroInsets, "ToolBar.separatorSize", new DimensionUIResource(10, 10), "ToolBar.handleIcon", new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults table) {
                return GTKIconFactory.getToolBarHandleIcon();
            }
        }, "ToolBar.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"UP", "navigateUp", "KP_UP", "navigateUp", "DOWN", "navigateDown", "KP_DOWN", "navigateDown", "LEFT", "navigateLeft", "KP_LEFT", "navigateLeft", "RIGHT", "navigateRight", "KP_RIGHT", "navigateRight"}), "ToolBar.font", new FontLazyValue(Region.TOOL_BAR), "ToolTip.font", new FontLazyValue(Region.TOOL_TIP), "Tree.padding", 4, "Tree.background", tableBg, "Tree.drawHorizontalLines", Boolean.FALSE, "Tree.drawVerticalLines", Boolean.FALSE, "Tree.rowHeight", -1, "Tree.scrollsOnExpand", Boolean.FALSE, "Tree.expanderSize", 10, "Tree.repaintWholeRow", Boolean.TRUE, "Tree.closedIcon", null, "Tree.leafIcon", null, "Tree.openIcon", null, "Tree.expandedIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getTreeExpandedIcon"), "Tree.collapsedIcon", new GTKStyle.GTKLazyValue("com.sun.java.swing.plaf.gtk.GTKIconFactory", "getTreeCollapsedIcon"), "Tree.leftChildIndent", 2, "Tree.rightChildIndent", 12, "Tree.scrollsHorizontallyAndVertically", Boolean.FALSE, "Tree.drawsFocusBorder", Boolean.TRUE, "Tree.focusInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "UP", "selectPrevious", "KP_UP", "selectPrevious", "shift UP", "selectPreviousExtendSelection", "shift KP_UP", "selectPreviousExtendSelection", "ctrl shift UP", "selectPreviousExtendSelection", "ctrl shift KP_UP", "selectPreviousExtendSelection", "ctrl UP", "selectPreviousChangeLead", "ctrl KP_UP", "selectPreviousChangeLead", "DOWN", "selectNext", "KP_DOWN", "selectNext", "shift DOWN", "selectNextExtendSelection", "shift KP_DOWN", "selectNextExtendSelection", "ctrl shift DOWN", "selectNextExtendSelection", "ctrl shift KP_DOWN", "selectNextExtendSelection", "ctrl DOWN", "selectNextChangeLead", "ctrl KP_DOWN", "selectNextChangeLead", "RIGHT", "selectChild", "KP_RIGHT", "selectChild", "LEFT", "selectParent", "KP_LEFT", "selectParent", "typed +", "expand", "typed -", "collapse", "BACK_SPACE", "moveSelectionToParent", "PAGE_UP", "scrollUpChangeSelection", "shift PAGE_UP", "scrollUpExtendSelection", "ctrl shift PAGE_UP", "scrollUpExtendSelection", "ctrl PAGE_UP", "scrollUpChangeLead", "PAGE_DOWN", "scrollDownChangeSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl shift PAGE_DOWN", "scrollDownExtendSelection", "ctrl PAGE_DOWN", "scrollDownChangeLead", "HOME", "selectFirst", "shift HOME", "selectFirstExtendSelection", "ctrl shift HOME", "selectFirstExtendSelection", "ctrl HOME", "selectFirstChangeLead", "END", "selectLast", "shift END", "selectLastExtendSelection", "ctrl shift END", "selectLastExtendSelection", "ctrl END", "selectLastChangeLead", "F2", "startEditing", "ctrl A", "selectAll", "ctrl SLASH", "selectAll", "ctrl BACK_SLASH", "clearSelection", "ctrl LEFT", "scrollLeft", "ctrl KP_LEFT", "scrollLeft", "ctrl RIGHT", "scrollRight", "ctrl KP_RIGHT", "scrollRight", "SPACE", "addToSelection", "ctrl SPACE", "toggleAndAnchor", "shift SPACE", "extendTo", "ctrl shift SPACE", "moveSelectionTo"}), "Tree.focusInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[]{"RIGHT", "selectParent", "KP_RIGHT", "selectParent", "LEFT", "selectChild", "KP_LEFT", "selectChild"}), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"}), "Tree.font", new FontLazyValue(Region.TREE), "Viewport.font", new FontLazyValue(Region.VIEWPORT)};
        table.putDefaults(defaults);
        if (this.fallbackFont != null) {
            table.put("TitledBorder.font", this.fallbackFont);
        }
        table.put(SwingUtilities2.AA_TEXT_PROPERTY_KEY, aaTextInfo);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        GTKStyleFactory factory = (GTKStyleFactory)GTKLookAndFeel.getStyleFactory();
        GTKStyle windowStyle = (GTKStyle)factory.getStyle(null, Region.INTERNAL_FRAME);
        table.put("window", windowStyle.getGTKColor(1, GTKColorType.BACKGROUND));
        table.put("windowText", windowStyle.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        GTKStyle entryStyle = (GTKStyle)factory.getStyle(null, Region.TEXT_FIELD);
        table.put("text", entryStyle.getGTKColor(1, GTKColorType.TEXT_BACKGROUND));
        table.put("textText", entryStyle.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        table.put("textHighlight", entryStyle.getGTKColor(512, GTKColorType.TEXT_BACKGROUND));
        table.put("textHighlightText", entryStyle.getGTKColor(512, GTKColorType.TEXT_FOREGROUND));
        table.put("textInactiveText", entryStyle.getGTKColor(8, GTKColorType.TEXT_FOREGROUND));
        Object caretColor = entryStyle.getClassSpecificValue("cursor-color");
        if (caretColor == null) {
            caretColor = GTKStyle.BLACK_COLOR;
        }
        table.put("caretColor", caretColor);
        GTKStyle menuStyle = (GTKStyle)factory.getStyle(null, Region.MENU_ITEM);
        table.put("menu", menuStyle.getGTKColor(1, GTKColorType.BACKGROUND));
        table.put("menuText", menuStyle.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        GTKStyle scrollbarStyle = (GTKStyle)factory.getStyle(null, Region.SCROLL_BAR);
        table.put("scrollbar", scrollbarStyle.getGTKColor(1, GTKColorType.BACKGROUND));
        GTKStyle infoStyle = (GTKStyle)factory.getStyle(null, Region.OPTION_PANE);
        table.put("info", infoStyle.getGTKColor(1, GTKColorType.BACKGROUND));
        table.put("infoText", infoStyle.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        GTKStyle desktopStyle = (GTKStyle)factory.getStyle(null, Region.DESKTOP_PANE);
        table.put("desktop", desktopStyle.getGTKColor(1, GTKColorType.BACKGROUND));
        GTKStyle widgetStyle = (GTKStyle)factory.getStyle(null, Region.LABEL);
        Color bg = widgetStyle.getGTKColor(1, GTKColorType.BACKGROUND);
        table.put("control", bg);
        table.put("controlHighlight", bg);
        table.put("controlText", widgetStyle.getGTKColor(1, GTKColorType.TEXT_FOREGROUND));
        table.put("controlLtHighlight", widgetStyle.getGTKColor(1, GTKColorType.LIGHT));
        table.put("controlShadow", widgetStyle.getGTKColor(1, GTKColorType.DARK));
        table.put("controlDkShadow", widgetStyle.getGTKColor(1, GTKColorType.BLACK));
        table.put("light", widgetStyle.getGTKColor(1, GTKColorType.LIGHT));
        table.put("mid", widgetStyle.getGTKColor(1, GTKColorType.MID));
        table.put("dark", widgetStyle.getGTKColor(1, GTKColorType.DARK));
        table.put("black", widgetStyle.getGTKColor(1, GTKColorType.BLACK));
        table.put("white", widgetStyle.getGTKColor(1, GTKColorType.WHITE));
    }

    public static ComponentUI createUI(JComponent c) {
        String key = c.getUIClassID().intern();
        if (key == "FileChooserUI") {
            return GTKFileChooserUI.createUI(c);
        }
        return SynthLookAndFeel.createUI(c);
    }

    static String getGtkThemeName() {
        return gtkThemeName;
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    @Override
    public void initialize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof UNIXToolkit && !((UNIXToolkit)toolkit).loadGTK()) {
            throw new InternalError("Unable to load native GTK libraries");
        }
        super.initialize();
        this.inInitialize = true;
        this.loadStyles();
        this.inInitialize = false;
        gtkAAFontSettingsCond = !isSunCJK && SwingUtilities2.isLocalDisplay();
        aaTextInfo = SwingUtilities2.AATextInfo.getAATextInfo(gtkAAFontSettingsCond);
    }

    private static void flushUnreferenced() {
        WeakPCL pcl;
        while ((pcl = (WeakPCL)queue.poll()) != null) {
            pcl.dispose();
        }
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit instanceof SunToolkit && ((SunToolkit)toolkit).isNativeGTKAvailable();
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public String getDescription() {
        return "GTK look and feel";
    }

    @Override
    public String getName() {
        return "GTK look and feel";
    }

    @Override
    public String getID() {
        return "GTK";
    }

    @Override
    protected void loadSystemColors(UIDefaults table, String[] systemColors, boolean useNative) {
        super.loadSystemColors(table, systemColors, false);
    }

    private void loadStyles() {
        gtkThemeName = (String)Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Net/ThemeName");
        GTKLookAndFeel.setStyleFactory(this.getGTKStyleFactory());
        if (!this.inInitialize) {
            UIDefaults table = UIManager.getLookAndFeelDefaults();
            this.initSystemColorDefaults(table);
            this.initComponentDefaults(table);
        }
    }

    private GTKStyleFactory getGTKStyleFactory() {
        Font defaultFont;
        Object fontName;
        GTKEngine engine = GTKEngine.INSTANCE;
        Object iconSizes = engine.getSetting(GTKEngine.Settings.GTK_ICON_SIZES);
        if (iconSizes instanceof String && !this.configIconSizes((String)iconSizes)) {
            System.err.println("Error parsing gtk-icon-sizes string: '" + iconSizes + "'");
        }
        if (!((fontName = Toolkit.getDefaultToolkit().getDesktopProperty("gnome.Gtk/FontName")) instanceof String) && !((fontName = engine.getSetting(GTKEngine.Settings.GTK_FONT_NAME)) instanceof String)) {
            fontName = "sans 10";
        }
        if (this.styleFactory == null) {
            this.styleFactory = new GTKStyleFactory();
        }
        this.fallbackFont = defaultFont = PangoFonts.lookupFont((String)fontName);
        this.styleFactory.initStyles(defaultFont);
        return this.styleFactory;
    }

    private boolean configIconSizes(String sizeString) {
        String[] sizes = sizeString.split(":");
        for (int i = 0; i < sizes.length; ++i) {
            int h;
            int w;
            String[] splits = sizes[i].split("=");
            if (splits.length != 2) {
                return false;
            }
            String size = splits[0].trim().intern();
            if (size.length() < 1) {
                return false;
            }
            if ((splits = splits[1].split(",")).length != 2) {
                return false;
            }
            String width = splits[0].trim();
            String height = splits[1].trim();
            if (width.length() < 1 || height.length() < 1) {
                return false;
            }
            try {
                w = Integer.parseInt(width);
                h = Integer.parseInt(height);
            }
            catch (NumberFormatException nfe) {
                return false;
            }
            if (w > 0 && h > 0) {
                int type = GTKStyle.GTKStockIconInfo.getIconType(size);
                GTKStyle.GTKStockIconInfo.setIconSize(type, w, h);
                continue;
            }
            System.err.println("Invalid size in gtk-icon-sizes: " + w + "," + h);
        }
        return true;
    }

    @Override
    public boolean shouldUpdateStyleOnAncestorChanged() {
        return true;
    }

    @Override
    public LayoutStyle getLayoutStyle() {
        return GnomeLayoutStyle.INSTANCE;
    }

    static {
        boolean cjkLocale;
        gtkThemeName = "Default";
        String version = AccessController.doPrivileged(new GetPropertyAction("swing.gtk.version"));
        IS_22 = version != null ? version.equals("2.2") : true;
        String language = Locale.getDefault().getLanguage();
        boolean bl = cjkLocale = Locale.CHINESE.getLanguage().equals(language) || Locale.JAPANESE.getLanguage().equals(language) || Locale.KOREAN.getLanguage().equals(language);
        if (cjkLocale) {
            boolean isSunDesktop = false;
            switch (OSInfo.getOSType()) {
                case SOLARIS: {
                    isSunDesktop = true;
                    break;
                }
                case LINUX: {
                    Boolean val = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                        @Override
                        public Boolean run() {
                            File f = new File("/etc/sun-release");
                            return f.exists();
                        }
                    });
                    isSunDesktop = val;
                }
            }
            if (isSunDesktop && !SunGraphicsEnvironment.isOpenSolaris) {
                isSunCJK = true;
            }
        }
        queue = new ReferenceQueue();
    }

    private static class GnomeLayoutStyle
    extends DefaultLayoutStyle {
        private static GnomeLayoutStyle INSTANCE = new GnomeLayoutStyle();

        private GnomeLayoutStyle() {
        }

        @Override
        public int getPreferredGap(JComponent component1, JComponent component2, LayoutStyle.ComponentPlacement type, int position, Container parent) {
            super.getPreferredGap(component1, component2, type, position, parent);
            switch (type) {
                case INDENT: {
                    if (position == 3 || position == 7) {
                        return 12;
                    }
                }
                case RELATED: {
                    if (this.isLabelAndNonlabel(component1, component2, position)) {
                        return 12;
                    }
                    return 6;
                }
                case UNRELATED: {
                    return 12;
                }
            }
            return 0;
        }

        @Override
        public int getContainerGap(JComponent component, int position, Container parent) {
            super.getContainerGap(component, position, parent);
            return 12;
        }
    }

    static class WeakPCL
    extends WeakReference<GTKLookAndFeel>
    implements PropertyChangeListener {
        private Toolkit kit;
        private String key;

        WeakPCL(GTKLookAndFeel target, Toolkit kit, String key) {
            super(target, queue);
            this.kit = kit;
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public void propertyChange(final PropertyChangeEvent pce) {
            final GTKLookAndFeel lnf = (GTKLookAndFeel)this.get();
            if (lnf == null || UIManager.getLookAndFeel() != lnf) {
                this.dispose();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String name = pce.getPropertyName();
                        if ("gnome.Net/ThemeName".equals(name)) {
                            GTKEngine.INSTANCE.themeChanged();
                            GTKIconFactory.resetIcons();
                        }
                        lnf.loadStyles();
                        Window[] appWindows = Window.getWindows();
                        for (int i = 0; i < appWindows.length; ++i) {
                            SynthLookAndFeel.updateStyles(appWindows[i]);
                        }
                    }
                });
            }
        }

        void dispose() {
            this.kit.removePropertyChangeListener(this.key, this);
        }
    }
}

