/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.ComponentUI;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.TabListPopupAction;
import org.netbeans.swing.tabcontrol.WinsysInfoForTabbedContainer;
import org.netbeans.swing.tabcontrol.event.TabActionEvent;
import org.netbeans.swing.tabcontrol.plaf.TabControlButton;
import org.openide.util.ImageUtilities;
import org.openide.windows.WindowManager;

public class TabControlButtonFactory {
    private TabControlButtonFactory() {
    }

    public static Icon getIcon(String string) {
        ImageIcon imageIcon = ImageUtilities.loadImageIcon((String)string, (boolean)true);
        if (null == imageIcon) {
            Logger.getLogger(TabControlButtonFactory.class.getName()).log(Level.INFO, "Cannot find button icon: " + string);
        }
        return imageIcon;
    }

    public static TabControlButton createCloseButton(TabDisplayer tabDisplayer) {
        return new CloseButton(tabDisplayer);
    }

    public static TabControlButton createCloseGroupButton(TabDisplayer tabDisplayer) {
        return new CloseGroupButton(tabDisplayer);
    }

    public static TabControlButton createSlidePinButton(TabDisplayer tabDisplayer) {
        return new SlidePinButton(tabDisplayer);
    }

    public static TabControlButton createSlideGroupButton(TabDisplayer tabDisplayer) {
        return new SlideGroupButton(tabDisplayer);
    }

    public static TabControlButton createRestoreGroupButton(TabDisplayer tabDisplayer, String string) {
        return new RestoreGroupButton(tabDisplayer, string);
    }

    public static TabControlButton createMaximizeRestoreButton(TabDisplayer tabDisplayer, boolean bl) {
        return new MaximizeRestoreButton(tabDisplayer, bl);
    }

    public static TabControlButton createScrollLeftButton(TabDisplayer tabDisplayer, Action action, boolean bl) {
        TimerButton timerButton = new TimerButton(9, tabDisplayer, action, bl);
        timerButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Scroll_Documents_Left"));
        return timerButton;
    }

    public static TabControlButton createScrollRightButton(TabDisplayer tabDisplayer, Action action, boolean bl) {
        TimerButton timerButton = new TimerButton(10, tabDisplayer, action, bl);
        timerButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Scroll_Documents_Right"));
        return timerButton;
    }

    public static TabControlButton createDropDownButton(TabDisplayer tabDisplayer, boolean bl) {
        return new DropDownButton(tabDisplayer, bl);
    }

    private static Component getActiveTab(TabDisplayer tabDisplayer) {
        Component component = null;
        int n = tabDisplayer.getSelectionModel().getSelectedIndex();
        if (n >= 0) {
            TabData tabData = tabDisplayer.getModel().getTab(n);
            component = tabData.getComponent();
        }
        return component;
    }

    private static class DropDownButton
    extends TabControlButton {
        private boolean forcePressedIcon = false;

        public DropDownButton(TabDisplayer tabDisplayer, boolean bl) {
            super(8, tabDisplayer, bl);
            this.setAction(new TabListPopupAction(tabDisplayer));
            this.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Show_Opened_Documents_List"));
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (this.isEnabled()) {
                if (mouseEvent.getID() == 501) {
                    this.forcePressedIcon = true;
                    this.repaint();
                    this.getAction().actionPerformed(new ActionEvent(this, 1001, "pressed"));
                    return;
                }
            }
            if (!this.isEnabled()) return;
            if (mouseEvent.getID() != 502) return;
            this.forcePressedIcon = false;
            this.repaint();
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            return null;
        }

        @Override
        void performAction(ActionEvent actionEvent) {
        }

        @Override
        public Icon getRolloverIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getRolloverIcon();
        }

        @Override
        public Icon getIcon() {
            if (this.forcePressedIcon) {
                return this.getPressedIcon();
            }
            return super.getIcon();
        }
    }

    private static class TimerButton
    extends TabControlButton
    implements ActionListener {
        Timer timer = null;
        int count = 0;

        public TimerButton(int n, TabDisplayer tabDisplayer, Action action, boolean bl) {
            super(n, tabDisplayer, bl);
            this.setAction(action);
        }

        private Timer getTimer() {
            if (this.timer == null) {
                this.timer = new Timer(400, this);
                this.timer.setRepeats(true);
            }
            return this.timer;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ++this.count;
            if (this.count > 2) {
                if (this.count > 5) {
                    this.timer.setDelay(75);
                } else {
                    this.timer.setDelay(200);
                }
            }
            this.performAction();
        }

        private void performAction() {
            if (!this.isEnabled()) {
                this.stopTimer();
                return;
            }
            this.getAction().actionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
        }

        private void startTimer() {
            Timer timer = this.getTimer();
            if (timer.isRunning()) {
                return;
            }
            this.repaint();
            timer.setDelay(400);
            timer.start();
        }

        private void stopTimer() {
            if (this.timer != null) {
                this.timer.stop();
            }
            this.repaint();
            this.count = 0;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        protected void processMouseEvent(MouseEvent var1_1) {
            if (!this.isEnabled()) ** GOTO lbl-1000
            if (var1_1.getID() == 501) {
                this.startTimer();
            } else if (var1_1.getID() == 502) {
                this.stopTimer();
            }
            super.processMouseEvent(var1_1);
        }

        @Override
        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            if (focusEvent.getID() == 1005) {
                this.stopTimer();
            }
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            return null;
        }
    }

    private static class MaximizeRestoreButton
    extends TabControlButton {
        public MaximizeRestoreButton(TabDisplayer tabDisplayer, boolean bl) {
            super(-1, tabDisplayer, bl);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            return "maximize";
        }

        @Override
        protected int getButtonId() {
            WinsysInfoForTabbedContainer winsysInfoForTabbedContainer;
            int n = 3;
            Component component = TabControlButtonFactory.getActiveTab(this.getTabDisplayer());
            if (null != component && null != (winsysInfoForTabbedContainer = this.getTabDisplayer().getContainerWinsysInfo()) && winsysInfoForTabbedContainer.inMaximizedMode(component)) {
                n = 4;
            }
            return n;
        }

        @Override
        public String getToolTipText() {
            if (this.getButtonId() == 3) {
                return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Maximize_Window");
            }
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Restore_Window");
        }
    }

    private static class RestoreGroupButton
    extends TabControlButton {
        private final String groupName;
        private static boolean useCustomUI = true;

        public RestoreGroupButton(TabDisplayer tabDisplayer, String string) {
            super(tabDisplayer);
            assert (null != string);
            this.groupName = string;
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            return "restoreGroup";
        }

        @Override
        protected int getButtonId() {
            return 11;
        }

        @Override
        protected TabActionEvent createTabActionEvent(ActionEvent actionEvent) {
            TabActionEvent tabActionEvent = super.createTabActionEvent(actionEvent);
            tabActionEvent.setGroupName(this.groupName);
            return tabActionEvent;
        }

        @Override
        public String getToolTipText() {
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Restore_Window_Group");
        }

        @Override
        public String getUIClassID() {
            return useCustomUI ? "RestoreGroupButtonUI" : super.getUIClassID();
        }

        @Override
        public void updateUI() {
            ButtonUI buttonUI = null;
            Class<? extends ComponentUI> clazz = UIManager.getDefaults().getUIClass(this.getUIClassID());
            if (null != clazz) {
                buttonUI = (ButtonUI)UIManager.getUI(this);
            }
            if (buttonUI != null) {
                this.setUI(buttonUI);
            } else {
                useCustomUI = false;
                super.updateUI();
            }
        }
    }

    private static class SlideGroupButton
    extends TabControlButton {
        public SlideGroupButton(TabDisplayer tabDisplayer) {
            super(tabDisplayer);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            return "minimizeGroup";
        }

        @Override
        protected int getButtonId() {
            return 12;
        }

        @Override
        public String getToolTipText() {
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Minimize_Window_Group");
        }

        @Override
        public void addNotify() {
            boolean bl;
            super.addNotify();
            Window window = SwingUtilities.getWindowAncestor(this.displayer);
            boolean bl2 = bl = window != WindowManager.getDefault().getMainWindow();
            if (bl) {
                this.setVisible(false);
            }
        }
    }

    private static class SlidePinButton
    extends TabControlButton {
        public SlidePinButton(TabDisplayer tabDisplayer) {
            super(tabDisplayer);
            ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
            toolTipManager.registerComponent(this);
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            if (this.getButtonId() == 2) {
                return "disableAutoHide";
            }
            return "enableAutoHide";
        }

        @Override
        protected int getButtonId() {
            WinsysInfoForTabbedContainer winsysInfoForTabbedContainer;
            int n = 2;
            Component component = TabControlButtonFactory.getActiveTab(this.getTabDisplayer());
            if (null != component && null != (winsysInfoForTabbedContainer = this.getTabDisplayer().getContainerWinsysInfo())) {
                Object object = winsysInfoForTabbedContainer.getOrientation(component);
                if (TabDisplayer.ORIENTATION_EAST.equals(object)) {
                    n = 6;
                } else if (TabDisplayer.ORIENTATION_WEST.equals(object)) {
                    n = 5;
                } else if (TabDisplayer.ORIENTATION_SOUTH.equals(object)) {
                    n = 7;
                }
            }
            return n;
        }

        @Override
        public String getToolTipText() {
            if (this.getButtonId() == 2) {
                return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Pin");
            }
            return ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Minimize_Window");
        }

        @Override
        public void addNotify() {
            boolean bl;
            super.addNotify();
            Window window = SwingUtilities.getWindowAncestor(this.displayer);
            boolean bl2 = bl = window != WindowManager.getDefault().getMainWindow();
            if (bl) {
                this.setVisible(false);
            }
        }
    }

    private static class CloseGroupButton
    extends TabControlButton {
        public CloseGroupButton(TabDisplayer tabDisplayer) {
            super(1, tabDisplayer);
            this.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Close_Window_Group"));
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            return "closeGroup";
        }
    }

    private static class CloseButton
    extends TabControlButton {
        public CloseButton(TabDisplayer tabDisplayer) {
            super(1, tabDisplayer);
            this.setToolTipText(ResourceBundle.getBundle("org/netbeans/swing/tabcontrol/plaf/Bundle").getString("Tip_Close_Window"));
        }

        @Override
        protected String getTabActionCommand(ActionEvent actionEvent) {
            return "close";
        }
    }
}

