/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.crypto.Cipher;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.CounterSignatureDigestCalculator;
import org.bouncycastle.cms.DigestCalculator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformationStore;

public class SignerInformation {
    private SignerId sid;
    private SignerInfo info;
    private AlgorithmIdentifier digestAlgorithm;
    private AlgorithmIdentifier encryptionAlgorithm;
    private final ASN1Set signedAttributeSet;
    private final ASN1Set unsignedAttributeSet;
    private CMSProcessable content;
    private byte[] signature;
    private DERObjectIdentifier contentType;
    private DigestCalculator digestCalculator;
    private byte[] resultDigest;
    private AttributeTable signedAttributeValues;
    private AttributeTable unsignedAttributeValues;

    SignerInformation(SignerInfo signerInfo, DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, DigestCalculator digestCalculator) {
        this.info = signerInfo;
        this.sid = new SignerId();
        this.contentType = dERObjectIdentifier;
        try {
            SignerIdentifier signerIdentifier = signerInfo.getSID();
            if (signerIdentifier.isTagged()) {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance((Object)signerIdentifier.getId());
                this.sid.setSubjectKeyIdentifier(aSN1OctetString.getEncoded());
            } else {
                IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)signerIdentifier.getId());
                this.sid.setIssuer(issuerAndSerialNumber.getName().getEncoded());
                this.sid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid sid in SignerInfo");
        }
        this.digestAlgorithm = signerInfo.getDigestAlgorithm();
        this.signedAttributeSet = signerInfo.getAuthenticatedAttributes();
        this.unsignedAttributeSet = signerInfo.getUnauthenticatedAttributes();
        this.encryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        this.signature = signerInfo.getEncryptedDigest().getOctets();
        this.content = cMSProcessable;
        this.digestCalculator = digestCalculator;
    }

    private byte[] encodeObj(DEREncodable dEREncodable) throws IOException {
        if (dEREncodable != null) {
            return dEREncodable.getDERObject().getEncoded();
        }
        return null;
    }

    public SignerId getSID() {
        return this.sid;
    }

    public int getVersion() {
        return this.info.getVersion().getValue().intValue();
    }

    public AlgorithmIdentifier getDigestAlgorithmID() {
        return this.digestAlgorithm;
    }

    public String getDigestAlgOID() {
        return this.digestAlgorithm.getObjectId().getId();
    }

    public byte[] getDigestAlgParams() {
        try {
            return this.encodeObj(this.digestAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting digest parameters " + exception);
        }
    }

    public byte[] getContentDigest() {
        if (this.resultDigest == null) {
            throw new IllegalStateException("method can only be called after verify.");
        }
        return (byte[])this.resultDigest.clone();
    }

    public String getEncryptionAlgOID() {
        return this.encryptionAlgorithm.getObjectId().getId();
    }

    public byte[] getEncryptionAlgParams() {
        try {
            return this.encodeObj(this.encryptionAlgorithm.getParameters());
        }
        catch (Exception exception) {
            throw new RuntimeException("exception getting encryption parameters " + exception);
        }
    }

    public AttributeTable getSignedAttributes() {
        if (this.signedAttributeSet != null && this.signedAttributeValues == null) {
            this.signedAttributeValues = new AttributeTable(this.signedAttributeSet);
        }
        return this.signedAttributeValues;
    }

    public AttributeTable getUnsignedAttributes() {
        if (this.unsignedAttributeSet != null && this.unsignedAttributeValues == null) {
            this.unsignedAttributeValues = new AttributeTable(this.unsignedAttributeSet);
        }
        return this.unsignedAttributeValues;
    }

    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    public SignerInformationStore getCounterSignatures() {
        AttributeTable attributeTable = this.getUnsignedAttributes();
        if (attributeTable == null) {
            return new SignerInformationStore(new ArrayList(0));
        }
        ArrayList<SignerInformation> arrayList = new ArrayList<SignerInformation>();
        ASN1EncodableVector aSN1EncodableVector = attributeTable.getAll(CMSAttributes.counterSignature);
        for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
            Attribute attribute = (Attribute)aSN1EncodableVector.get(i);
            ASN1Set aSN1Set = attribute.getAttrValues();
            if (aSN1Set.size() < 1) {
                // empty if block
            }
            Enumeration enumeration = aSN1Set.getObjects();
            while (enumeration.hasMoreElements()) {
                SignerInfo signerInfo = SignerInfo.getInstance(enumeration.nextElement());
                String string = CMSSignedHelper.INSTANCE.getDigestAlgName(signerInfo.getDigestAlgorithm().getObjectId().getId());
                arrayList.add(new SignerInformation(signerInfo, CMSAttributes.counterSignature, null, new CounterSignatureDigestCalculator(string, null, this.getSignature())));
            }
        }
        return new SignerInformationStore(arrayList);
    }

    public byte[] getEncodedSignedAttributes() throws IOException {
        if (this.signedAttributeSet != null) {
            return this.signedAttributeSet.getEncoded("DER");
        }
        return null;
    }

    private boolean doVerify(PublicKey publicKey, Provider provider) throws CMSException, NoSuchAlgorithmException {
        DERObjectIdentifier dERObjectIdentifier;
        String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this.getDigestAlgOID());
        String string2 = string + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string2, provider);
        MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string, provider);
        try {
            if (this.digestCalculator != null) {
                this.resultDigest = this.digestCalculator.getDigest();
            } else {
                if (this.content != null) {
                    this.content.write(new CMSSignedGenerator.DigOutputStream(messageDigest));
                } else if (this.signedAttributeSet == null) {
                    throw new CMSException("data not encapsulated in signature - use detached constructor.");
                }
                this.resultDigest = messageDigest.digest();
            }
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        boolean bl = this.contentType.equals((Object)CMSAttributes.counterSignature);
        DERObject dERObject = this.getSingleValuedSignedAttribute(CMSAttributes.contentType, "content-type");
        if (dERObject == null) {
            if (!bl && this.signedAttributeSet != null) {
                throw new CMSException("The content-type attribute type MUST be present whenever signed attributes are present in signed-data");
            }
        } else {
            if (bl) {
                throw new CMSException("[For counter signatures,] the signedAttributes field MUST NOT contain a content-type attribute");
            }
            if (!(dERObject instanceof DERObjectIdentifier)) {
                throw new CMSException("content-type attribute value not of ASN.1 type 'OBJECT IDENTIFIER'");
            }
            dERObjectIdentifier = (DERObjectIdentifier)dERObject;
            if (!dERObjectIdentifier.equals((Object)this.contentType)) {
                throw new CMSException("content-type attribute value does not match eContentType");
            }
        }
        if ((dERObject = this.getSingleValuedSignedAttribute(CMSAttributes.messageDigest, "message-digest")) == null) {
            if (this.signedAttributeSet != null) {
                throw new CMSException("the message-digest signed attribute type MUST be present when there are any signed attributes present");
            }
        } else {
            if (!(dERObject instanceof ASN1OctetString)) {
                throw new CMSException("message-digest attribute value not of ASN.1 type 'OCTET STRING'");
            }
            dERObjectIdentifier = (ASN1OctetString)dERObject;
            if (!MessageDigest.isEqual(this.resultDigest, dERObjectIdentifier.getOctets())) {
                throw new CMSException("message-digest attribute value does not match calculated value");
            }
        }
        if ((dERObject = this.getSignedAttributes()) != null && dERObject.getAll(CMSAttributes.counterSignature).size() > 0) {
            throw new CMSException("A countersignature attribute MUST NOT be a signed attribute");
        }
        dERObjectIdentifier = this.getUnsignedAttributes();
        if (dERObjectIdentifier != null) {
            ASN1EncodableVector aSN1EncodableVector = dERObjectIdentifier.getAll(CMSAttributes.counterSignature);
            for (int i = 0; i < aSN1EncodableVector.size(); ++i) {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(i);
                if (attribute.getAttrValues().size() >= 1) continue;
                throw new CMSException("A countersignature attribute MUST contain at least one AttributeValue");
            }
        }
        try {
            signature.initVerify(publicKey);
            if (this.signedAttributeSet == null) {
                if (this.digestCalculator != null) {
                    return this.verifyDigest(this.resultDigest, publicKey, this.getSignature(), provider);
                }
                if (this.content != null) {
                    this.content.write(new CMSSignedGenerator.SigOutputStream(signature));
                }
            } else {
                signature.update(this.getEncodedSignedAttributes());
            }
            return signature.verify(this.getSignature());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key not appropriate to signature in message.", invalidKeyException);
        }
        catch (IOException iOException) {
            throw new CMSException("can't process mime object to create signature.", iOException);
        }
        catch (SignatureException signatureException) {
            throw new CMSException("invalid signature format in message: " + signatureException.getMessage(), signatureException);
        }
    }

    private boolean isNull(DEREncodable dEREncodable) {
        return dEREncodable instanceof ASN1Null || dEREncodable == null;
    }

    private DigestInfo derDecode(byte[] byArray) throws IOException, CMSException {
        if (byArray[0] != 48) {
            throw new IOException("not a digest info object");
        }
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        DigestInfo digestInfo = new DigestInfo((ASN1Sequence)aSN1InputStream.readObject());
        if (digestInfo.getEncoded().length != byArray.length) {
            throw new CMSException("malformed RSA signature");
        }
        return digestInfo;
    }

    private boolean verifyDigest(byte[] byArray, PublicKey publicKey, byte[] byArray2, Provider provider) throws NoSuchAlgorithmException, CMSException {
        String string = CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.getEncryptionAlgOID());
        try {
            if (string.equals("RSA")) {
                Cipher cipher = CMSEnvelopedHelper.INSTANCE.getCipherInstance("RSA/ECB/PKCS1Padding", provider);
                cipher.init(2, publicKey);
                DigestInfo digestInfo = this.derDecode(cipher.doFinal(byArray2));
                if (!digestInfo.getAlgorithmId().getObjectId().equals((Object)this.digestAlgorithm.getObjectId())) {
                    return false;
                }
                if (!this.isNull(digestInfo.getAlgorithmId().getParameters())) {
                    return false;
                }
                byte[] byArray3 = digestInfo.getDigest();
                return MessageDigest.isEqual(byArray, byArray3);
            }
            if (string.equals("DSA")) {
                Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance("NONEwithDSA", provider);
                signature.initVerify(publicKey);
                signature.update(byArray);
                return signature.verify(byArray2);
            }
            throw new CMSException("algorithm: " + string + " not supported in base signatures.");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CMSException("Exception processing signature: " + generalSecurityException, generalSecurityException);
        }
        catch (IOException iOException) {
            throw new CMSException("Exception decoding signature: " + iOException, iOException);
        }
    }

    public boolean verify(PublicKey publicKey, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.verify(publicKey, CMSUtils.getProvider(string));
    }

    public boolean verify(PublicKey publicKey, Provider provider) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        this.getSigningTime();
        return this.doVerify(publicKey, provider);
    }

    public boolean verify(X509Certificate x509Certificate, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        return this.verify(x509Certificate, CMSUtils.getProvider(string));
    }

    public boolean verify(X509Certificate x509Certificate, Provider provider) throws NoSuchAlgorithmException, CertificateExpiredException, CertificateNotYetValidException, CMSException {
        Time time = this.getSigningTime();
        if (time != null) {
            x509Certificate.checkValidity(time.getDate());
        }
        return this.doVerify(x509Certificate.getPublicKey(), provider);
    }

    public SignerInfo toSignerInfo() {
        return this.info;
    }

    private DERObject getSingleValuedSignedAttribute(DERObjectIdentifier dERObjectIdentifier, String string) throws CMSException {
        AttributeTable attributeTable = this.getUnsignedAttributes();
        if (attributeTable != null && attributeTable.getAll(dERObjectIdentifier).size() > 0) {
            throw new CMSException("The " + string + " attribute MUST NOT be an unsigned attribute");
        }
        AttributeTable attributeTable2 = this.getSignedAttributes();
        if (attributeTable2 == null) {
            return null;
        }
        ASN1EncodableVector aSN1EncodableVector = attributeTable2.getAll(dERObjectIdentifier);
        switch (aSN1EncodableVector.size()) {
            case 0: {
                return null;
            }
            case 1: {
                Attribute attribute = (Attribute)aSN1EncodableVector.get(0);
                ASN1Set aSN1Set = attribute.getAttrValues();
                if (aSN1Set.size() != 1) {
                    throw new CMSException("A " + string + " attribute MUST have a single attribute value");
                }
                return aSN1Set.getObjectAt(0).getDERObject();
            }
        }
        throw new CMSException("The SignedAttributes in a signerInfo MUST NOT include multiple instances of the " + string + " attribute");
    }

    private Time getSigningTime() throws CMSException {
        DERObject dERObject = this.getSingleValuedSignedAttribute(CMSAttributes.signingTime, "signing-time");
        if (dERObject == null) {
            return null;
        }
        try {
            return Time.getInstance((Object)dERObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CMSException("signing-time attribute value not a valid 'Time' structure");
        }
    }

    public static SignerInformation replaceUnsignedAttributes(SignerInformation signerInformation, AttributeTable attributeTable) {
        SignerInfo signerInfo = signerInformation.info;
        DERSet dERSet = null;
        if (attributeTable != null) {
            dERSet = new DERSet((DEREncodableVector)attributeTable.toASN1EncodableVector());
        }
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)dERSet), signerInformation.contentType, signerInformation.content, null);
    }

    public static SignerInformation addCounterSigners(SignerInformation signerInformation, SignerInformationStore signerInformationStore) {
        SignerInfo signerInfo = signerInformation.info;
        AttributeTable attributeTable = signerInformation.getUnsignedAttributes();
        ASN1EncodableVector aSN1EncodableVector = attributeTable != null ? attributeTable.toASN1EncodableVector() : new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        Iterator iterator = signerInformationStore.getSigners().iterator();
        while (iterator.hasNext()) {
            aSN1EncodableVector2.add((DEREncodable)((SignerInformation)iterator.next()).toSignerInfo());
        }
        aSN1EncodableVector.add((DEREncodable)new Attribute(CMSAttributes.counterSignature, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector2)));
        return new SignerInformation(new SignerInfo(signerInfo.getSID(), signerInfo.getDigestAlgorithm(), signerInfo.getAuthenticatedAttributes(), signerInfo.getDigestEncryptionAlgorithm(), signerInfo.getEncryptedDigest(), (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector)), signerInformation.contentType, signerInformation.content, null);
    }
}

