/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.emp4j.providers;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.pdfsam.emp4j.messages.interfaces.InquirableMessagesSource;

public class ExceptionMessageProvider
implements Serializable {
    private static final long serialVersionUID = -3579371571520612008L;
    public static final String CONFIGURATION_PATH_PARAM = "emp4j.configuration";
    public static final String CONFIGURATION_PATH_DEFAULT = "emp4j.xml";
    private static ExceptionMessageProvider providerInstance;
    private InquirableMessagesSource source;
    private static boolean errorOnCreate;
    private static transient Logger log;

    private ExceptionMessageProvider() throws Exception {
        Document document = this.getConfiguration();
        Node classNode = document.selectSingleNode("/exception-message-provider/source/@class");
        if (classNode == null) {
            throw new Exception("Unable to find MessagesSource class name");
        }
        Class<?> fileSourceClass = Class.forName(classNode.getText());
        Node sourceNode = document.selectSingleNode("/exception-message-provider/source");
        Constructor<?> constructor = fileSourceClass.getConstructor(Node.class);
        this.source = (InquirableMessagesSource)constructor.newInstance(sourceNode);
    }

    public static synchronized ExceptionMessageProvider getInstance() throws Exception {
        try {
            if (providerInstance == null && !errorOnCreate) {
                providerInstance = new ExceptionMessageProvider();
            }
        }
        catch (Throwable t) {
            errorOnCreate = true;
            ExceptionMessageProvider.getLog().fatal("Error creating instance of ExceptionMessageProvider.", t);
        }
        return providerInstance;
    }

    private Document getConfiguration() throws Exception {
        Document retVal;
        SAXReader reader = new SAXReader();
        String configPath = System.getProperty(CONFIGURATION_PATH_PARAM, CONFIGURATION_PATH_DEFAULT);
        File configFile = new File(configPath);
        if (configFile.exists()) {
            retVal = reader.read(configFile);
        } else {
            ClassLoader cl = ExceptionMessageProvider.class.getClassLoader();
            URL resourceUrl = null;
            if (cl != null) {
                resourceUrl = cl.getResource(configPath);
                if (resourceUrl == null) {
                    resourceUrl = cl.getResource(configPath);
                }
            } else {
                resourceUrl = ClassLoader.getSystemResource(configPath);
            }
            if (resourceUrl != null) {
                retVal = reader.read(resourceUrl);
            } else {
                throw new NullPointerException("Cannot locate ExceptionMessageProvider configuration file.");
            }
        }
        return retVal;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone ExceptionMessageProvider object.");
    }

    public synchronized String getExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode) throws Exception {
        return this.source.getExceptionMessage(exceptionTypeKey, exceptionErrorCode);
    }

    public synchronized String getExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode, String[] args) throws Exception {
        return this.source.getExceptionMessage(exceptionTypeKey, exceptionErrorCode, args);
    }

    public synchronized String getLocalizedExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode) throws Exception {
        return this.source.getLocalizedExceptionMessage(exceptionTypeKey, exceptionErrorCode);
    }

    public synchronized String getLocalizedExceptionMessage(Object exceptionTypeKey, int exceptionErrorCode, String[] args) throws Exception {
        return this.source.getLocalizedExceptionMessage(exceptionTypeKey, exceptionErrorCode, args);
    }

    private static Logger getLog() {
        if (log == null) {
            log = Logger.getLogger(ExceptionMessageProvider.class.getPackage().getName());
        }
        return log;
    }

    static {
        errorOnCreate = false;
    }
}

