/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSNotSupported;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.ICSDevice;
import de.intarsys.pdf.content.ICSDeviceFeatures;
import de.intarsys.pdf.content.ICSInterpreter;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDPostScript;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import de.intarsys.tools.geometry.ApplySpaceChangeShape;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;

public abstract class CSDeviceAdapter
implements ICSDevice,
ICSDeviceFeatures {
    public static int MAX_STACK_SIZE = 500;
    private AffineTransform deviceTransform = new AffineTransform();
    protected GraphicsState graphicsState;
    private ICSInterpreter interpreter;
    private GraphicsState[] stack = new GraphicsState[MAX_STACK_SIZE];
    private int stackPtr = 0;
    protected TextState textState;

    protected void basicSetNonStrokeColorSpace(PDColorSpace pDColorSpace) {
        this.graphicsState.nonStrokeColorSpace = pDColorSpace;
        this.graphicsState.nonStrokeColorValues = null;
    }

    protected void basicSetNonStrokeColorValues(float[] fArray) {
        this.graphicsState.nonStrokeColorValues = fArray;
    }

    protected void basicSetStrokeColorSpace(PDColorSpace pDColorSpace) {
        this.graphicsState.strokeColorSpace = pDColorSpace;
        this.graphicsState.strokeColorValues = null;
    }

    protected void basicSetStrokeColorValues(float[] fArray) {
        this.graphicsState.strokeColorValues = fArray;
    }

    @Override
    public void close() {
        this.interpreter = null;
    }

    @Override
    public void compatibilityBegin() {
    }

    @Override
    public void compatibilityEnd() {
    }

    protected void doForm(COSName cOSName, PDForm pDForm) throws CSException {
        this.saveState();
        try {
            CDSRectangle cDSRectangle;
            CDSMatrix cDSMatrix = pDForm.getMatrix();
            if (cDSMatrix != null) {
                this.transform(cDSMatrix.getA(), cDSMatrix.getB(), cDSMatrix.getC(), cDSMatrix.getD(), cDSMatrix.getE(), cDSMatrix.getF());
            }
            if ((cDSRectangle = pDForm.getBoundingBox()) != null) {
                Rectangle2D rectangle2D = cDSRectangle.toNormalizedRectangle();
                this.penRectangle((float)rectangle2D.getMinX(), (float)rectangle2D.getMinY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
                this.pathClipNonZero();
                this.pathEnd();
            }
            if (this.interpreter != null) {
                this.interpreter.process(pDForm.getContentStream(), pDForm.getResources());
            }
        }
        finally {
            this.restoreState();
        }
    }

    protected void doImage(COSName cOSName, PDImage pDImage) throws CSException {
    }

    protected void doPostScript(COSName cOSName, PDPostScript pDPostScript) throws CSException {
    }

    @Override
    public void doShading(COSName cOSName, PDShading pDShading) {
    }

    @Override
    public void doXObject(COSName cOSName, PDXObject pDXObject) {
        if (pDXObject == null) {
            return;
        }
        if (pDXObject.isForm()) {
            try {
                this.doForm(cOSName, (PDForm)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering form", exception);
            }
        } else if (pDXObject.isImage()) {
            try {
                this.doImage(cOSName, (PDImage)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering image", exception);
            }
        } else if (pDXObject.isPostscript()) {
            try {
                this.doPostScript(cOSName, (PDPostScript)pDXObject);
            }
            catch (CSException cSException) {
                throw cSException;
            }
            catch (Exception exception) {
                throw new CSError("Unexpected error rendering postscript", exception);
            }
        } else {
            throw new CSNotSupported("unknown XObject type");
        }
    }

    public AffineTransform getDeviceTransform() {
        return this.deviceTransform;
    }

    @Override
    public GraphicsState getGraphicsState() {
        return this.graphicsState;
    }

    @Override
    public ICSInterpreter getInterpreter() {
        return this.interpreter;
    }

    protected GraphicsState graphicsStateCopy(GraphicsState graphicsState) {
        return graphicsState.copy();
    }

    protected GraphicsState graphicsStateCreate() {
        return new GraphicsState();
    }

    @Override
    public void inlineImage(PDImage pDImage) {
    }

    @Override
    public void markedContentBegin(COSName cOSName) {
    }

    @Override
    public void markedContentBeginProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
    }

    @Override
    public void markedContentEnd() {
    }

    @Override
    public void markedContentPoint(COSName cOSName) {
    }

    @Override
    public void markedContentPointProperties(COSName cOSName, COSName cOSName2, COSDictionary cOSDictionary) {
    }

    @Override
    public void open(ICSInterpreter iCSInterpreter) {
        this.interpreter = iCSInterpreter;
        this.graphicsState = this.graphicsStateCreate();
        this.textState = this.graphicsState.textState;
        this.basicSetNonStrokeColorSpace(PDCSDeviceGray.SINGLETON);
        this.basicSetStrokeColorSpace(PDCSDeviceGray.SINGLETON);
    }

    @Override
    public void pathClipEvenOdd() {
    }

    @Override
    public void pathClipNonZero() {
    }

    @Override
    public void pathClose() {
    }

    @Override
    public void pathCloseFillStrokeEvenOdd() {
    }

    @Override
    public void pathCloseFillStrokeNonZero() {
    }

    @Override
    public void pathCloseStroke() {
    }

    @Override
    public void pathEnd() {
    }

    @Override
    public void pathFillEvenOdd() {
    }

    @Override
    public void pathFillNonZero() {
    }

    @Override
    public void pathFillStrokeEvenOdd() {
    }

    @Override
    public void pathFillStrokeNonZero() {
    }

    @Override
    public void pathStroke() {
    }

    @Override
    public void penCurveToC(float f, float f2, float f3, float f4, float f5, float f6) {
    }

    @Override
    public void penCurveToV(float f, float f2, float f3, float f4) {
    }

    @Override
    public void penCurveToY(float f, float f2, float f3, float f4) {
    }

    @Override
    public void penLineTo(float f, float f2) {
    }

    @Override
    public void penMoveTo(float f, float f2) {
    }

    @Override
    public void penRectangle(float f, float f2, float f3, float f4) {
    }

    @Override
    public void restoreState() {
        if (this.stackPtr == 0) {
            throw new RuntimeException("stack underflow");
        }
        --this.stackPtr;
        this.graphicsState = this.stack[this.stackPtr];
        this.textState = this.graphicsState.textState;
    }

    @Override
    public void saveState() {
        if (this.stackPtr == MAX_STACK_SIZE) {
            throw new RuntimeException("stack overflow");
        }
        this.stack[this.stackPtr++] = this.graphicsState;
        this.graphicsState = this.graphicsStateCopy(this.graphicsState);
        this.textState = this.graphicsState.textState;
    }

    public void setDeviceTransform(AffineTransform affineTransform) {
        this.deviceTransform = affineTransform;
    }

    @Override
    public void setExtendedState(COSName cOSName, PDExtGState pDExtGState) {
        if (pDExtGState == null) {
            return;
        }
        if (this.graphicsState.extState == null) {
            this.graphicsState.extState = (PDExtGState)PDExtGState.META.createFromCos(pDExtGState.cosGetObject().copyShallow());
        } else {
            this.graphicsState.extState.cosGetDict().addAll(pDExtGState.cosGetDict());
        }
        this.graphicsState.capStyle = pDExtGState.getFieldInt(PDExtGState.DK_LC, this.graphicsState.capStyle);
        COSArray cOSArray = pDExtGState.cosGetField(PDExtGState.DK_D).asArray();
        if (cOSArray != null && cOSArray.size() == 2) {
            COSArray cOSArray2 = cOSArray.get(0).asArray();
            COSNumber cOSNumber = cOSArray.get(1).asNumber();
            if (cOSArray2 != null && cOSNumber != null) {
                float[] fArray = new float[cOSArray2.size()];
                int n = 0;
                while (n < cOSArray2.size()) {
                    COSNumber cOSNumber2 = cOSArray2.get(n).asNumber();
                    fArray[n] = cOSNumber2 == null ? 0.0f : cOSNumber2.floatValue();
                    ++n;
                }
                this.graphicsState.dashPattern = fArray;
                this.graphicsState.dashPhase = cOSNumber.intValue();
            }
        }
        this.graphicsState.joinStyle = pDExtGState.getFieldInt(PDExtGState.DK_LJ, this.graphicsState.joinStyle);
        this.setMiterLimit(pDExtGState.getFieldFixed(PDExtGState.DK_ML, this.graphicsState.miterLimit));
        this.setLineWidth(pDExtGState.getFieldFixed(PDExtGState.DK_LW, this.graphicsState.lineWidth));
        this.graphicsState.strokeAlphaValue = pDExtGState.getFieldFixed(PDExtGState.DK_CA, this.graphicsState.strokeAlphaValue);
        this.graphicsState.nonStrokeAlphaValue = pDExtGState.getFieldFixed(PDExtGState.DK_ca, this.graphicsState.nonStrokeAlphaValue);
    }

    @Override
    public void setFlatnessTolerance(float f) {
    }

    @Override
    public void setLineCap(int n) {
        this.graphicsState.capStyle = n;
    }

    @Override
    public void setLineDash(float[] fArray, float f) {
        this.graphicsState.dashPattern = fArray;
        this.graphicsState.dashPhase = f;
    }

    @Override
    public void setLineJoin(int n) {
        this.graphicsState.joinStyle = n;
    }

    @Override
    public void setLineWidth(float f) {
        this.graphicsState.lineWidth = f;
    }

    @Override
    public void setMiterLimit(float f) {
        this.graphicsState.miterLimit = f;
    }

    @Override
    public void setNonStrokeColorCMYK(float f, float f2, float f3, float f4) {
        float[] fArray;
        PDCSDeviceCMYK pDCSDeviceCMYK = PDCSDeviceCMYK.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != pDCSDeviceCMYK) {
            this.basicSetNonStrokeColorSpace(pDCSDeviceCMYK);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, fArray = new float[]{f, f2, f3, f4})) {
            this.basicSetNonStrokeColorValues(fArray);
        }
    }

    @Override
    public void setNonStrokeColorGray(float f) {
        float[] fArray;
        PDCSDeviceGray pDCSDeviceGray = PDCSDeviceGray.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != pDCSDeviceGray) {
            this.basicSetNonStrokeColorSpace(pDCSDeviceGray);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, fArray = new float[]{f})) {
            this.basicSetNonStrokeColorValues(fArray);
        }
    }

    @Override
    public void setNonStrokeColorRGB(float f, float f2, float f3) {
        float[] fArray;
        PDCSDeviceRGB pDCSDeviceRGB = PDCSDeviceRGB.SINGLETON;
        if (this.graphicsState.nonStrokeColorSpace != pDCSDeviceRGB) {
            this.basicSetNonStrokeColorSpace(pDCSDeviceRGB);
        }
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, fArray = new float[]{f, f2, f3})) {
            this.basicSetNonStrokeColorValues(fArray);
        }
    }

    @Override
    public void setNonStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        this.basicSetNonStrokeColorSpace(pDColorSpace);
    }

    @Override
    public void setNonStrokeColorValues(float[] fArray) {
        if (!Arrays.equals(this.graphicsState.nonStrokeColorValues, fArray)) {
            this.basicSetNonStrokeColorValues(fArray);
        }
    }

    @Override
    public void setNonStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
    }

    @Override
    public void setRenderingIntent(COSName cOSName) {
    }

    @Override
    public void setStrokeColorCMYK(float f, float f2, float f3, float f4) {
        float[] fArray;
        PDCSDeviceCMYK pDCSDeviceCMYK = PDCSDeviceCMYK.SINGLETON;
        if (this.graphicsState.strokeColorSpace != pDCSDeviceCMYK) {
            this.basicSetStrokeColorSpace(pDCSDeviceCMYK);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, fArray = new float[]{f, f2, f3, f4})) {
            this.basicSetStrokeColorValues(fArray);
        }
    }

    @Override
    public void setStrokeColorGray(float f) {
        float[] fArray;
        PDCSDeviceGray pDCSDeviceGray = PDCSDeviceGray.SINGLETON;
        if (this.graphicsState.strokeColorSpace != pDCSDeviceGray) {
            this.basicSetStrokeColorSpace(pDCSDeviceGray);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, fArray = new float[]{f})) {
            this.basicSetStrokeColorValues(fArray);
        }
    }

    @Override
    public void setStrokeColorRGB(float f, float f2, float f3) {
        float[] fArray;
        PDCSDeviceRGB pDCSDeviceRGB = PDCSDeviceRGB.SINGLETON;
        if (this.graphicsState.strokeColorSpace != pDCSDeviceRGB) {
            this.basicSetStrokeColorSpace(pDCSDeviceRGB);
        }
        if (!Arrays.equals(this.graphicsState.strokeColorValues, fArray = new float[]{f, f2, f3})) {
            this.basicSetStrokeColorValues(fArray);
        }
    }

    @Override
    public void setStrokeColorSpace(COSName cOSName, PDColorSpace pDColorSpace) {
        this.basicSetStrokeColorSpace(pDColorSpace);
    }

    @Override
    public void setStrokeColorValues(float[] fArray) {
        if (!Arrays.equals(this.graphicsState.strokeColorValues, fArray)) {
            this.basicSetStrokeColorValues(fArray);
        }
    }

    @Override
    public void setStrokeColorValues(float[] fArray, COSName cOSName, PDPattern pDPattern) {
    }

    @Override
    public boolean supportsColorSpace() {
        return true;
    }

    @Override
    public boolean supportsExtendedState() {
        return true;
    }

    @Override
    public boolean supportsFont() {
        return true;
    }

    @Override
    public boolean supportsInlineImage() {
        return true;
    }

    @Override
    public boolean supportsPattern() {
        return true;
    }

    @Override
    public boolean supportsProperties() {
        return true;
    }

    @Override
    public boolean supportsShading() {
        return true;
    }

    @Override
    public boolean supportsXObject() {
        return true;
    }

    @Override
    public void textBegin() {
        this.textState.lineTransform.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.textState.transform.setTransform(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.active = true;
    }

    @Override
    public void textEnd() {
        this.textState.active = false;
    }

    @Override
    public void textLineMove(float f, float f2) {
        this.textState.lineTransform.translate(f, f2);
        this.textState.transform.setTransform(this.textState.lineTransform);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    @Override
    public void textLineNew() {
        this.textState.lineTransform.translate(0.0, this.textState.leading);
        this.textState.transform.setTransform(this.textState.lineTransform);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    @Override
    public void textMove(float f, float f2) {
        this.textState.transform.translate(f, f2);
        this.textState.globalTransform.translate(f, f2);
    }

    @Override
    public void textMoveTo(float f, float f2) {
        float f3 = f - (float)this.textState.transform.getTranslateX();
        float f4 = f2 - (float)this.textState.transform.getTranslateY();
        this.textMove(f3, f4);
    }

    @Override
    public void textSetCharSpacing(float f) {
        this.textState.charSpacing = f;
        this.textState.derivedCharSpacingScaled = this.textState.charSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textSetFont(COSName cOSName, PDFont pDFont, float f) {
        this.textState.font = pDFont;
        this.textState.fontSize = f;
        this.textState.derivedGlyphAdvanceFactor = this.textState.fontSize / 1000.0f * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textSetHorizontalScaling(float f) {
        this.textState.horizontalScaling = f;
        this.textState.derivedHorizontalScalingFactor = this.textState.horizontalScaling / 100.0f;
        this.textState.derivedGlyphAdvanceFactor = this.textState.fontSize / 1000.0f * this.textState.derivedHorizontalScalingFactor;
        this.textState.derivedCharSpacingScaled = this.textState.charSpacing * this.textState.derivedHorizontalScalingFactor;
        this.textState.derivedWordSpacingScaled = this.textState.wordSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textSetLeading(float f) {
        this.textState.leading = f;
    }

    @Override
    public void textSetRenderingMode(int n) {
        this.textState.renderingMode = n;
    }

    @Override
    public void textSetRise(float f) {
        this.textState.rise = f;
    }

    @Override
    public void textSetTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.textState.lineTransform.setTransform(f, f2, f3, f4, f5, f6);
        this.textState.transform.setTransform(f, f2, f3, f4, f5, f6);
        this.textState.globalTransform.setTransform(this.graphicsState.transform);
        this.textState.globalTransform.concatenate(this.textState.transform);
    }

    @Override
    public void textSetWordSpacing(float f) {
        this.textState.wordSpacing = f;
        this.textState.derivedWordSpacingScaled = this.textState.wordSpacing * this.textState.derivedHorizontalScalingFactor;
    }

    @Override
    public void textShow(byte[] byArray, int n, int n2) {
    }

    @Override
    public void textShow(char[] cArray, int n, int n2) {
        byte[] byArray = this.textState.font.getEncoding().encode(cArray, n, n2);
        this.textShow(byArray, 0, byArray.length);
    }

    @Override
    public void textShow(String string) {
        byte[] byArray = this.textState.font.getEncoding().encode(string.toCharArray(), 0, string.length());
        this.textShow(byArray, 0, byArray.length);
    }

    @Override
    public void textT3SetGlyphWidth(float f, float f2) {
    }

    @Override
    public void textT3SetGlyphWidthBB(float f, float f2, float f3, float f4, float f5, float f6) {
    }

    @Override
    public void transform(float f, float f2, float f3, float f4, float f5, float f6) {
        AffineTransform affineTransform = new AffineTransform(f, f2, f3, f4, f5, f6);
        affineTransform.preConcatenate(this.graphicsState.transform);
        this.graphicsState.transform = affineTransform;
        if (this.graphicsState.clip != null) {
            this.graphicsState.clip = ApplySpaceChangeShape.setTransform((Shape)this.graphicsState.clip, (AffineTransform)this.graphicsState.transform);
        }
    }
}

