/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.installresource;

import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.installresource.Install;
import de.intarsys.tools.stream.StreamTools;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class InstallZip
extends Install {
    public InstallZip(String string, String string2, boolean bl) {
        super(string, string2, bl);
    }

    protected void loadEntry(File file, ZipFile zipFile, ZipEntry zipEntry) throws IOException, FileNotFoundException {
        InputStream inputStream = null;
        FileOutputStream fileOutputStream = null;
        String string = zipEntry.getName();
        File file2 = new File(file, string);
        if (zipEntry.isDirectory()) {
            file2.mkdirs();
        } else {
            File file3 = file2.getParentFile();
            if (file3 != null && !file3.exists()) {
                file3.mkdirs();
            }
            inputStream = zipFile.getInputStream(zipEntry);
            fileOutputStream = new FileOutputStream(file2);
            StreamTools.copyStream(inputStream, fileOutputStream);
        }
    }

    @Override
    protected File loadURL(URL uRL) throws IOException {
        File file = TempTools.createTempFile("file", this.getName());
        InstallZip.copy(uRL, file);
        InstallZip.deleteOnExit(file);
        File file2 = TempTools.createTempDir("dir", this.getName());
        this.loadZip(file, file2);
        return file2;
    }

    protected void loadZip(File file, File file2) throws ZipException, IOException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                this.loadEntry(file2, zipFile, zipEntry);
            }
        }
        finally {
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }
}

