/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.Agent;
import clojure.lang.IFn;
import clojure.lang.ISeq;
import clojure.lang.RT;
import clojure.lang.Ref;
import clojure.lang.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class LockingTransaction {
    public static final int RETRY_LIMIT = 10000;
    public static final int LOCK_WAIT_MSECS = 100;
    public static final long BARGE_WAIT_NANOS = 10000000L;
    static final int RUNNING = 0;
    static final int COMMITTING = 1;
    static final int RETRY = 2;
    static final int KILLED = 3;
    static final int COMMITTED = 4;
    static final ThreadLocal<LockingTransaction> transaction = new ThreadLocal();
    private static final AtomicLong lastPoint = new AtomicLong();
    Info info;
    long readPoint;
    long startPoint;
    long startTime;
    final RetryEx retryex = new RetryEx();
    final ArrayList<Agent.Action> actions = new ArrayList();
    final HashMap<Ref, Object> vals = new HashMap();
    final HashSet<Ref> sets = new HashSet();
    final TreeMap<Ref, ArrayList<CFn>> commutes = new TreeMap();
    final HashSet<Ref> ensures = new HashSet();

    void getReadPoint() {
        this.readPoint = lastPoint.incrementAndGet();
    }

    long getCommitPoint() {
        return lastPoint.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop(int status) {
        if (this.info != null) {
            Info info = this.info;
            synchronized (info) {
                this.info.status.set(status);
                this.info.latch.countDown();
            }
            this.info = null;
            this.vals.clear();
            this.sets.clear();
            this.commutes.clear();
        }
    }

    void tryWriteLock(Ref ref2) {
        try {
            if (!ref2.lock.writeLock().tryLock(100L, TimeUnit.MILLISECONDS)) {
                throw this.retryex;
            }
        }
        catch (InterruptedException e2) {
            throw this.retryex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object lock(Ref ref2) {
        this.releaseIfEnsured(ref2);
        boolean unlocked = true;
        try {
            this.tryWriteLock(ref2);
            unlocked = false;
            if (ref2.tvals != null && ref2.tvals.point > this.readPoint) {
                throw this.retryex;
            }
            Info refinfo = ref2.tinfo;
            if (refinfo != null && refinfo != this.info && refinfo.running() && !this.barge(refinfo)) {
                ref2.lock.writeLock().unlock();
                unlocked = true;
                Object object = this.blockAndBail(refinfo);
                return object;
            }
            ref2.tinfo = this.info;
            Object object = ref2.tvals == null ? null : ref2.tvals.val;
            return object;
        }
        finally {
            if (!unlocked) {
                ref2.lock.writeLock().unlock();
            }
        }
    }

    private Object blockAndBail(Info refinfo) {
        this.stop(2);
        try {
            refinfo.latch.await(100L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        throw this.retryex;
    }

    private void releaseIfEnsured(Ref ref2) {
        if (this.ensures.contains(ref2)) {
            this.ensures.remove(ref2);
            ref2.lock.readLock().unlock();
        }
    }

    void abort() throws AbortException {
        this.stop(3);
        throw new AbortException();
    }

    private boolean bargeTimeElapsed() {
        return System.nanoTime() - this.startTime > 10000000L;
    }

    private boolean barge(Info refinfo) {
        boolean barged = false;
        if (this.bargeTimeElapsed() && this.startPoint < refinfo.startPoint && (barged = refinfo.status.compareAndSet(0, 3))) {
            refinfo.latch.countDown();
        }
        return barged;
    }

    static LockingTransaction getEx() {
        LockingTransaction t = transaction.get();
        if (t == null || t.info == null) {
            throw new IllegalStateException("No transaction running");
        }
        return t;
    }

    public static boolean isRunning() {
        return LockingTransaction.getRunning() != null;
    }

    static LockingTransaction getRunning() {
        LockingTransaction t = transaction.get();
        if (t == null || t.info == null) {
            return null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object runInTransaction(Callable fn2) throws Exception {
        Object ret;
        LockingTransaction t = transaction.get();
        if (t == null) {
            t = new LockingTransaction();
            transaction.set(t);
            try {
                ret = t.run(fn2);
            }
            finally {
                transaction.remove();
            }
        } else {
            ret = t.info != null ? fn2.call() : t.run(fn2);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    Object run(Callable fn2) throws Exception {
        boolean done = false;
        Object ret = null;
        ArrayList<Ref> locked = new ArrayList<Ref>();
        ArrayList<Notify> notify = new ArrayList<Notify>();
        for (int i = 0; !done && i < 10000; ++i) {
            block40: {
                Ref ref2;
                this.getReadPoint();
                if (i == 0) {
                    this.startPoint = this.readPoint;
                    this.startTime = System.nanoTime();
                }
                this.info = new Info(0, this.startPoint);
                ret = fn2.call();
                if (!this.info.status.compareAndSet(0, 1)) break block40;
                for (Map.Entry e2 : this.commutes.entrySet()) {
                    ref2 = (Ref)e2.getKey();
                    if (this.sets.contains(ref2)) continue;
                    boolean wasEnsured = this.ensures.contains(ref2);
                    this.releaseIfEnsured(ref2);
                    this.tryWriteLock(ref2);
                    locked.add(ref2);
                    if (wasEnsured && ref2.tvals != null && ref2.tvals.point > this.readPoint) {
                        throw this.retryex;
                    }
                    Info refinfo = ref2.tinfo;
                    if (refinfo != null && refinfo != this.info && refinfo.running() && !this.barge(refinfo)) {
                        throw this.retryex;
                    }
                    Object val2 = ref2.tvals == null ? null : ref2.tvals.val;
                    this.vals.put(ref2, val2);
                    for (CFn f : (ArrayList)e2.getValue()) {
                        this.vals.put(ref2, f.fn.applyTo(RT.cons(this.vals.get(ref2), f.args)));
                    }
                }
                for (Ref ref3 : this.sets) {
                    this.tryWriteLock(ref3);
                    locked.add(ref3);
                }
                for (Map.Entry e2 : this.vals.entrySet()) {
                    ref2 = (Ref)e2.getKey();
                    ref2.validate(ref2.getValidator(), e2.getValue());
                }
                long commitPoint = this.getCommitPoint();
                for (Map.Entry<Ref, Object> e3 : this.vals.entrySet()) {
                    Ref ref4 = e3.getKey();
                    Object oldval = ref4.tvals == null ? null : ref4.tvals.val;
                    Object newval = e3.getValue();
                    int hcount = ref4.histCount();
                    if (ref4.tvals == null) {
                        ref4.tvals = new Ref.TVal(newval, commitPoint);
                    } else if (ref4.faults.get() > 0 && hcount < ref4.maxHistory || hcount < ref4.minHistory) {
                        ref4.tvals = new Ref.TVal(newval, commitPoint, ref4.tvals);
                        ref4.faults.set(0);
                    } else {
                        ref4.tvals = ref4.tvals.next;
                        ref4.tvals.val = newval;
                        ref4.tvals.point = commitPoint;
                    }
                    if (ref4.getWatches().count() <= 0) continue;
                    notify.add(new Notify(ref4, oldval, newval));
                }
                done = true;
                this.info.status.set(4);
            }
            for (int k = locked.size() - 1; k >= 0; --k) {
                ((Ref)locked.get((int)k)).lock.writeLock().unlock();
            }
            locked.clear();
            for (Ref r : this.ensures) {
                r.lock.readLock().unlock();
            }
            this.ensures.clear();
            this.stop(done ? 4 : 2);
            try {
                if (!done) continue;
                for (Notify n : notify) {
                    n.ref.notifyWatches(n.oldval, n.newval);
                }
                for (Agent.Action action : this.actions) {
                    Agent.dispatchAction(action);
                }
                continue;
            }
            finally {
                notify.clear();
                this.actions.clear();
            }
            catch (RetryEx retry) {
                for (int k = locked.size() - 1; k >= 0; --k) {
                    ((Ref)locked.get((int)k)).lock.writeLock().unlock();
                }
                locked.clear();
                for (Ref r : this.ensures) {
                    r.lock.readLock().unlock();
                }
                this.ensures.clear();
                this.stop(done ? 4 : 2);
                try {
                    if (!done) continue;
                    for (Notify n : notify) {
                        n.ref.notifyWatches(n.oldval, n.newval);
                    }
                    for (Agent.Action action : this.actions) {
                        Agent.dispatchAction(action);
                    }
                    continue;
                }
                finally {
                    notify.clear();
                    this.actions.clear();
                }
                catch (Throwable throwable) {
                    for (int k = locked.size() - 1; k >= 0; --k) {
                        ((Ref)locked.get((int)k)).lock.writeLock().unlock();
                    }
                    locked.clear();
                    for (Ref r : this.ensures) {
                        r.lock.readLock().unlock();
                    }
                    this.ensures.clear();
                    this.stop(done ? 4 : 2);
                    try {
                        if (done) {
                            for (Notify n : notify) {
                                n.ref.notifyWatches(n.oldval, n.newval);
                            }
                            for (Agent.Action action : this.actions) {
                                Agent.dispatchAction(action);
                            }
                        }
                    }
                    finally {
                        notify.clear();
                        this.actions.clear();
                    }
                    throw throwable;
                }
            }
        }
        if (!done) {
            throw Util.runtimeException("Transaction failed after reaching retry limit");
        }
        return ret;
    }

    public void enqueue(Agent.Action action) {
        this.actions.add(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doGet(Ref ref2) {
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (this.vals.containsKey(ref2)) {
            return this.vals.get(ref2);
        }
        try {
            ref2.lock.readLock().lock();
            if (ref2.tvals == null) {
                throw new IllegalStateException(ref2.toString() + " is unbound.");
            }
            Ref.TVal ver = ref2.tvals;
            do {
                if (ver.point > this.readPoint) continue;
                Object object = ver.val;
                return object;
            } while ((ver = ver.prior) != ref2.tvals);
        }
        finally {
            ref2.lock.readLock().unlock();
        }
        ref2.faults.incrementAndGet();
        throw this.retryex;
    }

    Object doSet(Ref ref2, Object val2) {
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (this.commutes.containsKey(ref2)) {
            throw new IllegalStateException("Can't set after commute");
        }
        if (!this.sets.contains(ref2)) {
            this.sets.add(ref2);
            this.lock(ref2);
        }
        this.vals.put(ref2, val2);
        return val2;
    }

    void doEnsure(Ref ref2) {
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (this.ensures.contains(ref2)) {
            return;
        }
        ref2.lock.readLock().lock();
        if (ref2.tvals != null && ref2.tvals.point > this.readPoint) {
            ref2.lock.readLock().unlock();
            throw this.retryex;
        }
        Info refinfo = ref2.tinfo;
        if (refinfo != null && refinfo.running()) {
            ref2.lock.readLock().unlock();
            if (refinfo != this.info) {
                this.blockAndBail(refinfo);
            }
        } else {
            this.ensures.add(ref2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object doCommute(Ref ref2, IFn fn2, ISeq args) {
        ArrayList<CFn> fns;
        if (!this.info.running()) {
            throw this.retryex;
        }
        if (!this.vals.containsKey(ref2)) {
            Object val2 = null;
            try {
                ref2.lock.readLock().lock();
                val2 = ref2.tvals == null ? null : ref2.tvals.val;
            }
            finally {
                ref2.lock.readLock().unlock();
            }
            this.vals.put(ref2, val2);
        }
        if ((fns = this.commutes.get(ref2)) == null) {
            fns = new ArrayList();
            this.commutes.put(ref2, fns);
        }
        fns.add(new CFn(fn2, args));
        Object ret = fn2.applyTo(RT.cons(this.vals.get(ref2), args));
        this.vals.put(ref2, ret);
        return ret;
    }

    static class Notify {
        public final Ref ref;
        public final Object oldval;
        public final Object newval;

        Notify(Ref ref2, Object oldval, Object newval) {
            this.ref = ref2;
            this.oldval = oldval;
            this.newval = newval;
        }
    }

    static class CFn {
        final IFn fn;
        final ISeq args;

        public CFn(IFn fn2, ISeq args) {
            this.fn = fn2;
            this.args = args;
        }
    }

    public static class Info {
        final AtomicInteger status;
        final long startPoint;
        final CountDownLatch latch;

        public Info(int status, long startPoint) {
            this.status = new AtomicInteger(status);
            this.startPoint = startPoint;
            this.latch = new CountDownLatch(1);
        }

        public boolean running() {
            int s = this.status.get();
            return s == 0 || s == 1;
        }
    }

    static class AbortException
    extends Exception {
        AbortException() {
        }
    }

    static class RetryEx
    extends Error {
        RetryEx() {
        }
    }
}

