/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.object.RootObjectMapper;

public final class Mapping
implements ToXContent {
    public static final List<String> LEGACY_INCLUDE_IN_OBJECT = Arrays.asList("_all", "_id", "_parent", "_routing", "_timestamp", "_ttl");
    final Version indexCreated;
    final RootObjectMapper root;
    final MetadataFieldMapper[] metadataMappers;
    final ImmutableMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> rootMappersMap;
    final SourceTransform[] sourceTransforms;
    volatile ImmutableMap<String, Object> meta;

    public Mapping(Version indexCreated, RootObjectMapper rootObjectMapper, MetadataFieldMapper[] metadataMappers, SourceTransform[] sourceTransforms, ImmutableMap<String, Object> meta) {
        this.indexCreated = indexCreated;
        this.root = rootObjectMapper;
        this.metadataMappers = metadataMappers;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (MetadataFieldMapper metadataMapper : metadataMappers) {
            if (indexCreated.before(Version.V_2_0_0_beta1) && LEGACY_INCLUDE_IN_OBJECT.contains(metadataMapper.name())) {
                this.root.putMapper(metadataMapper);
            }
            builder.put(metadataMapper.getClass(), (Object)metadataMapper);
        }
        Arrays.sort(metadataMappers, new Comparator<Mapper>(){

            @Override
            public int compare(Mapper o1, Mapper o2) {
                return o1.name().compareTo(o2.name());
            }
        });
        this.rootMappersMap = builder.build();
        this.sourceTransforms = sourceTransforms;
        this.meta = meta;
    }

    public RootObjectMapper root() {
        return this.root;
    }

    public Mapping mappingUpdate(Mapper rootObjectMapper) {
        return new Mapping(this.indexCreated, (RootObjectMapper)rootObjectMapper, this.metadataMappers, this.sourceTransforms, this.meta);
    }

    public <T extends MetadataFieldMapper> T rootMapper(Class<T> clazz) {
        return (T)((MetadataFieldMapper)this.rootMappersMap.get(clazz));
    }

    public void merge(Mapping mergeWith, MergeResult mergeResult) {
        assert (this.metadataMappers.length == mergeWith.metadataMappers.length);
        this.root.merge(mergeWith.root, mergeResult);
        for (MetadataFieldMapper metadataMapper : this.metadataMappers) {
            Object mergeWithMetadataMapper = mergeWith.rootMapper(metadataMapper.getClass());
            if (mergeWithMetadataMapper == null) continue;
            metadataMapper.merge((Mapper)mergeWithMetadataMapper, mergeResult);
        }
        if (!mergeResult.simulate()) {
            this.meta = mergeWith.meta;
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.root.toXContent(builder, params, new ToXContent(){

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                if (Mapping.this.sourceTransforms.length > 0) {
                    if (Mapping.this.sourceTransforms.length == 1) {
                        builder.field("transform");
                        Mapping.this.sourceTransforms[0].toXContent(builder, params);
                    } else {
                        builder.startArray("transform");
                        for (ToXContent toXContent : Mapping.this.sourceTransforms) {
                            toXContent.toXContent(builder, params);
                        }
                        builder.endArray();
                    }
                }
                if (Mapping.this.meta != null && !Mapping.this.meta.isEmpty()) {
                    builder.field("_meta", (Map<String, Object>)Mapping.this.meta);
                }
                for (ToXContent toXContent : Mapping.this.metadataMappers) {
                    toXContent.toXContent(builder, params);
                }
                return builder;
            }
        });
        return builder;
    }

    public BytesReference toBytes() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.toXContent(builder, new ToXContent.MapParams((Map<String, String>)ImmutableMap.of()));
            return builder.endObject().bytes();
        }
        catch (IOException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    public String toString() {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.toXContent(builder, new ToXContent.MapParams((Map<String, String>)ImmutableMap.of()));
            return builder.endObject().string();
        }
        catch (IOException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    public static interface SourceTransform
    extends ToXContent {
        public Map<String, Object> transformSourceAsMap(Map<String, Object> var1);
    }
}

