/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.all.AllField;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.internal.EnabledAttributeMapper;
import org.elasticsearch.index.query.QueryParseContext;

public class AllFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_all";
    public static final String CONTENT_TYPE = "_all";
    private EnabledAttributeMapper enabledState;

    public AllFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? Defaults.FIELD_TYPE.clone() : existing.clone(), Defaults.ENABLED, indexSettings);
    }

    protected AllFieldMapper(MappedFieldType fieldType, EnabledAttributeMapper enabled, Settings indexSettings) {
        super("_all", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.enabledState = enabled;
    }

    public boolean enabled() {
        return this.enabledState.enabled;
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        if (!this.enabledState.enabled) {
            return;
        }
        context.allEntries().reset();
        Analyzer analyzer = this.findAnalyzer(context);
        fields.add(new AllField(this.fieldType().names().indexName(), context.allEntries(), analyzer, this.fieldType()));
    }

    private Analyzer findAnalyzer(ParseContext context) {
        NamedAnalyzer analyzer = this.fieldType().indexAnalyzer();
        if (analyzer == null && (analyzer = context.docMapper().mappers().indexAnalyzer()) == null) {
            analyzer = Lucene.STANDARD_ANALYZER;
        }
        return analyzer;
    }

    @Override
    protected String contentType() {
        return "_all";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        if (!includeDefaults) {
            BytesStreamOutput bytesStreamOutput = new BytesStreamOutput(0);
            XContentBuilder b = new XContentBuilder(builder.contentType().xContent(), bytesStreamOutput);
            b.startObject().flush();
            long pos = bytesStreamOutput.position();
            this.innerToXContent(b, false);
            b.flush();
            if (pos == bytesStreamOutput.position()) {
                return builder;
            }
        }
        builder.startObject("_all");
        this.innerToXContent(builder, includeDefaults);
        builder.endObject();
        return builder;
    }

    private void innerToXContent(XContentBuilder builder, boolean includeDefaults) throws IOException {
        if (includeDefaults || this.enabledState != Defaults.ENABLED) {
            builder.field("enabled", this.enabledState.enabled);
        }
        if (includeDefaults || this.fieldType().stored() != Defaults.FIELD_TYPE.stored()) {
            builder.field("store", this.fieldType().stored());
        }
        if (includeDefaults || this.fieldType().storeTermVectors() != Defaults.FIELD_TYPE.storeTermVectors()) {
            builder.field("store_term_vectors", this.fieldType().storeTermVectors());
        }
        if (includeDefaults || this.fieldType().storeTermVectorOffsets() != Defaults.FIELD_TYPE.storeTermVectorOffsets()) {
            builder.field("store_term_vector_offsets", this.fieldType().storeTermVectorOffsets());
        }
        if (includeDefaults || this.fieldType().storeTermVectorPositions() != Defaults.FIELD_TYPE.storeTermVectorPositions()) {
            builder.field("store_term_vector_positions", this.fieldType().storeTermVectorPositions());
        }
        if (includeDefaults || this.fieldType().storeTermVectorPayloads() != Defaults.FIELD_TYPE.storeTermVectorPayloads()) {
            builder.field("store_term_vector_payloads", this.fieldType().storeTermVectorPayloads());
        }
        if (includeDefaults || this.fieldType().omitNorms() != Defaults.FIELD_TYPE.omitNorms()) {
            builder.field("omit_norms", this.fieldType().omitNorms());
        }
        this.doXContentAnalyzers(builder, includeDefaults);
        if (this.fieldType().similarity() != null) {
            builder.field("similarity", this.fieldType().similarity().name());
        } else if (includeDefaults) {
            builder.field("similarity", "default");
        }
    }

    @Override
    public void merge(Mapper mergeWith, MergeResult mergeResult) throws MergeMappingException {
        if (((AllFieldMapper)mergeWith).enabled() != this.enabled() && ((AllFieldMapper)mergeWith).enabledState != Defaults.ENABLED) {
            mergeResult.addConflict("mapper [" + this.fieldType().names().fullName() + "] enabled is " + this.enabled() + " now encountering " + ((AllFieldMapper)mergeWith).enabled());
        }
        super.merge(mergeWith, mergeResult);
    }

    @Override
    public boolean isGenerated() {
        return true;
    }

    static final class AllFieldType
    extends MappedFieldType {
        public AllFieldType() {
            this.setFieldDataType(new FieldDataType("string"));
        }

        protected AllFieldType(AllFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new AllFieldType(this);
        }

        @Override
        public String typeName() {
            return "_all";
        }

        @Override
        public String value(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }

        @Override
        public Query queryStringTermQuery(Term term) {
            return new AllTermQuery(term);
        }

        @Override
        public Query termQuery(Object value, QueryParseContext context) {
            return this.queryStringTermQuery(this.createTerm(value));
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Map<String, Object> fielddataMap;
            Object format;
            Builder builder = new Builder(parserContext.mapperService().fullName("_all"));
            Object docValues = node.get("doc_values");
            if (docValues != null && XContentMapValues.nodeBooleanValue(docValues)) {
                throw new MapperParsingException("Field [" + name + "] is always tokenized and cannot have doc values");
            }
            Object fielddata = node.get("fielddata");
            if (fielddata != null && "doc_values".equals(format = (fielddataMap = XContentMapValues.nodeMapValue(fielddata, "fielddata")).get("format"))) {
                throw new MapperParsingException("Field [" + name + "] is always tokenized and cannot have doc values");
            }
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("enabled")) {
                    builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode) ? EnabledAttributeMapper.ENABLED : EnabledAttributeMapper.DISABLED);
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("auto_boost") || !parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, AllFieldMapper> {
        private EnabledAttributeMapper enabled = Defaults.ENABLED;

        public Builder(MappedFieldType existing) {
            super("_all", existing == null ? Defaults.FIELD_TYPE : existing);
            this.builder = this;
            this.indexName = "_all";
        }

        public Builder enabled(EnabledAttributeMapper enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public AllFieldMapper build(Mapper.BuilderContext context) {
            if (this.fieldType.indexOptions() == IndexOptions.NONE) {
                this.fieldType.setIndexOptions(Defaults.FIELD_TYPE.indexOptions());
            }
            this.fieldType.setTokenized(true);
            return new AllFieldMapper(this.fieldType, this.enabled, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_all";
        public static final String INDEX_NAME = "_all";
        public static final EnabledAttributeMapper ENABLED = EnabledAttributeMapper.UNSET_ENABLED;
        public static final MappedFieldType FIELD_TYPE = new AllFieldType();

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
            FIELD_TYPE.setTokenized(true);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_all"));
            FIELD_TYPE.freeze();
        }
    }

    public static interface IncludeInAll {
        public void includeInAll(Boolean var1);

        public void includeInAllIfNotSet(Boolean var1);

        public void unsetIncludeInAll();
    }
}

