/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.node;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClientModule;
import org.elasticsearch.cluster.ClusterModule;
import org.elasticsearch.cluster.ClusterNameModule;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.routing.RoutingService;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.lease.Releasables;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoveryService;
import org.elasticsearch.env.Environment;
import org.elasticsearch.env.EnvironmentModule;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeEnvironmentModule;
import org.elasticsearch.gateway.GatewayAllocator;
import org.elasticsearch.gateway.GatewayModule;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.http.HttpServer;
import org.elasticsearch.http.HttpServerModule;
import org.elasticsearch.index.search.shape.ShapeModule;
import org.elasticsearch.indices.IndicesModule;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.breaker.CircuitBreakerModule;
import org.elasticsearch.indices.cache.query.IndicesQueryCache;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.fielddata.cache.IndicesFieldDataCache;
import org.elasticsearch.indices.memory.IndexingMemoryController;
import org.elasticsearch.indices.store.IndicesStore;
import org.elasticsearch.indices.ttl.IndicesTTLService;
import org.elasticsearch.monitor.MonitorModule;
import org.elasticsearch.monitor.MonitorService;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.NodeModule;
import org.elasticsearch.node.internal.InternalSettingsPreparer;
import org.elasticsearch.node.settings.NodeSettingsService;
import org.elasticsearch.percolator.PercolatorModule;
import org.elasticsearch.percolator.PercolatorService;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsModule;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.repositories.RepositoriesModule;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestModule;
import org.elasticsearch.script.ScriptModule;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolModule;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.tribe.TribeModule;
import org.elasticsearch.tribe.TribeService;
import org.elasticsearch.watcher.ResourceWatcherModule;
import org.elasticsearch.watcher.ResourceWatcherService;

public class Node
implements Releasable {
    private static final String CLIENT_TYPE = "node";
    public static final String HTTP_ENABLED = "http.enabled";
    private final Lifecycle lifecycle = new Lifecycle();
    private final Injector injector;
    private final Settings settings;
    private final Environment environment;
    private final PluginsService pluginsService;
    private final Client client;

    public Node(Settings preparedSettings) {
        this(preparedSettings, Version.CURRENT, Collections.emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Node(Settings preparedSettings, Version version, Collection<Class<? extends Plugin>> classpathPlugins) {
        NodeEnvironment nodeEnvironment;
        Settings pSettings = Settings.settingsBuilder().put(preparedSettings).put("client.type", CLIENT_TYPE).build();
        Environment tmpEnv = InternalSettingsPreparer.prepareEnvironment(pSettings, null);
        Settings tmpSettings = TribeService.processSettings(tmpEnv.settings());
        ESLogger logger = Loggers.getLogger(Node.class, tmpSettings.get("name"));
        logger.info("version[{}], pid[{}], build[{}/{}]", version, JvmInfo.jvmInfo().pid(), Build.CURRENT.hashShort(), Build.CURRENT.timestamp());
        logger.info("initializing ...", new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("using config [{}], data [{}], logs [{}], plugins [{}]", tmpEnv.configFile(), Arrays.toString(tmpEnv.dataFiles()), tmpEnv.logsFile(), tmpEnv.pluginsFile());
        }
        this.pluginsService = new PluginsService(tmpSettings, tmpEnv.pluginsFile(), classpathPlugins);
        this.settings = this.pluginsService.updatedSettings();
        this.environment = new Environment(this.settings());
        try {
            nodeEnvironment = new NodeEnvironment(this.settings, this.environment);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to created node environment", ex);
        }
        ThreadPool threadPool = new ThreadPool(this.settings);
        boolean success = false;
        try {
            ModulesBuilder modules = new ModulesBuilder();
            modules.add(new Version.Module(version));
            modules.add(new CircuitBreakerModule(this.settings));
            for (Module pluginModule : this.pluginsService.nodeModules()) {
                modules.add(pluginModule);
            }
            modules.add(new PluginsModule(this.pluginsService));
            modules.add(new SettingsModule(this.settings));
            modules.add(new NodeModule(this));
            modules.add(new NetworkModule());
            modules.add(new ScriptModule(this.settings));
            modules.add(new EnvironmentModule(this.environment));
            modules.add(new NodeEnvironmentModule(nodeEnvironment));
            modules.add(new ClusterNameModule(this.settings));
            modules.add(new ThreadPoolModule(threadPool));
            modules.add(new DiscoveryModule(this.settings));
            modules.add(new ClusterModule(this.settings));
            modules.add(new RestModule(this.settings));
            modules.add(new TransportModule(this.settings));
            if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
                modules.add(new HttpServerModule(this.settings));
            }
            modules.add(new IndicesModule(this.settings));
            modules.add(new SearchModule(this.settings));
            modules.add(new ActionModule(false));
            modules.add(new MonitorModule(this.settings));
            modules.add(new GatewayModule(this.settings));
            modules.add(new NodeClientModule());
            modules.add(new ShapeModule());
            modules.add(new PercolatorModule());
            modules.add(new ResourceWatcherModule());
            modules.add(new RepositoriesModule());
            modules.add(new TribeModule());
            this.pluginsService.processModules(modules);
            this.injector = modules.createInjector();
            this.client = this.injector.getInstance(Client.class);
            threadPool.setNodeSettingsService(this.injector.getInstance(NodeSettingsService.class));
            success = true;
        }
        finally {
            if (!success) {
                nodeEnvironment.close();
                ThreadPool.terminate(threadPool, 10L, TimeUnit.SECONDS);
            }
        }
        logger.info("initialized", new Object[0]);
    }

    public Settings settings() {
        return this.settings;
    }

    public Client client() {
        return this.client;
    }

    public Node start() {
        if (!this.lifecycle.moveToStarted()) {
            return this;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("starting ...", new Object[0]);
        this.injector.getInstance(Discovery.class).setRoutingService(this.injector.getInstance(RoutingService.class));
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.nodeServices()) {
            this.injector.getInstance(plugin).start();
        }
        this.injector.getInstance(MappingUpdatedAction.class).setClient(this.client);
        this.injector.getInstance(IndicesService.class).start();
        this.injector.getInstance(IndexingMemoryController.class).start();
        this.injector.getInstance(IndicesClusterStateService.class).start();
        this.injector.getInstance(IndicesTTLService.class).start();
        this.injector.getInstance(SnapshotsService.class).start();
        this.injector.getInstance(SnapshotShardsService.class).start();
        this.injector.getInstance(TransportService.class).start();
        this.injector.getInstance(ClusterService.class).start();
        this.injector.getInstance(RoutingService.class).start();
        this.injector.getInstance(SearchService.class).start();
        this.injector.getInstance(MonitorService.class).start();
        this.injector.getInstance(RestController.class).start();
        this.injector.getInstance(GatewayAllocator.class).setReallocation(this.injector.getInstance(ClusterService.class), this.injector.getInstance(RoutingService.class));
        DiscoveryService discoService = (DiscoveryService)this.injector.getInstance(DiscoveryService.class).start();
        discoService.waitForInitialState();
        this.injector.getInstance(GatewayService.class).start();
        if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).start();
        }
        this.injector.getInstance(ResourceWatcherService.class).start();
        this.injector.getInstance(TribeService.class).start();
        logger.info("started", new Object[0]);
        return this;
    }

    private Node stop() {
        if (!this.lifecycle.moveToStopped()) {
            return this;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("stopping ...", new Object[0]);
        this.injector.getInstance(TribeService.class).stop();
        this.injector.getInstance(ResourceWatcherService.class).stop();
        if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).stop();
        }
        this.injector.getInstance(SnapshotsService.class).stop();
        this.injector.getInstance(SnapshotShardsService.class).stop();
        this.injector.getInstance(IndicesClusterStateService.class).stop();
        this.injector.getInstance(IndexingMemoryController.class).stop();
        this.injector.getInstance(IndicesTTLService.class).stop();
        this.injector.getInstance(RoutingService.class).stop();
        this.injector.getInstance(ClusterService.class).stop();
        this.injector.getInstance(DiscoveryService.class).stop();
        this.injector.getInstance(MonitorService.class).stop();
        this.injector.getInstance(GatewayService.class).stop();
        this.injector.getInstance(SearchService.class).stop();
        this.injector.getInstance(RestController.class).stop();
        this.injector.getInstance(TransportService.class).stop();
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.nodeServices()) {
            this.injector.getInstance(plugin).stop();
        }
        this.injector.getInstance(IndicesService.class).stop();
        logger.info("stopped", new Object[0]);
        return this;
    }

    @Override
    public synchronized void close() {
        if (this.lifecycle.started()) {
            this.stop();
        }
        if (!this.lifecycle.moveToClosed()) {
            return;
        }
        ESLogger logger = Loggers.getLogger(Node.class, this.settings.get("name"));
        logger.info("closing ...", new Object[0]);
        StopWatch stopWatch = new StopWatch("node_close");
        stopWatch.start("tribe");
        this.injector.getInstance(TribeService.class).close();
        stopWatch.stop().start("http");
        if (this.settings.getAsBoolean(HTTP_ENABLED, (Boolean)true).booleanValue()) {
            this.injector.getInstance(HttpServer.class).close();
        }
        stopWatch.stop().start("snapshot_service");
        this.injector.getInstance(SnapshotsService.class).close();
        this.injector.getInstance(SnapshotShardsService.class).close();
        stopWatch.stop().start("client");
        Releasables.close(this.injector.getInstance(Client.class));
        stopWatch.stop().start("indices_cluster");
        this.injector.getInstance(IndicesClusterStateService.class).close();
        stopWatch.stop().start("indices");
        this.injector.getInstance(IndexingMemoryController.class).close();
        this.injector.getInstance(IndicesTTLService.class).close();
        this.injector.getInstance(IndicesService.class).close();
        this.injector.getInstance(IndicesQueryCache.class).close();
        this.injector.getInstance(IndicesFieldDataCache.class).close();
        this.injector.getInstance(IndicesStore.class).close();
        stopWatch.stop().start("routing");
        this.injector.getInstance(RoutingService.class).close();
        stopWatch.stop().start("cluster");
        this.injector.getInstance(ClusterService.class).close();
        stopWatch.stop().start("discovery");
        this.injector.getInstance(DiscoveryService.class).close();
        stopWatch.stop().start("monitor");
        this.injector.getInstance(MonitorService.class).close();
        stopWatch.stop().start("gateway");
        this.injector.getInstance(GatewayService.class).close();
        stopWatch.stop().start("search");
        this.injector.getInstance(SearchService.class).close();
        stopWatch.stop().start("rest");
        this.injector.getInstance(RestController.class).close();
        stopWatch.stop().start("transport");
        this.injector.getInstance(TransportService.class).close();
        stopWatch.stop().start("percolator_service");
        this.injector.getInstance(PercolatorService.class).close();
        for (Class<? extends LifecycleComponent> plugin : this.pluginsService.nodeServices()) {
            stopWatch.stop().start("plugin(" + plugin.getName() + ")");
            this.injector.getInstance(plugin).close();
        }
        stopWatch.stop().start("script");
        try {
            this.injector.getInstance(ScriptService.class).close();
        }
        catch (IOException e) {
            logger.warn("ScriptService close failed", e, new Object[0]);
        }
        stopWatch.stop().start("thread_pool");
        this.injector.getInstance(ThreadPool.class).shutdown();
        try {
            this.injector.getInstance(ThreadPool.class).awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        stopWatch.stop().start("thread_pool_force_shutdown");
        try {
            this.injector.getInstance(ThreadPool.class).shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
        stopWatch.stop();
        if (logger.isTraceEnabled()) {
            logger.trace("Close times for each service:\n{}", stopWatch.prettyPrint());
        }
        this.injector.getInstance(NodeEnvironment.class).close();
        this.injector.getInstance(PageCacheRecycler.class).close();
        logger.info("closed", new Object[0]);
    }

    public boolean isClosed() {
        return this.lifecycle.closed();
    }

    public Injector injector() {
        return this.injector;
    }
}

