/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.significant;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.significant.BucketSignificancePriorityQueue;
import org.elasticsearch.search.aggregations.bucket.significant.SignificantTerms;
import org.elasticsearch.search.aggregations.bucket.significant.heuristics.SignificanceHeuristic;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class InternalSignificantTerms<A extends InternalSignificantTerms, B extends Bucket>
extends InternalMultiBucketAggregation<A, B>
implements SignificantTerms,
ToXContent,
Streamable {
    protected SignificanceHeuristic significanceHeuristic;
    protected int requiredSize;
    protected long minDocCount;
    protected List<? extends Bucket> buckets;
    protected Map<String, Bucket> bucketMap;
    protected long subsetSize;
    protected long supersetSize;

    protected InternalSignificantTerms() {
    }

    protected InternalSignificantTerms(long subsetSize, long supersetSize, String name, int requiredSize, long minDocCount, SignificanceHeuristic significanceHeuristic, List<? extends Bucket> buckets, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.requiredSize = requiredSize;
        this.minDocCount = minDocCount;
        this.buckets = buckets;
        this.subsetSize = subsetSize;
        this.supersetSize = supersetSize;
        this.significanceHeuristic = significanceHeuristic;
    }

    @Override
    public Iterator<SignificantTerms.Bucket> iterator() {
        Iterator<SignificantTerms.Bucket> o = this.buckets.iterator();
        return o;
    }

    @Override
    public List<SignificantTerms.Bucket> getBuckets() {
        List<SignificantTerms.Bucket> o = this.buckets;
        return o;
    }

    @Override
    public SignificantTerms.Bucket getBucketByKey(String term) {
        if (this.bucketMap == null) {
            this.bucketMap = Maps.newHashMapWithExpectedSize((int)this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKeyAsString(), bucket);
            }
        }
        return this.bucketMap.get(term);
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        long globalSubsetSize = 0L;
        long globalSupersetSize = 0L;
        for (InternalAggregation aggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
            globalSubsetSize += terms.subsetSize;
            globalSupersetSize += terms.supersetSize;
        }
        HashMap<String, ArrayList<Bucket>> buckets = new HashMap<String, ArrayList<Bucket>>();
        for (InternalAggregation aggregation : aggregations) {
            InternalSignificantTerms terms = (InternalSignificantTerms)aggregation;
            for (Bucket bucket : terms.buckets) {
                ArrayList<Bucket> existingBuckets = (ArrayList<Bucket>)buckets.get(bucket.getKey());
                if (existingBuckets == null) {
                    existingBuckets = new ArrayList<Bucket>(aggregations.size());
                    buckets.put(bucket.getKeyAsString(), existingBuckets);
                }
                existingBuckets.add(bucket.newBucket(bucket.getSubsetDf(), globalSubsetSize, bucket.getSupersetDf(), globalSupersetSize, bucket.aggregations));
            }
        }
        this.significanceHeuristic.initialize(reduceContext);
        int size = Math.min(this.requiredSize, buckets.size());
        BucketSignificancePriorityQueue ordered = new BucketSignificancePriorityQueue(size);
        for (Map.Entry entry : buckets.entrySet()) {
            List list = (List)entry.getValue();
            Bucket b = ((Bucket)list.get(0)).reduce(list, reduceContext);
            b.updateScore(this.significanceHeuristic);
            if (!(b.score > 0.0) || b.subsetDf < this.minDocCount) continue;
            ordered.insertWithOverflow(b);
        }
        Bucket[] list = new Bucket[ordered.size()];
        for (int i = ordered.size() - 1; i >= 0; --i) {
            list[i] = (Bucket)ordered.pop();
        }
        return this.create(globalSubsetSize, globalSupersetSize, Arrays.asList(list), this);
    }

    protected abstract A create(long var1, long var3, List<Bucket> var5, InternalSignificantTerms var6);

    public static abstract class Bucket
    extends SignificantTerms.Bucket {
        long bucketOrd;
        protected InternalAggregations aggregations;
        double score;

        protected Bucket(long subsetSize, long supersetSize) {
            super(subsetSize, supersetSize);
        }

        protected Bucket(long subsetDf, long subsetSize, long supersetDf, long supersetSize, InternalAggregations aggregations) {
            super(subsetDf, subsetSize, supersetDf, supersetSize);
            this.aggregations = aggregations;
        }

        @Override
        public long getSubsetDf() {
            return this.subsetDf;
        }

        @Override
        public long getSupersetDf() {
            return this.supersetDf;
        }

        @Override
        public long getSupersetSize() {
            return this.supersetSize;
        }

        @Override
        public long getSubsetSize() {
            return this.subsetSize;
        }

        public void updateScore(SignificanceHeuristic significanceHeuristic) {
            this.score = significanceHeuristic.getScore(this.subsetDf, this.subsetSize, this.supersetDf, this.supersetSize);
        }

        @Override
        public long getDocCount() {
            return this.subsetDf;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        public Bucket reduce(List<? extends Bucket> buckets, InternalAggregation.ReduceContext context) {
            long subsetDf = 0L;
            long supersetDf = 0L;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                subsetDf += bucket.subsetDf;
                supersetDf += bucket.supersetDf;
                aggregationsList.add(bucket.aggregations);
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregationsList, context);
            return this.newBucket(subsetDf, this.subsetSize, supersetDf, this.supersetSize, aggs);
        }

        abstract Bucket newBucket(long var1, long var3, long var5, long var7, InternalAggregations var9);

        @Override
        public double getSignificanceScore() {
            return this.score;
        }
    }
}

