/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.GeoBoundingBox;
import org.apache.lucene.search.GeoPointDistanceQueryImpl;
import org.apache.lucene.search.GeoPointInBBoxQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.GeoProjectionUtils;
import org.apache.lucene.util.GeoUtils;
import org.apache.lucene.util.ToStringUtils;

public final class GeoPointDistanceQuery
extends GeoPointInBBoxQuery {
    protected final double centerLon;
    protected final double centerLat;
    protected final double radius;

    public GeoPointDistanceQuery(String field, double centerLon, double centerLat, double radius) {
        this(field, GeoPointDistanceQuery.computeBBox(centerLon, centerLat, radius), centerLon, centerLat, radius);
    }

    private GeoPointDistanceQuery(String field, GeoBoundingBox bbox, double centerLon, double centerLat, double radius) {
        super(field, bbox.minLon, bbox.minLat, bbox.maxLon, bbox.maxLat);
        if (!GeoUtils.isValidLon(centerLon)) {
            throw new IllegalArgumentException("invalid centerLon " + centerLon);
        }
        if (!GeoUtils.isValidLat(centerLat)) {
            throw new IllegalArgumentException("invalid centerLat " + centerLat);
        }
        this.centerLon = centerLon;
        this.centerLat = centerLat;
        this.radius = radius;
    }

    @Override
    public Query rewrite(IndexReader reader) {
        if (this.maxLon < this.minLon) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            GeoPointDistanceQueryImpl left = new GeoPointDistanceQueryImpl(this.field, this, new GeoBoundingBox(-180.0, this.maxLon, this.minLat, this.maxLat));
            left.setBoost(this.getBoost());
            bq.add(new BooleanClause((Query)left, BooleanClause.Occur.SHOULD));
            GeoPointDistanceQueryImpl right = new GeoPointDistanceQueryImpl(this.field, this, new GeoBoundingBox(this.minLon, 180.0, this.minLat, this.maxLat));
            right.setBoost(this.getBoost());
            bq.add(new BooleanClause((Query)right, BooleanClause.Occur.SHOULD));
            return bq.build();
        }
        return new GeoPointDistanceQueryImpl(this.field, this, new GeoBoundingBox(this.minLon, this.maxLon, this.minLat, this.maxLat));
    }

    static GeoBoundingBox computeBBox(double centerLon, double centerLat, double radius) {
        double[] t = GeoProjectionUtils.pointFromLonLatBearing(centerLon, centerLat, 0.0, radius, null);
        double[] r = GeoProjectionUtils.pointFromLonLatBearing(centerLon, centerLat, 90.0, radius, null);
        double[] b = GeoProjectionUtils.pointFromLonLatBearing(centerLon, centerLat, 180.0, radius, null);
        double[] l = GeoProjectionUtils.pointFromLonLatBearing(centerLon, centerLat, 270.0, radius, null);
        return new GeoBoundingBox(GeoUtils.normalizeLon(l[0]), GeoUtils.normalizeLon(r[0]), GeoUtils.normalizeLat(b[1]), GeoUtils.normalizeLat(t[1]));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoPointDistanceQuery)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GeoPointDistanceQuery that = (GeoPointDistanceQuery)((Object)o);
        if (Double.compare(that.centerLat, this.centerLat) != 0) {
            return false;
        }
        if (Double.compare(that.centerLon, this.centerLon) != 0) {
            return false;
        }
        return Double.compare(that.radius, this.radius) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.centerLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.centerLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.radius);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Center: [").append(this.centerLon).append(',').append(this.centerLat).append(']').append(" Distance: ").append(this.radius).append(" m").append(" Lower Left: [").append(this.minLon).append(',').append(this.minLat).append(']').append(" Upper Right: [").append(this.maxLon).append(',').append(this.maxLat).append("]").append(ToStringUtils.boost((float)this.getBoost())).toString();
    }

    public double getCenterLon() {
        return this.centerLon;
    }

    public double getCenterLat() {
        return this.centerLat;
    }

    public double getRadius() {
        return this.radius;
    }
}

