/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.springframework.util.PatternMatchUtils;

public abstract class AstUtils {
    public static boolean hasAtLeastOneAnnotation(ClassNode node, String ... annotations) {
        if (AstUtils.hasAtLeastOneAnnotation((AnnotatedNode)node, annotations)) {
            return true;
        }
        for (MethodNode method : node.getMethods()) {
            if (!AstUtils.hasAtLeastOneAnnotation((AnnotatedNode)method, annotations)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAtLeastOneAnnotation(AnnotatedNode node, String ... annotations) {
        for (AnnotationNode annotationNode : node.getAnnotations()) {
            for (String annotation : annotations) {
                if (!PatternMatchUtils.simpleMatch((String)annotation, (String)annotationNode.getClassNode().getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAtLeastOneFieldOrMethod(ClassNode node, String ... types) {
        HashSet<String> typesSet = new HashSet<String>(Arrays.asList(types));
        for (FieldNode field : node.getFields()) {
            if (!typesSet.contains(field.getType().getName())) continue;
            return true;
        }
        for (MethodNode method : node.getMethods()) {
            if (!typesSet.contains(method.getReturnType().getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean subclasses(ClassNode node, String ... types) {
        for (String type : types) {
            if (!node.getSuperClass().getName().equals(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAtLeastOneInterface(ClassNode classNode, String ... types) {
        HashSet<String> typesSet = new HashSet<String>(Arrays.asList(types));
        for (ClassNode inter : classNode.getInterfaces()) {
            if (!typesSet.contains(inter.getName())) continue;
            return true;
        }
        return false;
    }

    public static ClosureExpression getClosure(BlockStatement block, String name, boolean remove) {
        for (Statement statement : new ArrayList(block.getStatements())) {
            ConstantExpression method;
            MethodCallExpression call;
            Expression methodCall;
            Expression expression;
            if (!(statement instanceof ExpressionStatement) || !((expression = ((ExpressionStatement)statement).getExpression()) instanceof MethodCallExpression) || !((methodCall = (call = (MethodCallExpression)expression).getMethod()) instanceof ConstantExpression) || !name.equals((method = (ConstantExpression)methodCall).getValue())) continue;
            ArgumentListExpression arguments = (ArgumentListExpression)call.getArguments();
            if (remove) {
                block.getStatements().remove(statement);
            }
            ClosureExpression closure = (ClosureExpression)arguments.getExpression(0);
            return closure;
        }
        return null;
    }

    public static ClosureExpression getClosure(BlockStatement block, String name) {
        return AstUtils.getClosure(block, name, false);
    }
}

