/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.dependency.tools;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.springframework.boot.dependency.tools.AbstractDependencies;
import org.springframework.boot.dependency.tools.Dependency;

public class PropertiesFileDependencies
extends AbstractDependencies {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesFileDependencies(InputStream inputStream) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            this.initialize(properties);
        }
        finally {
            inputStream.close();
        }
    }

    private void initialize(Properties properties) {
        TreeMap<String, String> sortedMap = new TreeMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            sortedMap.put(entry.getKey().toString(), entry.getValue().toString());
        }
        for (Map.Entry<Object, Object> entry : sortedMap.entrySet()) {
            AbstractDependencies.ArtifactAndGroupId artifactAndGroupId = this.parse((String)entry.getKey());
            Dependency dependency = artifactAndGroupId.newDependency((String)entry.getValue());
            this.add(artifactAndGroupId, dependency);
        }
    }

    private AbstractDependencies.ArtifactAndGroupId parse(String value) {
        String[] parts = value.split("\\:");
        if (parts.length != 2) {
            throw new IllegalStateException("Unable to parse " + value);
        }
        return new AbstractDependencies.ArtifactAndGroupId(parts[0], parts[1]);
    }
}

