/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.springframework.boot.dependency.tools.Dependencies;
import org.springframework.boot.dependency.tools.ManagedDependencies;
import org.springframework.boot.dependency.tools.PropertiesFileDependencies;

public class VersionManagedDependencies {
    public static final String CONFIGURATION = "versionManagement";
    private Configuration versionManagementConfiguration;
    private Collection<Dependencies> versionManagedDependencies;
    private ManagedDependencies managedDependencies;

    public VersionManagedDependencies(Project project) {
        this.versionManagementConfiguration = project.getConfigurations().getByName(CONFIGURATION);
    }

    public ManagedDependencies getManagedDependencies() {
        if (this.managedDependencies == null) {
            this.managedDependencies = ManagedDependencies.get(this.getVersionManagedDependencies());
        }
        return this.managedDependencies;
    }

    private Collection<Dependencies> getVersionManagedDependencies() {
        if (this.versionManagedDependencies == null) {
            Set files = this.versionManagementConfiguration.resolve();
            ArrayList<Dependencies> dependencies = new ArrayList<Dependencies>(files.size());
            for (File file : files) {
                dependencies.add(this.getPropertiesFileManagedDependencies(file));
            }
            this.versionManagedDependencies = dependencies;
        }
        return this.versionManagedDependencies;
    }

    private Dependencies getPropertiesFileManagedDependencies(File file) {
        if (!file.getName().toLowerCase().endsWith(".properties")) {
            throw new IllegalStateException(file + " is not a version property file");
        }
        try {
            return new PropertiesFileDependencies((InputStream)new FileInputStream(file));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

