/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.gradle.exclude;

import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.internal.artifacts.DefaultExcludeRule;
import org.gradle.api.logging.Logger;
import org.springframework.boot.dependency.tools.Dependency;
import org.springframework.boot.dependency.tools.ManagedDependencies;
import org.springframework.boot.gradle.VersionManagedDependencies;

public class ApplyExcludeRules
implements Action<Configuration> {
    private final Logger logger;
    private final VersionManagedDependencies versionManagedDependencies;

    public ApplyExcludeRules(Project project) {
        this.logger = project.getLogger();
        this.versionManagedDependencies = new VersionManagedDependencies(project);
    }

    public void execute(Configuration configuration) {
        if (!"versionManagement".equals(configuration.getName())) {
            configuration.getIncoming().beforeResolve((Action)new Action<ResolvableDependencies>(){

                public void execute(ResolvableDependencies resolvableDependencies) {
                    resolvableDependencies.getDependencies().all((Action)new Action<org.gradle.api.artifacts.Dependency>(){

                        public void execute(org.gradle.api.artifacts.Dependency dependency) {
                            ApplyExcludeRules.this.applyExcludeRules(dependency);
                        }
                    });
                }
            });
        }
    }

    private void applyExcludeRules(org.gradle.api.artifacts.Dependency dependency) {
        if (dependency instanceof ModuleDependency) {
            this.applyExcludeRules((ModuleDependency)dependency);
        }
    }

    private void applyExcludeRules(ModuleDependency dependency) {
        Dependency managedDependency;
        ManagedDependencies managedDependencies = this.versionManagedDependencies.getManagedDependencies();
        if (dependency.getGroup() != null && (managedDependency = managedDependencies.find(dependency.getGroup(), dependency.getName())) != null) {
            for (Dependency.Exclusion exclusion : managedDependency.getExclusions()) {
                this.addExcludeRule(dependency, exclusion);
            }
            this.addImplicitExcludeRules(dependency);
            return;
        }
        this.logger.debug("No exclusions rules applied for non-managed dependency " + dependency);
    }

    private void addExcludeRule(ModuleDependency dependency, Dependency.Exclusion exclusion) {
        this.logger.info("Adding managed exclusion rule " + exclusion + " to " + dependency);
        DefaultExcludeRule rule = new DefaultExcludeRule(exclusion.getGroupId(), exclusion.getArtifactId());
        dependency.getExcludeRules().add(rule);
    }

    private void addImplicitExcludeRules(ModuleDependency dependency) {
        if (this.isStarter(dependency)) {
            this.logger.info("Adding implicit managed exclusion rules to starter " + dependency);
            dependency.getExcludeRules().add(new DefaultExcludeRule("commons-logging", "commons-logging"));
            dependency.getExcludeRules().add(new DefaultExcludeRule("commons-logging", "commons-logging-api"));
        }
    }

    private boolean isStarter(ModuleDependency dependency) {
        return dependency.getGroup() != null && dependency.getGroup().equals("org.springframework.boot") && dependency.getName().startsWith("spring-boot-starter");
    }
}

