/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core;

import grails.config.Config;
import grails.core.ArtefactHandler;
import grails.core.GrailsApplication;
import grails.core.support.GrailsConfigurationAware;
import grails.util.Holders;
import grails.util.Metadata;
import groovy.lang.GroovyObjectSupport;
import groovy.util.ConfigObject;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.grails.config.PropertySourcesConfig;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.util.ClassUtils;

public abstract class AbstractGrailsApplication
extends GroovyObjectSupport
implements GrailsApplication,
ApplicationContextAware,
BeanClassLoaderAware,
ApplicationListener<ApplicationEvent> {
    protected ClassLoader classLoader;
    protected Config config;
    protected Map flatConfig = Collections.emptyMap();
    protected ApplicationContext parentContext;
    protected Metadata applicationMeta = Metadata.getCurrent();
    protected boolean contextInitialized;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ((ConfigurableApplicationContext)applicationContext).addApplicationListener((ApplicationListener)this);
        }
    }

    @Override
    public Metadata getMetadata() {
        return this.applicationMeta;
    }

    @Override
    public boolean isWarDeployed() {
        return this.getMetadata().isWarDeployed();
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
        Holders.setConfig(config);
        this.updateFlatConfig();
    }

    public void setConfig(ConfigObject config) {
        this.config = new PropertySourcesConfig().merge((Map<String, Object>)config);
        Holders.setConfig(this.config);
        this.updateFlatConfig();
    }

    public void updateFlatConfig() {
        this.flatConfig = this.config == null ? new LinkedHashMap() : this.config.flatten();
    }

    @Override
    public Map<String, Object> getFlatConfig() {
        return this.getConfig().flatten();
    }

    @Override
    public void configChanged() {
        this.updateFlatConfig();
        ArtefactHandler[] handlers = this.getArtefactHandlers();
        if (handlers != null) {
            for (ArtefactHandler handler : handlers) {
                if (!(handler instanceof GrailsConfigurationAware)) continue;
                ((GrailsConfigurationAware)((Object)handler)).setConfiguration(this.config);
            }
        }
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Class getClassForName(String className) {
        return ClassUtils.resolveClassName((String)className, (ClassLoader)this.getClassLoader());
    }

    @Override
    public ApplicationContext getMainContext() {
        return this.parentContext;
    }

    @Override
    public void setMainContext(ApplicationContext context) {
        this.parentContext = context;
    }

    @Override
    public ApplicationContext getParentContext() {
        return this.parentContext;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            this.contextInitialized = true;
        }
    }
}

