/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.selector;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import reactor.bus.selector.HeaderResolver;
import reactor.bus.selector.ObjectSelector;
import reactor.bus.selector.Selector;

public class RegexSelector
extends ObjectSelector<Object, Pattern> {
    private final HeaderResolver headerResolver = new HeaderResolver(){

        @Nullable
        public Map<String, Object> resolve(Object key) {
            Matcher m = ((Pattern)RegexSelector.this.getObject()).matcher(key.toString());
            if (!m.matches()) {
                return null;
            }
            int groups = m.groupCount();
            HashMap<String, Object> headers = new HashMap<String, Object>();
            for (int i = 1; i <= groups; ++i) {
                String name = "group" + i;
                String value = m.group(i);
                headers.put(name, value);
            }
            return headers;
        }
    };

    public RegexSelector(String pattern) {
        super(Pattern.compile(pattern));
    }

    public static Selector regexSelector(String regex) {
        return new RegexSelector(regex);
    }

    @Override
    public boolean matches(Object key) {
        return key instanceof String && ((Pattern)this.getObject()).matcher((String)key).matches();
    }

    @Override
    public HeaderResolver getHeaderResolver() {
        return this.headerResolver;
    }
}

