/*
 * Decompiled with CFR 0.152.
 */
package reactor.bus.support;

import reactor.bus.Bus;
import reactor.bus.Event;
import reactor.bus.EventBus;
import reactor.core.support.Assert;
import reactor.fn.Consumer;

public class NotifyConsumer<T>
implements Consumer<T> {
    private final Object notifyKey;
    private final Bus observable;
    private final boolean wrapEvent;

    public NotifyConsumer(Object notifyKey, Bus<?> observable) {
        Assert.notNull(observable, (String)"Observable cannot be null.");
        this.notifyKey = notifyKey;
        this.observable = observable;
        this.wrapEvent = EventBus.class.isAssignableFrom(observable.getClass());
    }

    public void accept(T t) {
        this.observable.notify(this.notifyKey, this.wrapEvent ? Event.wrap(t) : t);
    }
}

