/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.bag.immutable.primitive;

import com.gs.collections.api.BooleanIterable;
import com.gs.collections.api.LazyBooleanIterable;
import com.gs.collections.api.bag.ImmutableBag;
import com.gs.collections.api.bag.primitive.BooleanBag;
import com.gs.collections.api.bag.primitive.ImmutableBooleanBag;
import com.gs.collections.api.bag.primitive.MutableBooleanBag;
import com.gs.collections.api.block.function.primitive.BooleanToObjectFunction;
import com.gs.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import com.gs.collections.api.block.predicate.primitive.BooleanPredicate;
import com.gs.collections.api.block.procedure.primitive.BooleanIntProcedure;
import com.gs.collections.api.block.procedure.primitive.BooleanProcedure;
import com.gs.collections.api.iterator.BooleanIterator;
import com.gs.collections.api.list.primitive.MutableBooleanList;
import com.gs.collections.api.set.primitive.MutableBooleanSet;
import com.gs.collections.impl.bag.immutable.primitive.ImmutableBooleanSingletonBag;
import com.gs.collections.impl.bag.mutable.primitive.BooleanHashBag;
import com.gs.collections.impl.factory.Bags;
import com.gs.collections.impl.factory.primitive.BooleanBags;
import com.gs.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import com.gs.collections.impl.list.mutable.primitive.BooleanArrayList;
import com.gs.collections.impl.set.mutable.primitive.BooleanHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
final class ImmutableBooleanEmptyBag
implements ImmutableBooleanBag,
Serializable {
    private static final long serialVersionUID = 1L;
    static final ImmutableBooleanBag INSTANCE = new ImmutableBooleanEmptyBag();

    ImmutableBooleanEmptyBag() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public ImmutableBooleanBag newWith(boolean element) {
        return new ImmutableBooleanSingletonBag(element);
    }

    public ImmutableBooleanBag newWithout(boolean element) {
        return this;
    }

    public ImmutableBooleanBag newWithAll(BooleanIterable elements) {
        return BooleanBags.immutable.withAll(elements);
    }

    public ImmutableBooleanBag newWithoutAll(BooleanIterable elements) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public boolean contains(boolean value) {
        return false;
    }

    public boolean containsAll(BooleanIterable source) {
        return source.isEmpty();
    }

    public boolean containsAll(boolean ... elements) {
        return elements.length == 0;
    }

    public void forEach(BooleanProcedure procedure) {
    }

    public ImmutableBooleanBag select(BooleanPredicate predicate) {
        return this;
    }

    public ImmutableBooleanBag reject(BooleanPredicate predicate) {
        return this;
    }

    public <V> ImmutableBag<V> collect(BooleanToObjectFunction<? extends V> function) {
        return Bags.immutable.of();
    }

    public MutableBooleanList toList() {
        return new BooleanArrayList();
    }

    public int sizeDistinct() {
        return 0;
    }

    public int occurrencesOf(boolean item) {
        return 0;
    }

    public void forEachWithOccurrences(BooleanIntProcedure booleanIntProcedure) {
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return ifNone;
    }

    public int count(BooleanPredicate predicate) {
        return 0;
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return false;
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return true;
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectBooleanToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BooleanBag)) {
            return false;
        }
        BooleanBag bag = (BooleanBag)obj;
        return bag.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public MutableBooleanSet toSet() {
        return new BooleanHashSet();
    }

    public MutableBooleanBag toBag() {
        return new BooleanHashBag();
    }

    public ImmutableBooleanBag toImmutable() {
        return this;
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public boolean[] toArray() {
        return new boolean[0];
    }

    public String toString() {
        return "[]";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BooleanIterator booleanIterator() {
        return new InternalBooleanIterator();
    }

    private static class InternalBooleanIterator
    implements BooleanIterator {
        private InternalBooleanIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public boolean next() {
            throw new NoSuchElementException();
        }
    }
}

