/*
 * Decompiled with CFR 0.152.
 */
package com.gs.collections.impl.multimap.set;

import com.gs.collections.api.block.procedure.Procedure2;
import com.gs.collections.api.map.MutableMap;
import com.gs.collections.api.multimap.Multimap;
import com.gs.collections.api.multimap.set.ImmutableSetMultimap;
import com.gs.collections.api.multimap.set.MutableSetMultimap;
import com.gs.collections.api.set.MutableSet;
import com.gs.collections.api.tuple.Pair;
import com.gs.collections.impl.map.mutable.UnifiedMap;
import com.gs.collections.impl.multimap.AbstractMutableMultimap;
import com.gs.collections.impl.multimap.set.ImmutableSetMultimapImpl;
import com.gs.collections.impl.set.mutable.UnifiedSet;
import java.io.Externalizable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnifiedSetMultimap<K, V>
extends AbstractMutableMultimap<K, V, MutableSet<V>>
implements MutableSetMultimap<K, V>,
Externalizable {
    private static final long serialVersionUID = 1L;

    public UnifiedSetMultimap() {
    }

    public UnifiedSetMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Math.max(multimap.sizeDistinct() * 2, 16));
        this.putAll(multimap);
    }

    public UnifiedSetMultimap(Pair<K, V> ... pairs) {
        super(pairs);
    }

    @Override
    protected MutableMap<K, MutableSet<V>> createMap() {
        return UnifiedMap.newMap();
    }

    @Override
    protected MutableMap<K, MutableSet<V>> createMapWithKeyCount(int keyCount) {
        return UnifiedMap.newMap(keyCount);
    }

    public static <K, V> UnifiedSetMultimap<K, V> newMultimap(Multimap<? extends K, ? extends V> multimap) {
        return new UnifiedSetMultimap<K, V>(multimap);
    }

    public static <K, V> UnifiedSetMultimap<K, V> newMultimap() {
        return new UnifiedSetMultimap<K, V>();
    }

    public static <K, V> UnifiedSetMultimap<K, V> newMultimap(Pair<K, V> ... pairs) {
        return new UnifiedSetMultimap<K, V>(pairs);
    }

    @Override
    protected MutableSet<V> createCollection() {
        return new UnifiedSet();
    }

    public UnifiedSetMultimap<K, V> newEmpty() {
        return new UnifiedSetMultimap<K, V>();
    }

    public MutableSetMultimap<K, V> toMutable() {
        return new UnifiedSetMultimap<K, V>(this);
    }

    public ImmutableSetMultimap<K, V> toImmutable() {
        final UnifiedMap map = UnifiedMap.newMap();
        this.map.forEachKeyValue(new Procedure2<K, MutableSet<V>>(){

            public void value(K key, MutableSet<V> set) {
                map.put(key, (Object)set.toImmutable());
            }
        });
        return new ImmutableSetMultimapImpl(map);
    }
}

