/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.queue;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import reactor.core.queue.CompletableQueue;

public final class CompletableBlockingQueue<T>
extends ArrayBlockingQueue<T>
implements CompletableQueue<T> {
    boolean terminated = false;

    public CompletableBlockingQueue(int capacity) {
        super(capacity);
    }

    @Override
    public void complete() {
        this.terminated = true;
    }

    @Override
    public boolean isComplete() {
        return this.terminated;
    }

    @Override
    public T take() throws InterruptedException {
        if (this.terminated && this.isEmpty()) {
            return null;
        }
        return (T)super.take();
    }

    @Override
    public T poll() {
        if (this.terminated && this.isEmpty()) {
            return null;
        }
        return (T)super.poll();
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.terminated && this.isEmpty()) {
            return null;
        }
        return (T)super.poll(timeout, unit);
    }
}

