/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine.types;

import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.internal.MappingUtils;
import org.grails.datastore.mapping.engine.types.CustomTypeMarshaller;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.query.Query;
import org.springframework.dao.InvalidDataAccessResourceUsageException;

public abstract class AbstractMappingAwareCustomTypeMarshaller<T, N, Q>
implements CustomTypeMarshaller<T, N, Q> {
    private Class<T> targetType;

    public AbstractMappingAwareCustomTypeMarshaller(Class<T> targetType) {
        this.targetType = targetType;
    }

    @Override
    public boolean supports(Datastore datastore) {
        return true;
    }

    @Override
    public Class<T> getTargetType() {
        return this.targetType;
    }

    @Override
    public Object write(PersistentProperty property, T value, N nativeTarget) {
        String targetName = MappingUtils.getTargetKey(property);
        return this.writeInternal(property, targetName, value, nativeTarget);
    }

    protected abstract Object writeInternal(PersistentProperty var1, String var2, T var3, N var4);

    @Override
    public Q query(PersistentProperty property, Query.PropertyCriterion criterion, Q nativeQuery) {
        String targetName = MappingUtils.getTargetKey(property);
        this.queryInternal(property, targetName, criterion, nativeQuery);
        return nativeQuery;
    }

    protected void queryInternal(PersistentProperty property, String key, Query.PropertyCriterion value, Q nativeQuery) {
        throw new InvalidDataAccessResourceUsageException("Custom type [" + this.getTargetType().getName() + "] does not support querying");
    }

    @Override
    public T read(PersistentProperty property, N source) {
        String targetName = MappingUtils.getTargetKey(property);
        return this.readInternal(property, targetName, source);
    }

    protected abstract T readInternal(PersistentProperty var1, String var2, N var3);
}

