/*
 * Decompiled with CFR 0.152.
 */
package reactor.spring.core.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.AsyncListenableTaskExecutor;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.ListenableFutureTask;
import reactor.core.dispatch.AbstractLifecycleDispatcher;
import reactor.fn.Consumer;
import reactor.fn.Pausable;
import reactor.fn.timer.Timer;

public abstract class AbstractAsyncTaskExecutor
implements ScheduledExecutorService,
AsyncListenableTaskExecutor,
InitializingBean,
SmartLifecycle {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer;
    private String name = this.getClass().getSimpleName();
    private int threads = Runtime.getRuntime().availableProcessors();
    private int backlog = 2048;

    protected AbstractAsyncTaskExecutor(Timer timer) {
        this.timer = timer;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.getDispatcher().awaitAndShutdown();
        callback.run();
    }

    public void start() {
    }

    public void stop() {
        this.getDispatcher().shutdown();
    }

    public boolean isRunning() {
        return this.getDispatcher().alive();
    }

    public int getPhase() {
        return 0;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.getDispatcher().awaitAndShutdown(timeout, unit);
    }

    @Override
    public boolean isTerminated() {
        return !this.getDispatcher().alive();
    }

    @Override
    public boolean isShutdown() {
        return this.isTerminated();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.getDispatcher().shutdown();
        return Collections.emptyList();
    }

    @Override
    public void shutdown() {
        this.getDispatcher().shutdown();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<FutureTask<T>> submittedTasks = new ArrayList<FutureTask<T>>();
        for (Callable<T> task : tasks) {
            FutureTask<T> ft = new FutureTask<T>(task);
            this.execute(ft);
            submittedTasks.add(ft);
        }
        T result = null;
        long start = System.currentTimeMillis();
        do {
            FutureTask futureTask;
            Iterator i$ = submittedTasks.iterator();
            while (i$.hasNext() && null == (result = (T)(futureTask = (FutureTask)i$.next()).get(100L, TimeUnit.MILLISECONDS)) && !futureTask.isDone()) {
            }
        } while (null == result && System.currentTimeMillis() - start <= TimeUnit.MILLISECONDS.convert(timeout, unit));
        for (FutureTask futureTask : submittedTasks) {
            if (futureTask.isDone()) continue;
            futureTask.cancel(true);
        }
        return result;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e.getMessage(), e);
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<Future<T>> submittedTasks = new ArrayList<Future<T>>();
        for (Callable<T> task : tasks) {
            FutureTask<T> ft = new FutureTask<T>(task);
            this.execute(ft);
            submittedTasks.add(ft);
        }
        Object result = null;
        long start = System.currentTimeMillis();
        block4: do {
            boolean allComplete = false;
            for (Future future : submittedTasks) {
                try {
                    result = future.get(100L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                catch (TimeoutException e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                }
                if (!(allComplete = !allComplete && future.isDone())) continue;
                continue block4;
            }
        } while (null == result && System.currentTimeMillis() - start <= TimeUnit.MILLISECONDS.convert(timeout, unit));
        return submittedTasks;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, Integer.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    public void execute(final Runnable task, long startTimeout) {
        this.timer.submit((Consumer)new Consumer<Long>(){

            public void accept(Long now) {
                AbstractAsyncTaskExecutor.this.execute(task);
            }
        }, startTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future);
        return future;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future);
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        FutureTask<T> future = new FutureTask<T>(task, result);
        this.execute(future);
        return future;
    }

    public ListenableFuture<?> submitListenable(Runnable task) {
        ListenableFutureTask f = new ListenableFutureTask(task, null);
        this.submit((Runnable)f);
        return f;
    }

    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        ListenableFutureTask f = new ListenableFutureTask(task);
        this.submit((Runnable)f);
        return f;
    }

    @Override
    public void execute(Runnable task) {
        this.getDispatcher().execute(task);
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        long initialDelay = AbstractAsyncTaskExecutor.convertToMillis(delay, unit);
        final ScheduledFutureTask future = new ScheduledFutureTask(command, null, initialDelay);
        this.timer.submit((Consumer)new Consumer<Long>(){

            public void accept(Long now) {
                AbstractAsyncTaskExecutor.this.execute(future);
            }
        }, initialDelay, TimeUnit.MILLISECONDS);
        return future;
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        long initialDelay = AbstractAsyncTaskExecutor.convertToMillis(delay, unit);
        final ScheduledFutureTask future = new ScheduledFutureTask(callable, initialDelay);
        this.timer.submit((Consumer)new Consumer<Long>(){

            public void accept(Long now) {
                AbstractAsyncTaskExecutor.this.execute(future);
            }
        }, initialDelay, TimeUnit.MILLISECONDS);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(final Runnable command, long initialDelay, long period, TimeUnit unit) {
        long initialDelayInMs = AbstractAsyncTaskExecutor.convertToMillis(initialDelay, unit);
        long periodInMs = AbstractAsyncTaskExecutor.convertToMillis(period, unit);
        final AtomicReference<Pausable> registration = new AtomicReference<Pausable>();
        final Runnable task = new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        command.run();
                    }
                    catch (Throwable t) {
                        AbstractAsyncTaskExecutor.this.log.error(t.getMessage(), t);
                        Pausable reg = (Pausable)registration.get();
                        if (null == reg) break block2;
                        reg.cancel();
                    }
                }
            }
        };
        Consumer<Long> consumer = new Consumer<Long>(){

            public void accept(Long now) {
                AbstractAsyncTaskExecutor.this.execute(task);
            }
        };
        ScheduledFutureTask future = new ScheduledFutureTask(task, null, initialDelay);
        registration.set(this.timer.schedule((Consumer)consumer, periodInMs, TimeUnit.MILLISECONDS, initialDelayInMs));
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        long initialDelayInMs = AbstractAsyncTaskExecutor.convertToMillis(initialDelay, unit);
        final long delayInMs = AbstractAsyncTaskExecutor.convertToMillis(initialDelay, unit);
        final ScheduledFutureTask future = new ScheduledFutureTask(command, null, initialDelayInMs);
        final AtomicReference<Pausable> registration = new AtomicReference<Pausable>();
        Consumer<Long> consumer = new Consumer<Long>(){
            final Consumer<Long> self = this;

            public void accept(Long now) {
                AbstractAsyncTaskExecutor.this.execute(new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                future.run();
                                AbstractAsyncTaskExecutor.this.timer.submit(self, delayInMs, TimeUnit.MILLISECONDS);
                            }
                            catch (Throwable t) {
                                AbstractAsyncTaskExecutor.this.log.error(t.getMessage(), t);
                                Pausable reg = (Pausable)registration.get();
                                if (null == reg) break block2;
                                reg.cancel();
                            }
                        }
                    }
                });
            }
        };
        registration.set(this.timer.submit((Consumer)consumer, initialDelayInMs, TimeUnit.MILLISECONDS));
        return future;
    }

    protected abstract AbstractLifecycleDispatcher getDispatcher();

    private static long convertToMillis(long l, TimeUnit timeUnit) {
        if (timeUnit == TimeUnit.MILLISECONDS) {
            return l;
        }
        return timeUnit.convert(l, TimeUnit.MILLISECONDS);
    }

    private static class ScheduledFutureTask<T>
    extends FutureTask<T>
    implements ScheduledFuture<T> {
        private final long delay;

        private ScheduledFutureTask(Runnable runnable, T result, long delay) {
            super(runnable, result);
            this.delay = delay;
        }

        private ScheduledFutureTask(Callable<T> callable, long delay) {
            super(callable);
            this.delay = delay;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return AbstractAsyncTaskExecutor.convertToMillis(this.delay, unit);
        }

        @Override
        public int compareTo(Delayed d) {
            if (this == d) {
                return 0;
            }
            long diff = this.getDelay(TimeUnit.MILLISECONDS) - d.getDelay(TimeUnit.MILLISECONDS);
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
    }
}

