/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import java.io.Serializable;
import java.util.Map;
import reactor.fn.Function;
import reactor.fn.tuple.Tuple;
import reactor.fn.tuple.Tuple2;
import reactor.rx.Stream;

public abstract class MapStream<K, V>
extends Stream<Signal<K, V>>
implements Map<K, V> {
    public Stream<Tuple2<K, V>> onPut() {
        return this.map(new Function<Signal<K, V>, Tuple2<K, V>>(){

            public Tuple2<K, V> apply(Signal<K, V> kvSignal) {
                if (kvSignal.op == Operation.put) {
                    return kvSignal.pair();
                }
                return null;
            }
        });
    }

    public Stream<K> onRemove() {
        return this.map(new Function<Signal<K, V>, K>(){

            public K apply(Signal<K, V> kvSignal) {
                if (kvSignal.op == Operation.remove) {
                    return kvSignal.key;
                }
                return null;
            }
        });
    }

    public static class MutableSignal<K, V>
    extends Signal<K, V> {
        public MutableSignal() {
            super(null, null, null, null);
        }

        public void op(Operation op) {
            this.op = op;
        }

        public void key(K key) {
            this.key = key;
        }

        public void previous(V previous) {
            this.previous = previous;
        }

        public void value(V value) {
            this.value = value;
        }
    }

    public static class Signal<K, V>
    implements Serializable {
        Operation op;
        K key;
        V previous;
        V value;

        Signal(Operation op, K key, V value, V previous) {
            this.op = op;
            this.key = key;
            this.value = value;
            this.previous = previous;
        }

        public Operation op() {
            return this.op;
        }

        public K key() {
            return this.key;
        }

        public V previous() {
            return this.previous;
        }

        public V value() {
            return this.value;
        }

        public Tuple2<K, V> pair() {
            return Tuple.of(this.key, this.value);
        }

        public String toString() {
            return "SubscribableMap.Signal{op=" + (Object)((Object)this.op) + (this.key != null ? ", key=" + this.key : "") + (this.previous != null ? ", previous=" + this.previous : "") + (this.value != null ? ", value=" + this.value : "") + '}';
        }

        public static <K, V> Signal<K, V> create(Operation op) {
            return new Signal<Object, Object>(op, null, null, null);
        }

        public static <K, V> Signal<K, V> create(Operation op, K key) {
            return new Signal<K, Object>(op, key, null, null);
        }

        public static <K, V> Signal<K, V> create(Operation op, K key, V value) {
            return new Signal<K, Object>(op, key, value, null);
        }

        public static <K, V> Signal<K, V> create(Operation op, K key, V value, V previous) {
            return new Signal<K, V>(op, key, value, previous);
        }
    }

    public static enum Operation {
        put,
        putAll,
        remove,
        clear;

    }
}

