/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.layout;

import java.io.File;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;

public class BuildLayoutFactory {
    public BuildLayout getLayoutFor(File currentDir, boolean searchUpwards) {
        return this.getLayoutFor(currentDir, searchUpwards ? null : currentDir.getParentFile());
    }

    public BuildLayout getLayoutFor(BuildLayoutConfiguration configuration) {
        if (configuration.isUseEmptySettings()) {
            return new BuildLayout(configuration.getCurrentDir(), configuration.getCurrentDir(), null);
        }
        if (configuration.getSettingsFile() != null) {
            return new BuildLayout(configuration.getCurrentDir(), configuration.getCurrentDir(), configuration.getSettingsFile());
        }
        File currentDir = configuration.getCurrentDir();
        boolean searchUpwards = configuration.isSearchUpwards();
        return this.getLayoutFor(currentDir, searchUpwards ? null : currentDir.getParentFile());
    }

    BuildLayout getLayoutFor(File currentDir, File stopAt) {
        File settingsFile = new File(currentDir, "settings.gradle");
        if (settingsFile.isFile()) {
            return this.layout(currentDir, currentDir, settingsFile);
        }
        for (File candidate = currentDir.getParentFile(); candidate != null && !candidate.equals(stopAt); candidate = candidate.getParentFile()) {
            settingsFile = new File(candidate, "settings.gradle");
            if (settingsFile.isFile()) {
                return this.layout(candidate, candidate, settingsFile);
            }
            settingsFile = new File(candidate, "master/settings.gradle");
            if (!settingsFile.isFile()) continue;
            return this.layout(candidate, settingsFile.getParentFile(), settingsFile);
        }
        return this.layout(currentDir, currentDir);
    }

    private BuildLayout layout(File rootDir, File settingsDir) {
        return new BuildLayout(rootDir, settingsDir, null);
    }

    private BuildLayout layout(File rootDir, File settingsDir, File settingsFile) {
        return new BuildLayout(rootDir, settingsDir, settingsFile);
    }
}

