/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.Type;
import org.spockframework.gentyref.GenericTypeReflector;
import org.spockframework.lang.Wildcard;
import org.spockframework.mock.IDefaultResponse;
import org.spockframework.mock.IMockInteraction;
import org.spockframework.mock.IMockObject;
import org.spockframework.runtime.InvalidSpecException;
import spock.lang.Specification;

public class MockObject
implements IMockObject {
    private final String name;
    private final Type type;
    private final Object instance;
    private final boolean verified;
    private final boolean global;
    private final IDefaultResponse defaultResponse;
    private final Specification specification;

    public MockObject(String name, Type type, Object instance, boolean verified, boolean global, IDefaultResponse defaultResponse, Specification specification) {
        this.name = name;
        this.type = type;
        this.instance = instance;
        this.verified = verified;
        this.global = global;
        this.defaultResponse = defaultResponse;
        this.specification = specification;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return GenericTypeReflector.erase(this.type);
    }

    @Override
    public Type getExactType() {
        return this.type;
    }

    @Override
    public Object getInstance() {
        return this.instance;
    }

    @Override
    public boolean isVerified() {
        return this.verified;
    }

    @Override
    public IDefaultResponse getDefaultResponse() {
        return this.defaultResponse;
    }

    @Override
    public Specification getSpecification() {
        return this.specification;
    }

    @Override
    public boolean matches(Object target, IMockInteraction interaction) {
        boolean match;
        if (target instanceof Wildcard) {
            return this.verified || !interaction.isRequired();
        }
        boolean bl = this.global ? this.instance.getClass() == target.getClass() : (match = this.instance == target);
        if (match) {
            this.checkRequiredInteractionAllowed(interaction);
        }
        return match;
    }

    private void checkRequiredInteractionAllowed(IMockInteraction interaction) {
        if (!this.verified && interaction.isRequired()) {
            String mockName = this.name != null ? this.name : "unnamed";
            throw new InvalidSpecException("Stub '%s' matches the following required interaction:\n\n%s\n\nRemove the cardinality (e.g. '1 *'), or turn the stub into a mock.\n").withArgs(mockName, interaction);
        }
    }
}

