/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.Properties;
import javajs.J2SIgnoreImport;
import javajs.J2SRequireImport;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

@J2SIgnoreImport(value={Properties.class, BufferedInputStream.class})
@J2SRequireImport(value={SB.class})
public final class JC {
    public static final String PDB_ANNOTATIONS = ";dssr;rna3d;dom;val;";
    public static String[] databases = new String[]{"dssr", "http://x3dna.bio.columbia.edu/dssr/report.php?id=%FILE&opts=--json=ebi-no-str-id", "dssrModel", "http://x3dna.bio.columbia.edu/dssr/report.php?POST?opts=--json=ebi-no-str-id&model=", "ligand", "http://www.rcsb.org/pdb/files/ligand/%FILE.cif", "mp", "http://www.materialsproject.org/materials/%FILE/cif", "nci", "http://cactus.nci.nih.gov/chemical/structure/%FILE", "cod", "http://www.crystallography.net/cod/cif/%c1/%c2%c3/%c4%c5/%FILE.cif", "nmr", "http://www.nmrdb.org/new_predictor?POST?molfile=", "nmrdb", "http://www.nmrdb.org/service/predictor?POST?molfile=", "pdb", "http://www.rcsb.org/pdb/files/%FILE.pdb.gz", "pdbe", "http://www.ebi.ac.uk/pdbe/entry-files/download/%FILE.cif", "pdbe2", "http://www.ebi.ac.uk/pdbe/static/entry/%FILE_updated.cif", "pubchem", "http://pubchem.ncbi.nlm.nih.gov/rest/pug/compound/%FILE/SDF?record_type=3d", "map", "http://www.ebi.ac.uk/pdbe/api/%TYPE/%FILE?pretty=false&metadata=true", "rna3d", "http://rna.bgsu.edu/rna3dhub/%TYPE/download/%FILE"};
    public static String[] macros = new String[]{"aflow", "http://aflowlib.mems.duke.edu/users/jmolers/jmol/spt/AFLOW.spt"};
    public static final String copyright = "(C) 2015 Jmol Development";
    public static final String version;
    public static final String date;
    public static final int versionInt;
    public static final boolean officialRelease = false;
    public static final String DEFAULT_HELP_PATH = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
    public static final String STATE_VERSION_STAMP = "# Jmol state version ";
    public static final String EMBEDDED_SCRIPT_TAG = "**** Jmol Embedded Script ****";
    public static final String NOTE_SCRIPT_FILE = "NOTE: file recognized as a script file: ";
    public static final String SCRIPT_EDITOR_IGNORE = "\u0001## EDITOR_IGNORE ##";
    public static final String REPAINT_IGNORE = "\u0001## REPAINT_IGNORE ##";
    public static final String LOAD_ATOM_DATA_TYPES = ";xyz;vxyz;vibration;temperature;occupancy;partialcharge;";
    public static final float radiansPerDegree = (float)Math.PI / 180;
    public static final String allowedQuaternionFrames = "RC;RP;a;b;c;n;p;q;x;";
    public static final String EXPORT_DRIVER_LIST = "Idtf;Maya;Povray;Vrml;X3d;Tachyon;Obj";
    public static final V3 center;
    public static final V3 axisX;
    public static final V3 axisY;
    public static final V3 axisZ;
    public static final V3 axisNX;
    public static final V3 axisNY;
    public static final V3 axisNZ;
    public static final V3[] unitAxisVectors;
    public static final int XY_ZTOP = 100;
    public static final int DEFAULT_PERCENT_VDW_ATOM = 23;
    public static final float DEFAULT_BOND_RADIUS = 0.15f;
    public static final short DEFAULT_BOND_MILLIANGSTROM_RADIUS = 150;
    public static final float DEFAULT_STRUT_RADIUS = 0.3f;
    public static final float DEFAULT_BOND_TOLERANCE = 0.45f;
    public static final float DEFAULT_MIN_BOND_DISTANCE = 0.4f;
    public static final float DEFAULT_MAX_CONNECT_DISTANCE = 1.0E8f;
    public static final float DEFAULT_MIN_CONNECT_DISTANCE = 0.1f;
    public static final int MINIMIZATION_ATOM_MAX = 200;
    public static final float MINIMIZE_FIXED_RANGE = 5.0f;
    public static final float ENC_CALC_MAX_DIST = 3.0f;
    public static final int ENV_CALC_MAX_LEVEL = 3;
    public static final int MOUSE_NONE = -1;
    public static final byte MULTIBOND_NEVER = 0;
    public static final byte MULTIBOND_WIREFRAME = 1;
    public static final byte MULTIBOND_NOTSMALL = 2;
    public static final byte MULTIBOND_ALWAYS = 3;
    public static final int MAXIMUM_AUTO_BOND_COUNT = 20;
    public static final short madMultipleBondSmallMaximum = 500;
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public static final int[] altArgbsCpk;
    public static final int[] argbsFormalCharge;
    public static final int[] argbsRwbScale;
    public static final int FORMAL_CHARGE_COLIX_RED;
    public static final int PARTIAL_CHARGE_COLIX_RED;
    public static final int PARTIAL_CHARGE_RANGE_SIZE;
    public static final int[] argbsRoygbScale;
    public static final int argbsIsosurfacePositive = -11525984;
    public static final int argbsIsosurfaceNegative = -6283184;
    public static final byte ATOMID_AMINO_NITROGEN = 1;
    public static final byte ATOMID_ALPHA_CARBON = 2;
    public static final byte ATOMID_CARBONYL_CARBON = 3;
    public static final byte ATOMID_CARBONYL_OXYGEN = 4;
    public static final byte ATOMID_O1 = 5;
    public static final int ATOMID_ALPHA_ONLY_MASK = 4;
    public static final int ATOMID_PROTEIN_MASK = 14;
    public static final byte ATOMID_O5_PRIME = 6;
    public static final byte ATOMID_C5_PRIME = 7;
    public static final byte ATOMID_C4_PRIME = 8;
    public static final byte ATOMID_C3_PRIME = 9;
    public static final byte ATOMID_O3_PRIME = 10;
    public static final byte ATOMID_C2_PRIME = 11;
    public static final byte ATOMID_C1_PRIME = 12;
    public static final byte ATOMID_O4_PRIME = 78;
    public static final int ATOMID_NUCLEIC_MASK = 8128;
    public static final byte ATOMID_NUCLEIC_PHOSPHORUS = 13;
    public static final int ATOMID_PHOSPHORUS_ONLY_MASK = 8192;
    public static final int ATOMID_DISTINGUISHING_ATOM_MAX = 14;
    public static final byte ATOMID_CARBONYL_OD1 = 14;
    public static final byte ATOMID_CARBONYL_OD2 = 15;
    public static final byte ATOMID_CARBONYL_OE1 = 16;
    public static final byte ATOMID_CARBONYL_OE2 = 17;
    public static final byte ATOMID_N1 = 32;
    public static final byte ATOMID_C2 = 33;
    public static final byte ATOMID_N3 = 34;
    public static final byte ATOMID_C4 = 35;
    public static final byte ATOMID_C5 = 36;
    public static final byte ATOMID_C6 = 37;
    public static final byte ATOMID_O2 = 38;
    public static final byte ATOMID_N7 = 39;
    public static final byte ATOMID_C8 = 40;
    public static final byte ATOMID_N9 = 41;
    public static final byte ATOMID_N4 = 42;
    public static final byte ATOMID_N2 = 43;
    public static final byte ATOMID_N6 = 44;
    public static final byte ATOMID_C5M = 45;
    public static final byte ATOMID_O6 = 46;
    public static final byte ATOMID_O4 = 47;
    public static final byte ATOMID_S4 = 48;
    public static final byte ATOMID_C7 = 49;
    public static final byte ATOMID_TERMINATING_OXT = 64;
    public static final byte ATOMID_H5T_TERMINUS = 72;
    public static final byte ATOMID_O5T_TERMINUS = 73;
    public static final byte ATOMID_O1P = 74;
    public static final byte ATOMID_OP1 = 75;
    public static final byte ATOMID_O2P = 76;
    public static final byte ATOMID_OP2 = 77;
    public static final byte ATOMID_O2_PRIME = 79;
    public static final byte ATOMID_H3T_TERMINUS = 88;
    public static final byte ATOMID_HO3_PRIME = 89;
    public static final byte ATOMID_HO5_PRIME = 90;
    public static final int PURINE_MASK = 153957;
    public static final int PYRIMIDINE_MASK = 108186;
    public static final int DNA_MASK = 65480;
    public static final int RNA_MASK = 196663;
    public static final int GROUPID_ARGININE = 2;
    public static final int GROUPID_ASPARAGINE = 3;
    public static final int GROUPID_ASPARTATE = 4;
    public static final int GROUPID_CYSTEINE = 5;
    public static final int GROUPID_GLUTAMINE = 6;
    public static final int GROUPID_GLUTAMATE = 7;
    public static final int GROUPID_HISTIDINE = 9;
    public static final int GROUPID_LYSINE = 12;
    public static final int GROUPID_PROLINE = 15;
    public static final int GROUPID_TRYPTOPHAN = 19;
    public static final int GROUPID_AMINO_MAX = 24;
    public static final int GROUPID_NUCLEIC_MAX = 42;
    public static final int GROUPID_WATER = 42;
    public static final int GROUPID_SOLVENT_MIN = 45;
    private static final int GROUPID_ION_MIN = 46;
    private static final int GROUPID_ION_MAX = 48;
    public static String[] predefinedVariable;
    public static String[] predefinedStatic;
    public static final String MODELKIT_ZAP_STRING = "5\n\nC 0 0 0\nH .63 .63 .63\nH -.63 -.63 .63\nH -.63 .63 -.63\nH .63 -.63 -.63";
    public static final String MODELKIT_ZAP_TITLE = "Jmol Model Kit";
    public static final String ZAP_TITLE = "zapped";
    public static final String ADD_HYDROGEN_TITLE = "Viewer.AddHydrogens";
    public static final String DEFAULT_FONTFACE = "SansSerif";
    public static final String DEFAULT_FONTSTYLE = "Plain";
    public static final int MEASURE_DEFAULT_FONTSIZE = 15;
    public static final int AXES_DEFAULT_FONTSIZE = 14;
    public static final int SHAPE_BALLS = 0;
    public static final int SHAPE_STICKS = 1;
    public static final int SHAPE_HSTICKS = 2;
    public static final int SHAPE_SSSTICKS = 3;
    public static final int SHAPE_STRUTS = 4;
    public static final int SHAPE_LABELS = 5;
    public static final int SHAPE_MEASURES = 6;
    public static final int SHAPE_STARS = 7;
    public static final int SHAPE_MIN_HAS_SETVIS = 8;
    public static final int SHAPE_HALOS = 8;
    public static final int SHAPE_MIN_SECONDARY = 9;
    public static final int SHAPE_BACKBONE = 9;
    public static final int SHAPE_TRACE = 10;
    public static final int SHAPE_CARTOON = 11;
    public static final int SHAPE_STRANDS = 12;
    public static final int SHAPE_MESHRIBBON = 13;
    public static final int SHAPE_RIBBONS = 14;
    public static final int SHAPE_ROCKETS = 15;
    public static final int SHAPE_MAX_SECONDARY = 16;
    public static final int SHAPE_MIN_SPECIAL = 16;
    public static final int SHAPE_DOTS = 16;
    public static final int SHAPE_DIPOLES = 17;
    public static final int SHAPE_VECTORS = 18;
    public static final int SHAPE_GEOSURFACE = 19;
    public static final int SHAPE_ELLIPSOIDS = 20;
    public static final int SHAPE_MAX_SIZE_ZERO_ON_RESTRICT = 21;
    public static final int SHAPE_POLYHEDRA = 21;
    public static final int SHAPE_MIN_HAS_ID = 22;
    public static final int SHAPE_MIN_MESH_COLLECTION = 22;
    public static final int SHAPE_DRAW = 22;
    public static final int SHAPE_MAX_SPECIAL = 23;
    public static final int SHAPE_CGO = 23;
    public static final int SHAPE_MIN_SURFACE = 24;
    public static final int SHAPE_ISOSURFACE = 24;
    public static final int SHAPE_CONTACT = 25;
    public static final int SHAPE_LCAOCARTOON = 26;
    private static final int SHAPE_LAST_ATOM_VIS_FLAG = 26;
    public static final int SHAPE_MO = 27;
    public static final int SHAPE_NBO = 28;
    public static final int SHAPE_PMESH = 29;
    public static final int SHAPE_PLOT3D = 30;
    public static final int SHAPE_MAX_SURFACE = 30;
    public static final int SHAPE_MAX_MESH_COLLECTION = 30;
    public static final int SHAPE_ECHO = 31;
    public static final int SHAPE_MAX_HAS_ID = 32;
    public static final int SHAPE_BBCAGE = 32;
    public static final int SHAPE_MAX_HAS_SETVIS = 33;
    public static final int SHAPE_UCCAGE = 33;
    public static final int SHAPE_AXES = 34;
    public static final int SHAPE_HOVER = 35;
    public static final int SHAPE_FRANK = 36;
    public static final int SHAPE_MAX = 37;
    public static final int VIS_BOND_FLAG = 32;
    public static final int VIS_BALLS_FLAG = 16;
    public static final int VIS_LABEL_FLAG = 512;
    public static final int VIS_BACKBONE_FLAG = 8192;
    public static final int VIS_CARTOON_FLAG = 32768;
    public static final int ALPHA_CARBON_VISIBILITY_FLAG = 1040384;
    public static final String[] shapeClassBases;
    public static final String SCRIPT_COMPLETED = "Script completed";
    public static final String JPEG_EXTENSIONS = ";jpg;jpeg;jpg64;jpeg64;";
    public static final String IMAGE_TYPES = ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;";
    public static final String IMAGE_OR_SCENE = ";jpg;jpeg;jpg64;jpeg64;gif;gift;pdf;ppm;png;pngj;pngt;scene;";
    public static final int LABEL_MINIMUM_FONTSIZE = 6;
    public static final int LABEL_MAXIMUM_FONTSIZE = 63;
    public static final int LABEL_DEFAULT_FONTSIZE = 13;
    public static final int LABEL_DEFAULT_X_OFFSET = 4;
    public static final int LABEL_DEFAULT_Y_OFFSET = 4;
    public static final int LABEL_OFFSET_MAX = 500;
    private static final int LABEL_OFFSET_MASK = 1023;
    private static final int LABEL_FLAGY_OFFSET_SHIFT = 11;
    private static final int LABEL_FLAGX_OFFSET_SHIFT = 21;
    public static final int LABEL_FLAGS = 63;
    private static final int LABEL_POINTER_FLAGS = 3;
    public static final int LABEL_POINTER_NONE = 0;
    public static final int LABEL_POINTER_ON = 1;
    public static final int LABEL_POINTER_BACKGROUND = 2;
    private static final int TEXT_ALIGN_SHIFT = 2;
    private static final int TEXT_ALIGN_FLAGS = 12;
    public static final int TEXT_ALIGN_NONE = 0;
    public static final int TEXT_ALIGN_LEFT = 4;
    public static final int TEXT_ALIGN_CENTER = 8;
    public static final int TEXT_ALIGN_RIGHT = 12;
    private static final int LABEL_ZPOS_FLAGS = 48;
    public static final int LABEL_ZPOS_GROUP = 16;
    public static final int LABEL_ZPOS_FRONT = 32;
    private static final int LABEL_EXPLICIT = 64;
    private static final int LABEL_CENTERED = 256;
    public static int LABEL_DEFAULT_OFFSET;
    public static final int ECHO_TOP = 0;
    public static final int ECHO_BOTTOM = 1;
    public static final int ECHO_MIDDLE = 2;
    public static final int ECHO_XY = 3;
    public static final int ECHO_XYZ = 4;
    private static final String[] echoNames;
    private static final String[] hAlignNames;
    public static final int SMILES_TYPE_SMILES = 1;
    public static final int SMILES_TYPE_SMARTS = 2;
    public static final int SMILES_MATCH_ALL = 16;
    public static final int SMILES_MATCH_ONE = 32;
    public static final int SMILES_RETURN_FIRST = 64;
    public static final int SMILES_EXPLICIT_H = 256;
    public static final int SMILES_TOPOLOGY = 512;
    public static final int SMILES_NOAROMATIC = 1024;
    public static final int SMILES_NOSTEREO = 2048;
    public static final int SMILES_POLYHEDRAL = 4096;
    public static final int SMILES_BIO = 65536;
    public static final int SMILES_BIO_ALLOW_UNMATCHED_RINGS = 69632;
    public static final int SMILES_BIO_COV_CROSSLINK = 73728;
    public static final int SMILES_BIO_HH_CROSSLINK = 90112;
    public static final int SMILES_BIO_COMMENT = 196608;
    public static final int SMILES_BIO_NOCOMMENTS = 327680;
    public static final int SMILES_ATOM_COMMENT = 524288;
    public static final int JSV_NOT = -1;
    public static final int JSV_SEND_JDXMOL = 0;
    public static final int JSV_SETPEAKS = 7;
    public static final int JSV_SELECT = 14;
    public static final int JSV_STRUCTURE = 21;
    public static final int JSV_SEND_H1SIMULATE = 28;
    public static final int NBO_MODEL = 35;
    public static final int NBO_RUN = 42;
    public static final int NBO_VIEW = 49;
    public static final int NBO_SEARCH = 56;
    public static final int NBO_CONFIG = 63;
    public static String READER_NOT_FOUND;
    public static final int UNITID_MODEL = 1;
    public static final int UNITID_RESIDUE = 2;
    public static final int UNITID_ATOM = 4;
    public static final int UNITID_INSCODE = 8;
    public static final int UNITID_TRIM = 16;

    public static String getMacroList() {
        SB sB = new SB();
        for (int i = 0; i < macros.length; i += 2) {
            sB.append(macros[i]).append("\t").append(macros[i + 1]).append("\n");
        }
        return sB.toString();
    }

    public static String getMacro(String string) {
        for (int i = 0; i < macros.length; i += 2) {
            if (!macros[i].equals(string)) continue;
            return macros[i + 1];
        }
        return null;
    }

    public static String embedScript(String string) {
        return "\n/****** Jmol Embedded Script **** \n" + string + "\n**/";
    }

    public static final int getShapeVisibilityFlag(int n) {
        return 16 << Math.min(n, 26);
    }

    public static final int shapeTokenIndex(int n) {
        switch (n) {
            case 0x40000024: 
            case 0x44000001: {
                return 0;
            }
            case 659488: 
            case 1677721602: {
                return 1;
            }
            case 1613238294: {
                return 2;
            }
            case 1611141176: {
                return 3;
            }
            case 659482: {
                return 4;
            }
            case 1825200140: {
                return 5;
            }
            case 0x20021010: 
            case 1745489933: {
                return 6;
            }
            case 1112152076: {
                return 7;
            }
            case 1112152070: {
                return 8;
            }
            case 1114249217: {
                return 9;
            }
            case 1112152078: {
                return 10;
            }
            case 1112152066: {
                return 11;
            }
            case 1649022989: {
                return 12;
            }
            case 1112152071: {
                return 13;
            }
            case 1112152073: {
                return 14;
            }
            case 1112152074: {
                return 15;
            }
            case 1112150019: {
                return 16;
            }
            case 135175: {
                return 17;
            }
            case 135198: {
                return 18;
            }
            case 1112150021: {
                return 19;
            }
            case 1112150020: {
                return 20;
            }
            case 1275203591: {
                return 21;
            }
            case 135174: {
                return 23;
            }
            case 135176: {
                return 22;
            }
            case 135180: {
                return 24;
            }
            case 134353929: {
                return 25;
            }
            case 135182: {
                return 26;
            }
            case 1073877010: {
                return 27;
            }
            case 1073877011: {
                return 28;
            }
            case 135188: {
                return 29;
            }
            case 135190: {
                return 30;
            }
            case 537022465: {
                return 31;
            }
            case 1611272194: {
                return 34;
            }
            case 1678381065: {
                return 32;
            }
            case 1613369372: {
                return 33;
            }
            case 544771: {
                return 35;
            }
            case 1611272202: {
                return 36;
            }
        }
        return -1;
    }

    public static final String getShapeClassName(int n, boolean bl) {
        if (n < 0) {
            return shapeClassBases[~n];
        }
        return "org.jmol." + (bl ? "render" : "shape") + (n >= 9 && n < 16 ? "bio." : (n >= 16 && n < 23 ? "special." : (n >= 24 && n < 30 ? "surface." : (n == 23 ? "cgo." : ".")))) + shapeClassBases[n];
    }

    public static boolean isScriptType(String string) {
        return PT.isOneOf(string.substring(string.lastIndexOf(".") + 1), ";pse;spt;png;pngj;jmol;zip;");
    }

    public static String getEchoName(int n) {
        return echoNames[n];
    }

    public static int setZPosition(int n, int n2) {
        return n & 0xFFFFFFCF | n2;
    }

    public static int setPointer(int n, int n2) {
        return n & 0xFFFFFFFC | n2;
    }

    public static int getPointer(int n) {
        return n & 3;
    }

    public static String getPointerName(int n) {
        return (n & 1) == 0 ? "" : ((n & 2) > 0 ? "background" : "on");
    }

    public static boolean isOffsetAbsolute(int n) {
        return (n & 0x40) != 0;
    }

    public static int getOffset(int n, int n2, boolean bl) {
        int n3 = ((n = Math.min(Math.max(n, -500), 500)) & 0x3FF) << 21 | ((n2 = Math.min(Math.max(n2, -500), 500)) & 0x3FF) << 11 | (bl ? 64 : 0);
        if (n3 == LABEL_DEFAULT_OFFSET) {
            n3 = 0;
        } else if (!(bl || n != 0 && n2 != 0)) {
            n3 |= 0x100;
        }
        return n3;
    }

    public static int getXOffset(int n) {
        if (n == 0) {
            return 4;
        }
        int n2 = n >> 21 & 0x3FF;
        n2 = n2 > 500 ? n2 - 1023 - 1 : n2;
        return n2;
    }

    public static int getYOffset(int n) {
        if (n == 0) {
            return 4;
        }
        int n2 = n >> 11 & 0x3FF;
        return n2 > 500 ? n2 - 1023 - 1 : n2;
    }

    public static int getAlignment(int n) {
        return n & 0xC;
    }

    public static int setHorizAlignment(int n, int n2) {
        return n & 0xFFFFFFF3 | n2;
    }

    public static String getHorizAlignmentName(int n) {
        return hAlignNames[n >> 2 & 3];
    }

    public static int getServiceCommand(String string) {
        return string.length() < 7 ? -1 : "JSPECVIPEAKS: SELECT:JSVSTR:H1SIMULNBO:MODNBO:RUNNBO:VIENBO:SEANBO:CON".indexOf(string.substring(0, 7).toUpperCase());
    }

    public static boolean checkFlag(int n, int n2) {
        return (n & n2) == n2;
    }

    public static int getUnitIDFlags(String string) {
        int n = 14;
        if (string.indexOf("-") == 0) {
            if (string.indexOf("m") > 0) {
                n |= 1;
            }
            if (string.indexOf("a") < 0) {
                n ^= 4;
            }
            if (string.indexOf("t") > 0) {
                n |= 0x10;
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String string = null;
        String string2 = null;
        BufferedInputStream bufferedInputStream = null;
        Object object = null;
        try {
            object = JC.class.getClassLoader().getResourceAsStream("org/jmol/viewer/Jmol.properties");
            bufferedInputStream = new BufferedInputStream((InputStream)object);
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            string = PT.trimQuotes(properties.getProperty("Jmol.___JmolVersion", string));
            string2 = PT.trimQuotes(properties.getProperty("Jmol.___JmolDate", string2));
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                try {
                    ((InputStream)object).close();
                }
                catch (Exception exception) {}
            }
        }
        if (string2 != null) {
            string2 = string2.substring(7, 23);
        }
        version = string != null ? string : "(Unknown version)";
        date = string2 != null ? string2 : "(Unknown date)";
        int n = -1;
        try {
            object = version;
            int n2 = ((String)object).indexOf(".");
            if (n2 < 0) {
                n = 100000 * Integer.parseInt((String)object);
                object = null;
            }
            if (object != null) {
                n = 100000 * Integer.parseInt(((String)object).substring(0, n2));
                if ((n2 = ((String)(object = ((String)object).substring(n2 + 1))).indexOf(".")) < 0) {
                    n += 1000 * Integer.parseInt((String)object);
                    object = null;
                }
                if (object != null) {
                    n += 1000 * Integer.parseInt(((String)object).substring(0, n2));
                    if ((n2 = ((String)(object = ((String)object).substring(n2 + 1))).indexOf("_")) >= 0) {
                        object = ((String)object).substring(0, n2);
                    }
                    if ((n2 = ((String)object).indexOf(" ")) >= 0) {
                        object = ((String)object).substring(0, n2);
                    }
                    n += Integer.parseInt((String)object);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        versionInt = n;
        center = V3.new3(0.0f, 0.0f, 0.0f);
        axisX = V3.new3(1.0f, 0.0f, 0.0f);
        axisY = V3.new3(0.0f, 1.0f, 0.0f);
        axisZ = V3.new3(0.0f, 0.0f, 1.0f);
        axisNX = V3.new3(-1.0f, 0.0f, 0.0f);
        axisNY = V3.new3(0.0f, -1.0f, 0.0f);
        axisNZ = V3.new3(0.0f, 0.0f, -1.0f);
        unitAxisVectors = new V3[]{axisX, axisY, axisZ, axisNX, axisNY, axisNZ};
        altArgbsCpk = new int[]{-60269, -4217178, -208, -11069553, -64, -96, -2565928, -11513776, -12566464, -15708080};
        argbsFormalCharge = new int[]{-65536, -49088, -32640, -16192, -1, -2565889, -4934401, -7302913, -9671425, -12039937, -14408449, -16776961};
        argbsRwbScale = new int[]{-65536, -61424, -57312, -53200, -49088, -44976, -40864, -36752, -32640, -28528, -24416, -20304, -16192, -12080, -7968, -1, -2039553, -3092225, -4144897, -5197569, -6250241, -7302913, -8355585, -9408257, -10460929, -11513601, -12566273, -13618945, -14671617, -15724289, -16776961};
        FORMAL_CHARGE_COLIX_RED = Elements.elementSymbols.length + altArgbsCpk.length;
        PARTIAL_CHARGE_COLIX_RED = FORMAL_CHARGE_COLIX_RED + argbsFormalCharge.length;
        PARTIAL_CHARGE_RANGE_SIZE = argbsRwbScale.length;
        argbsRoygbScale = new int[]{-65536, -57344, -49152, -40960, Short.MIN_VALUE, -24576, -16384, -8192, -4096, -256, -987136, -2031872, -4129024, -6226176, -8323328, -10420480, -12517632, -14614784, -16711936, -16711904, -16711872, -16711840, -16711808, -16711776, -16711744, -16711712, -16711681, -16719617, -16727809, -16736001, -16744193, -16752385, -16760577, -16768769, -16776961};
        predefinedVariable = new String[]{"@_1H _H & !(_2H,_3H)", "@_12C _C & !(_13C,_14C)", "@_14N _N & !(_15N)", "@solvent water, (_g>=45 & _g<48)", "@ligand _g=0|!(_g<46,protein,nucleic,water)", "@turn structure=1", "@sheet structure=2", "@helix structure=3", "@helix310 substructure=7", "@helixalpha substructure=8", "@helixpi substructure=9", "@bulges within(dssr,'bulges')", "@coaxStacks within(dssr,'coaxStacks')", "@hairpins within(dssr,'hairpins')", "@hbonds within(dssr,'hbonds')", "@helices within(dssr,'helices')", "@iloops within(dssr,'iloops')", "@isoCanonPairs within(dssr,'isoCanonPairs')", "@junctions within(dssr,'junctions')", "@kissingLoops within(dssr,'kissingLoops')", "@multiplets within(dssr,'multiplets')", "@nonStack within(dssr,'nonStack')", "@nts within(dssr,'nts')", "@naChains within(dssr,'naChains')", "@pairs within(dssr,'pairs')", "@ssSegments within(dssr,'ssSegments')", "@stacks within(dssr,'stacks')", "@stems within(dssr,'stems')"};
        predefinedStatic = new String[]{"@amino _g>0 & _g<=23", "@acidic asp,glu", "@basic arg,his,lys", "@charged acidic,basic", "@negative acidic", "@positive basic", "@neutral amino&!(acidic,basic)", "@polar amino&!hydrophobic", "@cyclic his,phe,pro,trp,tyr", "@acyclic amino&!cyclic", "@aliphatic ala,gly,ile,leu,val", "@aromatic his,phe,trp,tyr", "@cystine within(group, (cys.sg or cyx.sg) and connected(cys.sg or cyx.sg))", "@buried ala,cys,ile,leu,met,phe,trp,val", "@surface amino&!buried", "@hydrophobic ala,gly,ile,leu,met,phe,pro,trp,tyr,val", "@mainchain backbone", "@small ala,gly,ser", "@medium asn,asp,cys,pro,thr,val", "@large arg,glu,gln,his,ile,leu,lys,met,phe,trp,tyr", "@c nucleic & ([C] or [DC] or within(group,_a=42))", "@g nucleic & ([G] or [DG] or within(group,_a=43))", "@cg c,g", "@a nucleic & ([A] or [DA] or within(group,_a=44))", "@t nucleic & ([T] or [DT] or within(group,_a=45 | _a=49))", "@at a,t", "@i nucleic & ([I] or [DI] or within(group,_a=46) & !g)", "@u nucleic & ([U] or [DU] or within(group,_a=47) & !t)", "@tu nucleic & within(group,_a=48)", "@ions _g>=46&_g<48", "@alpha _a=2", "@_bb protein&_a>=1&_a<6 | nucleic& _a>=6&_a<14", "@backbone _bb | _H && connected(single, _bb)", "@spine protein&_a>=1&_a<4|nucleic&_a>=6&_a<14&_a!=12", "@sidechain (protein,nucleic) & !backbone", "@base nucleic & !backbone", "@dynamic_flatring search('[a]')"};
        shapeClassBases = new String[]{"Balls", "Sticks", "Hsticks", "Sssticks", "Struts", "Labels", "Measures", "Stars", "Halos", "Backbone", "Trace", "Cartoon", "Strands", "MeshRibbon", "Ribbons", "Rockets", "Dots", "Dipoles", "Vectors", "GeoSurface", "Ellipsoids", "Polyhedra", "Draw", "CGO", "Isosurface", "Contact", "LcaoCartoon", "MolecularOrbital", "NBO", "Pmesh", "Plot3D", "Echo", "Bbcage", "Uccage", "Axes", "Hover", "Frank"};
        if (argbsFormalCharge.length != 12) {
            Logger.error("formal charge color table length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 37) {
            Logger.error("shapeClassBases wrong length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 37) {
            Logger.error("the shapeClassBases array has the wrong length");
            throw new NullPointerException();
        }
        LABEL_DEFAULT_OFFSET = 0x802000;
        echoNames = new String[]{"top", "bottom", "middle", "xy", "xyz"};
        hAlignNames = new String[]{"", "left", "center", "right"};
        READER_NOT_FOUND = "File reader was not found:";
    }
}

