/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.GaussianDialog;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBODialogModel;
import org.openscience.jmol.app.nbo.NBOPanel;

abstract class NBODialogRun
extends NBODialogModel {
    private String useExt;
    protected GaussianDialog gau;
    protected DefaultListModel<String> listModel;
    protected JList<String> lstKeywords;
    private JComboBox<String> comboEditOps;
    private JButton jbRun;
    private JButton jbSave;
    private DefaultComboBoxModel<String> comboModel;
    String fileData;
    String fileData2;
    String params;

    protected NBODialogRun(JFrame jFrame) {
        super(jFrame);
    }

    protected void buildRun(Container container) {
        this.useExt = "47";
        Properties properties = JmolPanel.historyFile.getProperties();
        this.workingPath = properties.getProperty("workingPath", System.getProperty("user.home"));
        container.removeAll();
        container.setLayout(new BorderLayout());
        if (this.topPanel == null) {
            this.topPanel = this.buildTopPanel();
        }
        container.add((Component)this.topPanel, "First");
        JSplitPane jSplitPane = new JSplitPane(1, this.runS(), this.modelOut());
        jSplitPane.setDividerLocation(430);
        jSplitPane.setBorder(BorderFactory.createLoweredBevelBorder());
        container.add((Component)jSplitPane, "Center");
        NBOPanel nBOPanel = new NBOPanel(this, 7);
        nBOPanel.setLayout(new FlowLayout(0));
        this.statusLab.setText("");
        container.add((Component)this.statusPanel, "Last");
        if (this.isJmolNBO) {
            this.setInputFile(this.inputFile, "47", null);
        }
    }

    protected JPanel runS() {
        this.params = "";
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("ESS  ")).setFont(new Font("Arial", 1, 25));
        String[] stringArray = new String[]{"GenNBO", "GO9", "GAMESS"};
        this.action = new JComboBox<String>(stringArray);
        this.action.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogRun.this.essChanged();
            }
        });
        box.add(this.action);
        box.setBorder(BorderFactory.createEmptyBorder(20, 0, 10, 5));
        jPanel.add(box).setMaximumSize(new Dimension(500, 60));
        jPanel.add(new JSeparator());
        box = Box.createHorizontalBox();
        box.add(new JLabel("INPUT")).setFont(new Font("Arial", 1, 25));
        box.add(this.folderBox());
        this.browse.setEnabled(true);
        jPanel.add(box);
        jPanel.add(new JSeparator());
        box = Box.createHorizontalBox();
        box.add(new JLabel("EDIT ")).setFont(new Font("Arial", 1, 25));
        this.comboModel = new DefaultComboBoxModel();
        this.comboModel.addElement("-type-");
        this.comboModel.addElement("$NBO Keylist");
        this.comboEditOps = new JComboBox<String>(this.comboModel);
        box.add(this.comboEditOps);
        this.comboEditOps.setEnabled(this.isJmolNBO);
        this.comboEditOps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogRun.this.editOpChanged();
            }
        });
        box.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 5));
        jPanel.add(box).setMaximumSize(new Dimension(500, 60));
        this.editBox = Box.createVerticalBox();
        this.editBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.editBox.add(Box.createRigidArea(new Dimension(430, 230)));
        jPanel.add(this.editBox);
        box = Box.createHorizontalBox();
        this.jbRun = new JButton("Run");
        box.add(this.jbRun).setFont(new Font("Arial", 0, 20));
        this.jCheckAtomNum = new JCheckBox("View atom numbers");
        this.jCheckAtomNum.setEnabled(false);
        this.jCheckAtomNum.setAlignmentX(0.5f);
        this.jCheckAtomNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!NBODialogRun.this.jCheckAtomNum.isSelected()) {
                    NBODialogRun.this.nboService.runScriptQueued("select {*};label off");
                } else {
                    NBODialogRun.this.nboService.runScriptQueued("select {*};label %a");
                }
                NBODialogRun.this.nboService.runScriptQueued("color labels white;select remove {*}");
            }
        });
        box.add(this.jCheckAtomNum);
        box.add(Box.createRigidArea(new Dimension(100, 0)));
        this.jbSave = new JButton("Save File");
        this.jbSave.setEnabled(this.isJmolNBO);
        this.jbSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    NBODialogRun.this.nboService.writeToFile(NBODialogRun.this.fileData + " " + NBODialogRun.this.params + NBODialogConfig.sep + NBODialogRun.this.fileData2, NBODialogRun.this.inputFile);
                }
                catch (IOException iOException) {
                    NBODialogRun.this.appendOutputWithCaret("-Error saving file-");
                    return;
                }
                NBODialogRun.this.appendOutputWithCaret("-File saved-");
            }
        });
        box.add(this.jbSave);
        this.jbRun.setEnabled(this.isJmolNBO);
        this.jbRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogRun.this.goRunClicked(NBODialogRun.this.jtSelectAtoms.getText(), NBODialogRun.this.inputFile, null);
            }
        });
        jPanel.add(box);
        if (this.isJmolNBO) {
            this.getParams(this.inputFile);
            this.comboEditOps.setSelectedIndex(1);
        }
        return jPanel;
    }

    protected void essChanged() {
        this.clearInputFile();
        this.jbRun.setEnabled(false);
        this.jbSave.setEnabled(false);
        this.comboEditOps.setEnabled(false);
        this.editBox.removeAll();
        this.editBox.add(Box.createRigidArea(new Dimension(430, 230)));
        this.appendOutputWithCaret("ESS changed:\n  " + this.action.getSelectedItem().toString());
        Object object = this.action.getSelectedItem();
        if (object.equals("GenNBO")) {
            this.useExt = "47";
            this.comboModel.removeElement("Gaussian Input File");
            return;
        }
        if (object.equals("GO9")) {
            this.useExt = "gau";
            this.comboModel.addElement("Gaussian Input File");
            return;
        }
    }

    protected void editOpChanged() {
        Object object = this.comboEditOps.getSelectedItem();
        if (object.equals("-type-")) {
            this.editBox.removeAll();
            this.editBox.add(Box.createRigidArea(new Dimension(430, 230)));
        } else if (object.equals("$NBO Keylist")) {
            this.addList();
        } else if (object.equals("Gaussian Input File")) {
            this.editBox.removeAll();
            JScrollPane jScrollPane = new JScrollPane();
            this.editBox.setSize(new Dimension(430, 230));
            this.gau = new GaussianDialog((JFrame)this.getParent(), this.vwr);
            jScrollPane.setViewportView(this.gau.getContentPane());
            this.editBox.add(jScrollPane);
        }
        this.setComponents(this.editBox);
        this.repaint();
        this.revalidate();
    }

    @Override
    protected void showWorkpathDialogR(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileNameExtensionFilter(this.useExt, this.useExt));
        jFileChooser.setFileHidingEnabled(true);
        jFileChooser.setSelectedFile(new File(string));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            this.inputFile = jFileChooser.getSelectedFile();
            this.setInputFile(this.inputFile, this.useExt, this.showWorkPathDone);
            this.comboEditOps.setEnabled(true);
            this.getParams(this.inputFile);
            this.appendOutputWithCaret("File loaded:\n  " + this.jobStem + "." + this.useExt);
            this.comboEditOps.setSelectedIndex(1);
            if (!this.useExt.equals("47")) {
                this.nboService.runScriptQueued("load \"input::" + this.inputFile.toString() + "\"");
            }
            this.jbRun.setEnabled(true);
            this.jCheckAtomNum.setEnabled(true);
            this.jbSave.setEnabled(true);
            this.nboResetV();
            this.saveHistory();
            this.isJmolNBO = this.checkJmolNBO();
        }
    }

    protected void getParams(File file) {
        this.params = "";
        String string = this.nboService.getFileData(file.toString());
        String[] stringArray = PT.split(string, "$END");
        boolean bl = false;
        SB sB = new SB();
        SB sB2 = new SB();
        if (stringArray.length <= 0) {
            return;
        }
        int n = 0;
        while (true) {
            String string2 = stringArray[n];
            string2 = PT.trim(string2, "\t\r\n ");
            if (!bl) {
                if (string2.indexOf("$NBO") >= 0) {
                    bl = true;
                    if (PT.split(string2, "$NBO").length > 1) {
                        this.params = this.cleanParams(PT.split(string2, "$NBO")[1]);
                    }
                    string2 = string2.substring(0, string2.indexOf("$NBO")) + "$NBO";
                    Logger.info("Params read: " + this.params);
                }
                sB.append(string2).append(sep);
                if (++n == stringArray.length) break;
                if (!bl) {
                    sB.append("$END").append(sep);
                    continue;
                }
                sB2.append("$END").append(sep);
                continue;
            }
            sB2.append(string2).append(sep);
            if (++n == stringArray.length) break;
            sB2.append("$END").append(sep);
        }
        this.fileData = sB.toString();
        this.fileData2 = sB2.append(sep).toString();
    }

    private String cleanParams(String string) {
        String[] stringArray = PT.getTokens(PT.rep(PT.clean(string), "file=", "FILE="));
        String string2 = " ";
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = " " + stringArray[i] + " ";
            if (string3.indexOf("=") < 0) {
                string3 = string3.toUpperCase();
            }
            if (string2.indexOf(string3) >= 0) continue;
            if (string2.length() + string3.length() - string2.lastIndexOf(sep) >= 80) {
                string2 = string2 + sep + " ";
            }
            string2 = string2 + string3.substring(1);
        }
        return string2.trim() + " ";
    }

    protected void addList() {
        if (this.inputFile != null) {
            this.editBox.removeAll();
            this.editBox.setSize(new Dimension(430, 230));
            this.listModel = new DefaultListModel();
            for (String object2 : this.params.split(" |\\n")) {
                if (object2.length() <= 1) continue;
                this.listModel.addElement(object2);
            }
            this.lstKeywords = new JList<String>(this.listModel);
            this.lstKeywords.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        NBODialogRun.this.removeListParams(NBODialogRun.this.lstKeywords.getSelectedValuesList());
                    }
                }
            });
            Box box = Box.createHorizontalBox();
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add(this.lstKeywords);
            jScrollPane.setBorder(new TitledBorder("Current Keywords:"));
            box.add(jScrollPane);
            Box box2 = Box.createVerticalBox();
            JButton jButton = new JButton("Add");
            jButton.setAlignmentX(0.5f);
            box2.add(jButton).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                }
            });
            JButton jButton2 = new JButton("Remove");
            jButton2.setAlignmentX(0.5f);
            box2.add(jButton2).addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (!NBODialogRun.this.lstKeywords.isSelectionEmpty()) {
                        NBODialogRun.this.removeListParams(NBODialogRun.this.lstKeywords.getSelectedValuesList());
                    }
                }
            });
            box.add(box2);
            this.editBox.add(box);
            this.jtSelectAtoms = new JTextField();
            this.jtSelectAtoms.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    NBODialogRun.this.addParams(NBODialogRun.this.jtSelectAtoms.getText().split(" "));
                }
            });
            this.jtSelectAtoms.setBorder(new TitledBorder("Additional Keywords"));
            this.editBox.add(this.jtSelectAtoms);
        }
    }

    protected void addParams(String[] stringArray) {
        this.appendOutputWithCaret("Keyword(s) added:");
        for (String string : stringArray) {
            if (string.equals("")) continue;
            if (string.toUpperCase().indexOf("FILE=") >= 0) {
                this.removeStringParams("FILE=");
                String string2 = "FILE=" + string.substring(5);
                this.params = this.params + string2 + " ";
                this.listModel.addElement(string2);
                this.appendOutputWithCaret("  " + string2);
                continue;
            }
            if (!this.params.contains(string.toUpperCase())) {
                this.appendOutputWithCaret("  " + string.toUpperCase());
                this.params = this.params + string.toUpperCase() + " ";
                this.listModel.addElement(string.toUpperCase());
                continue;
            }
            this.params = this.params + string + " ";
            this.listModel.addElement(string);
        }
        this.jtSelectAtoms.setText("");
    }

    protected void removeListParams(List<String> list) {
        this.appendOutputWithCaret("Keyword(s) removed:");
        for (String string : list) {
            this.listModel.removeElement(string);
            if (!this.params.toUpperCase().contains(string.toUpperCase())) continue;
            this.params = this.params.substring(0, this.params.indexOf(string.toUpperCase())) + this.params.substring(this.params.indexOf(string.toUpperCase()) + string.length());
            this.appendOutputWithCaret("  " + string);
        }
        String string = this.lstKeywords.getSelectedValue();
        this.listModel.removeElement(string);
    }

    private void removeStringParams(String string) {
        String string2 = "";
        for (String string3 : this.params.split(" ")) {
            if (!string3.contains(string)) {
                string2 = string2.concat(string3) + " ";
                continue;
            }
            this.listModel.removeElement(string3);
        }
        this.params = string2;
    }

    @Override
    protected synchronized void goRunClicked(String string, File file, Runnable runnable) {
        String string2;
        if (file == null) {
            string = PT.clean(this.jtSelectAtoms.getText());
            string2 = "gennbo";
            file = this.inputFile;
        } else {
            string2 = this.action != null ? (String)this.action.getSelectedItem() : "gennbo";
        }
        this.runJob(string, file, string2, runnable);
    }

    private void runJob(String string, final File file, String string2, final Runnable runnable) {
        String string3 = "";
        for (String string4 : string.split(" ")) {
            if (this.params.contains(string4 = string4.toUpperCase())) continue;
            string3 = string3 + string4 + " ";
        }
        if (this.fileData == null) {
            this.getParams(file);
        }
        if (!this.params.toUpperCase().contains("FILE=")) {
            this.params = this.params + "FILE=" + this.jobStem;
        }
        this.params = this.params + string3;
        string3 = "";
        try {
            this.nboService.writeToFile(this.fileData + " " + this.params + sep + this.fileData2, file);
        }
        catch (IOException iOException) {
            Logger.info("Could not create " + file);
            return;
        }
        final SB sB = new SB();
        this.appendToFile("GLOBAL C_PATH " + file.getParent() + sep, sB);
        this.appendToFile("GLOBAL C_JOBSTEM " + this.jobStem + sep, sB);
        this.appendToFile("GLOBAL C_ESS " + string2 + sep, sB);
        this.appendToFile("GLOBAL C_LABEL_1 FILE=" + this.jobStem, sB);
        final String string5 = this.jobStem;
        this.nboService.queueJob("run", "running " + string2 + "...", new Runnable(){

            @Override
            public void run() {
                NBODialogRun.this.nboService.rawCmdNew("r", sB, true, 20);
                try {
                    NBODialogRun.this.nboService.writeToFile(NBODialogRun.this.fileData + " " + NBODialogRun.this.params + NBODialogConfig.sep + NBODialogRun.this.fileData2, file);
                    NBODialogRun.this.getParams(file);
                    NBODialogRun.this.addList();
                    NBODialogRun.this.statusLab.setText("Complete: Output to " + file.getParent() + "\\" + string5 + ".nbo");
                    if (runnable != null) {
                        NBODialogRun.this.nboService.queueJob("load file", "", runnable);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
    }
}

