/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.api.GenericLineReader;
import javajs.util.Lst;
import javajs.util.M3;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.script.SV;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.BSUtil;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public abstract class AtomSetCollectionReader
implements GenericLineReader {
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public boolean isBinary;
    public boolean debugging;
    public AtomSetCollection asc;
    protected BufferedReader reader;
    protected GenericBinaryDocument binaryDoc;
    protected String readerName;
    public Map<String, Object> htParams;
    public Lst<P3[]> trajectorySteps;
    private Object domains;
    public Object validation;
    public Object dssr;
    protected boolean isConcatenated;
    public String addedData;
    public String addedDataKey;
    public boolean fixJavaFloat = true;
    public String line;
    public String prevline;
    protected int[] next = new int[1];
    protected int ptLine;
    public int[] latticeCells;
    public T3[] fillRange;
    public boolean doProcessLines;
    public boolean iHaveUnitCell;
    public boolean iHaveSymmetryOperators;
    public boolean continuing = true;
    public Viewer vwr;
    public boolean doApplySymmetry;
    protected boolean ignoreFileSymmetryOperators;
    protected boolean isTrajectory;
    public boolean applySymmetryToBonds;
    protected boolean doCheckUnitCell;
    protected boolean getHeader;
    protected boolean isSequential;
    protected int templateAtomCount;
    public int modelNumber;
    protected int vibrationNumber;
    public int desiredVibrationNumber = Integer.MIN_VALUE;
    protected BS bsModels;
    protected boolean useFileModelNumbers;
    protected boolean havePartialChargeFilter;
    public String calculationType = "?";
    protected String sgName;
    protected boolean ignoreFileUnitCell;
    protected boolean ignoreFileSpaceGroupName;
    public float[] unitCellParams;
    protected int desiredModelNumber = Integer.MIN_VALUE;
    public SymmetryInterface symmetry;
    protected OC out;
    protected boolean iHaveFractionalCoordinates;
    public boolean doPackUnitCell;
    protected P3 ptSupercell;
    protected boolean mustFinalizeModelSet;
    protected boolean forcePacked;
    public float packingError = 0.02f;
    private SB loadNote = new SB();
    boolean doConvertToFractional;
    boolean fileCoordinatesAreFractional;
    boolean merging;
    float symmetryRange;
    private int[] firstLastStep;
    private int lastModelNumber = Integer.MAX_VALUE;
    public int desiredSpaceGroupIndex = -1;
    protected P3 fileScaling;
    protected float latticeScaling = Float.NaN;
    protected P3 fileOffset;
    private P3 fileOffsetFractional;
    protected P3 unitCellOffset;
    private boolean unitCellOffsetFractional;
    private Lst<String> moreUnitCellInfo;
    protected String filePath;
    protected String fileName;
    protected int stateScriptVersionInt = Integer.MAX_VALUE;
    public int baseAtomIndex;
    protected boolean isFinalized;
    protected boolean haveModel;
    private String previousSpaceGroup;
    private float[] previousUnitCell;
    private int nMatrixElements = 0;
    protected M3 matUnitCellOrientation;
    protected BS bsFilter;
    public String filter;
    private boolean haveAtomFilter;
    private boolean filterAltLoc;
    private boolean filterGroup3;
    private boolean filterChain;
    private boolean filterAtomName;
    private boolean filterAtomType;
    private String filterAtomTypeStr;
    private String filterAtomNameTerminator = ";";
    private boolean filterElement;
    protected boolean filterHetero;
    private boolean filterEveryNth;
    String filterSymop;
    private int filterN;
    private int nFiltered;
    private boolean doSetOrientation;
    protected boolean doCentralize;
    protected boolean addVibrations;
    protected boolean useAltNames;
    protected boolean allowPDBFilter;
    public boolean doReadMolecularOrbitals;
    protected boolean reverseModels;
    private String nameRequired;
    boolean doCentroidUnitCell;
    boolean centroidPacked;
    public String strSupercell;
    private String filter1;
    private String filter2;
    private M3 matRot;
    public MSInterface ms;
    public boolean vibsFractional = false;
    private String previousScript;
    private String siteScript;

    protected void setup(String string, Map<String, Object> map, Object object) {
        this.setupASCR(string, map, object);
    }

    protected void setupASCR(String string, Map<String, Object> map, Object object) {
        if (string == null) {
            return;
        }
        this.debugging = Logger.debugging;
        this.htParams = map;
        this.filePath = string.replace('\\', '/');
        int n = this.filePath.lastIndexOf(47);
        this.fileName = this.filePath.substring(n + 1);
        if (object instanceof BufferedReader) {
            this.reader = (BufferedReader)object;
        } else if (object instanceof GenericBinaryDocument) {
            this.binaryDoc = (GenericBinaryDocument)object;
        }
    }

    Object readData() throws Exception {
        this.initialize();
        this.asc = new AtomSetCollection(this.readerName, this, null, null);
        try {
            this.initializeReader();
            if (this.binaryDoc == null) {
                if (this.line == null && this.continuing) {
                    this.rd();
                }
                while (this.line != null && this.continuing) {
                    if (!this.checkLine()) continue;
                    this.rd();
                }
            } else {
                this.binaryDoc.setOutputChannel(this.out);
                this.processBinaryDocument();
            }
            this.finalizeSubclassReader();
            if (!this.isFinalized) {
                this.finalizeReaderASCR();
            }
        }
        catch (Throwable throwable) {
            Logger.info("Reader error: " + throwable);
            if (!this.vwr.isJS) {
                throwable.printStackTrace();
            }
            this.setError(throwable);
        }
        if (this.reader != null) {
            this.reader.close();
        }
        if (this.binaryDoc != null) {
            this.binaryDoc.close();
        }
        return this.finish();
    }

    private void fixBaseIndices() {
        try {
            int n = (Integer)this.htParams.get("baseModelIndex");
            this.baseAtomIndex += this.asc.ac;
            this.htParams.put("baseAtomIndex", this.baseAtomIndex);
            this.htParams.put("baseModelIndex", n += this.asc.atomSetCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Object readDataObject(Object object) throws Exception {
        this.initialize();
        this.asc = new AtomSetCollection(this.readerName, this, null, null);
        this.initializeReader();
        this.processDOM(object);
        return this.finish();
    }

    protected void processDOM(Object object) {
    }

    protected void processBinaryDocument() throws Exception {
    }

    protected void initializeReader() throws Exception {
    }

    protected boolean checkLine() throws Exception {
        return true;
    }

    public boolean checkLastModel() {
        if (this.isLastModel(this.modelNumber) && this.doProcessLines) {
            this.doProcessLines = false;
            this.continuing = false;
            return false;
        }
        this.doProcessLines = false;
        return true;
    }

    public boolean isLastModel(int n) {
        return this.desiredModelNumber > 0 || n >= this.lastModelNumber;
    }

    public void appendLoadNote(String string) {
        if (string == null) {
            this.loadNote = new SB();
            return;
        }
        this.loadNote.append(string).append("\n");
        Logger.info(string);
    }

    protected void initializeTrajectoryFile() {
        this.asc.addAtom(new Atom());
        this.trajectorySteps = (Lst)this.htParams.get("trajectorySteps");
        if (this.trajectorySteps == null) {
            this.trajectorySteps = new Lst();
            this.htParams.put("trajectorySteps", this.trajectorySteps);
        }
    }

    protected void finalizeSubclassReader() throws Exception {
    }

    protected void finalizeReaderASCR() throws Exception {
        this.isFinalized = true;
        if (this.asc.atomSetCount > 0) {
            Map<String, Object> map;
            if (this.asc.atomSetCount == 1) {
                this.asc.setCurrentModelInfo("dbName", this.htParams.get("dbName"));
            }
            this.applySymmetryAndSetTrajectory();
            this.asc.finalizeStructures();
            if (this.doCentralize) {
                this.asc.centralize();
            }
            if (this.fillRange != null) {
                this.asc.setInfo("boundbox", this.fillRange);
            }
            if ((map = this.asc.getAtomSetAuxiliaryInfo(0)) != null) {
                if (this.domains != null) {
                    this.asc.setGlobalBoolean(5);
                    String string = ((SV)this.domains).getMapKeys(2, true);
                    int n = string.indexOf("{ ", 2);
                    if (n >= 0) {
                        string = string.substring(n + 2);
                    }
                    if ((n = string.indexOf("_metadata")) < 0) {
                        n = string.indexOf("metadata");
                    }
                    if (n >= 0) {
                        string = string.substring(0, n);
                    }
                    string = PT.rep(PT.replaceAllCharacters(string, "{}", "").trim(), "\n", "\n  ") + "\n\nUse SHOW DOMAINS for details.";
                    this.appendLoadNote("\nDomains loaded:\n   " + string);
                    int n2 = this.asc.atomSetCount;
                    while (--n2 >= 0) {
                        map = this.asc.getAtomSetAuxiliaryInfo(n2);
                        map.put("domains", this.domains);
                    }
                }
                if (this.validation != null) {
                    int n = this.asc.atomSetCount;
                    while (--n >= 0) {
                        map = this.asc.getAtomSetAuxiliaryInfo(n);
                        map.put("validation", this.validation);
                    }
                }
                if (this.dssr != null) {
                    map.put("dssrJSON", Boolean.TRUE);
                    int n = this.asc.atomSetCount;
                    while (--n >= 0) {
                        map = this.asc.getAtomSetAuxiliaryInfo(n);
                        map.put("dssr", this.dssr);
                    }
                }
            }
        }
        if (!this.fixJavaFloat) {
            this.asc.setInfo("legacyJavaFloat", Boolean.TRUE);
        }
        this.setLoadNote();
    }

    protected String setLoadNote() {
        String string = this.loadNote.toString();
        if (this.loadNote.length() > 0) {
            this.asc.setInfo("modelLoadNote", string);
        }
        return string;
    }

    public void setIsPDB() {
        this.asc.setGlobalBoolean(4);
        if (this.htParams.get("pdbNoHydrogens") != null) {
            this.asc.setInfo("pdbNoHydrogens", this.htParams.get("pdbNoHydrogens"));
        }
        if (this.checkFilterKey("ADDHYDROGENS")) {
            this.asc.setInfo("pdbAddHydrogens", Boolean.TRUE);
        }
    }

    protected void setModelPDB(boolean bl) {
        if (bl) {
            this.asc.setGlobalBoolean(4);
        } else {
            this.asc.clearGlobalBoolean(4);
        }
        this.asc.setCurrentModelInfo("isPDB", bl ? Boolean.TRUE : null);
    }

    private Object finish() {
        String string;
        String string2;
        String string3 = (String)this.htParams.get("loadState");
        this.asc.setInfo("loadState", string3 == null ? "" : string3);
        string3 = (String)this.htParams.get("smilesString");
        if (string3 != null) {
            this.asc.setInfo("smilesString", string3);
        }
        if (!this.htParams.containsKey("templateAtomCount")) {
            this.htParams.put("templateAtomCount", this.asc.ac);
        }
        if (this.htParams.containsKey("bsFilter")) {
            this.htParams.put("filteredAtomCount", BSUtil.cardinalityOf((BS)this.htParams.get("bsFilter")));
        }
        if (!this.calculationType.equals("?")) {
            this.asc.setInfo("calculationType", this.calculationType);
        }
        if ((string2 = (string = this.asc.fileTypeName)).indexOf("(") >= 0) {
            string2 = string2.substring(0, string2.indexOf("("));
        }
        int n = this.asc.atomSetCount;
        while (--n >= 0) {
            this.asc.setModelInfoForSet("fileName", this.filePath, n);
            this.asc.setModelInfoForSet("fileType", string2, n);
        }
        this.asc.freeze(this.reverseModels);
        if (this.asc.errorMessage != null) {
            return this.asc.errorMessage + "\nfor file " + this.filePath + "\ntype " + string;
        }
        if ((this.asc.bsAtoms == null ? this.asc.ac == 0 : this.asc.bsAtoms.nextSetBit(0) < 0) && string2.indexOf("DataOnly") < 0 && this.asc.atomSetInfo.get("dataOnly") == null) {
            return "No atoms found\nfor file " + this.filePath + "\ntype " + string;
        }
        this.fixBaseIndices();
        return this.asc;
    }

    private void setError(Throwable throwable) {
        String string = throwable.getMessage();
        this.asc.errorMessage = this.line == null ? "Error reading file at end of file \n" + string : "Error reading file at line " + this.ptLine + ":\n" + this.line + "\n" + string;
        if (!this.vwr.isJS) {
            throwable.printStackTrace();
        }
    }

    private void initialize() {
        Object object;
        Object object2;
        if (this.htParams.containsKey("baseAtomIndex")) {
            this.baseAtomIndex = (Integer)this.htParams.get("baseAtomIndex");
        }
        this.initializeSymmetry();
        this.vwr = (Viewer)this.htParams.remove("vwr");
        if (this.htParams.containsKey("stateScriptVersionInt")) {
            this.stateScriptVersionInt = (Integer)this.htParams.get("stateScriptVersionInt");
        }
        if ((object2 = this.htParams.get("packingError")) != null) {
            this.packingError = ((Float)object2).floatValue();
        } else if (this.htParams.get("legacyJavaFloat") != null) {
            this.fixJavaFloat = false;
        }
        this.merging = this.htParams.containsKey("merging");
        this.getHeader = this.htParams.containsKey("getHeader");
        this.isSequential = this.htParams.containsKey("isSequential");
        this.readerName = (String)this.htParams.get("readerName");
        if (this.htParams.containsKey("outputChannel")) {
            this.out = (OC)this.htParams.get("outputChannel");
        }
        if (this.htParams.containsKey("vibrationNumber")) {
            this.desiredVibrationNumber = (Integer)this.htParams.get("vibrationNumber");
        } else if (this.htParams.containsKey("modelNumber")) {
            this.desiredModelNumber = (Integer)this.htParams.get("modelNumber");
        }
        this.applySymmetryToBonds = this.htParams.containsKey("applySymmetryToBonds");
        this.bsFilter = (BS)this.htParams.get("bsFilter");
        this.setFilter(null);
        this.fillRange = (T3[])this.htParams.get("fillRange");
        if (this.strSupercell != null && !this.checkFilterKey("NOPACK")) {
            this.forcePacked = true;
        }
        if ((object2 = this.htParams.get("supercell")) instanceof String) {
            this.strSupercell = (String)object2;
        } else {
            this.ptSupercell = (P3)object2;
        }
        int n = this.htParams.containsKey("ptFile") ? (Integer)this.htParams.get("ptFile") : -1;
        this.isTrajectory = this.htParams.containsKey("isTrajectory");
        if (n > 0 && this.htParams.containsKey("firstLastSteps")) {
            object = ((Lst)this.htParams.get("firstLastSteps")).get(n - 1);
            if (object instanceof BS) {
                this.bsModels = (BS)object;
            } else {
                this.firstLastStep = (int[])object;
            }
        } else if (this.htParams.containsKey("firstLastStep")) {
            this.firstLastStep = (int[])this.htParams.get("firstLastStep");
        } else if (this.htParams.containsKey("bsModels")) {
            this.bsModels = (BS)this.htParams.get("bsModels");
        }
        this.useFileModelNumbers = this.htParams.containsKey("useFileModelNumbers");
        if (this.htParams.containsKey("templateAtomCount")) {
            this.templateAtomCount = (Integer)this.htParams.get("templateAtomCount");
        }
        if (this.bsModels != null || this.firstLastStep != null) {
            this.desiredModelNumber = Integer.MIN_VALUE;
        }
        if (this.bsModels == null && this.firstLastStep != null) {
            if (this.firstLastStep[0] < 0) {
                this.firstLastStep[0] = 0;
            }
            if (this.firstLastStep[2] == 0 || this.firstLastStep[1] < this.firstLastStep[0]) {
                this.firstLastStep[1] = -1;
            }
            if (this.firstLastStep[2] < 1) {
                this.firstLastStep[2] = 1;
            }
            this.bsModels = BSUtil.newAndSetBit(this.firstLastStep[0]);
            if (this.firstLastStep[1] > this.firstLastStep[0]) {
                for (int i = this.firstLastStep[0]; i <= this.firstLastStep[1]; i += this.firstLastStep[2]) {
                    this.bsModels.set(i);
                }
            }
        }
        if (this.bsModels != null && (this.firstLastStep == null || this.firstLastStep[1] != -1)) {
            this.lastModelNumber = this.bsModels.length();
        }
        this.symmetryRange = this.htParams.containsKey("symmetryRange") ? ((Float)this.htParams.get("symmetryRange")).floatValue() : 0.0f;
        this.initializeSymmetryOptions();
        if (this.htParams.containsKey("spaceGroupIndex")) {
            this.desiredSpaceGroupIndex = (Integer)this.htParams.get("spaceGroupIndex");
            if (this.desiredSpaceGroupIndex == -2) {
                this.sgName = (String)this.htParams.get("spaceGroupName");
            }
            this.ignoreFileSpaceGroupName = this.desiredSpaceGroupIndex == -2 || this.desiredSpaceGroupIndex >= 0;
            boolean bl = this.ignoreFileSymmetryOperators = this.desiredSpaceGroupIndex != -1;
        }
        if (this.htParams.containsKey("unitCellOffset")) {
            this.fileScaling = P3.new3(1.0f, 1.0f, 1.0f);
            this.fileOffset = (P3)this.htParams.get("unitCellOffset");
            this.fileOffsetFractional = P3.newP(this.fileOffset);
            this.unitCellOffsetFractional = this.htParams.containsKey("unitCellOffsetFractional");
        }
        if (this.htParams.containsKey("unitcell")) {
            object = (float[])this.htParams.get("unitcell");
            if (this.merging) {
                this.setFractionalCoordinates(true);
            }
            if (((E)object).length == 9) {
                this.addPrimitiveLatticeVector(0, (float[])object, 0);
                this.addPrimitiveLatticeVector(1, (float[])object, 3);
                this.addPrimitiveLatticeVector(2, (float[])object, 6);
            } else {
                this.setUnitCell((float)object[0], (float)object[1], (float)object[2], (float)object[3], (float)object[4], (float)object[5]);
            }
            this.ignoreFileUnitCell = this.iHaveUnitCell;
            if (this.merging && !this.iHaveUnitCell) {
                this.setFractionalCoordinates(false);
            }
        }
        this.domains = this.htParams.get("domains");
        this.validation = this.htParams.get("validation");
        this.dssr = this.htParams.get("dssr");
        this.isConcatenated = this.htParams.containsKey("concatenate");
    }

    protected void initializeSymmetryOptions() {
        this.latticeCells = new int[3];
        this.doApplySymmetry = false;
        P3 p3 = (P3)this.htParams.get("lattice");
        if (p3 == null || p3.length() == 0.0f) {
            if (!this.forcePacked && this.strSupercell == null) {
                return;
            }
            p3 = P3.new3(1.0f, 1.0f, 1.0f);
        }
        this.latticeCells[0] = (int)p3.x;
        this.latticeCells[1] = (int)p3.y;
        this.latticeCells[2] = (int)p3.z;
        this.doCentroidUnitCell = this.htParams.containsKey("centroid");
        if (this.doCentroidUnitCell && (this.latticeCells[2] == -1 || this.latticeCells[2] == 0)) {
            this.latticeCells[2] = 1;
        }
        boolean bl = this.forcePacked || this.htParams.containsKey("packed");
        this.centroidPacked = this.doCentroidUnitCell && bl;
        this.doPackUnitCell = !this.doCentroidUnitCell && (bl || this.latticeCells[2] < 0);
        boolean bl2 = this.doApplySymmetry = this.latticeCells[0] > 0 && this.latticeCells[1] > 0;
        if (!this.doApplySymmetry) {
            this.latticeCells = new int[3];
        }
    }

    public boolean doGetModel(int n, String string) {
        boolean bl;
        if (string != null && this.nameRequired != null && this.nameRequired.length() > 0 && string.toUpperCase().indexOf(this.nameRequired) < 0) {
            return false;
        }
        boolean bl2 = this.bsModels == null ? this.desiredModelNumber < 1 || n == this.desiredModelNumber : (n > this.lastModelNumber ? false : (bl = n > 0 && this.bsModels.get(n - 1) || this.haveModel && this.firstLastStep != null && this.firstLastStep[1] < 0 && (this.firstLastStep[2] < 2 || (n - 1 - this.firstLastStep[0]) % this.firstLastStep[2] == 0)));
        if (bl && this.desiredModelNumber == 0) {
            this.discardPreviousAtoms();
        }
        this.haveModel |= bl;
        if (bl) {
            this.doProcessLines = true;
        }
        return bl;
    }

    protected void discardPreviousAtoms() {
        this.asc.discardPreviousAtoms();
    }

    protected void initializeSymmetry() {
        this.previousSpaceGroup = this.sgName;
        this.previousUnitCell = this.unitCellParams;
        this.iHaveUnitCell = this.ignoreFileUnitCell;
        if (!this.ignoreFileUnitCell) {
            this.unitCellParams = new float[26];
            int n = 25;
            while (--n >= 0) {
                this.unitCellParams[n] = Float.NaN;
            }
            this.unitCellParams[25] = this.latticeScaling;
            this.symmetry = null;
        }
        if (!this.ignoreFileSpaceGroupName) {
            this.sgName = "unspecified!";
        }
        this.doCheckUnitCell = false;
    }

    protected void newAtomSet(String string) {
        if (this.asc.iSet >= 0) {
            this.asc.newAtomSet();
            this.asc.setCollectionName("<collection of " + (this.asc.iSet + 1) + " models>");
        } else {
            this.asc.setCollectionName(string);
        }
        this.asc.setModelInfoForSet("name", string, Math.max(0, this.asc.iSet));
    }

    protected int cloneLastAtomSet(int n, P3[] p3Array) throws Exception {
        int n2 = this.asc.getLastAtomSetAtomCount();
        this.asc.cloneLastAtomSetFromPoints(n, p3Array);
        if (this.asc.haveUnitCell) {
            this.iHaveUnitCell = true;
            this.doCheckUnitCell = true;
            this.sgName = this.previousSpaceGroup;
            this.unitCellParams = this.previousUnitCell;
        }
        return n2;
    }

    public void setSpaceGroupName(String string) {
        if (this.ignoreFileSpaceGroupName) {
            return;
        }
        String string2 = string.trim();
        if (string2.equals(this.sgName)) {
            return;
        }
        if (!string2.equals("P1")) {
            Logger.info("Setting space group name to " + string2);
        }
        this.sgName = string2;
    }

    public int setSymmetryOperator(String string) {
        if (this.ignoreFileSymmetryOperators) {
            return -1;
        }
        int n = this.asc.getXSymmetry().addSpaceGroupOperation(string, true);
        if (n < 0) {
            Logger.warn("Skippings symmetry operation " + string);
        }
        this.iHaveSymmetryOperators = true;
        return n;
    }

    private void initializeCartesianToFractional() {
        int n;
        for (n = 0; n < 16; ++n) {
            if (Float.isNaN(this.unitCellParams[6 + n])) continue;
            return;
        }
        for (n = 0; n < 16; ++n) {
            this.unitCellParams[6 + n] = n % 5 == 0 ? 1 : 0;
        }
        this.nMatrixElements = 0;
    }

    public void clearUnitCell() {
        if (this.ignoreFileUnitCell) {
            return;
        }
        for (int i = 6; i < 22; ++i) {
            this.unitCellParams[i] = Float.NaN;
        }
        this.checkUnitCell(6);
    }

    public void setUnitCellItem(int n, float f) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0 && f == 1.0f || n == 3 && f == 0.0f) {
            return;
        }
        if (!Float.isNaN(f) && n >= 6 && Float.isNaN(this.unitCellParams[6])) {
            this.initializeCartesianToFractional();
        }
        this.unitCellParams[n] = f;
        if (this.debugging) {
            Logger.debug("setunitcellitem " + n + " " + f);
        }
        if (n < 6 || Float.isNaN(f)) {
            this.iHaveUnitCell = this.checkUnitCell(6);
        } else if (++this.nMatrixElements == 12) {
            this.iHaveUnitCell = this.checkUnitCell(22);
        }
    }

    public void setUnitCell(float f, float f2, float f3, float f4, float f5, float f6) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        this.clearUnitCell();
        this.unitCellParams[0] = f;
        this.unitCellParams[1] = f2;
        this.unitCellParams[2] = f3;
        if (f4 != 0.0f) {
            this.unitCellParams[3] = f4;
        }
        if (f5 != 0.0f) {
            this.unitCellParams[4] = f5;
        }
        if (f6 != 0.0f) {
            this.unitCellParams[5] = f6;
        }
        this.iHaveUnitCell = this.checkUnitCell(6);
    }

    public void addPrimitiveLatticeVector(int n, float[] fArray, int n2) {
        if (this.ignoreFileUnitCell) {
            return;
        }
        if (n == 0) {
            for (int i = 0; i < 6; ++i) {
                this.unitCellParams[i] = 0.0f;
            }
        }
        n = 6 + n * 3;
        this.unitCellParams[n++] = fArray[n2++];
        this.unitCellParams[n++] = fArray[n2++];
        this.unitCellParams[n] = fArray[n2];
        if (Float.isNaN(this.unitCellParams[0])) {
            for (n = 0; n < 6; ++n) {
                this.unitCellParams[n] = -1.0f;
            }
        }
        this.iHaveUnitCell = this.checkUnitCell(15);
    }

    private boolean checkUnitCell(int n) {
        for (int i = 0; i < n; ++i) {
            if (!Float.isNaN(this.unitCellParams[i])) continue;
            return false;
        }
        if (n == 22 && this.unitCellParams[0] == 1.0f && this.unitCellParams[1] == 1.0f && this.unitCellParams[2] == 1.0f && this.unitCellParams[6] == 1.0f && this.unitCellParams[11] == 1.0f && this.unitCellParams[16] == 1.0f) {
            return false;
        }
        if (this.doApplySymmetry) {
            this.getSymmetry();
            this.doConvertToFractional = !this.fileCoordinatesAreFractional;
        }
        return true;
    }

    protected SymmetryInterface getSymmetry() {
        if (!this.iHaveUnitCell) {
            return null;
        }
        if (this.symmetry == null) {
            this.getNewSymmetry().setUnitCell(this.unitCellParams, false);
            this.checkUnitCellOffset();
        }
        return this.symmetry;
    }

    private void checkUnitCellOffset() {
        if (this.fileOffsetFractional == null || this.symmetry == null) {
            return;
        }
        this.fileOffset.setT(this.fileOffsetFractional);
        if (this.unitCellOffsetFractional != this.fileCoordinatesAreFractional) {
            if (this.unitCellOffsetFractional) {
                this.symmetry.toCartesian(this.fileOffset, false);
            } else {
                this.symmetry.toFractional(this.fileOffset, false);
            }
        }
    }

    protected SymmetryInterface getNewSymmetry() {
        this.symmetry = (Symmetry)this.getInterface("org.jmol.symmetry.Symmetry");
        return this.symmetry;
    }

    public void setFractionalCoordinates(boolean bl) {
        this.iHaveFractionalCoordinates = this.fileCoordinatesAreFractional = bl;
        this.checkUnitCellOffset();
    }

    protected void setFilterAtomTypeStr(String string) {
        this.filterAtomTypeStr = string;
        this.filterAtomNameTerminator = "\u0000";
    }

    protected void setFilter(String string) {
        if (string == null) {
            string = (String)this.htParams.get("filter");
        } else {
            this.bsFilter = null;
        }
        if (string != null) {
            string = string.toUpperCase();
        }
        this.filter = string;
        this.doSetOrientation = !this.checkFilterKey("NOORIENT");
        this.doCentralize = !this.checkFilterKey("NOCENTER") && this.checkFilterKey("CENTER");
        this.addVibrations = !this.checkFilterKey("NOVIB");
        this.doReadMolecularOrbitals = !this.checkFilterKey("NOMO");
        this.useAltNames = this.checkFilterKey("ALTNAME");
        this.reverseModels = this.checkFilterKey("REVERSEMODELS");
        if (this.filter == null) {
            return;
        }
        if (this.checkFilterKey("HETATM")) {
            this.filterHetero = true;
            this.filter = PT.rep(this.filter, "HETATM", "HETATM-Y");
        }
        if (this.checkFilterKey("ATOM")) {
            this.filterHetero = true;
            this.filter = PT.rep(this.filter, "ATOM", "HETATM-N");
        }
        if (this.checkFilterKey("CELL=")) {
            this.strSupercell = this.filter.substring(this.filter.indexOf("CELL=") + 5).toLowerCase();
        }
        this.nameRequired = PT.getQuotedAttribute(this.filter, "NAME");
        if (this.nameRequired != null) {
            if (this.nameRequired.startsWith("'")) {
                this.nameRequired = PT.split(this.nameRequired, "'")[1];
            } else if (this.nameRequired.startsWith("\"")) {
                this.nameRequired = PT.split(this.nameRequired, "\"")[1];
            }
            string = this.filter = PT.rep(this.filter, this.nameRequired, "");
            string = this.filter = PT.rep(this.filter, "NAME=", "");
        }
        this.filterAtomName = this.checkFilterKey("*.") || this.checkFilterKey("!.");
        this.filterElement = this.checkFilterKey("_");
        this.filterGroup3 = this.checkFilterKey("[");
        this.filterChain = this.checkFilterKey(":");
        this.filterAltLoc = this.checkFilterKey("%");
        this.filterEveryNth = this.checkFilterKey("/=");
        if (this.filterEveryNth) {
            this.filterN = this.parseIntAt(this.filter, this.filter.indexOf("/=") + 2);
        } else {
            this.filterAtomType = this.checkFilterKey("=");
        }
        if (this.filterN == Integer.MIN_VALUE) {
            this.filterEveryNth = false;
        }
        boolean bl = this.haveAtomFilter = this.filterAtomName || this.filterAtomType || this.filterElement || this.filterGroup3 || this.filterChain || this.filterAltLoc || this.filterHetero || this.filterEveryNth || this.checkFilterKey("/=");
        if (this.bsFilter == null) {
            this.bsFilter = new BS();
            this.htParams.put("bsFilter", this.bsFilter);
            this.filter = (";" + this.filter + ";").replace(',', ';');
            String string2 = this.getFilter("LATTICESCALING=");
            if (string2 != null && this.unitCellParams.length > 25) {
                this.unitCellParams[25] = this.latticeScaling = this.parseFloatStr(string2);
            }
            if ((string2 = this.getFilter("SYMOP=")) != null) {
                this.filterSymop = " " + string2 + " ";
            }
            Logger.info("filtering with " + this.filter);
            if (this.haveAtomFilter) {
                this.filter1 = this.filter;
                int n = this.filter.indexOf("|");
                if (n >= 0) {
                    this.filter1 = this.filter.substring(0, n).trim() + ";";
                    this.filter2 = ";" + this.filter.substring(n).trim();
                }
            }
        }
    }

    public String getFilter(String string) {
        int n = this.filter == null ? -1 : this.filter.indexOf(string);
        return n < 0 ? null : this.filter.substring(n + string.length(), this.filter.indexOf(";", n));
    }

    public boolean checkFilterKey(String string) {
        return this.filter != null && this.filter.indexOf(string) >= 0;
    }

    protected boolean filterAtom(Atom atom, int n) {
        if (!this.haveAtomFilter) {
            return true;
        }
        boolean bl = this.checkFilter(atom, this.filter1);
        if (this.filter2 != null) {
            bl |= this.checkFilter(atom, this.filter2);
        }
        if (bl && this.filterEveryNth) {
            bl = this.nFiltered++ % this.filterN == 0;
        }
        this.bsFilter.setBitTo(n >= 0 ? n : this.asc.ac, bl);
        return bl;
    }

    private boolean checkFilter(Atom atom, String string) {
        return !(this.filterGroup3 && atom.group3 != null && this.filterReject(string, "[", atom.group3.toUpperCase() + "]") || this.filterAtomName && !this.allowAtomName(atom.atomName, string) || this.filterAtomTypeStr != null && atom.atomName != null && atom.atomName.toUpperCase().indexOf("\u0000" + this.filterAtomTypeStr) < 0 || this.filterElement && atom.elementSymbol != null && this.filterReject(string, "_", atom.elementSymbol.toUpperCase() + ";") || this.filterChain && atom.chainID != 0 && this.filterReject(string, ":", "" + this.vwr.getChainIDStr(atom.chainID)) || this.filterAltLoc && atom.altLoc != '\u0000' && this.filterReject(string, "%", "" + atom.altLoc) || this.filterHetero && this.allowPDBFilter && this.filterReject(string, "HETATM", atom.isHetero ? "-Y" : "-N"));
    }

    public boolean rejectAtomName(String string) {
        return this.filterAtomName && !this.allowAtomName(string, this.filter);
    }

    private boolean allowAtomName(String string, String string2) {
        return string == null || !this.filterReject(string2, ".", string.toUpperCase() + this.filterAtomNameTerminator);
    }

    protected boolean filterReject(String string, String string2, String string3) {
        return string.indexOf(string2) >= 0 && string.indexOf("!" + string2) >= 0 == string.indexOf(string2 + string3) >= 0;
    }

    protected void set2D() {
        this.asc.setInfo("is2D", Boolean.TRUE);
        if (!this.checkFilterKey("NOMIN")) {
            this.asc.setInfo("doMinimize", Boolean.TRUE);
        }
    }

    public boolean doGetVibration(int n) {
        return this.addVibrations && (this.desiredVibrationNumber <= 0 || n == this.desiredVibrationNumber);
    }

    public void setTransform(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (this.matRot != null || !this.doSetOrientation) {
            return;
        }
        this.matRot = new M3();
        V3 v3 = V3.new3(f, f2, f3);
        v3.normalize();
        this.matRot.setColumnV(0, v3);
        v3.set(f4, f5, f6);
        v3.normalize();
        this.matRot.setColumnV(1, v3);
        v3.set(f7, f8, f9);
        v3.normalize();
        this.matRot.setColumnV(2, v3);
        this.asc.setInfo("defaultOrientationMatrix", M3.newM3(this.matRot));
        Quat quat = Quat.newM(this.matRot);
        this.asc.setInfo("defaultOrientationQuaternion", quat);
        Logger.info("defaultOrientationMatrix = " + this.matRot);
    }

    public void setAtomCoordXYZ(Atom atom, float f, float f2, float f3) {
        atom.set(f, f2, f3);
        this.setAtomCoord(atom);
    }

    public Atom setAtomCoordScaled(Atom atom, String[] stringArray, int n, float f) {
        if (atom == null) {
            atom = this.asc.addNewAtom();
        }
        this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[n]) * f, this.parseFloatStr(stringArray[n + 1]) * f, this.parseFloatStr(stringArray[n + 2]) * f);
        return atom;
    }

    protected void setAtomCoordTokens(Atom atom, String[] stringArray, int n) {
        this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[n]), this.parseFloatStr(stringArray[n + 1]), this.parseFloatStr(stringArray[n + 2]));
    }

    public Atom addAtomXYZSymName(String[] stringArray, int n, String string, String string2) {
        Atom atom = this.asc.addNewAtom();
        if (string != null) {
            atom.elementSymbol = string;
        }
        if (string2 != null) {
            atom.atomName = string2;
        }
        this.setAtomCoordTokens(atom, stringArray, n);
        return atom;
    }

    public void setAtomCoord(Atom atom) {
        if (this.fileScaling != null) {
            atom.x = atom.x * this.fileScaling.x + this.fileOffset.x;
            atom.y = atom.y * this.fileScaling.y + this.fileOffset.y;
            atom.z = atom.z * this.fileScaling.z + this.fileOffset.z;
        }
        if (this.doConvertToFractional && !this.fileCoordinatesAreFractional && this.getSymmetry() != null) {
            if (!this.symmetry.haveUnitCell()) {
                this.symmetry.setUnitCell(this.unitCellParams, false);
            }
            this.symmetry.toFractional(atom, false);
            this.iHaveFractionalCoordinates = true;
        }
        if (this.fixJavaFloat && this.fileCoordinatesAreFractional) {
            PT.fixPtFloats(atom, 100000.0f);
        }
        this.doCheckUnitCell = true;
    }

    public void addSites(Map<String, Map<String, Object>> map) {
        this.asc.setCurrentModelInfo("pdbSites", map);
        String string = "";
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            String string2 = entry.getKey();
            Map<String, Object> map2 = entry.getValue();
            int n = string2.length();
            while (--n >= 0) {
                char c = string2.charAt(n);
                if (PT.isLetterOrDigit(c) || c == '\'') continue;
                string2 = string2.substring(0, n) + "_" + string2.substring(n + 1);
            }
            String string3 = (String)map2.get("groups");
            if (string3.length() == 0) continue;
            this.addSiteScript("@site_" + string2 + " " + string3);
            this.addSiteScript("site_" + string2 + " = [\"" + PT.rep(string3, ",", "\",\"") + "\"]");
            string = string + ",\"site_" + string2 + "\"";
        }
        if (string.length() > 0) {
            this.addSiteScript("site_list = [" + string.substring(1) + "]");
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        this.applySymTrajASCR();
    }

    public SymmetryInterface applySymTrajASCR() throws Exception {
        SymmetryInterface symmetryInterface;
        if (this.forcePacked) {
            this.initializeSymmetryOptions();
        }
        SymmetryInterface symmetryInterface2 = symmetryInterface = this.iHaveUnitCell && this.doCheckUnitCell ? this.asc.getXSymmetry().applySymmetryFromReader(this.getSymmetry()) : null;
        if (symmetryInterface == null) {
            this.asc.setTensors();
        }
        if (this.isTrajectory) {
            this.asc.setTrajectory();
        }
        if (this.moreUnitCellInfo != null) {
            this.asc.setCurrentModelInfo("moreUnitCellInfo", this.moreUnitCellInfo);
            this.moreUnitCellInfo = null;
        }
        this.finalizeSubclassSymmetry(symmetryInterface != null);
        if (symmetryInterface != null && this.ptSupercell != null) {
            this.asc.getXSymmetry().finalizeUnitCell(this.ptSupercell);
        }
        this.initializeSymmetry();
        return symmetryInterface;
    }

    protected void finalizeSubclassSymmetry(boolean bl) throws Exception {
    }

    protected void doPreSymmetry() throws Exception {
    }

    public void finalizeMOData(Map<String, Object> map) {
        this.asc.setCurrentModelInfo("moData", map);
        if (map == null) {
            return;
        }
        Lst lst = (Lst)map.get("mos");
        if (lst != null) {
            Logger.info(lst.size() + " molecular orbitals read in model " + this.asc.atomSetCount);
        }
    }

    public static String getElementSymbol(int n) {
        return JmolAdapter.getElementSymbol(n);
    }

    protected void fillDataBlockFixed(String[][] stringArray, int n, int n2, int n3) throws Exception {
        if (n2 == 0) {
            this.fillDataBlock(stringArray, n3);
            return;
        }
        int n4 = stringArray.length;
        for (int i = 0; i < n4; ++i) {
            this.discardLinesUntilNonBlank();
            int n5 = (this.line.length() - n + 1) / n2;
            stringArray[i] = new String[n5];
            int n6 = 0;
            int n7 = n;
            while (n6 < n5) {
                stringArray[i][n6] = this.line.substring(n7, Math.min(this.line.length(), n7 + n2));
                ++n6;
                n7 += n2;
            }
        }
    }

    protected void fillDataBlock(String[][] stringArray, int n) throws Exception {
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = PT.getTokens(this.discardLinesUntilNonBlank());
            if (stringArray[i].length >= n) continue;
            --i;
        }
    }

    protected float[] fillFloatArray(String string, int n, float[] fArray) throws Exception {
        String[] stringArray = new String[]{};
        int n2 = 0;
        for (int i = 0; i < fArray.length; ++i) {
            while (stringArray != null && n2 >= stringArray.length) {
                if (string == null) {
                    string = this.rd();
                }
                if (n == 0) {
                    stringArray = PT.getTokens(string);
                } else {
                    stringArray = new String[string.length() / n];
                    for (int j = 0; j < stringArray.length; ++j) {
                        stringArray[j] = string.substring(j * n, (j + 1) * n);
                    }
                }
                string = null;
                n2 = 0;
            }
            if (stringArray == null) break;
            fArray[i] = this.parseFloatStr(stringArray[n2++]);
        }
        return fArray;
    }

    protected void fillFrequencyData(int n, int n2, int n3, boolean[] blArray, boolean bl, int n4, int n5, int[] nArray, int n6) throws Exception {
        boolean bl2;
        boolean bl3 = bl2 = n3 != n2;
        if (nArray != null) {
            n2 = nArray.length;
        }
        int n7 = bl ? n2 : n2 * 3;
        int n8 = blArray.length;
        String[][] stringArray = new String[n7][];
        this.fillDataBlockFixed(stringArray, n4, n5, n6);
        int n9 = 0;
        int n10 = 0;
        while (n9 < n7) {
            String[] stringArray2 = stringArray[n9];
            String[] stringArray3 = bl ? null : stringArray[++n9];
            String[] stringArray4 = bl ? null : stringArray[++n9];
            int n11 = stringArray2.length - (bl ? n8 * 3 : n8) - 1;
            int n12 = 0;
            for (int i = 0; i < n8; ++i) {
                int n13;
                String string;
                if ((string = stringArray2[++n11]).charAt(0) == ')') {
                    string = string.substring(1);
                }
                float f = this.parseFloatStr(string);
                float f2 = this.parseFloatStr(bl ? stringArray2[++n11] : stringArray3[n11]);
                float f3 = this.parseFloatStr(bl ? stringArray2[++n11] : stringArray4[n11]);
                if (blArray[i]) continue;
                int n14 = n13 = nArray == null ? n10 : nArray[n10];
                if (n13 < 0) continue;
                if (this.debugging) {
                    Logger.debug("atom " + n13 + " vib" + n12 + ": " + f + " " + f2 + " " + f3);
                }
                this.asc.addVibrationVectorWithSymmetry(n + n3 * n12++ + n13, f, f2, f3, bl2);
            }
            ++n9;
            ++n10;
        }
    }

    protected String readLines(int n) throws Exception {
        int n2 = n;
        while (--n2 >= 0) {
            this.rd();
        }
        return this.line;
    }

    public String discardLinesUntilStartsWith(String string) throws Exception {
        while (this.rd() != null && !this.line.startsWith(string)) {
        }
        return this.line;
    }

    public String discardLinesUntilContains(String string) throws Exception {
        while (this.rd() != null && this.line.indexOf(string) < 0) {
        }
        return this.line;
    }

    public String discardLinesUntilContains2(String string, String string2) throws Exception {
        while (this.rd() != null && this.line.indexOf(string) < 0 && this.line.indexOf(string2) < 0) {
        }
        return this.line;
    }

    public String discardLinesUntilBlank() throws Exception {
        while (this.rd() != null && this.line.trim().length() != 0) {
        }
        return this.line;
    }

    public String discardLinesUntilNonBlank() throws Exception {
        while (this.rd() != null && this.line.trim().length() == 0) {
        }
        return this.line;
    }

    protected void checkLineForScript(String string) {
        this.line = string;
        this.checkCurrentLineForScript();
    }

    public void checkCurrentLineForScript() {
        int n;
        if (this.line.endsWith("#noautobond")) {
            this.line = this.line.substring(0, this.line.lastIndexOf(35)).trim();
            this.asc.setNoAutoBond();
        }
        if ((n = this.line.indexOf("jmolscript:")) >= 0) {
            String string = this.line.substring(n + 11, this.line.length());
            if (string.indexOf("#") >= 0) {
                string = string.substring(0, string.indexOf("#"));
            }
            this.addJmolScript(string);
            this.line = this.line.substring(0, n).trim();
        }
    }

    public void addJmolScript(String string) {
        Logger.info("#jmolScript: " + string);
        if (this.previousScript == null) {
            this.previousScript = "";
        } else if (!this.previousScript.endsWith(";")) {
            this.previousScript = this.previousScript + ";";
        }
        this.previousScript = this.previousScript + string;
        this.asc.setInfo("jmolscript", this.previousScript);
    }

    protected void addSiteScript(String string) {
        if (this.siteScript == null) {
            this.siteScript = "";
        } else if (!this.siteScript.endsWith(";")) {
            this.siteScript = this.siteScript + ";";
        }
        this.siteScript = this.siteScript + string;
        this.asc.setInfo("sitescript", this.siteScript);
    }

    public String rd() throws Exception {
        return this.RL();
    }

    public String RL() throws Exception {
        this.prevline = this.line;
        this.line = this.reader.readLine();
        if (this.out != null && this.line != null) {
            this.out.append(this.line).append("\n");
        }
        ++this.ptLine;
        if (this.debugging) {
            Logger.debug(this.line);
        }
        return this.line;
    }

    protected static final String[] getStrings(String string, int n, int n2) {
        String[] stringArray = new String[n];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            stringArray[n3] = string.substring(n4, n4 + n2);
            ++n3;
            n4 += n2;
        }
        return stringArray;
    }

    public String[] getTokens() {
        return PT.getTokens(this.line);
    }

    public static float[] getTokensFloat(String string, float[] fArray, int n) {
        if (fArray == null) {
            fArray = new float[n];
        }
        PT.parseFloatArrayDataN(PT.getTokens(string), fArray, n);
        return fArray;
    }

    protected float parseFloat() {
        return PT.parseFloatNext(this.line, this.next);
    }

    public float parseFloatStr(String string) {
        this.next[0] = 0;
        return PT.parseFloatNext(string, this.next);
    }

    protected float parseFloatRange(String string, int n, int n2) {
        this.next[0] = n;
        return PT.parseFloatRange(string, n2, this.next);
    }

    protected int parseInt() {
        return PT.parseIntNext(this.line, this.next);
    }

    public int parseIntStr(String string) {
        this.next[0] = 0;
        return PT.parseIntNext(string, this.next);
    }

    public int parseIntAt(String string, int n) {
        this.next[0] = n;
        return PT.parseIntNext(string, this.next);
    }

    protected int parseIntRange(String string, int n, int n2) {
        this.next[0] = n;
        return PT.parseIntRange(string, n2, this.next);
    }

    protected String parseToken() {
        return PT.parseTokenNext(this.line, this.next);
    }

    protected String parseTokenStr(String string) {
        this.next[0] = 0;
        return PT.parseTokenNext(string, this.next);
    }

    protected String parseTokenNext(String string) {
        return PT.parseTokenNext(string, this.next);
    }

    protected String parseTokenRange(String string, int n, int n2) {
        this.next[0] = n;
        return PT.parseTokenRange(string, n2, this.next);
    }

    protected static Lst<Integer> getFortranFormatLengths(String string) {
        Lst<Integer> lst = new Lst<Integer>();
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        boolean bl = false;
        boolean bl2 = true;
        string = string + ",";
        block5: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '.': {
                    bl = false;
                    continue block5;
                }
                case ',': {
                    int n4;
                    for (n4 = 0; n4 < n2; ++n4) {
                        lst.addLast(n * n3);
                    }
                    bl = false;
                    bl2 = true;
                    n2 = 0;
                    continue block5;
                }
                case 'X': {
                    n = n2;
                    n2 = 1;
                    n3 = -1;
                    continue block5;
                }
                default: {
                    int n4 = PT.isDigit(c);
                    if (n4 != 0) {
                        if (bl) {
                            n = n * 10 + c - 48;
                            continue block5;
                        }
                        if (!bl2) continue block5;
                        n2 = n2 * 10 + c - 48;
                        continue block5;
                    }
                    if (PT.isLetter(c)) {
                        n = 0;
                        bl = true;
                        bl2 = false;
                        n3 = 1;
                        continue block5;
                    }
                    bl = false;
                }
            }
        }
        return lst;
    }

    protected V3[] read3Vectors(boolean bl) throws Exception {
        V3[] v3Array = new V3[3];
        float[] fArray = new float[3];
        for (int i = 0; i < 3; ++i) {
            if (i > 0 || Float.isNaN(this.parseFloatStr(this.line))) {
                this.rd();
                if (i == 0 && this.line != null) {
                    i = -1;
                    continue;
                }
            }
            this.fillFloatArray(this.line, 0, fArray);
            v3Array[i] = new V3();
            v3Array[i].setA(fArray);
            if (!bl) continue;
            v3Array[i].scale(0.5291772f);
        }
        return v3Array;
    }

    protected void setElementAndIsotope(Atom atom, String string) {
        int n = this.parseIntStr(string);
        if (n == Integer.MIN_VALUE) {
            atom.elementSymbol = string;
        } else {
            atom.elementNumber = (short)((string = string.substring(("" + n).length())).length() == 0 ? n : (n << 7) + JmolAdapter.getElementNumber(string));
        }
    }

    public void finalizeModelSet() {
    }

    public void setChainID(Atom atom, String string) {
        atom.chainID = this.vwr.getChainID(string, true);
    }

    @Override
    public String readNextLine() throws Exception {
        if (this.rd() != null && this.line.indexOf("#jmolscript:") >= 0) {
            this.checkCurrentLineForScript();
        }
        return this.line;
    }

    public void appendUunitCellInfo(String string) {
        if (this.moreUnitCellInfo == null) {
            this.moreUnitCellInfo = new Lst();
        }
        this.moreUnitCellInfo.addLast(string);
        this.appendLoadNote(string);
    }

    public Object getInterface(String string) {
        Object object = Interface.getInterface(string, this.vwr, "file");
        if (object == null) {
            throw new NullPointerException("Interface");
        }
        return object;
    }

    public void forceSymmetry(boolean bl) {
        if (bl) {
            this.doPackUnitCell = bl;
        }
        if (!this.doApplySymmetry) {
            this.doApplySymmetry = true;
            this.latticeCells[0] = 1;
            this.latticeCells[1] = 1;
            this.latticeCells[2] = 1;
        }
    }
}

