/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.popup;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Properties;
import javajs.util.SB;
import org.jmol.api.Translator;

public abstract class PopupResource {
    protected Properties structure = new Properties();
    protected Properties words = new Properties();

    public abstract String getMenuName();

    protected PopupResource(String string, Properties properties) {
        this.buildStructure(string);
        this.localize(string != null, properties);
    }

    protected abstract String[] getWordContents();

    protected abstract void buildStructure(String var1);

    String getStructure(String string) {
        return this.structure.getProperty(string);
    }

    String getWord(String string) {
        String string2 = this.words.getProperty(string);
        return string2 == null ? string : string2;
    }

    protected void setStructure(String string, Translator translator) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() == 0 || string2.charAt(0) == '#') continue;
                int n = string2.indexOf("=");
                if (n < 0) {
                    n = string2.length();
                    string2 = string2 + "=";
                }
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                String string5 = null;
                n = string3.indexOf("|");
                if (n >= 0) {
                    string5 = string3.substring(n + 1).trim();
                    string3 = string3.substring(0, n).trim();
                }
                if (string3.length() == 0) continue;
                if (string4.length() > 0) {
                    this.structure.setProperty(string3, string4);
                }
                if (string5 == null || string5.length() <= 0) continue;
                this.words.setProperty(string3, translator == null ? string5 : translator.translate(string5));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void addItems(String[][] stringArray) {
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string2 = stringArray2[1];
            if (string2 == null) {
                string2 = string;
            }
            string = string2;
            this.structure.setProperty(stringArray2[0], string2);
        }
    }

    private void localize(boolean bl, Properties properties) {
        String[] stringArray = this.getWordContents();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            String string2;
            if ((string2 = this.words.getProperty(string = stringArray[i++])) == null) {
                string2 = stringArray[i];
            }
            this.words.setProperty(string, string2);
            if (properties == null || string.indexOf("Text") < 0) continue;
            properties.setProperty(string, string2);
        }
    }

    public abstract String getMenuAsText(String var1);

    protected String getStuctureAsText(String string, String[][] stringArray, String[][] stringArray2) {
        return "# " + this.getMenuName() + ".mnu " + string + "\n\n" + "# Part I -- Menu Structure\n" + "# ------------------------\n\n" + this.dumpStructure(stringArray) + "\n\n" + "# Part II -- Key Definitions\n" + "# --------------------------\n\n" + this.dumpStructure(stringArray2) + "\n\n" + "# Part III -- Word Translations\n" + "# -----------------------------\n\n" + this.dumpWords();
    }

    private String dumpWords() {
        String[] stringArray = this.getWordContents();
        SB sB = new SB();
        for (int i = 0; i < stringArray.length; ++i) {
            String string;
            if (this.structure.getProperty(string = stringArray[i++]) != null) continue;
            sB.append(string).append(" | ").append(stringArray[i]).appendC('\n');
        }
        return sB.toString();
    }

    private String dumpStructure(String[][] stringArray) {
        String string = "";
        SB sB = new SB();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i][0];
            String string3 = this.words.getProperty(string2);
            if (string3 != null) {
                string2 = string2 + " | " + string3;
            }
            sB.append(string2).append(" = ").append(stringArray[i][1] == null ? string : stringArray[i][1]).appendC('\n');
        }
        return sB.toString();
    }
}

