/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.corrector;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangeRelationMemberRoleCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.corrector.Correction;
import org.openstreetmap.josm.corrector.RoleCorrection;
import org.openstreetmap.josm.corrector.RoleCorrectionTable;
import org.openstreetmap.josm.corrector.RoleCorrectionTableModel;
import org.openstreetmap.josm.corrector.TagCorrection;
import org.openstreetmap.josm.corrector.TagCorrectionTable;
import org.openstreetmap.josm.corrector.TagCorrectionTableModel;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.widgets.JMultilineLabel;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.UserCancelException;

public abstract class TagCorrector<P extends OsmPrimitive> {
    private String[] applicationOptions = new String[]{I18n.tr("Apply selected changes", new Object[0]), I18n.tr("Do not apply changes", new Object[0]), I18n.tr("Cancel", new Object[0])};

    public abstract Collection<Command> execute(P var1, P var2) throws UserCancelException;

    protected Collection<Command> applyCorrections(Map<OsmPrimitive, List<TagCorrection>> map, Map<OsmPrimitive, List<RoleCorrection>> map2, String string) throws UserCancelException {
        if (!map.isEmpty() || !map2.isEmpty()) {
            JScrollPane jScrollPane;
            Object object;
            Object object2;
            List<RoleCorrection> list;
            List<Correction> list2;
            ArrayList<Command> arrayList = new ArrayList<Command>();
            HashMap<OsmPrimitive, Object> hashMap = new HashMap<OsmPrimitive, Object>();
            HashMap<OsmPrimitive, Object> hashMap2 = new HashMap<OsmPrimitive, Object>();
            JPanel jPanel = new JPanel(new GridBagLayout());
            JMultilineLabel jMultilineLabel = new JMultilineLabel(string);
            jMultilineLabel.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel, GBC.eop().anchor(10).fill(2));
            JMultilineLabel jMultilineLabel2 = new JMultilineLabel(I18n.tr("Please select which changes you want to apply.", new Object[0]));
            jMultilineLabel2.setMaxWidth(600);
            jPanel.add((Component)jMultilineLabel2, GBC.eop().anchor(10).fill(2));
            for (Map.Entry<OsmPrimitive, List<TagCorrection>> iterator : map.entrySet()) {
                OsmPrimitive osmPrimitive = iterator.getKey();
                list2 = iterator.getValue();
                if (list2.isEmpty()) continue;
                list = new JLabel(I18n.tr("Tags of ", new Object[0]));
                jPanel.add((Component)((Object)list), GBC.std());
                object2 = new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()) + ':', ImageProvider.get(osmPrimitive.getDisplayType()), 2);
                jPanel.add((Component)object2, GBC.eol());
                object = new TagCorrectionTable(list2);
                jScrollPane = new JScrollPane((Component)object);
                jPanel.add((Component)jScrollPane, GBC.eop().fill(2));
                hashMap.put(osmPrimitive, object);
            }
            for (Map.Entry<OsmPrimitive, List<Correction>> entry : map2.entrySet()) {
                OsmPrimitive osmPrimitive = entry.getKey();
                list2 = entry.getValue();
                if (list2.isEmpty()) continue;
                list = new JLabel(I18n.tr("Roles in relations referring to", new Object[0]));
                jPanel.add((Component)((Object)list), GBC.std());
                object2 = new JLabel(osmPrimitive.getDisplayName(DefaultNameFormatter.getInstance()), ImageProvider.get(osmPrimitive.getDisplayType()), 2);
                jPanel.add((Component)object2, GBC.eol());
                ((JLabel)((Object)list)).setLabelFor((Component)object2);
                object = new RoleCorrectionTable((List<RoleCorrection>)list2);
                jScrollPane = new JScrollPane((Component)object);
                jPanel.add((Component)jScrollPane, GBC.eop().fill(2));
                ((JLabel)object2).setLabelFor((Component)object);
                hashMap2.put(osmPrimitive, object);
            }
            int n = JOptionPane.showOptionDialog(Main.parent, jPanel, I18n.tr("Automatic tag correction", new Object[0]), 1, -1, null, this.applicationOptions, this.applicationOptions[0]);
            if (n == 0) {
                for (Map.Entry<OsmPrimitive, List<TagCorrection>> entry : map.entrySet()) {
                    list2 = entry.getValue();
                    list = entry.getKey();
                    object2 = null;
                    if (list instanceof Way) {
                        object2 = new Way((Way)((Object)list));
                    } else if (list instanceof Node) {
                        object2 = new Node((Node)((Object)list));
                    } else if (list instanceof Relation) {
                        object2 = new Relation((Relation)((Object)list));
                    } else {
                        throw new AssertionError();
                    }
                    object = new HashSet();
                    for (int i = 0; i < list2.size(); ++i) {
                        if (!((TagCorrectionTableModel)((TagCorrectionTable)hashMap.get(list)).getCorrectionTableModel()).getApply(i)) continue;
                        TagCorrection tagCorrection = (TagCorrection)list2.get(i);
                        if (tagCorrection.isKeyChanged() && !object.contains(tagCorrection.oldKey)) {
                            ((OsmPrimitive)object2).remove(tagCorrection.oldKey);
                        }
                        ((OsmPrimitive)object2).put(tagCorrection.newKey, tagCorrection.newValue);
                        object.add(tagCorrection.newKey);
                    }
                    if (object.isEmpty()) continue;
                    arrayList.add(new ChangeCommand((OsmPrimitive)((Object)list), (OsmPrimitive)object2));
                }
                for (Map.Entry<OsmPrimitive, List<RoleCorrection>> entry : map2.entrySet()) {
                    list2 = entry.getKey();
                    list = entry.getValue();
                    for (int i = 0; i < list.size(); ++i) {
                        object = list.get(i);
                        if (!((RoleCorrectionTableModel)((RoleCorrectionTable)hashMap2.get(list2)).getCorrectionTableModel()).getApply(i)) continue;
                        arrayList.add(new ChangeRelationMemberRoleCommand(((RoleCorrection)object).relation, ((RoleCorrection)object).position, ((RoleCorrection)object).newRole));
                    }
                }
            } else if (n != 1) {
                throw new UserCancelException();
            }
            return arrayList;
        }
        return Collections.emptyList();
    }
}

