/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.openstreetmap.josm.data.osm.Hash;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.tools.Utils;

public class Storage<T>
extends AbstractSet<T> {
    private final Hash<? super T, ? super T> hash;
    private T[] data;
    private int mask;
    private int size;
    private volatile int modCount;
    private double loadFactor = 0.6;
    private static final int DEFAULT_CAPACITY = 16;
    private final boolean safeIterator;
    private boolean arrayCopyNecessary;

    public Storage() {
        this(Storage.defaultHash(), 16, false);
    }

    public Storage(int n) {
        this(Storage.defaultHash(), n, false);
    }

    public Storage(Hash<? super T, ? super T> hash) {
        this(hash, 16, false);
    }

    public Storage(boolean bl) {
        this(Storage.defaultHash(), 16, bl);
    }

    public Storage(int n, boolean bl) {
        this(Storage.defaultHash(), n, bl);
    }

    public Storage(Hash<? super T, ? super T> hash, boolean bl) {
        this(hash, 16, bl);
    }

    public Storage(Hash<? super T, ? super T> hash, int n) {
        this(hash, n, false);
    }

    public Storage(Hash<? super T, ? super T> hash, int n, boolean bl) {
        this.hash = hash;
        int n2 = 1 << (int)Math.ceil(Math.log((double)n / this.loadFactor) / Math.log(2.0));
        Object[] objectArray = new Object[n2];
        this.data = objectArray;
        this.mask = this.data.length - 1;
        this.safeIterator = bl;
    }

    private void copyArray() {
        if (this.arrayCopyNecessary) {
            this.data = Utils.copyArray(this.data);
            this.arrayCopyNecessary = false;
        }
    }

    @Override
    public synchronized int size() {
        return this.size;
    }

    @Override
    public synchronized Iterator<T> iterator() {
        if (this.safeIterator) {
            this.arrayCopyNecessary = true;
            return new SafeReadonlyIter(this.data);
        }
        return new Iter();
    }

    @Override
    public synchronized boolean contains(Object object) {
        Object object2 = object;
        int n = this.getBucket(this.hash, object2);
        return n >= 0;
    }

    @Override
    public synchronized boolean add(T t) {
        T t2 = this.putUnique(t);
        return t2 == t;
    }

    @Override
    public synchronized boolean remove(Object object) {
        Object object2 = object;
        Object object3 = this.removeElem(object2);
        return object3 != null;
    }

    @Override
    public synchronized void clear() {
        this.copyArray();
        ++this.modCount;
        this.size = 0;
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = null;
        }
    }

    @Override
    public synchronized int hashCode() {
        int n = 0;
        for (T t : this) {
            n += this.hash.getHashCode(t);
        }
        return n;
    }

    public synchronized T put(T t) {
        this.copyArray();
        ++this.modCount;
        this.ensureSpace();
        int n = this.getBucket(this.hash, t);
        if (n < 0) {
            ++this.size;
            assert (this.data[n ^= 0xFFFFFFFF] == null);
        }
        T t2 = this.data[n];
        this.data[n] = t;
        return t2;
    }

    public synchronized T get(T t) {
        int n = this.getBucket(this.hash, t);
        return n < 0 ? null : (T)this.data[n];
    }

    public synchronized T putUnique(T t) {
        this.copyArray();
        ++this.modCount;
        this.ensureSpace();
        int n = this.getBucket(this.hash, t);
        if (n < 0) {
            ++this.size;
            assert (this.data[~n] == null);
            this.data[n ^ 0xFFFFFFFF] = t;
            return t;
        }
        return this.data[n];
    }

    public synchronized T removeElem(T t) {
        this.copyArray();
        ++this.modCount;
        int n = this.getBucket(this.hash, t);
        return n < 0 ? null : (T)this.doRemove(n);
    }

    public <K> Map<K, T> foreignKey(Hash<K, ? super T> hash) {
        return new FMap(hash);
    }

    private static int rehash(int n) {
        return 1103515245 * n >> 2;
    }

    private <K> int getBucket(Hash<K, ? super T> hash, K k) {
        T t;
        int n = Storage.rehash(hash.getHashCode(k));
        int n2 = n & this.mask;
        while ((t = this.data[n2]) != null) {
            if (hash.equals(k, t)) {
                return n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        return ~n2;
    }

    private T doRemove(int n) {
        T t = this.data[n];
        assert (t != null);
        this.fillTheHole(n);
        --this.size;
        return t;
    }

    private void fillTheHole(int n) {
        T t;
        int n2 = n + 1 & this.mask;
        while ((t = this.data[n2]) != null) {
            int n3 = Storage.rehash(this.hash.getHashCode(t)) & this.mask;
            if (n2 < n3 && (n3 <= n || n <= n2) || n3 <= n && n <= n2) {
                this.data[n] = this.data[n2];
                n = n2;
            }
            n2 = n2 + 1 & this.mask;
        }
        this.data[n] = null;
    }

    private void ensureSpace() {
        if ((double)this.size > (double)this.data.length * this.loadFactor) {
            Object[] objectArray = new Object[this.data.length * 2];
            int n = objectArray.length - 1;
            for (T t : this.data) {
                if (t == null) continue;
                int n2 = Storage.rehash(this.hash.getHashCode(t)) & n;
                while (objectArray[n2] != null) {
                    n2 = n2 + 1 & n;
                }
                objectArray[n2] = t;
            }
            this.data = objectArray;
            this.mask = n;
        }
    }

    public static <O> Hash<O, O> defaultHash() {
        return new Hash<O, O>(){

            @Override
            public int getHashCode(O o) {
                return o.hashCode();
            }

            @Override
            public boolean equals(O o, O o2) {
                return o.equals(o2);
            }
        };
    }

    private final class Iter
    implements Iterator<T> {
        private final int mods;
        private int slot;
        private int removeSlot = -1;

        Iter() {
            this.mods = Storage.this.modCount;
        }

        @Override
        public boolean hasNext() {
            this.align();
            return this.slot < Storage.this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removeSlot = this.slot;
            return Storage.this.data[this.slot++];
        }

        @Override
        public void remove() {
            if (this.removeSlot == -1) {
                throw new IllegalStateException();
            }
            Storage.this.doRemove(this.removeSlot);
            this.slot = this.removeSlot;
            this.removeSlot = -1;
        }

        private void align() {
            if (this.mods != Storage.this.modCount) {
                throw new ConcurrentModificationException();
            }
            while (this.slot < Storage.this.data.length && Storage.this.data[this.slot] == null) {
                ++this.slot;
            }
        }
    }

    private final class SafeReadonlyIter
    implements Iterator<T> {
        private final T[] data;
        private int slot;

        SafeReadonlyIter(T[] TArray) {
            this.data = TArray;
        }

        @Override
        public boolean hasNext() {
            this.align();
            return this.slot < this.data.length;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.data[this.slot++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void align() {
            while (this.slot < this.data.length && this.data[this.slot] == null) {
                ++this.slot;
            }
        }
    }

    private final class FMap<K>
    implements Map<K, T> {
        private Hash<K, ? super T> fHash;

        private FMap(Hash<K, ? super T> hash) {
            this.fHash = hash;
        }

        @Override
        public int size() {
            return Storage.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Storage.this.isEmpty();
        }

        @Override
        public boolean containsKey(Object object) {
            Object object2 = object;
            int n = Storage.this.getBucket(this.fHash, object2);
            return n >= 0;
        }

        @Override
        public boolean containsValue(Object object) {
            return Storage.this.contains(object);
        }

        @Override
        public T get(Object object) {
            Object object2 = object;
            int n = Storage.this.getBucket(this.fHash, object2);
            return n < 0 ? null : Storage.this.data[n];
        }

        @Override
        public T put(K k, T t) {
            if (!this.fHash.equals(k, t)) {
                throw new IllegalArgumentException("inconsistent key");
            }
            return Storage.this.put(t);
        }

        @Override
        public T remove(Object object) {
            Storage.this.modCount++;
            Object object2 = object;
            int n = Storage.this.getBucket(this.fHash, object2);
            return n < 0 ? null : Storage.this.doRemove(n);
        }

        @Override
        public void putAll(Map<? extends K, ? extends T> map) {
            if (map instanceof FMap) {
                Storage.this.addAll(map.values());
            } else {
                for (Map.Entry entry : map.entrySet()) {
                    this.put(entry.getKey(), (T)entry.getValue());
                }
            }
        }

        @Override
        public void clear() {
            Storage.this.clear();
        }

        @Override
        public Set<K> keySet() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Collection<T> values() {
            return Storage.this;
        }

        @Override
        public Set<Map.Entry<K, T>> entrySet() {
            throw new UnsupportedOperationException();
        }
    }

    public static class PrimitiveIdHash
    implements Hash<PrimitiveId, PrimitiveId> {
        @Override
        public int getHashCode(PrimitiveId primitiveId) {
            return (int)primitiveId.getUniqueId() ^ primitiveId.getType().hashCode();
        }

        @Override
        public boolean equals(PrimitiveId primitiveId, PrimitiveId primitiveId2) {
            if (primitiveId == null || primitiveId2 == null) {
                return false;
            }
            return primitiveId.getUniqueId() == primitiveId2.getUniqueId() && primitiveId.getType() == primitiveId2.getType();
        }
    }
}

