/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.tools.ExifReader;

public class ThumbsLoader
implements Runnable {
    public static final int maxSize = 120;
    public static final int minSize = 22;
    public volatile boolean stop;
    private List<ImageEntry> data;
    private GeoImageLayer layer;
    private MediaTracker tracker;
    private ICacheAccess<String, BufferedImageCacheEntry> cache;
    private boolean cacheOff = Main.pref.getBoolean("geoimage.noThumbnailCache", false);

    public ThumbsLoader(GeoImageLayer geoImageLayer) {
        this.layer = geoImageLayer;
        this.data = new ArrayList<ImageEntry>(geoImageLayer.data);
        if (!this.cacheOff) {
            try {
                this.cache = JCSCacheManager.getCache("geoimage-thumbnails", 0, 120, Main.pref.getCacheDirectory().getPath() + File.separator + "geoimage-thumbnails");
            }
            catch (IOException iOException) {
                Main.warn("Failed to initialize cache for geoimage-thumbnails");
                Main.warn(iOException);
            }
        }
    }

    @Override
    public void run() {
        Main.debug("Load Thumbnails");
        this.tracker = new MediaTracker(Main.map.mapView);
        for (ImageEntry imageEntry : this.data) {
            if (this.stop) {
                return;
            }
            if (imageEntry.thumbnail != null) continue;
            imageEntry.thumbnail = this.loadThumb(imageEntry);
            if (!Main.isDisplayingMapView()) continue;
            this.layer.updateOffscreenBuffer = true;
            Main.map.mapView.repaint();
        }
        this.layer.thumbsLoaded();
        this.layer.updateOffscreenBuffer = true;
        Main.map.mapView.repaint();
    }

    private BufferedImage loadThumb(ImageEntry imageEntry) {
        Object object;
        int n;
        int n2;
        Object object2;
        String string = imageEntry.getFile() + ":" + 120;
        if (!this.cacheOff && this.cache != null) {
            try {
                object2 = this.cache.get(string);
                if (object2 != null && ((BufferedImageCacheEntry)object2).getImage() != null) {
                    Main.debug(" from cache");
                    return ((BufferedImageCacheEntry)object2).getImage();
                }
            }
            catch (IOException iOException) {
                Main.warn(iOException);
            }
        }
        object2 = Toolkit.getDefaultToolkit().createImage(imageEntry.getFile().getPath());
        this.tracker.addImage((Image)object2, 0);
        try {
            this.tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            Main.error(" InterruptedException while loading thumb");
            return null;
        }
        if (this.tracker.isErrorID(1) || ((Image)object2).getWidth(null) <= 0 || ((Image)object2).getHeight(null) <= 0) {
            Main.error(" Invalid image");
            return null;
        }
        int n3 = ((Image)object2).getWidth(null);
        int n4 = ((Image)object2).getHeight(null);
        Integer n5 = imageEntry.getExifOrientation();
        if (n5 != null && ExifReader.orientationSwitchesDimensions(n5)) {
            n2 = n4;
            n = n3;
        } else {
            n2 = n3;
            n = n4;
        }
        Rectangle rectangle = ImageDisplay.calculateDrawImageRectangle(new Rectangle(0, 0, n2, n), new Rectangle(0, 0, 120, 120));
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        AffineTransform affineTransform = AffineTransform.getScaleInstance((double)rectangle.width / (double)n2, (double)rectangle.height / (double)n);
        if (n5 != null) {
            object = ExifReader.getRestoreOrientationTransform(n5, n3, n4);
            affineTransform.concatenate((AffineTransform)object);
        }
        while (!graphics2D.drawImage((Image)object2, affineTransform, null)) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                Main.warn("InterruptedException while drawing thumb");
            }
        }
        graphics2D.dispose();
        this.tracker.removeImage((Image)object2);
        if (bufferedImage.getWidth() <= 0 || bufferedImage.getHeight() <= 0) {
            Main.error(" Invalid image");
            return null;
        }
        if (!this.cacheOff && this.cache != null) {
            try {
                object = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    ImageIO.write((RenderedImage)bufferedImage, "png", (OutputStream)object);
                    this.cache.put(string, new BufferedImageCacheEntry(((ByteArrayOutputStream)object).toByteArray()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((ByteArrayOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((ByteArrayOutputStream)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                Main.warn("Failed to save geoimage thumb to cache");
                Main.warn(iOException);
            }
        }
        return bufferedImage;
    }
}

