/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.presets;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.map.TaggingPresetPreference;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetItem;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetMenu;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetSeparator;
import org.openstreetmap.josm.gui.tagging.presets.items.Check;
import org.openstreetmap.josm.gui.tagging.presets.items.CheckGroup;
import org.openstreetmap.josm.gui.tagging.presets.items.Combo;
import org.openstreetmap.josm.gui.tagging.presets.items.ComboMultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.ItemSeparator;
import org.openstreetmap.josm.gui.tagging.presets.items.Key;
import org.openstreetmap.josm.gui.tagging.presets.items.Label;
import org.openstreetmap.josm.gui.tagging.presets.items.Link;
import org.openstreetmap.josm.gui.tagging.presets.items.MultiSelect;
import org.openstreetmap.josm.gui.tagging.presets.items.Optional;
import org.openstreetmap.josm.gui.tagging.presets.items.PresetLink;
import org.openstreetmap.josm.gui.tagging.presets.items.Roles;
import org.openstreetmap.josm.gui.tagging.presets.items.Space;
import org.openstreetmap.josm.gui.tagging.presets.items.Text;
import org.openstreetmap.josm.io.CachedFile;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Predicates;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlObjectParser;
import org.xml.sax.SAXException;

public final class TaggingPresetReader {
    public static final String PRESET_MIME_TYPES = "application/xml, text/xml, text/plain; q=0.8, application/zip, application/octet-stream; q=0.5";
    private static volatile File zipIcons;
    private static volatile boolean loadIcons;

    public static Set<String> getPresetSources() {
        return new TaggingPresetPreference.PresetPrefHelper().getActiveUrls();
    }

    private static XmlObjectParser buildParser() {
        XmlObjectParser xmlObjectParser = new XmlObjectParser();
        xmlObjectParser.mapOnStart("item", TaggingPreset.class);
        xmlObjectParser.mapOnStart("separator", TaggingPresetSeparator.class);
        xmlObjectParser.mapBoth("group", TaggingPresetMenu.class);
        xmlObjectParser.map("text", Text.class);
        xmlObjectParser.map("link", Link.class);
        xmlObjectParser.map("preset_link", PresetLink.class);
        xmlObjectParser.mapOnStart("optional", Optional.class);
        xmlObjectParser.mapOnStart("roles", Roles.class);
        xmlObjectParser.map("role", Roles.Role.class);
        xmlObjectParser.map("checkgroup", CheckGroup.class);
        xmlObjectParser.map("check", Check.class);
        xmlObjectParser.map("combo", Combo.class);
        xmlObjectParser.map("multiselect", MultiSelect.class);
        xmlObjectParser.map("label", Label.class);
        xmlObjectParser.map("space", Space.class);
        xmlObjectParser.map("key", Key.class);
        xmlObjectParser.map("list_entry", ComboMultiSelect.PresetListEntry.class);
        xmlObjectParser.map("item_separator", ItemSeparator.class);
        xmlObjectParser.mapBoth("chunk", Chunk.class);
        xmlObjectParser.map("reference", Reference.class);
        return xmlObjectParser;
    }

    public static Collection<TaggingPreset> readAll(Reader reader, boolean bl) throws SAXException {
        return TaggingPresetReader.readAll(reader, bl, new HashSetWithLast<TaggingPreset>());
    }

    static Collection<TaggingPreset> readAll(Reader reader, boolean bl, HashSetWithLast<TaggingPreset> hashSetWithLast) throws SAXException {
        XmlObjectParser xmlObjectParser = TaggingPresetReader.buildParser();
        Object object = null;
        Object object2 = null;
        Roles roles = null;
        LinkedList<Check> linkedList = new LinkedList<Check>();
        LinkedList<ComboMultiSelect.PresetListEntry> linkedList2 = new LinkedList<ComboMultiSelect.PresetListEntry>();
        HashMap hashMap = new HashMap();
        ArrayDeque<String> arrayDeque = new ArrayDeque<String>();
        ArrayDeque arrayDeque2 = new ArrayDeque();
        if (bl) {
            xmlObjectParser.startWithValidation(reader, Main.getXMLBase() + "/tagging-preset-1.0", "resource://data/tagging-preset.xsd");
        } else {
            xmlObjectParser.start(reader);
        }
        while (xmlObjectParser.hasNext() || !arrayDeque2.isEmpty()) {
            Object object3;
            Object object4;
            if (!arrayDeque2.isEmpty()) {
                object4 = ((Iterator)arrayDeque2.peek()).next();
                if (!((Iterator)arrayDeque2.peek()).hasNext()) {
                    arrayDeque2.pop();
                }
            } else {
                object4 = xmlObjectParser.next();
            }
            if (object4 instanceof Chunk) {
                if (!arrayDeque.isEmpty() && ((Chunk)object4).id.equals(arrayDeque.peek())) {
                    arrayDeque.pop();
                    ((Chunk)object4).id = null;
                    continue;
                }
                object3 = ((Chunk)object4).id;
                arrayDeque.push((String)object3);
                hashMap.put((String)object3, new ArrayList());
                continue;
            }
            if (!arrayDeque.isEmpty()) {
                ((List)hashMap.get(arrayDeque.peek())).add(object4);
                continue;
            }
            if (object4 instanceof Reference) {
                object3 = ((Reference)object4).ref;
                if (hashMap.get(object3) == null) {
                    throw new SAXException(I18n.tr("Reference {0} is being used before it was defined", object3));
                }
                Iterator iterator = ((List)hashMap.get(object3)).iterator();
                if (iterator.hasNext()) {
                    arrayDeque2.push(iterator);
                    continue;
                }
                Main.warn("Ignoring reference '" + (String)object3 + "' denoting an empty chunk");
                continue;
            }
            if (!(object4 instanceof TaggingPresetItem) && !linkedList.isEmpty()) {
                hashSetWithLast.getLast().data.addAll(linkedList);
                linkedList.clear();
            }
            if (object4 instanceof TaggingPresetMenu) {
                object3 = (TaggingPresetMenu)object4;
                if (object3 == object || object3 == object2) {
                    object = ((TaggingPresetMenu)object3).group;
                } else {
                    ((TaggingPresetMenu)object3).group = object;
                    if (hashSetWithLast.contains(object3)) {
                        object2 = object3;
                        object3 = (TaggingPresetMenu)Utils.filter(hashSetWithLast, Predicates.equalTo(object3)).iterator().next();
                        ((TaggingPresetMenu)object2).group = null;
                    } else {
                        ((TaggingPresetMenu)object3).setDisplayName();
                        hashSetWithLast.add((TaggingPreset)object3);
                        object2 = null;
                    }
                    object = object3;
                }
                roles = null;
                continue;
            }
            if (object4 instanceof TaggingPresetSeparator) {
                object3 = (TaggingPresetSeparator)object4;
                ((TaggingPresetSeparator)object3).group = object;
                hashSetWithLast.add((TaggingPreset)object3);
                roles = null;
                continue;
            }
            if (object4 instanceof TaggingPreset) {
                object3 = (TaggingPreset)object4;
                ((TaggingPreset)object3).group = object;
                ((TaggingPreset)object3).setDisplayName();
                hashSetWithLast.add((TaggingPreset)object3);
                roles = null;
                continue;
            }
            if (!hashSetWithLast.isEmpty()) {
                if (object4 instanceof Roles) {
                    hashSetWithLast.getLast().data.add((TaggingPresetItem)object4);
                    if (hashSetWithLast.getLast().roles != null) {
                        throw new SAXException(I18n.tr("Roles cannot appear more than once", new Object[0]));
                    }
                    hashSetWithLast.getLast().roles = (Roles)object4;
                    roles = (Roles)object4;
                    continue;
                }
                if (object4 instanceof Roles.Role) {
                    if (roles == null) {
                        throw new SAXException(I18n.tr("Preset role element without parent", new Object[0]));
                    }
                    roles.roles.add((Roles.Role)object4);
                    continue;
                }
                if (object4 instanceof Check) {
                    linkedList.add((Check)object4);
                    continue;
                }
                if (object4 instanceof ComboMultiSelect.PresetListEntry) {
                    linkedList2.add((ComboMultiSelect.PresetListEntry)object4);
                    continue;
                }
                if (object4 instanceof CheckGroup) {
                    hashSetWithLast.getLast().data.add((TaggingPresetItem)object4);
                    ((CheckGroup)object4).checks.clear();
                    ((CheckGroup)object4).checks.addAll(linkedList);
                    linkedList.clear();
                    continue;
                }
                if (!linkedList.isEmpty()) {
                    hashSetWithLast.getLast().data.addAll(linkedList);
                    linkedList.clear();
                }
                hashSetWithLast.getLast().data.add((TaggingPresetItem)object4);
                if (object4 instanceof ComboMultiSelect) {
                    ((ComboMultiSelect)object4).addListEntries(linkedList2);
                } else if (object4 instanceof Key && ((Key)object4).value == null) {
                    ((Key)object4).value = "";
                }
                linkedList2 = new LinkedList();
                roles = null;
                continue;
            }
            throw new SAXException(I18n.tr("Preset sub element without parent", new Object[0]));
        }
        if (!hashSetWithLast.isEmpty() && !linkedList.isEmpty()) {
            hashSetWithLast.getLast().data.addAll(linkedList);
            linkedList.clear();
        }
        return hashSetWithLast;
    }

    public static Collection<TaggingPreset> readAll(String string, boolean bl) throws SAXException, IOException {
        return TaggingPresetReader.readAll(string, bl, new HashSetWithLast<TaggingPreset>());
    }

    static Collection<TaggingPreset> readAll(String string, boolean bl, HashSetWithLast<TaggingPreset> hashSetWithLast) throws SAXException, IOException {
        Collection<TaggingPreset> collection;
        CachedFile cachedFile = new CachedFile(string).setHttpAccept(PRESET_MIME_TYPES);
        try (InputStream inputStream = cachedFile.findZipEntryInputStream("xml", "preset");){
            if (inputStream != null) {
                zipIcons = cachedFile.getFile();
            }
            try (UTFInputStreamReader uTFInputStreamReader = UTFInputStreamReader.create(inputStream == null ? cachedFile.getInputStream() : inputStream);){
                collection = TaggingPresetReader.readAll(new BufferedReader(uTFInputStreamReader), bl, hashSetWithLast);
            }
        }
        return collection;
    }

    public static Collection<TaggingPreset> readAll(Collection<String> collection, boolean bl) {
        return TaggingPresetReader.readAll(collection, bl, true);
    }

    public static Collection<TaggingPreset> readAll(Collection<String> collection, boolean bl, boolean bl2) {
        HashSetWithLast<TaggingPreset> hashSetWithLast = new HashSetWithLast<TaggingPreset>();
        for (String string : collection) {
            try {
                TaggingPresetReader.readAll(string, bl, hashSetWithLast);
            }
            catch (IOException iOException) {
                Main.error(iOException, false);
                Main.error(string);
                if (string.startsWith("http")) {
                    Main.addNetworkError(string, (Throwable)iOException);
                }
                if (!bl2) continue;
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read tagging preset source: {0}", string), I18n.tr("Error", new Object[0]), 0);
            }
            catch (SAXException sAXException) {
                Main.error(sAXException);
                Main.error(string);
                JOptionPane.showMessageDialog(Main.parent, "<html>" + I18n.tr("Error parsing {0}: ", string) + "<br><br><table width=600>" + sAXException.getMessage() + "</table></html>", I18n.tr("Error", new Object[0]), 0);
            }
        }
        return hashSetWithLast;
    }

    public static Collection<TaggingPreset> readFromPreferences(boolean bl, boolean bl2) {
        return TaggingPresetReader.readAll(TaggingPresetReader.getPresetSources(), bl, bl2);
    }

    public static File getZipIcons() {
        return zipIcons;
    }

    public static boolean isLoadIcons() {
        return loadIcons;
    }

    public static void setLoadIcons(boolean bl) {
        loadIcons = bl;
    }

    private TaggingPresetReader() {
    }

    static {
        loadIcons = true;
    }

    static class HashSetWithLast<E>
    extends LinkedHashSet<E> {
        protected E last;

        HashSetWithLast() {
        }

        @Override
        public boolean add(E e) {
            this.last = e;
            return super.add(e);
        }

        @Override
        public E getLast() {
            return this.last;
        }
    }

    public static class Reference {
        public String ref;
    }

    public static class Chunk {
        public String id;
    }
}

