# OOjs UI Release History

## v0.11.3 / 2015-05-12
* BarToolGroup: Don't use "pointer" cursor for disabled tools in enabled toolgroups (Bartosz Dziewoński)
* Tool: Support icon+label in bar tool groups (Bartosz Dziewoński)
* ToolGroupTool: Correct opacity of disabled nested tool group handle (Bartosz Dziewoński)
* ToolGroupTool: Synchronize inner ToolGroup disabledness state (Bartosz Dziewoński)
* MediaWiki theme: Add a powerful default text color for tools (Trevor Parscal)
* MediaWiki theme: Adjust quotes icon to match other icons (nirzar)
* MediaWiki theme: Give names to some more toolbar colours (Bartosz Dziewoński)
* MediaWiki theme: Provide all variants of the 'tag' icon (James D. Forrester)
* MediaWiki theme: Rejigger some toolbar coloring (Bartosz Dziewoński)
* MediaWiki theme: Remove box-shadow from nested toolbars (Bartosz Dziewoński)
* MediaWiki theme: Remove unusued toolbar shadow (Trevor Parscal)
* MediaWiki theme: Update button specification (nirzar)

## v0.11.2 / 2015-05-11
* Don't select lookup items on initialize (Ed Sanders)
* ListToolGroup, MenuToolGroup: Set accelTooltips = false (Bartosz Dziewoński)
* PopupWidget: Add setAlignment (Moriel Schottlender)
* SelectWidget: Mark as @abstract, which it is (Bartosz Dziewoński)
* Simplify default action prevention in buttons and forms (Bartosz Dziewoński)
* TabOptionWidget: Fix disabled styles to not react to hover/select (Ed Sanders)
* TextInputWidget: Allow override of #setValidityFlag (Ed Sanders)
* TextInputWidget: Use aria-required along with the required attribute (Prateek Saxena)
* Toolbar: Fix shadow styling (Bartosz Dziewoński)
* Toolbar: Move some tweaks from demo to actual implementation (Bartosz Dziewoński)
* Toolbar: Remove some useless code from the example (Bartosz Dziewoński)
* Toolbar: Rework example and add 'menu' tool group example (Bartosz Dziewoński)
* MediaWiki theme: Change highlight color for selected menu option (nirzar)
* MediaWiki theme: Polish the toolbar design (nirzar)
* MediaWiki theme: Remove accidentally duplicated styles for SelectWidget (Bartosz Dziewoński)

## v0.11.1 / 2015-05-04
* Add IndexLayout (Trevor Parscal)
* CardLayout: Fix typo (Kirsten Menger-Anderson)
* LabelElement: Document that label config option can take an HtmlSnippet (Roan Kattouw)
* PopupButtonWidget: Update align config in example (Kirsten Menger-Anderson)
* Remove GridLayout remnants (Bartosz Dziewoński)
* SelectWidget: Add #selectItemByData method (Moriel Schottlender)
* TabOptionWidget: Change link to card layout (Kirsten Menger-Anderson)
* TextInputWidget: Annotate input validation with aria-invalid (Prateek Saxena)
* TextInputWidget: Don't set 'invalid' flag on first focus, even if invalid (Bartosz Dziewoński)
* TextInputWidget: Support 'required' config option in PHP (Bartosz Dziewoński)
* MediaWiki theme: Add 'destructive' variant to block icon (Moriel Schottlender)
* MediaWiki theme: Better vertical alignment of 'search' icon (Ed Sanders)
* MediaWiki theme: Tweak 'search' icon size (Ed Sanders)
* MediaWiki theme: Use variable for transition time and easing function (Prateek Saxena)
* MediaWiki theme: input: Use variable for transition time and easing function (Prateek Saxena)
* MediaWiki theme: radio/checkbox: Use variable for transition time and easing function (Prateek Saxena)
* MediaWiki, Apex themes: Switch icons: clear → cancel, closeInput → clear (Bartosz Dziewoński)
* MediaWiki, Apex themes: Switch over 'magnifyingGlass' icon to be 'search' (James D. Forrester)
* build: Add clean:doc task (Bartosz Dziewoński)
* build: Bump grunt-jscs to latest version (James D. Forrester)
* core: Add OO.ui.debounce() utility (Roan Kattouw)
* demo: Add icons with variants to icons demo (Bartosz Dziewoński)

## v0.11.0 / 2015-04-29
* [BREAKING CHANGE] Do not set font-size: 0.8em anywhere in the library (Bartosz Dziewoński)

* [DEPRECATING CHANGE] Create rtl-ready alignments in PopupWidget (Moriel Schottlender)

* MediaWiki theme: Adding variants to several icons (Moriel Schottlender)
* TextInputWidget: Allow functions to be passed as 'validate' config option (Bartosz Dziewoński)
* TextInputWidget: Styles for 'invalid' flag (Bartosz Dziewoński)
* Update OOjs to v1.1.7 (James D. Forrester)
* Update jQuery from v1.11.1 to v1.11.3 (James D. Forrester)
* build: Use jquery and oojs from npm instead of embedded lib (Timo Tijhof)

## v0.10.1 / 2015-04-27
* Correct 'tabindex' attribute setting (Bartosz Dziewoński)
* Make toolbars keyboard-accessible (Bartosz Dziewoński)
* ToggleButtonWidget: Unbreak horizontal alignment (Bartosz Dziewoński)

## v0.10.0 / 2015-04-22
* [BREAKING CHANGE] ButtonWidget: remove deprecated nofollow option alias (C. Scott Ananian)
* [BREAKING CHANGE] Convert ToggleWidget from a mixin to an abstract class (Bartosz Dziewoński)
* [BREAKING CHANGE] MenuLayout: Reimplement without inline styles (Bartosz Dziewoński)

* BarToolGroup: Allow tools with labels instead of icons (Bartosz Dziewoński)
* BookletLayout: Find first focusable element and add focusable utility (Moriel Schottlender)
* ButtonInputWidget: Don't double-mixin FlaggedElement (Bartosz Dziewoński)
* ButtonWidget: Remove href to make unclickable when disabled (Bartosz Dziewoński)
* ButtonWidget: Remove pointless #isHyperlink property (Bartosz Dziewoński)
* FormLayout: Better document how this works with InputWidgets (Bartosz Dziewoński)
* MenuLayout: Add example (Kirsten Menger-Anderson)
* MenuLayout: Fix initialization order (Bartosz Dziewoński)
* PHP: More useful debugging information on unsafe tag attributes (Chad Horohoe)
* SelectWidget#getTargetItem: Simplify (Ed Sanders)
* Toolbar: Add example (Bartosz Dziewoński)
* themes: Add viewCompact, viewDetails, visionSimulator icons for iconography page (Mun May Tee)
* demo: Remove VisualEditor references from toolbar demo, use generic icons (Ed Sanders)
* demo: Remove outline controls from outlined BookletLayout demo (Bartosz Dziewoński)
* demo: Simplify ButtonGroupWidget and ButtonSelectWidget examples (Bartosz Dziewoński)

## v0.9.8 / 2015-04-12
* Apex, MediaWiki: Correct or delete unused SVG files (James D. Forrester)
* Apex theme: Correctly position popups in RTL; follows-up v0.9.5 (Moriel Schottlender)
* BookletLayout: Allow focus on any item (Moriel Schottlender)
* Error: Add description (Kirsten Menger-Anderson)
* Move coverage output from "/dist/coverage" to "/coverage" (Timo Tijhof)
* ProcessDialog: Remove stray 'this.$' from documentation code example (Roan Kattouw)
* ProgressBarWidget: Remove spurious styles from CSS output (Bartosz Dziewoński)
* build: Add explicit dependency upon grunt-cli (Kunal Mehta)
* build: Run lint before build in grunt-test (Timo Tijhof)
* colorize-svg: Generate language-specific rules for images even if equal to default ones (Bartosz Dziewoński)
* colorize-svg: Sprinkle `/* @noflip */` on language-specific rules (Bartosz Dziewoński)
* demo: Change html dir property when direction changes (Moriel Schottlender)

## v0.9.7 / 2015-04-03
* build: Generate correct paths to fallback images (Bartosz Dziewoński)

## v0.9.5 / 2015-04-02
* [DEPRECATING CHANGE] Deprecate search widget event re-emission (Ed Sanders)

* ActionFieldLayout: Add description and example (Kirsten Menger-Anderson)
* Add vertical spacing to RadioSelectWidget in MW theme (Ed Sanders)
* Allow rejecting Process with single Error (Matthew Flaschen)
* Apex theme: Tweak 'check.svg' syntax (Bartosz Dziewoński)
* Balance padding now that focus highlight is balanced (Ed Sanders)
* BookletLayout: Add description and example (Kirsten Menger-Anderson)
* Bring in remaining VisualEditor icons for Apex and MediaWiki themes (James D. Forrester)
* Choose can't emit with a null item (Ed Sanders)
* Correctly position popups in RTL (Moriel Schottlender)
* Fix opacity of icons/indicators in disabled DecoratedOptionWidget (Ed Sanders)
* IconWidget: Mix in FlaggedElement (Bartosz Dziewoński)
* Increase specificity of ButtonElement icon and indicator styles (Bartosz Dziewoński)
* Make colorize-svg.js actually work more often (Bartosz Dziewoński)
* MediaWiki theme: Allow intention flags for non-buttons (Andrew Garrett)
* MediaWiki theme: Fix icon opacity for disabled ButtonOptionWidgets (Bartosz Dziewoński)
* MediaWiki theme: Use checkbox icon per mockups (Bartosz Dziewoński)
* MediaWiki, Apex: Provide an RTL variant for the help icon (James D. Forrester)
* MenuLayout: Correct documentation (Bartosz Dziewoński)
* OutlineOption: Add description (Kirsten Menger-Anderson)
* PageLayout: Add description (Kirsten Menger-Anderson)
* Process: Add description (Kirsten Menger-Anderson)
* Properly support LTR/RTL icon versions in colorize-svg.js (Bartosz Dziewoński)
* Refactor icon handling again (Bartosz Dziewoński)
* Remove line height reset for windows (Ed Sanders)
* Restore font family definitions to form elements (Ed Sanders)
* Revert "Button styles between OOJS and MW" (Bartosz Dziewoński)
* StackLayout: Add description and example (Kirsten Menger-Anderson)
* build: Add a 'generated automatically' banner to demo.rtl.css (Bartosz Dziewoński)
* build: Generate prettier task names for 'colorizeSvg' (Bartosz Dziewoński)
* build: Have separate 'cssjanus' target for demo.rtl.css (Bartosz Dziewoński)
* build: Simplify 'fileExists' task configuration (Bartosz Dziewoński)
* build: Support (poorly) per-language icon versions in colorize-svg.js (Bartosz Dziewoński)
* build: Update grunt-banana-checker to v0.2.1 (James D. Forrester)

## v0.9.4 / 2015-03-25
* ButtonElement: Clarify description (Kirsten Menger-Anderson)
* ButtonElement: Disable line wrapping on buttons (Ed Sanders)
* Compensate for loss of margin when opening modals (Ed Sanders)
* FieldLayout: Clarify description and mark private methods (Kirsten Menger-Anderson)
* FieldsetLayout: Add description and example (Kirsten Menger-Anderson)
* FormLayout: Add description, example, and mark private method (Kirsten Menger-Anderson)
* Layout: Add description (Kirsten Menger-Anderson)
* LookupElement: Add description and mark private and protected methods (Kirsten Menger-Anderson)
* LookupElement: Fix typo in docs (Bartosz Dziewoński)
* Make outline controls abilities configurable (Trevor Parscal)
* MenuLayout: Reorder styles (Bartosz Dziewoński)
* MenuSectionOptionWidget: Add description and example (Kirsten Menger-Anderson)
* ProcessDialog#executeAction: Don't eat parent's return value (Roan Kattouw)
* PanelLayout: Add description and example (Kirsten Menger-Anderson)
* Reduce thickness of toolbar border in MediaWiki (Ed Sanders)
* SearchWidget: Add description and mark private methods (Kirsten Menger-Anderson)
* TabIndexElement: Mark private method (Kirsten Menger-Anderson)

## v0.9.3 / 2015-03-19
* Add .mailmap file (Roan Kattouw)
* Add Kirsten to AUTHORS.txt (Roan Kattouw)
* Dialog: Fix links to static properties (Kirsten Menger-Anderson)
* DraggableGroupElement: Clarify description and mark private methods (Kirsten Menger-Anderson)
* Fix code style in @examples (Ed Sanders)
* FlaggedElement: Add example and clarify description (Kirsten Menger-Anderson)
* GroupElement: Clarify description (Kirsten Menger-Anderson)
* IndicatorElement: Clarify description (Kirsten Menger-Anderson)
* LookupElement: Add optional config field for suggestions when empty (Matthew Flaschen)
* MenuSelectWidget: Clarify description (Kirsten Menger-Anderson)
* ProcessDialog: send an array to showErrors in failed executeAction (Moriel Schottlender)
* TabIndexedElement: Clarify description (Kirsten Menger-Anderson)
* TitledElement: Clarify description (Kirsten Menger-Anderson)
* Update OOjs to v1.1.6 (James D. Forrester)
* Widget: Clarify description (Kirsten Menger-Anderson)
* Window: Clarify description of setDimensions method (Kirsten Menger-Anderson)
* WindowManager: Clarify description and mark private methods (Kirsten Menger-Anderson)
* demo: Add one more toolbars demo (Bartosz Dziewoński)

## v0.9.2 / 2015-03-12
* Toolbar: Be less aggressive with 'white-space: nowrap' (Bartosz Dziewoński)
* Window: Revert changes from 521061dd (Bartosz Dziewoński)

## v0.9.1 / 2015-03-11
* Syncing some button styles with MediaWiki UI (kaldari)
* MediaWiki Theme: Add the progressive variant to the check icon (Prateek Saxena)
* demo: Fix typo in toolbars demo (Bartosz Dziewoński)
* TextInputWidget: Use MutationObserver for #onElementAttach support (Bartosz Dziewoński)
* TextInputWidget: Adjust size and label on first focus, too (Bartosz Dziewoński)
* jsduck: Add MouseEvent and KeyboardEvent to externals (Timo Tijhof)
* jsduck: Set --processes=0 to fix warnings-exit-nonzero (Timo Tijhof)
* Dialog: Mark private methods and add description of methods and configs (Kirsten Menger-Anderson)
* ProcessDialog: Add description and example and mark private methods (Kirsten Menger-Anderson)
* MessageDialog: Add description, example, and mark private methods (Kirsten Menger-Anderson)
* build: Remove obsolete 'build' task from grunt-doc (Timo Tijhof)
* build: Move pre/post 'doc' task into package.json (Timo Tijhof)
* Remove remnants of window isolation (Bartosz Dziewoński)
* demo: Simplify @media styles (Bartosz Dziewoński)
* PanelLayout: Add 'framed' config option (Bartosz Dziewoński)
* TextInputMenuSelectWidget: Add description and mark private methods (Kirsten Menger-Anderson)
* Toolbar: Tighten whitespace on narrow displays (Bartosz Dziewoński)
* demo: Use popup with head in the toolbars demo (Bartosz Dziewoński)
* Remove half-baked touch event handling (Bartosz Dziewoński)
* ButtonElement: Use #setButtonElement correctly (Bartosz Dziewoński)
* WindowManager: Documentation typo (Ed Sanders)
* ButtonInputWidget: Clarify description of configs and methods (Kirsten Menger-Anderson)
* Icon width should only be applied if there is an icon (Moriel Schottlender)
* package.json: Bump grunt-svg2png to 0.2.7 (Bartosz Dziewoński)
* Add warning variant to MediaWiki set (Mark Holmquist)
* Button styles between OOJS and MW (nirzar)
* AUTHORS: Add Derk-Jan Hartman (Derk-Jan Hartman)
* ActionSet: Add description for events and clarify method descriptions (Kirsten Menger-Anderson)
* demo: Load styles before building demo widgets (not asynchronously) (Bartosz Dziewoński)
* ActionWidget: Fix bad copy-paste in documentation (Bartosz Dziewoński)
* Window: Clarify descriptions of methods and configs (Kirsten Menger-Anderson)
* OutlineSelectWidget: Add description (Kirsten Menger-Anderson)
* OutlineControlsWidget: Add description (Kirsten Menger-Anderson)
* MediaWiki Theme: Add "Wikicon" icons (James D. Forrester)
* build: Set 'generateExactDuplicates: true' for CSSJanus (Bartosz Dziewoński)
* build: Implement basic image flipping support in colorize-svg (Bartosz Dziewoński)
* ActionWidget: Clarify description and mark private method (Kirsten Menger-Anderson)
* ActionSet: Clarify description (Kirsten Menger-Anderson)
* InputWidget: Clarify description (Kirsten Menger-Anderson)
* MediaWiki Theme: textInputWidget: Update focus state (Prateek Saxena)
* Only prevent default for handled keypresses (Brad Jorsch)

## v0.9.0 / 2015-03-04
* [BREAKING CHANGE] Remove innerOverlay (Ed Sanders)
* [BREAKING CHANGE] TextInputWidget: Remove 'icon' and 'indicator' events (Bartosz Dziewoński)
* [BREAKING CHANGE] Remove deprecated LookupInputWidget (Bartosz Dziewoński)
* [BREAKING CHANGE] Remove deprecated GridLayout (Bartosz Dziewoński)

* Only modify body class when first/last window opens/closes (Ed Sanders)
* InputWidget: Focus checkboxes and radios, too, when the label is clicked (Bartosz Dziewoński)
* Move `OO.ui.infuse` to `OO.ui.Element.static.infuse`. (C. Scott Ananian)
* Don't call LabelElement constructor twice for ActionFieldLayouts (Roan Kattouw)
* PopupElement: Add description (Kirsten Menger-Anderson)
* Make icon and indicator container sizes consistent (Ed Sanders)
* SelectWidget: Marked protected methods and clarified choose/press descriptions (Kirsten Menger-Anderson)
* demo: Call Toolbar#initialize in toolbar demo (Bartosz Dziewoński)
* demo: Add PopupTool to toolbar demo (Bartosz Dziewoński)
* PopupTool: Tool constructor takes a toolGroup, not a toolbar (Bartosz Dziewoński)
* Infer retry button action flags from symbolic name (Trevor Parscal)
* Revert "Unbreak form submission in JavaScript" (Bartosz Dziewoński)
* PopupWidget: Add description, example, and mark private methods (Kirsten Menger-Anderson)
* ToggleButtonWidget: Add description, example, and mark private method (Kirsten Menger-Anderson)
* ToggleWidget: Add description (Kirsten Menger-Anderson)
* ToggleSwitchWidget: Add description, example, and mark private methods (Kirsten Menger-Anderson)
* build: Add disconnect tolerance to karma config (James D. Forrester)
* ProgressBar: Add description and example (Kirsten Menger-Anderson)
* CheckboxInputWidget: Add description and example (Kirsten Menger-Anderson)
* Use the correct color for gray buttons (Prateek Saxena)
* RadioInputWidget: Add description and example (Kirsten Menger-Anderson)
* Fix invalid use of border shorthand syntax (Timo Tijhof)
* Restore previous toolbar items margins and padding (Bartosz Dziewoński)
* ProcessDialog: Dismiss errors on teardown (Moriel Schottlender)
* build: Remove footer override from jsduck (Timo Tijhof)
* FieldLayout: Fix display of bulleted list (Kirsten Menger-Anderson)
* Use only two variables each for each semantic color (Prateek Saxena)
* tests: Run JS/PHP tests for widgets with required parameters, too (Bartosz Dziewoński)
* TextInputWidget: Add description, example, and mark private methods (Kirsten Menger-Anderson)
* tests: Add infusion tests (Bartosz Dziewoński)
* PopupWidget: Add keydown listener and hide popup on ESC (Prateek Saxena)
* DropdownInputWidget: Add description, example, and mark private method (Kirsten Menger-Anderson)
* ComboBoxWidget: Add description, example, and mark private methods (Kirsten Menger-Anderson)
* DecoratedOptionWidget: Add description and example (Kirsten Menger-Anderson)
* SelectWidget: Add example and link to decorated option widget (Kirsten Menger-Anderson)
* GroupWidget and ItemWidget: Mark private (Kirsten Menger-Anderson)
* Fake toolbar group nesting (Bartosz Dziewoński)
* LabelWidget: Add description, example, and mark private method (Kirsten Menger-Anderson)
* IndicatorWidget: Add description and example (Kirsten Menger-Anderson)

## v0.8.3 / 2015-02-26
* Revert "Unbreak form submission in JavaScript" (Bartosz Dziewoński)

## v0.8.2 / 2015-02-26
* testsuitegenerator: Exclude 'text' parameter from tests, like 'content' (Bartosz Dziewoński)
* PHP TitledElement: Actually set $this->title (Bartosz Dziewoński)
* PHP PanelLayout: Fix getConfig() for 'expanded' config option (Bartosz Dziewoński)
* WindowManager: Don't pass 'this' to window factory method (Bartosz Dziewoński)

## v0.8.1 / 2015-02-25
* [DEPRECATING CHANGE] Rename setPosition to setLabelPosition (Ed Sanders)

* Element.php: Add "data" property (C. Scott Ananian)
* Element.php: Add "text" configuration option (C. Scott Ananian)
* Work around Safari 8 misrendering checkboxes in SVG-only distribution (Bartosz Dziewoński)
* TextInputWidget: Fix appearance of icons and labels when disabled (Ed Sanders)
* Remove '$: this.$' from code examples (Bartosz Dziewoński)
* Prefer OO.isPlainObject to $.isPlainObject (Bartosz Dziewoński)
* Error: Fix function name (Bartosz Dziewoński)
* build: Use grunt-contrib-copy instead of custom 'copy' task (Timo Tijhof)
* Element.php: Tweak docs (Bartosz Dziewoński)
* docparser.rb: Ruby 1.9.3 compatibility (Bartosz Dziewoński)
* Move toggle() from Widget to Element (Moriel Schottlender)
* build: Include 'lib' and 'dist' in jsduck output (Timo Tijhof)
* Fix typo: contian → contain (Bartosz Dziewoński)
* MediaWiki Theme: Drop unnecessary pseudo-element of CheckboxInputWidget (Timo Tijhof)
* MediaWiki Theme: Drop unnecessary pseudo-element of RadioInputWidget (Timo Tijhof)
* MediaWiki theme: Simplify spacing of checkboxes/radios in FieldLayouts (Bartosz Dziewoński)
* Add disabled RadioInputWidget to demo (Bartosz Dziewoński)
* RadioOptionWidget: Make disabling single options work (Bartosz Dziewoński)
* composer.json: Add description field (Kunal Mehta)
* IconElement: Add description for config options (Kirsten Menger-Anderson)
* IndicatorElement: Add description for configs and static properties (Kirsten Menger-Anderson)
* DraggableElement: Mark private methods and add description to events (Kirsten Menger-Anderson)
* Element: Add description for configs and static property (Kirsten Menger-Anderson)
* LabelElement: Add description, config description, static property description (Kirsten Menger-Anderson)
* TitledElement: Add description and config and static descriptions (Kirsten Menger-Anderson)
* ComboBox: Use combobox role (Derk-Jan Hartman)
* IconElement: Add description of methods (Kirsten Menger-Anderson)
* Follow-up bade83bfdfc: actually remove ../ (Roan Kattouw)
* Remove loop length check (Ed Sanders)
* PopupButtonWidget: Add description and example and mark private method (Kirsten Menger-Anderson)
* FlaggedElement: Add description of event and config option (Kirsten Menger-Anderson)
* Unbreak docparser.rb (Bartosz Dziewoński)
* Allow passing positional parameters inside the config object (Bartosz Dziewoński)
* Run JS/PHP comparison tests using karma (Bartosz Dziewoński)
* test: Reduce timeout in Process test from 100 to 10 (Timo Tijhof)
* OptionWidget: Add description and descriptions of methods (Kirsten Menger-Anderson)
* FormLayout: Allow adding child layouts via config (Bartosz Dziewoński)
* Teach docparser about @member, @see, and PHP pass-by-reference (&$foo). (C. Scott Ananian)
* Element: Add `content` config option, matching PHP side. (C. Scott Ananian)
* SelectWidget: Add description for config, methods, events (Kirsten Menger-Anderson)
* Serialize PHP widget state into data-ooui attribute (C. Scott Ananian)
* Implement OO.ui.infuse to reconstitute PHP widgets in client-side JS (C. Scott Ananian)
* ButtonSelectWidget: Add description and example (Kirsten Menger-Anderson)
* RadioOptionWidget: Add description (Kirsten Menger-Anderson)
* ButtonOptionWidget: Add description (Kirsten Menger-Anderson)
* RadioSelectWidget: Add description and example (Kirsten Menger-Anderson)
* Set proper spacing between interleaved FieldsetLayouts and FormLayouts (Bartosz Dziewoński)
* MenuOptionWidget: Add description (Kirsten Menger-Anderson)
* Unbreak form submission in JavaScript (Bartosz Dziewoński)
* MenuSelectWidget: Add description and mark protected method (Kirsten Menger-Anderson)
* TabIndexelement: Add description, example, and mark private method (Kirsten Menger-Anderson)
* Add "composer test" command to lint PHP files and run phpcs (Kunal Mehta)
* Update OOjs to v1.1.5 (James D. Forrester)


## v0.8.0 / 2015-02-18
* [BREAKING CHANGE] Make default distribution provide SVG with PNG fallback (Bartosz Dziewoński)

* [DEPRECATING CHANGE] TextInputWidget: Deprecate 'icon' and 'indicator' events (Bartosz Dziewoński)

* ButtonElement: add protected to event handlers (Kirsten Menger-Anderson)
* docs: Make @example documentation tag work (Roan Kattouw)
* TextInputWidget: Hide mixin components when unused (Ed Sanders)
* DropdownWidget: Simplify redundant code (Bartosz Dziewoński)
* Update PHP widgets for accessibility-related changes in JS widgets (Bartosz Dziewoński)
* TabIndexedElement: Allow tabIndex property to be null (C. Scott Ananian)
* ButtonElement: Add description (Kirsten Menger-Anderson)
* Add missing ButtonInputWidget.less and corresponding mixin (Bartosz Dziewoński)
* Various fixes to the PHP implementation (C. Scott Ananian)
* Use Array.isArray instead of $.isArray (C. Scott Ananian)
* TextInputWidget: Use margins for moving the label (Ed Sanders)
* DraggableGroupElement: Add description (Kirsten Menger-Anderson)
* demo: Add horizontal alignment test (Bartosz Dziewoński)
* build: Pass RuboCop, customize settings (Bartosz Dziewoński)
* Widget: Add description (Kirsten Menger-Anderson)
* ButtonInputWidget: Add description and example (Kirsten Menger-Anderson)
* Dialog: Add description and example (Kirsten Menger-Anderson)
* DraggableElement: Add description (Kirsten Menger-Anderson)
* docparser: Add support for 'protected' methods (Bartosz Dziewoński)
* testsuitegenerator: Only test every pair of config options rather than every triple (Bartosz Dziewoński)
* TextInputWidget: Don't add label position classes when there's no label (Bartosz Dziewoński)
* Update JS/PHP comparison test suite (Bartosz Dziewoński)
* tests: Fix the check for properties (Bartosz Dziewoński)
* TextInputWidget: Add missing LabelElement mixin documentation (Ed Sanders)
* Follow-up c762da42: fix ProcessDialog error handling (Roan Kattouw)
* MediaWiki Theme: Add focus state for frameless button (Prateek Saxena)
* TextInputWidget: Allow maxLength of 0 in JS (matching PHP) (Bartosz Dziewoński)
* TextInputWidget: Only put $label in the DOM if needed (Bartosz Dziewoński)
* MediaWiki Theme: Use white icons for disabled buttons (Bartosz Dziewoński)
* Follow-up 6a6bb90ab: Update CSS file path in eg-iframe.html (Roan Kattouw)
* Element: Add description (Kirsten Menger-Anderson)
* PHP: Remove redundant documentation for getInputElement() (Bartosz Dziewoński)
* Some documentation tweaks (Bartosz Dziewoński)
* FieldLayout: Add description (Kirsten Menger-Anderson)
* FieldLayout: Clean up and remove lies (Bartosz Dziewoński)
* FlaggedElement: Add description (Kirsten Menger-Anderson)
* PHP demo: Correct path to CSS files (Bartosz Dziewoński)
* MediaWikiTheme: Resynchronize PHP with JS (Bartosz Dziewoński)
* ButtonWidget: Rename nofollow config option to noFollow (C. Scott Ananian)
* GroupElement: Add description (Kirsten Menger-Anderson)
* IconElement: Add description (Kirsten Menger-Anderson)
* IconWidget: Add description and example (Kirsten Menger-Anderson)
* IndicatorElement: Add description (Kirsten Menger-Anderson)
* InputWidget: Add description (Kirsten Menger-Anderson)
* SelectWidget: Add description (Kirsten Menger-Anderson)
* MediaWiki Theme: Fix border width for frameless buttons' focus state (Prateek Saxena)
* Window: Add description (Kirsten Menger-Anderson)
* WindowManager: Add description (Kirsten Menger-Anderson)
* ButtonGroupWidget: Add description and example (Kirsten Menger-Anderson)
* DropdownWidget: Add @private to private methods (Kirsten Menger-Anderson)
* Refactor keyboard accessibility of SelectWidgets (Bartosz Dziewoński)
* ActionSet: Add description and example (Kirsten Menger-Anderson)
* ActionSet: Add @private to onActionChange method (Kirsten Menger-Anderson)
* ActionWidget: Add description (Kirsten Menger-Anderson)
* ActionSet: Add description for specialFlags property (Kirsten Menger-Anderson)
* DropdownWidget: Add description and example (Kirsten Menger-Anderson)
* ButtonWidget: Add example and link (Kirsten Menger-Anderson)
* IconElement: Add description and fix display of static properties (Kirsten Menger-Anderson)


## v0.7.0 / 2015-02-11
* [BREAKING CHANGE] Remove window isolation (Trevor Parscal)

* [DEPRECATING CHANGE] GridLayout should no longer be used, instead use MenuLayout (Bartosz Dziewoński)

* Fade in window frames separately from window overlays (Ed Sanders)
* Fix initialisation of window visible (Ed Sanders)
* SelectWidget: 'listbox' wrapper role, 'aria-selected' state on contents (Derk-Jan Hartman)
* Cleanup unreachable code from DraggableGroupElement (Moriel Schottlender)
* DraggableGroupElement: Unset dragged item when dropped (Moriel Schottlender)
* Remove inline spacing from ButtonWidget (Roan Kattouw)
* Make sure DraggableGroupElement supports button widgets (Moriel Schottlender)
* demo: Use properties instead of attributes for <link> (Timo Tijhof)
* Revert "Remove inline spacing from ButtonWidget" (Bartosz Dziewoński)
* ToggleSwitchWidget: Accessibility improvements (Bartosz Dziewoński)
* TextInputWidget: Add required attribute on the basis of required config (Prateek Saxena)
* DropdownInputWidget: Fix undefined variable in PHP (Bartosz Dziewoński)
* PHP demo: Just echo the autoload error message, don't trigger_error() (Bartosz Dziewoński)
* demo: Stop inline consoles from generating white space (Bartosz Dziewoński)
* demo: Reorder widgets into somewhat logical groupings (Bartosz Dziewoński)
* demo: Add button style showcase from PHP demo (Bartosz Dziewoński)
* PHP demo: Resynchronize with JS demo (Bartosz Dziewoński)
* Stop treating ApexTheme class unfairly and make it proper (Bartosz Dziewoński)
* PHP demo: Add Vector/Raster and MediaWiki/Apex controls (Bartosz Dziewoński)
* Delete unused src/themes/apex/{raster,vector}.less (Bartosz Dziewoński)
* {Checkbox,Radio}InputWidget: Add missing configuration initialization (Bartosz Dziewoński)
* MediaWiki theme: Use distribution's image type for backgrounds (Bartosz Dziewoński)
* tests: Just echo the autoload error message, don't trigger_error() (Bartosz Dziewoński)
* MediaWiki theme: Fix non-clickability of radios and checkboxes (Bartosz Dziewoński)
* Fix text input auto-height calculation (Ed Sanders)
* MediaWiki theme: Consistent toggle button 'active' state (Bartosz Dziewoński)
* RadioOptionWidget: Make it a <label/> (Bartosz Dziewoński)
* MediaWiki theme: Correct flagged primary button text color when pressed (Bartosz Dziewoński)
* FieldsetLayout: Tweak positioning of help icon (Bartosz Dziewoński)
* TextInputWidget: Use aria-hidden for extra autosize textarea (Prateek Saxena)
* Refactor clickability of buttons (Bartosz Dziewoński)
* Remove usage of this.$ and config.$ (Trevor Parscal)
* build: Bump various devDependencies (James D. Forrester)
* History: Fix date typos (James D. Forrester)
* TabIndexedElement: Actually allow tabIndex of -1 (Bartosz Dziewoński)
* ListToolGroup: Remove hack for jQuery's .show()/.hide() (Bartosz Dziewoński)
* PopupWidget: Set $clippable only once, correctly (Bartosz Dziewoński)
* TextInputMenuSelectWidget: Correct documentation (Bartosz Dziewoński)
* PopupElement: Correct documentation (Bartosz Dziewoński)
* MediaWiki Theme: Rename @active to @pressed in button mixins (Prateek Saxena)
* tools.less: Use distribution's image type and path for background (Prateek Saxena)
* MediaWiki Theme: Fix background color for disabled buttons (Prateek Saxena)
* MenuSelectWidget: Don't clobber other events when unbinding (Bartosz Dziewoński)
* MenuSelectWidget: Codify current behavior of Tab closing the menu (Bartosz Dziewoński)
* DropdownWidget, ComboBoxWidget: Make keyboard-accessible (Bartosz Dziewoński)
* MenuSelectWidget: Remove dead code (Bartosz Dziewoński)
* MediaWiki Theme: Rename active-* variables to pressed-* (Prateek Saxena)
* ButtonWidget: Better handle non-string parameters in setHref/setTarget (C. Scott Ananian)
* Make better use of 'scrollIntoViewOnSelect' in OptionWidgets (Bartosz Dziewoński)
* ButtonWidget: Add "nofollow" option (C. Scott Ananian)
* MediaWiki Theme: Rename @highlight to @active (Prateek Saxena)
* MediaWiki Theme: Use darker color for frameless buttons (Prateek Saxena)
* ButtonWidget: Add documentation (Kirsten Menger-Anderson)

## v0.6.6 / 2015-02-04
* TextInputWidget: Mostly revert "Don't try adjusting size when detached" (Bartosz Dziewoński)
* Use css class instead of jQuery .show()/hide()/toggle() (Moriel Schottlender)
* build: Use karma to v0.12.31 (Timo Tijhof)
* Use standard border colours for progress bars (Ed Sanders)
* Remove disabled elements from keyboard navigation flow (Derk-Jan Hartman)
* Fix BookletLayout#toggleOutline to use MenuLayout method (Ed Sanders)
* Use CSS overriding trick to support RTL in menu layouts (Ed Sanders)

## v0.6.5 / 2015-02-01
* Make BookletLayout inherit from MenuLayout instead of embedding a GridLayout (Ed Sanders)
* ButtonElement: Unbreak 'pressed' state (Bartosz Dziewoński)

## v0.6.4 / 2015-01-30
* InputWidget: Resynchronize our internal .value with DOM .value in #getValue (eranroz)
* demo: Remove nonexistent 'align' config option for a DropdownWidget (Bartosz Dziewoński)
* MediaWiki theme: Reduce size of checkboxes and radio buttons by 20% (Ed Sanders)
* MediaWiki theme: Remove SearchWidget's border now dialogs have outline (Ed Sanders)
* TextInputWidget: Accept 'maxLength' configuration option (Bartosz Dziewoński)
* MediaWiki Theme: Adjust ButtonSelectWidget, ButtonGroupWidget highlights (Prateek Saxena)
* Update OOjs to v1.1.4 and switch to the jQuery-optimised version (James D. Forrester)
* build: Bump devDependencies and fix up (James D. Forrester)
* Seriously work around the Chromium scrollbar bug for good this time (Bartosz Dziewoński)
* Introduce and use TabIndexedElement (Bartosz Dziewoński)
* AUTHORS: Update for the last six months' work (James D. Forrester)
* Set input direction in html prop rather than css rule (Moriel Schottlender)
* Introduce DropdownInputWidget (Bartosz Dziewoński)
* Remove the 'flash' feature from MenuSelectWidget and OptionWidget (Bartosz Dziewoński)
* InputWidget: Clarify documentation of #getInputElement (Bartosz Dziewoński)
* Make sure there is a page before focusing in BookletLayout (Moriel Schottlender)
* Provide default margins for buttons and other widgets (Bartosz Dziewoński)
* OptionWidget: Unbreak 'pressed' state (Bartosz Dziewoński)
* TextInputWidget: Remove superfluous role=textbox (Derk-Jan Hartman)
* MediaWiki theme: Tweak some more border-radii (Bartosz Dziewoński)
* Widget: Set aria-disabled too in #setDisabled (Derk-Jan Hartman)
* Twiddle things (Ed Sanders)
* Add help icon for FieldsetLayout (Moriel Schottlender)
* PopupButtonWidget: Set aria-haspopup to true (Prateek Saxena)
* ToggleButtonWidget: Set aria-pressed when changing value (Derk-Jan Hartman)
* ActionFieldLayout: Add 'nowrap' to the button (Moriel Schottlender)
* demo: Have multiline text in multiline widgets (Bartosz Dziewoński)
* Add inline labels to text widgets (Ed Sanders)
* TextInputWidget: Don't try adjusting size when detached (Bartosz Dziewoński)
* MediaWiki Theme: Adjust MenuOptionWidget selected state (Bartosz Dziewoński)
* ToggleWidget: Use aria-checked (Prateek Saxena)
* MediaWiki theme: Unbreak disabled buttons (Bartosz Dziewoński)
* MediaWiki theme: Fix background issues with disabled buttons (Roan Kattouw)
* ButtonOptionWidget: Add the TabIndexedElement mixin (Derk-Jan Hartman)
* Remove labelPosition check (Ed Sanders)
* Fix opening/closing animation on windows (Roan Kattouw)
* Add MenuLayout (Ed Sanders)
* Add simpler window#updateSize API (Ed Sanders)

## v0.6.3 / 2015-01-14
* [DEPRECATING CHANGE] LookupInputWidget should no longer be used, instead use LookupElement

* MediaWiki Theme: Adjust toolbar popups' border and shadows (Bartosz Dziewoński)
* MediaWiki Theme: Don't use 'box-shadow' to produce thin grey lines in dialogs (Bartosz Dziewoński)
* demo: Switch the default theme from 'Apex' to 'MediaWiki' (Ricordisamoa)
* Toolbar: Update #initialize docs (Bartosz Dziewoński)
* Add an ActionFieldLayout (Moriel Schottlender)
* dialog: Provide a 'larger' size for things for which 'large' isn't enough (James D. Forrester)
* Synchronize ComboBoxWidget and DropdownWidget styles (Bartosz Dziewoński)
* Replace old&busted LookupInputWidget with new&hot LookupElement (Bartosz Dziewoński)

## v0.6.2 / 2015-01-09
* WindowManager#removeWindows: Documentation fix (Ed Sanders)
* Clear windows when destroying window manager (Ed Sanders)
* MediaWiki theme: Slightly reduce size of indicator arrows (Ed Sanders)
* MediaWiki Theme: Remove text-shadow on  button (Prateek Saxena)
* MediaWiki Theme: Fix focus state for buttons (Prateek Saxena)
* MediaWiki Theme: Fix disabled state of buttons (Prateek Saxena)
* MediaWiki Theme: Fix overlap between hover and active states (Prateek Saxena)
* Make @anchor-size a less variable and calculate borders from it (Ed Sanders)
* PHP LabelElement: Actually allow non-plaintext labels (Bartosz Dziewoński)
* MediaWiki Theme: Add state change transition to checkbox (Prateek Saxena)
* Synchronize @abstract class annotations between PHP and JS (Bartosz Dziewoński)
* Add 'lock' icon (Trevor Parscal)
* Don't test abstract classes (Bartosz Dziewoński)
* Element: Add support for 'id' config option (Bartosz Dziewoński)
* testsuitegenerator.rb: Handle inheritance chains (Bartosz Dziewoński)
* TextInputWidget: Add support for 'autofocus' config option (Bartosz Dziewoński)
* tests: Don't overwrite 'id' attribute (Bartosz Dziewoński)

## v0.6.1 / 2015-01-05
* Remove use of Math.round() for offset and position pixel values (Bartosz Dziewoński)
* Update JSPHP-suite.json (Bartosz Dziewoński)
* ButtonElement: Inherit all 'font' styles, not only 'font-family' (Bartosz Dziewoński)
* FieldsetLayout: Shrink size of label and bump the weight to compensate (James D. Forrester)
* IndicatorElement: Fix 'indicatorTitle' config option (Bartosz Dziewoński)
* Error: Unmark as @abstract (Bartosz Dziewoński)
* build: Update various devDependencies (James D. Forrester)
* readme: Update badges (Timo Tijhof)
* readme: No need to put the same heading in twice (James D. Forrester)

## v0.6.0 / 2014-12-16
* [BREAKING CHANGE] PopupToolGroup and friends: Pay off technical debt (Bartosz Dziewoński)
* ButtonGroupWidget: Remove weird margin-bottom: -1px; from theme styles (Bartosz Dziewoński)
* Prevent parent window scroll in modal mode using overflow hidden (Ed Sanders)
* MediaWiki theme: RadioInputWidget tweaks (Bartosz Dziewoński)
* ClippableElement: Handle clipping with left edge (Bartosz Dziewoński)
* Sprinkle some child selectors around in BookletLayout styles (Roan Kattouw)

## v0.5.0 / 2014-12-12
* [BREAKING CHANGE] FieldLayout: Handle 'inline' alignment better (Bartosz Dziewoński)
* [BREAKING CHANGE] Split primary flag into primary and progressive (Trevor Parscal)
* [BREAKING CHANGE] CheckboxInputWidget: Allow setting HTML 'value' attribute (Bartosz Dziewoński)
* MediaWiki theme: checkbox: Fix states according to spec (Prateek Saxena)
* MediaWiki theme: Add radio buttons (Prateek Saxena)
* MediaWiki theme: Use gray instead of blue for select and highlight (Trevor Parscal)
* MediaWiki theme: Copy .theme-oo-ui-outline{Controls,Option}Widget from Apex (Bartosz Dziewoński)
* MediaWiki theme: Add thematic border to the bottom of toolbars (Bartosz Dziewoński)
* MediaWiki theme: Extract @active-color variable (Bartosz Dziewoński)
* MediaWiki theme: Add hover state to listToolGroup (Trevor Parscal)
* MediaWiki theme: Add state transition to radio buttons (Prateek Saxena)
* MediaWiki theme: Make button sizes match Apex (Trevor Parscal)
* MediaWiki theme: Improve search widget styling (Trevor Parscal)
* build: Use String#slice instead of discouraged String#substr (Timo Tijhof)
* Element.getClosestScrollableContainer: Use 'body' or 'documentElement' based on browser (Prateek Saxena)
* testsuitegenerator: Actually filter out non-unique combinations (Bartosz Dziewoński)
* Fix primary button description text (Niklas Laxström)
* Give non-isolated windows a tabIndex for selection holding (Ed Sanders)
* Call .off() correctly in setButtonElement() (Roan Kattouw)
* RadioInputWidget: Remove documentation lies (Bartosz Dziewoński)
* Don't set line-height of unset button labels (Bartosz Dziewoński)
* Temporarily remove position:absolute on body when resizing (Ed Sanders)
* Kill the escape keydown event after handling a window close (Ed Sanders)
* PopupWidget: Remove box-shadow rule that generates invisible shadow (Bartosz Dziewoński)
* ClippableElement: 7 is a better number than 10 (Bartosz Dziewoński)
* FieldLayout: In styles, don't assume that label is given (Bartosz Dziewoński)
* TextInputWidget: Set vertical-align: middle, like buttons (Bartosz Dziewoński)
* FieldLayout: Synchronise PHP with JS (Bartosz Dziewoński)
* FieldLayout: Use <label> for this.$body, not this.$element (Bartosz Dziewoński)
* Account for <html> rather than <body> being the scrollable root in Chrome (Bartosz Dziewoński)
* GridLayout: Don't round to 1% (Bartosz Dziewoński)
* README.md: Drop localisation update auto-commits from release notes (James D. Forrester)
* README.md: Point to Phabricator, not Bugzilla (James D. Forrester)

## v0.4.0 / 2014-12-05
* [BREAKING CHANGE] Remove deprecated Element#onDOMEvent and #offDOMEvent (Bartosz Dziewoński)
* [BREAKING CHANGE] Make a number of Element getters static (Bartosz Dziewoński)
* [BREAKING CHANGE] Rename BookletLayout#getPageName → #getCurrentPageName (Bartosz Dziewoński)
* demo: Don't put buttons in a FieldsetLayout without FieldLayouts around them (Bartosz Dziewoński)
* IconElement: Add missing #getIconTitle (Bartosz Dziewoński)
* SelectWidget: Rewrite #getRelativeSelectableItem (Bartosz Dziewoński)
* Follow-up I859ff276e: Add cursor files to repo (Trevor Parscal)

## v0.3.0 / 2014-12-04
* [BREAKING CHANGE] ButtonWidget: Don't default 'target' to 'blank' (Bartosz Dziewoński)
* InputWidget: Update DOM value before firing 'change' event (Bartosz Dziewoński)
* TextInputWidget: Reuse a single clone instead of appending and removing new ones (Prateek Saxena)
* build: Have grunt watch run 'quick-build' instead of 'build' (Prateek Saxena)
* MediaWiki Theme: Reduce indentation in theme-oo-ui-checkboxInputWidget (Prateek Saxena)
* Adding DraggableGroupElement and DraggableElement mixins (Moriel Schottlender)
* Remove window even if closing promise rejects (Ed Sanders)
* Fix lies in documentation (Trevor Parscal)

## v0.2.4 / 2014-12-02
* TextInputWidget: Use .css( propertyName, value ) instead of .css( properties) for single property (Prateek Saxena)
* TextInputWidget: Stop adjustSize if the value of the textarea is the same (Prateek Saxena)
* Window: Avoid height flickering when resizing dialogs (Bartosz Dziewoński)
* MessageDialog: Fit actions again when the dialog is resized (Bartosz Dziewoński)

## v0.2.3 / 2014-11-26
* Dialog: Only handle escape events when open (Alex Monk)
* Pass original event with TextInputWidget#enter (Ed Sanders)
* Add missing documentation to ToolFactory (Ed Sanders)
* BookletLayout: Make #focus not crash when there are zero pages or when there is no outline (Roan Kattouw)
* Window: Disable transitions when changing window height to calculate content height (Bartosz Dziewoński)
* MessageDialog: Add Firefox hack for scrollbars when sizing dialogs (Bartosz Dziewoński)
* Fix RadioOptionWidget demos (Trevor Parscal)
* RadioOptionWidget: Remove lies from documentation (Trevor Parscal)
* RadioOptionWidget: Increase rule specificity to match OptionWidget (Bartosz Dziewoński)
* MessageDialog: Actually correctly calculate and set height (Bartosz Dziewoński)

## v0.2.2 / 2014-11-25
* LabelWidget: Add missing documentation for input configuration option (Ed Sanders)
* MessageDialog: Fit actions after updating window size, not before (Bartosz Dziewoński)
* MessageDialog: Use the right superclass (Bartosz Dziewoński)
* ProcessDialog, MessageDialog: Support iconed actions (Bartosz Dziewoński)
* Remove padding from undecorated option widgets (Ed Sanders)
* build: Add .npmignore (Timo Tijhof)

## v0.2.1 / 2014-11-24
* Start the window opening transition before ready, not after (Roan Kattouw)
* Add focus method to BookletLayout (Roan Kattouw)
* Add missing History.md file now we're a proper repo (James D. Forrester)
* README.md: Update introduction, badges, advice (James D. Forrester)
* LabelElement: Kill inline styles (Bartosz Dziewoński)
* composer: Rename package to 'oojs-ui' and require php 5.3.3 (Timo Tijhof)

## v0.2.0 / 2014-11-17
* First versioned release

## v0.1.0 / 2013-11-13
* Initial export of repo
