# kind-of [![NPM version](https://badge.fury.io/js/kind-of.svg)](http://badge.fury.io/js/kind-of)  [![Build Status](https://travis-ci.org/jonschlinkert/kind-of.svg)](https://travis-ci.org/jonschlinkert/kind-of) 

> Get the native type of a value.

## Install with [npm](npmjs.org)

```bash
npm i kind-of --save
```

## Usage

```js
var kindOf = require('kind-of');

kindOf(undefined);
//=> 'undefined'

kindOf(null);
//=> 'null'

kindOf(true);
//=> 'boolean'

kindOf(false);
//=> 'boolean'

kindOf(new Boolean(true));
//=> 'boolean'

kindOf(new Buffer(''));
//=> 'buffer'

kindOf(42);
//=> 'number'

kindOf(new Number(42));
//=> 'number'

kindOf("string");
//=> 'string'

kindOf(arguments);
//=> 'arguments'

kindOf({});
//=> 'object'

kindOf(new Test());
//=> 'object'

kindOf(new Date());
//=> 'date'

kindOf([]);
//=> 'array'

kindOf([1, 2, 3]);
//=> 'array'

kindOf(new Array());
//=> 'array'

kindOf(/[\s\S]+/);
//=> 'regexp'

kindOf(new RegExp('^' + 'foo$'));
//=> 'regexp'

kindOf(function () {});
//=> 'function'

kindOf(new Function());
//=> 'function'
```


## Run tests

Install dev dependencies:

```bash
npm i -d && npm test
```

## Benchmarks

Benchmarked against [typeof](http://github.com/CodingFu/typeof) and [type-of](https://github.com/ForbesLindesay/type-of).

```bash
#1: array.js
  kind-of x 21,578,944 ops/sec ±1.01% (97 runs sampled)
  (lib) type-of x 4,593,840 ops/sec ±0.76% (92 runs sampled)
  (lib) typeof x 5,786,776 ops/sec ±0.71% (97 runs sampled)

#2: boolean.js
  kind-of x 25,189,600 ops/sec ±0.60% (97 runs sampled)
  (lib) type-of x 2,751,076 ops/sec ±0.78% (100 runs sampled)
  (lib) typeof x 4,390,312 ops/sec ±0.61% (99 runs sampled)

#3: date.js
  kind-of x 8,862,303 ops/sec ±0.77% (99 runs sampled)
  (lib) type-of x 6,239,662 ops/sec ±0.67% (94 runs sampled)
  (lib) typeof x 6,180,922 ops/sec ±0.59% (97 runs sampled)

#4: function.js
  kind-of x 19,685,336 ops/sec ±1.67% (95 runs sampled)
  (lib) type-of x 6,648,551 ops/sec ±0.93% (95 runs sampled)
  (lib) typeof x 6,631,967 ops/sec ±1.05% (92 runs sampled)

#5: null.js
  kind-of x 24,155,010 ops/sec ±0.95% (91 runs sampled)
  (lib) type-of x 12,854,583 ops/sec ±0.69% (94 runs sampled)
  (lib) typeof x 8,182,952 ops/sec ±0.48% (99 runs sampled)

#6: number.js
  kind-of x 20,993,521 ops/sec ±0.37% (98 runs sampled)
  (lib) type-of x 2,112,716 ops/sec ±0.73% (96 runs sampled)
  (lib) typeof x 4,492,943 ops/sec ±0.68% (96 runs sampled)

#7: object.js
  kind-of x 3,686,169 ops/sec ±0.85% (96 runs sampled)
  (lib) type-of x 3,661,833 ops/sec ±0.73% (98 runs sampled)
  (lib) typeof x 6,159,847 ops/sec ±0.72% (98 runs sampled)

#8: regex.js
  kind-of x 10,780,535 ops/sec ±0.75% (95 runs sampled)
  (lib) type-of x 5,380,781 ops/sec ±0.83% (92 runs sampled)
  (lib) typeof x 5,852,558 ops/sec ±0.67% (95 runs sampled)

#9: string.js
  kind-of x 19,713,570 ops/sec ±0.69% (91 runs sampled)
  (lib) type-of x 4,017,753 ops/sec ±0.85% (98 runs sampled)
  (lib) typeof x 4,370,984 ops/sec ±0.62% (100 runs sampled)

#10: undef.js
  kind-of x 23,250,387 ops/sec ±0.88% (91 runs sampled)
  (lib) type-of x 13,725,183 ops/sec ±0.62% (91 runs sampled)
  (lib) typeof x 20,549,334 ops/sec ±0.74% (97 runs sampled)
```

## Author

**Jon Schlinkert**
 
+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert) 

## License
Copyright (c) 2014-2015 Jon Schlinkert  
Released under the MIT license

***

_This file was generated by [verb](https://github.com/assemble/verb) on February 09, 2015._