/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.plugin;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeApplication;
import com.eteks.sweethome3d.model.Library;
import com.eteks.sweethome3d.model.RecorderException;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.plugin.Plugin;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.undo.UndoableEditSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager {
    public static final String PLUGIN_LIBRARY_TYPE = "Plugin";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String CLASS = "class";
    private static final String DESCRIPTION = "description";
    private static final String VERSION = "version";
    private static final String LICENSE = "license";
    private static final String PROVIDER = "provider";
    private static final String APPLICATION_MINIMUM_VERSION = "applicationMinimumVersion";
    private static final String JAVA_MINIMUM_VERSION = "javaMinimumVersion";
    private static final String APPLICATION_PLUGIN_FAMILY = "ApplicationPlugin";
    private static final String DEFAULT_APPLICATION_PLUGIN_PROPERTIES_FILE = "ApplicationPlugin.properties";
    private final File[] pluginFolders;
    private final Map<String, PluginLibrary> pluginLibraries = new TreeMap<String, PluginLibrary>();
    private final Map<Home, List<Plugin>> homePlugins = new LinkedHashMap<Home, List<Plugin>>();

    public PluginManager(File file) {
        this(new File[]{file});
    }

    public PluginManager(File[] fileArray) {
        this.pluginFolders = fileArray;
        if (fileArray != null) {
            for (File file : fileArray) {
                File[] fileArray2 = file.listFiles(new FileFilter(){

                    public boolean accept(File file) {
                        return file.isFile();
                    }
                });
                if (fileArray2 == null) continue;
                Arrays.sort(fileArray2, Collections.reverseOrder(OperatingSystem.getFileVersionComparator()));
                for (File file2 : fileArray2) {
                    try {
                        this.loadPlugins(file2.toURI().toURL(), file2.getAbsolutePath());
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public PluginManager(URL[] uRLArray) {
        this.pluginFolders = null;
        for (URL uRL : uRLArray) {
            this.loadPlugins(uRL, uRL.toExternalForm());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPlugins(URL uRL, String string) {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(uRL.openStream());
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                int n = string2.lastIndexOf(DEFAULT_APPLICATION_PLUGIN_PROPERTIES_FILE);
                if (n == -1 || n != 0 && string2.charAt(n - 1) != '/') continue;
                try {
                    String string3 = string2.substring(0, n);
                    string3 = string3 + APPLICATION_PLUGIN_FAMILY;
                    URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{uRL}, this.getClass().getClassLoader());
                    this.readPlugin(ResourceBundle.getBundle(string3, Locale.getDefault(), uRLClassLoader), string, "jar:" + uRL.toString() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20"), uRLClassLoader);
                }
                catch (MissingResourceException missingResourceException) {}
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readPlugin(ResourceBundle resourceBundle, String string, String string2, ClassLoader classLoader) {
        try {
            String string3 = resourceBundle.getString(NAME);
            String string4 = resourceBundle.getString(JAVA_MINIMUM_VERSION);
            if (!OperatingSystem.isJavaVersionGreaterOrEqual(string4)) {
                System.err.println("Invalid plug-in " + string2 + ":\n" + "Not compatible Java version " + System.getProperty("java.version"));
                return;
            }
            String string5 = resourceBundle.getString(APPLICATION_MINIMUM_VERSION);
            if (!this.isApplicationVersionSuperiorTo(string5)) {
                System.err.println("Invalid plug-in " + string2 + ":\n" + "Not compatible application version");
                return;
            }
            String string6 = resourceBundle.getString(CLASS);
            Class<? extends Plugin> clazz = this.getPluginClass(classLoader, string6);
            String string7 = this.getOptionalString(resourceBundle, ID, null);
            String string8 = resourceBundle.getString(DESCRIPTION);
            String string9 = resourceBundle.getString(VERSION);
            String string10 = resourceBundle.getString(LICENSE);
            String string11 = resourceBundle.getString(PROVIDER);
            if (this.pluginLibraries.get(string3) == null) {
                this.pluginLibraries.put(string3, new PluginLibrary(string, string7, string3, string8, string9, string10, string11, clazz, classLoader));
            }
        }
        catch (MissingResourceException missingResourceException) {
            System.err.println("Invalid plug-in " + string2 + ":\n" + missingResourceException.getMessage());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println("Invalid plug-in " + string2 + ":\n" + illegalArgumentException.getMessage());
        }
    }

    private String getOptionalString(ResourceBundle resourceBundle, String string, String string2) {
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    private boolean isApplicationVersionSuperiorTo(String string) {
        String[] stringArray = string.split("\\.|_|\\s");
        if (stringArray.length >= 1) {
            try {
                int n = 5;
                int n2 = Integer.parseInt(stringArray[0]);
                if (n > n2) {
                    return true;
                }
                if (n == n2 && stringArray.length >= 2) {
                    return 0L >= (long)Integer.parseInt(stringArray[1]);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private Class<? extends Plugin> getPluginClass(ClassLoader classLoader, String string) {
        try {
            Class<?> clazz = classLoader.loadClass(string);
            if (!Plugin.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(string + " not a subclass of " + Plugin.class.getName());
            }
            if (Modifier.isAbstract(clazz.getModifiers()) || !Modifier.isPublic(clazz.getModifiers())) {
                throw new IllegalArgumentException(string + " not a public static class");
            }
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException(string + " constructor not accessible");
            }
            return clazz;
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new IllegalArgumentException(noClassDefFoundError.getMessage(), noClassDefFoundError);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(noSuchMethodException.getMessage(), noSuchMethodException);
        }
    }

    public List<Library> getPluginLibraries() {
        return Collections.unmodifiableList(new ArrayList<PluginLibrary>(this.pluginLibraries.values()));
    }

    public List<Plugin> getPlugins(HomeApplication homeApplication, Home home, UserPreferences userPreferences, UndoableEditSupport undoableEditSupport) {
        return this.getPlugins(homeApplication, home, userPreferences, null, undoableEditSupport);
    }

    List<Plugin> getPlugins(final HomeApplication homeApplication, final Home home, UserPreferences userPreferences, HomeController homeController, UndoableEditSupport undoableEditSupport) {
        if (homeApplication.getHomes().contains(home)) {
            List<Plugin> list = this.homePlugins.get(home);
            if (list == null) {
                list = new ArrayList<Plugin>();
                for (PluginLibrary pluginLibrary : this.pluginLibraries.values()) {
                    try {
                        Plugin plugin = pluginLibrary.getPluginClass().newInstance();
                        plugin.setPluginClassLoader(pluginLibrary.getPluginClassLoader());
                        plugin.setName(pluginLibrary.getName());
                        plugin.setDescription(pluginLibrary.getDescription());
                        plugin.setVersion(pluginLibrary.getVersion());
                        plugin.setLicense(pluginLibrary.getLicense());
                        plugin.setProvider(pluginLibrary.getProvider());
                        plugin.setUserPreferences(userPreferences);
                        plugin.setHome(home);
                        plugin.setHomeController(homeController);
                        plugin.setUndoableEditSupport(undoableEditSupport);
                        list.add(plugin);
                    }
                    catch (InstantiationException instantiationException) {
                        throw new RuntimeException(instantiationException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new RuntimeException(illegalAccessException);
                    }
                }
                list = Collections.unmodifiableList(list);
                this.homePlugins.put(home, list);
                homeApplication.addHomesListener(new CollectionListener<Home>(){

                    @Override
                    public void collectionChanged(CollectionEvent<Home> collectionEvent) {
                        if (collectionEvent.getType() == CollectionEvent.Type.DELETE && collectionEvent.getItem() == home) {
                            for (Plugin plugin : (List)PluginManager.this.homePlugins.get(home)) {
                                plugin.destroy();
                            }
                            PluginManager.this.homePlugins.remove(home);
                            homeApplication.removeHomesListener(this);
                        }
                    }
                });
            }
            return list;
        }
        return Collections.emptyList();
    }

    public boolean pluginExists(String string) throws RecorderException {
        if (this.pluginFolders == null || this.pluginFolders.length == 0) {
            throw new RecorderException("Can't access to plugins folder");
        }
        String string2 = new File(string).getName();
        return new File(this.pluginFolders[0], string2).exists();
    }

    public void deletePlugins(List<Library> list) throws RecorderException {
        for (Library library : list) {
            Iterator<Map.Entry<String, PluginLibrary>> iterator = this.pluginLibraries.entrySet().iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().getValue().getLocation();
                if (!string.equals(library.getLocation())) continue;
                if (new File(string).exists() && !new File(string).delete()) {
                    throw new RecorderException("Couldn't delete file " + library.getLocation());
                }
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPlugin(String string) throws RecorderException {
        try {
            if (this.pluginFolders == null || this.pluginFolders.length == 0) {
                throw new RecorderException("Can't access to plugins folder");
            }
            String string2 = new File(string).getName();
            File file = new File(this.pluginFolders[0], string2);
            InputStream inputStream = null;
            OutputStream outputStream = null;
            try {
                int n;
                inputStream = new BufferedInputStream(new FileInputStream(string));
                this.pluginFolders[0].mkdirs();
                outputStream = new FileOutputStream(file);
                byte[] byArray = new byte[8192];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new RecorderException("Can't write " + string + " in plugins folder", iOException);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PluginLibrary
    implements Library {
        private final String location;
        private final String name;
        private final String id;
        private final String description;
        private final String version;
        private final String license;
        private final String provider;
        private final Class<? extends Plugin> pluginClass;
        private final ClassLoader pluginClassLoader;

        public PluginLibrary(String string, String string2, String string3, String string4, String string5, String string6, String string7, Class<? extends Plugin> clazz, ClassLoader classLoader) {
            this.location = string;
            this.id = string2;
            this.name = string3;
            this.description = string4;
            this.version = string5;
            this.license = string6;
            this.provider = string7;
            this.pluginClass = clazz;
            this.pluginClassLoader = classLoader;
        }

        public Class<? extends Plugin> getPluginClass() {
            return this.pluginClass;
        }

        public ClassLoader getPluginClassLoader() {
            return this.pluginClassLoader;
        }

        @Override
        public String getType() {
            return PluginManager.PLUGIN_LIBRARY_TYPE;
        }

        @Override
        public String getLocation() {
            return this.location;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getLicense() {
            return this.license;
        }

        @Override
        public String getProvider() {
            return this.provider;
        }
    }
}

