/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.report;

import java.io.File;
import java.text.MessageFormat;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionLoader;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.report.ReportGenerator;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.XmlReporterExtension;
import org.zaproxy.zap.utils.DesktopUtils;
import org.zaproxy.zap.utils.XMLStringUtil;
import org.zaproxy.zap.view.ScanPanel;
import org.zaproxy.zap.view.widgets.WritableFileChooser;

public class ReportLastScan {
    private Logger logger = Logger.getLogger(ReportLastScan.class);
    private static final String HTM_FILE_EXTENSION = ".htm";
    private static final String HTML_FILE_EXTENSION = ".html";
    private static final String XML_FILE_EXTENSION = ".xml";

    public File generate(String string, Model model, String string2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder(500);
        this.generate(stringBuilder, model);
        return ReportGenerator.stringToHtml(stringBuilder.toString(), string2, string);
    }

    public void generate(StringBuilder stringBuilder, Model model) throws Exception {
        stringBuilder.append("<?xml version=\"1.0\"?>");
        stringBuilder.append("<OWASPZAPReport version=\"").append(Constant.PROGRAM_VERSION).append("\" generated=\"").append(ReportGenerator.getCurrentDateTimeString()).append("\">\r\n");
        this.siteXML(stringBuilder);
        stringBuilder.append("</OWASPZAPReport>");
    }

    private void siteXML(StringBuilder stringBuilder) {
        SiteMap siteMap = Model.getSingleton().getSession().getSiteTree();
        SiteNode siteNode = (SiteNode)siteMap.getRoot();
        int n = siteNode.getChildCount();
        for (int i = 0; i < n; ++i) {
            SiteNode siteNode2 = (SiteNode)siteNode.getChildAt(i);
            String string = ScanPanel.cleanSiteName(siteNode2, true);
            String[] stringArray = string.split(":");
            boolean bl = siteNode2.getNodeName().startsWith("https");
            String string2 = "<site name=\"" + XMLStringUtil.escapeControlChrs(siteNode2.getNodeName()) + "\"" + " host=\"" + XMLStringUtil.escapeControlChrs(stringArray[0]) + "\"" + " port=\"" + XMLStringUtil.escapeControlChrs(stringArray[1]) + "\"" + " ssl=\"" + String.valueOf(bl) + "\"" + ">";
            StringBuilder stringBuilder2 = this.getExtensionsXML(siteNode2);
            String string3 = "</site>";
            stringBuilder.append(string2);
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append(string3);
        }
    }

    public StringBuilder getExtensionsXML(SiteNode siteNode) {
        StringBuilder stringBuilder = new StringBuilder();
        ExtensionLoader extensionLoader = Control.getSingleton().getExtensionLoader();
        int n = extensionLoader.getExtensionCount();
        for (int i = 0; i < n; ++i) {
            Extension extension = extensionLoader.getExtension(i);
            if (!(extension instanceof XmlReporterExtension)) continue;
            stringBuilder.append(((XmlReporterExtension)((Object)extension)).getXml(siteNode));
        }
        return stringBuilder;
    }

    public void generateReport(ViewDelegate viewDelegate, Model model, ReportType reportType) {
        final ReportType reportType2 = reportType == null ? ReportType.HTML : reportType;
        try {
            WritableFileChooser writableFileChooser = new WritableFileChooser(Model.getSingleton().getOptionsParam().getUserDirectory());
            writableFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        return true;
                    }
                    if (file.isFile()) {
                        String string = file.getName().toLowerCase(Locale.ROOT);
                        switch (reportType2) {
                            case XML: {
                                return string.endsWith(ReportLastScan.XML_FILE_EXTENSION);
                            }
                        }
                        return string.endsWith(ReportLastScan.HTM_FILE_EXTENSION) || string.endsWith(ReportLastScan.HTML_FILE_EXTENSION);
                    }
                    return false;
                }

                @Override
                public String getDescription() {
                    switch (reportType2) {
                        case XML: {
                            return Constant.messages.getString("file.format.xml");
                        }
                    }
                    return Constant.messages.getString("file.format.html");
                }
            });
            String string = "";
            String string2 = "";
            switch (reportType2) {
                case XML: {
                    string2 = XML_FILE_EXTENSION;
                    string = Constant.getZapInstall() + "/xml/report.xml.xsl";
                    break;
                }
                default: {
                    string2 = HTML_FILE_EXTENSION;
                    string = Constant.getZapInstall() + "/xml/report.html.xsl";
                }
            }
            writableFileChooser.setSelectedFile(new File(string2));
            int n = writableFileChooser.showSaveDialog(View.getSingleton().getMainFrame());
            File file = null;
            if (n == 0) {
                file = writableFileChooser.getSelectedFile();
                File file2 = this.generate(file.getAbsolutePath(), model, string);
                if (file2 == null) {
                    viewDelegate.showMessageDialog(MessageFormat.format(Constant.messages.getString("report.unknown.error"), file.getAbsolutePath()));
                    return;
                }
                try {
                    DesktopUtils.openUrlInBrowser(file2.toURI());
                }
                catch (Exception exception) {
                    this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    viewDelegate.showMessageDialog(MessageFormat.format(Constant.messages.getString("report.complete.warning"), file2.getAbsolutePath()));
                }
            }
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            viewDelegate.showWarningDialog(Constant.messages.getString("report.unexpected.error"));
        }
    }

    @Deprecated
    public void generateHtml(ViewDelegate viewDelegate, Model model) {
        this.generateReport(viewDelegate, model, ReportType.HTML);
    }

    @Deprecated
    public void generateXml(ViewDelegate viewDelegate, Model model) {
        this.generateReport(viewDelegate, model, ReportType.XML);
    }

    public static enum ReportType {
        HTML,
        XML;

    }
}

