/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.parosproxy.paros.model.FileCopier;

public class FileCopierUnitTest {
    private FileCopier fileCopier;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.fileCopier = new FileCopier();
        this.tempFolder.create();
    }

    @Test
    public void shouldCopyFileViaPreJava7IO() throws Exception {
        File file = this.tempFolder.newFile();
        FileUtils.writeStringToFile((File)file, (String)"Test");
        File file2 = this.tempFolder.newFile();
        this.fileCopier.copyLegacy(file, file2);
        Assert.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
    }

    @Test
    public void shouldCopyFileViaNIO() throws Exception {
        File file = this.tempFolder.newFile();
        FileUtils.writeStringToFile((File)file, (String)"Test");
        File file2 = this.tempFolder.newFile();
        this.fileCopier.copyNIO(file, file2);
        Assert.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
    }

    @Test
    public void shouldFallbackToPreJava7IOIfNIOFails() throws Exception {
        FileCopier fileCopier = (FileCopier)Mockito.spy((Object)this.fileCopier);
        ((FileCopier)Mockito.doThrow(IOException.class).when((Object)fileCopier)).copyNIO((File)Matchers.any(File.class), (File)Matchers.any(File.class));
        File file = this.tempFolder.newFile();
        FileUtils.writeStringToFile((File)file, (String)"Test");
        File file2 = this.tempFolder.newFile();
        fileCopier.copy(file, file2);
        Assert.assertTrue((boolean)FileUtils.contentEquals((File)file, (File)file2));
    }
}

