/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.log4j.Logger;

public abstract class HttpBody {
    private static final Logger log = Logger.getLogger(HttpBody.class);
    public static final String DEFAULT_CHARSET = "8859_1";
    private byte[] body;
    private int pos;
    private String cachedString;
    private String charset = "8859_1";
    protected boolean isChangedCharset;

    public HttpBody() {
        this.body = new byte[0];
    }

    public HttpBody(int n) {
        if (n > 0) {
            if (n > 128000) {
                n = 128000;
            }
            this.body = new byte[n];
        } else {
            this.body = new byte[0];
        }
        this.pos = 0;
    }

    public HttpBody(String string) {
        this.setBody(string);
    }

    public void setBody(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.cachedString = null;
        this.body = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.body, 0, byArray.length);
        this.pos = this.body.length;
    }

    public void setBody(String string) {
        if (string == null) {
            return;
        }
        this.cachedString = null;
        try {
            this.body = string.getBytes(this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
        this.pos = this.body.length;
    }

    public void append(byte[] byArray, int n) {
        if (byArray == null) {
            return;
        }
        if (this.pos + n > this.body.length) {
            byte[] byArray2 = new byte[this.pos + n];
            System.arraycopy(this.body, 0, byArray2, 0, this.pos);
            this.body = byArray2;
        }
        System.arraycopy(byArray, 0, this.body, this.pos, n);
        this.pos += n;
        this.cachedString = null;
    }

    public void append(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        this.append(byArray, byArray.length);
    }

    public void append(String string) {
        if (string == null) {
            return;
        }
        try {
            this.append(string.getBytes(this.charset));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
        }
    }

    public String toString() {
        if (this.cachedString != null) {
            return this.cachedString;
        }
        this.cachedString = this.createCachedString(this.charset);
        return this.cachedString;
    }

    protected String createCachedString(String string) {
        String string2 = "";
        try {
            if (this.isChangedCharset) {
                string2 = new String(this.getBytes(), string);
                this.isChangedCharset = false;
            } else {
                string2 = new String(this.getBytes(), DEFAULT_CHARSET);
                this.isChangedCharset = false;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            log.error((Object)unsupportedEncodingException.getMessage(), (Throwable)unsupportedEncodingException);
            try {
                string2 = new String(this.getBytes(), DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException2) {
                log.error((Object)unsupportedEncodingException2.getMessage(), (Throwable)unsupportedEncodingException2);
            }
        }
        return string2;
    }

    public byte[] getBytes() {
        return this.body;
    }

    public int length() {
        return this.body.length;
    }

    public void setLength(int n) {
        if (this.body.length != n) {
            this.pos = Math.min(this.body.length, n);
            byte[] byArray = new byte[n];
            System.arraycopy(this.body, 0, byArray, 0, n);
            this.body = byArray;
            this.cachedString = null;
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        if (string == null || string.equals("") || string.equalsIgnoreCase(this.charset)) {
            return;
        }
        this.charset = string;
        this.isChangedCharset = true;
        this.cachedString = null;
    }

    public int hashCode() {
        return 31 + Arrays.hashCode(this.body);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HttpBody httpBody = (HttpBody)object;
        return Arrays.equals(this.body, httpBody.body);
    }
}

