/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap;

import com.apple.eawt.Application;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.option.OptionsParamView;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.ZapBootstrap;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnLoader;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;
import org.zaproxy.zap.model.SessionUtils;
import org.zaproxy.zap.utils.FontUtils;
import org.zaproxy.zap.utils.LocaleUtils;
import org.zaproxy.zap.view.LicenseFrame;
import org.zaproxy.zap.view.LocaleDialog;
import org.zaproxy.zap.view.ProxyDialog;
import org.zaproxy.zap.view.osxhandlers.OSXAboutHandler;
import org.zaproxy.zap.view.osxhandlers.OSXPreferencesHandler;
import org.zaproxy.zap.view.osxhandlers.OSXQuitHandler;

public class GuiBootstrap
extends ZapBootstrap {
    private final Logger logger = Logger.getLogger(GuiBootstrap.class);

    public GuiBootstrap(CommandLine commandLine) {
        super(commandLine);
    }

    @Override
    public int start() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiBootstrap.this.startImpl();
            }
        });
        return 0;
    }

    private void startImpl() {
        int n = super.start();
        if (n != 0) {
            System.exit(n);
        }
        BasicConfigurator.configure();
        this.logger.info((Object)GuiBootstrap.getStartingMessage());
        GuiBootstrap.setDefaultViewLocale(Constant.getLocale());
        this.setupLookAndFeel();
        if (GuiBootstrap.isFirstTime()) {
            this.showLicense();
        } else {
            this.init(false);
        }
    }

    private void init(final boolean bl) {
        try {
            this.initModel();
        }
        catch (Exception exception) {
            if (exception instanceof FileNotFoundException) {
                JOptionPane.showMessageDialog(null, Constant.messages.getString("start.db.error"), Constant.messages.getString("start.title.error"), 0);
            }
            this.logger.fatal((Object)exception.getMessage(), (Throwable)exception);
        }
        OptionsParam optionsParam = Model.getSingleton().getOptionsParam();
        OptionsParamView optionsParamView = optionsParam.getViewParam();
        FontUtils.setDefaultFont(optionsParamView.getFontName(), optionsParamView.getFontSize());
        View.setDisplayOption(optionsParamView.getDisplayOption());
        this.setupLocale(optionsParam);
        View.getSingleton().showSplashScreen();
        GuiBootstrap.promptForProxyDetailsIfNeeded(optionsParam);
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ExtensionAutoUpdate extensionAutoUpdate;
                try {
                    GuiBootstrap.this.initControlAndPostViewInit();
                }
                catch (Throwable throwable) {
                    if (!Constant.isDevBuild()) {
                        ErrorInfo errorInfo = new ErrorInfo(Constant.messages.getString("start.gui.dialog.fatal.error.title"), Constant.messages.getString("start.gui.dialog.fatal.error.message"), null, null, throwable, null, null);
                        JXErrorPane jXErrorPane = new JXErrorPane();
                        jXErrorPane.setErrorInfo(errorInfo);
                        JXErrorPane.showDialog((Component)View.getSingleton().getSplashScreen(), (JXErrorPane)jXErrorPane);
                    }
                    View.getSingleton().hideSplashScreen();
                    GuiBootstrap.this.logger.fatal((Object)"Failed to initialise GUI: ", throwable);
                    return;
                }
                GuiBootstrap.warnAddOnsAndExtensionsNoLongerRunnable();
                if (!bl && (extensionAutoUpdate = (ExtensionAutoUpdate)Control.getSingleton().getExtensionLoader().getExtension("ExtensionAutoUpdate")) != null) {
                    extensionAutoUpdate.alertIfNewVersions();
                }
            }
        });
        thread.setName("ZAP-BootstrapGUI");
        thread.setDaemon(false);
        thread.start();
    }

    private void initControlAndPostViewInit() throws Exception {
        Control.initSingletonWithView(this.getControlOverrides());
        final Control control = Control.getSingleton();
        final View view = View.getSingleton();
        EventQueue.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Path path;
                view.postInit();
                view.getMainFrame().setVisible(true);
                boolean bl = true;
                if (GuiBootstrap.this.getArgs().isEnabled("-session") && GuiBootstrap.this.getArgs().isEnabled("-newsession")) {
                    view.showWarningDialog(Constant.messages.getString("start.gui.cmdline.invalid.session.options", "-session", "-newsession", Constant.getZapHome()));
                } else if (GuiBootstrap.this.getArgs().isEnabled("-session")) {
                    path = SessionUtils.getSessionPath(GuiBootstrap.this.getArgs().getArgument("-session"));
                    if (!Files.exists(path, new LinkOption[0])) {
                        view.showWarningDialog(Constant.messages.getString("start.gui.cmdline.session.does.not.exist", Constant.getZapHome()));
                    } else {
                        bl = !control.getMenuFileControl().openSession(path.toAbsolutePath().toString());
                    }
                } else if (GuiBootstrap.this.getArgs().isEnabled("-newsession")) {
                    path = SessionUtils.getSessionPath(GuiBootstrap.this.getArgs().getArgument("-newsession"));
                    if (Files.exists(path, new LinkOption[0])) {
                        view.showWarningDialog(Constant.messages.getString("start.gui.cmdline.newsession.already.exist", Constant.getZapHome()));
                    } else {
                        bl = !control.getMenuFileControl().newSession(path.toAbsolutePath().toString());
                    }
                }
                view.hideSplashScreen();
                if (bl) {
                    try {
                        control.getMenuFileControl().newSession(false);
                    }
                    catch (Exception exception) {
                        GuiBootstrap.this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                        View.getSingleton().showWarningDialog(Constant.messages.getString("menu.file.newSession.error"));
                    }
                }
            }
        });
        try {
            control.getExtensionLoader().hookCommandLineListener(this.getArgs());
            control.runCommandLine();
        }
        catch (Exception exception) {
            this.logger.error((Object)exception.getMessage(), (Throwable)exception);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    view.showWarningDialog(exception.getMessage());
                }
            });
        }
    }

    private static void setDefaultViewLocale(Locale locale) {
        JComponent.setDefaultLocale(locale);
    }

    private void setupLookAndFeel() {
        block4: {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                if (Constant.isMacOsX()) {
                    this.setupOsXGui();
                    break block4;
                }
                for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
                    if (!"Nimbus".equals(lookAndFeelInfo.getName())) continue;
                    UIManager.setLookAndFeel(lookAndFeelInfo.getClassName());
                    break;
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException exception) {
                // empty catch block
            }
        }
    }

    private void setupOsXGui() {
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        System.setProperty("dock:name", "ZAP");
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", "ZAP");
        this.logger.info((Object)"Initializing OS X specific settings, despite Apple's best efforts");
        Application application = Application.getApplication();
        Image image = Toolkit.getDefaultToolkit().getImage(GuiBootstrap.class.getResource("/resource/zap1024x1024.png"));
        application.setDockIconImage(image);
        application.setAboutHandler(new OSXAboutHandler());
        application.setPreferencesHandler(new OSXPreferencesHandler());
        OSXQuitHandler oSXQuitHandler = new OSXQuitHandler();
        application.setQuitHandler(oSXQuitHandler);
    }

    private void setupLocale(OptionsParam optionsParam) {
        String string = optionsParam.getViewParam().getConfigLocale();
        if (string == null || string.length() == 0) {
            Locale locale = GuiBootstrap.determineUsersSystemLocale();
            if (locale == null) {
                GuiBootstrap.setDefaultViewLocale(Constant.getSystemsLocale());
                LocaleDialog localeDialog = new LocaleDialog(null, true);
                localeDialog.init(optionsParam);
                localeDialog.setVisible(true);
            } else {
                optionsParam.getViewParam().setLocale(locale);
            }
            GuiBootstrap.setDefaultViewLocale(GuiBootstrap.createLocale(optionsParam.getViewParam().getLocale().split("_")));
            Constant.setLocale(Model.getSingleton().getOptionsParam().getViewParam().getLocale());
            try {
                optionsParam.getViewParam().getConfig().save();
            }
            catch (ConfigurationException configurationException) {
                this.logger.warn((Object)"Failed to save locale: ", (Throwable)configurationException);
            }
        }
    }

    private static Locale determineUsersSystemLocale() {
        String[] stringArray;
        Locale locale = null;
        Locale locale2 = Constant.getSystemsLocale();
        for (String string : LocaleUtils.getAvailableLocales()) {
            stringArray = string.split("_");
            if (stringArray.length == 1 && locale2.getLanguage().equals(stringArray[0])) {
                locale = locale2;
                break;
            }
            if (stringArray.length == 2 && locale2.getLanguage().equals(stringArray[0]) && locale2.getCountry().equals(stringArray[1])) {
                locale = locale2;
                break;
            }
            if (stringArray.length != 3 || !locale2.getLanguage().equals(stringArray[0]) || !locale2.getCountry().equals(stringArray[1]) || !locale2.getVariant().equals(stringArray[2])) continue;
            locale = locale2;
            break;
        }
        if (locale == null) {
            for (String string : LocaleUtils.getAvailableLocales()) {
                stringArray = string.split("_");
                if (!locale2.getLanguage().equals(stringArray[0])) continue;
                locale = GuiBootstrap.createLocale(stringArray);
                break;
            }
        }
        return locale;
    }

    private static Locale createLocale(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Locale.Builder builder = new Locale.Builder();
        builder.setLanguage(stringArray[0]);
        if (stringArray.length >= 2) {
            builder.setRegion(stringArray[1]);
        }
        if (stringArray.length >= 3) {
            builder.setVariant(stringArray[2]);
        }
        return builder.build();
    }

    private static void promptForProxyDetailsIfNeeded(OptionsParam optionsParam) {
        if (optionsParam.getConnectionParam().isProxyChainPrompt()) {
            ProxyDialog proxyDialog = new ProxyDialog(null, true);
            proxyDialog.init(optionsParam);
            proxyDialog.setVisible(true);
        }
    }

    private void showLicense() {
        final LicenseFrame licenseFrame = new LicenseFrame();
        licenseFrame.setPostTask(new Runnable(){

            @Override
            public void run() {
                licenseFrame.dispose();
                if (!licenseFrame.isAccepted()) {
                    return;
                }
                try {
                    Files.createFile(Paths.get(Constant.getInstance().ACCEPTED_LICENSE, new String[0]), new FileAttribute[0]);
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(null, Constant.messages.getString("start.unknown.error"));
                    GuiBootstrap.this.logger.error((Object)"Failed to create 'accepted license' file: ", (Throwable)iOException);
                    return;
                }
                GuiBootstrap.this.init(true);
            }
        });
        licenseFrame.setVisible(true);
    }

    private static void warnAddOnsAndExtensionsNoLongerRunnable() {
        AddOnLoader addOnLoader = ExtensionFactory.getAddOnLoader();
        List<String> list = addOnLoader.getIdsAddOnsWithRunningIssuesSinceLastRun();
        if (list.isEmpty()) {
            return;
        }
        ArrayList<AddOn> arrayList = new ArrayList<AddOn>(list.size());
        for (String string : list) {
            arrayList.add(addOnLoader.getAddOnCollection().getAddOn(string));
        }
        AddOnRunIssuesUtils.showWarningMessageAddOnsNotRunnable(Constant.messages.getString("start.gui.warn.addOnsOrExtensionsNoLongerRunning"), addOnLoader.getAddOnCollection(), arrayList);
    }

    private static boolean isFirstTime() {
        Path path = Paths.get(Constant.getInstance().ACCEPTED_LICENSE, new String[0]);
        return Files.notExists(path, new LinkOption[0]);
    }
}

