/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.view.View;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.zaproxy.zap.extension.api.ApiAction;
import org.zaproxy.zap.extension.api.ApiException;
import org.zaproxy.zap.extension.api.ApiImplementor;
import org.zaproxy.zap.extension.api.ApiOther;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiView;
import org.zaproxy.zap.extension.api.OptionsParamApi;
import org.zaproxy.zap.extension.api.WebUI;

public class API {
    public static String API_DOMAIN = "zap";
    public static String API_URL = "http://" + API_DOMAIN + "/";
    public static String API_URL_S = "https://" + API_DOMAIN + "/";
    public static String API_KEY_PARAM = "apikey";
    private static Pattern patternParam = Pattern.compile("&", 2);
    private static final String CALL_BACK_URL = "/zapCallBackUrl/";
    private static final String STATUS_OK = "200 OK";
    private static final String STATUS_BAD_REQUEST = "400 Bad Request";
    private static final String STATUS_INTERNAL_SERVER_ERROR = "500 Internal Server Error";
    private Map<String, ApiImplementor> implementors = new HashMap<String, ApiImplementor>();
    private static API api = null;
    private WebUI webUI = new WebUI(this);
    private Map<String, ApiImplementor> callBacks = new HashMap<String, ApiImplementor>();
    private Map<String, ApiImplementor> shortcuts = new HashMap<String, ApiImplementor>();
    private Random random = new Random();
    private static final Logger logger = Logger.getLogger(API.class);

    private static synchronized API newInstance() {
        if (api == null) {
            api = new API();
        }
        return api;
    }

    public static API getInstance() {
        if (api == null) {
            API.newInstance();
        }
        return api;
    }

    public void registerApiImplementor(ApiImplementor apiImplementor) {
        if (this.implementors.get(apiImplementor.getPrefix()) != null) {
            logger.error((Object)("Second attempt to register API implementor with prefix of " + apiImplementor.getPrefix()));
            return;
        }
        this.implementors.put(apiImplementor.getPrefix(), apiImplementor);
        for (String string : apiImplementor.getApiShortcuts()) {
            logger.debug((Object)("Registering API shortcut: " + string));
            if (this.shortcuts.containsKey(string)) {
                logger.error((Object)("Duplicate API shortcut: " + string));
            }
            this.shortcuts.put("/" + string, apiImplementor);
        }
    }

    public void removeApiImplementor(ApiImplementor apiImplementor) {
        if (!this.implementors.containsKey(apiImplementor.getPrefix())) {
            logger.warn((Object)("Attempting to remove an API implementor not registered, with prefix: " + apiImplementor.getPrefix()));
            return;
        }
        this.implementors.remove(apiImplementor.getPrefix());
        for (String string : apiImplementor.getApiShortcuts()) {
            String string2 = "/" + string;
            if (!this.shortcuts.containsKey(string2)) continue;
            logger.debug((Object)("Removing registered API shortcut: " + string));
            this.shortcuts.remove(string2);
        }
    }

    public boolean isEnabled() {
        return !View.isInitialised() || API.getOptionsParamApi().isEnabled();
    }

    private static OptionsParamApi getOptionsParamApi() {
        return Model.getSingleton().getOptionsParam().getApiParam();
    }

    public boolean handleApiRequest(HttpRequestHeader httpRequestHeader, HttpInputStream httpInputStream, HttpOutputStream httpOutputStream) throws IOException {
        return this.handleApiRequest(httpRequestHeader, httpInputStream, httpOutputStream, false);
    }

    public boolean handleApiRequest(HttpRequestHeader httpRequestHeader, HttpInputStream httpInputStream, HttpOutputStream httpOutputStream, boolean bl) throws IOException {
        Map.Entry<String, ApiImplementor> entry2;
        Object object;
        Object object2;
        String string = httpRequestHeader.getURI().toString();
        Format format = Format.OTHER;
        ApiImplementor apiImplementor = null;
        ApiImplementor apiImplementor2 = null;
        if (string.contains(CALL_BACK_URL)) {
            logger.debug((Object)("handleApiRequest Callback: " + string));
            object2 = this.callBacks.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                if (!string.startsWith((String)object.getKey())) continue;
                apiImplementor = (ApiImplementor)object.getValue();
                break;
            }
        }
        if ((object2 = httpRequestHeader.getURI().getPath()) != null) {
            for (Map.Entry<String, ApiImplementor> entry2 : this.shortcuts.entrySet()) {
                if (!((String)object2).startsWith(entry2.getKey())) continue;
                apiImplementor2 = entry2.getValue();
                break;
            }
        }
        if (!(apiImplementor2 != null || apiImplementor != null || string.startsWith(API_URL) || string.startsWith(API_URL_S) || bl)) {
            return false;
        }
        if (this.getOptionsParamApi().isSecureOnly() && !httpRequestHeader.isSecure()) {
            logger.debug((Object)"handleApiRequest rejecting insecure request");
            return false;
        }
        logger.debug((Object)("handleApiRequest " + string));
        object = new HttpMessage();
        ((HttpMessage)object).setRequestHeader(httpRequestHeader);
        entry2 = null;
        ApiImplementor apiImplementor3 = null;
        RequestType requestType = null;
        String string2 = "text/plain; charset=UTF-8";
        String string3 = "";
        String string4 = null;
        boolean bl2 = false;
        try {
            JSONObject jSONObject = API.getParams(httpRequestHeader.getURI().getEscapedQuery());
            if (apiImplementor2 != null) {
                object = apiImplementor2.handleShortcut((HttpMessage)object);
            } else if (apiImplementor != null) {
                string3 = apiImplementor.handleCallBack((HttpMessage)object);
            } else {
                String[] stringArray = string.split("/");
                if (stringArray.length > 3 && stringArray[3].equalsIgnoreCase("favicon.ico")) {
                    InputStream inputStream = API.class.getResourceAsStream("/resource/zap.ico");
                    byte[] byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                    inputStream.close();
                    ((HttpMessage)object).setResponseHeader(API.getDefaultResponseHeader(string2));
                    ((HttpMessage)object).getResponseHeader().setContentLength(byArray.length);
                    httpOutputStream.write(((HttpMessage)object).getResponseHeader());
                    httpOutputStream.write(byArray);
                    httpOutputStream.flush();
                    httpOutputStream.close();
                    httpInputStream.close();
                    return true;
                }
                if (stringArray.length > 3) {
                    try {
                        format = Format.valueOf(stringArray[3].toUpperCase());
                        switch (format) {
                            case JSON: {
                                string2 = "application/json; charset=UTF-8";
                                break;
                            }
                            case JSONP: {
                                string2 = "application/javascript; charset=UTF-8";
                                break;
                            }
                            case XML: {
                                string2 = "text/xml; charset=UTF-8";
                                break;
                            }
                            case HTML: {
                                string2 = "text/html; charset=UTF-8";
                                break;
                            }
                            case UI: {
                                string2 = "text/html; charset=UTF-8";
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        format = Format.HTML;
                        throw new ApiException(ApiException.Type.BAD_FORMAT);
                    }
                }
                if (stringArray.length > 4 && (apiImplementor3 = this.implementors.get(entry2 = stringArray[4])) == null) {
                    throw new ApiException(ApiException.Type.NO_IMPLEMENTOR);
                }
                if (stringArray.length > 5) {
                    try {
                        requestType = RequestType.valueOf(stringArray[5]);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new ApiException(ApiException.Type.BAD_TYPE);
                    }
                }
                if (stringArray.length > 6 && (string4 = stringArray[6]) != null && string4.indexOf("?") > 0) {
                    string4 = string4.substring(0, string4.indexOf("?"));
                }
                if (format.equals((Object)Format.UI)) {
                    if (!this.isEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    string3 = this.webUI.handleRequest((String)((Object)entry2), apiImplementor3, requestType, string4);
                    string2 = "text/html; charset=UTF-8";
                } else if (string4 != null) {
                    if (!this.isEnabled()) {
                        throw new ApiException(ApiException.Type.DISABLED);
                    }
                    String string5 = this.getApiKey();
                    if (format.equals((Object)Format.JSONP)) {
                        if (!API.getOptionsParamApi().isEnableJSONP()) {
                            throw new ApiException(ApiException.Type.DISABLED);
                        }
                        if (!(string5 == null || string5.length() <= 0 || jSONObject.has(API_KEY_PARAM) && string5.equals(jSONObject.getString(API_KEY_PARAM)))) {
                            throw new ApiException(ApiException.Type.BAD_API_KEY);
                        }
                    }
                    block10 : switch (requestType) {
                        case action: {
                            ApiResponse apiResponse;
                            List<String> list;
                            if (!(string5 == null || string5.length() <= 0 || jSONObject.has(API_KEY_PARAM) && string5.equals(jSONObject.getString(API_KEY_PARAM)))) {
                                throw new ApiException(ApiException.Type.BAD_API_KEY);
                            }
                            ApiAction apiAction = apiImplementor3.getApiAction(string4);
                            if (apiAction != null && (list = apiAction.getMandatoryParamNames()) != null) {
                                for (String string6 : list) {
                                    if (jSONObject.has(string6) && jSONObject.getString(string6).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, string6);
                                }
                            }
                            if ((apiResponse = apiImplementor3.handleApiOptionAction(string4, jSONObject)) == null) {
                                apiResponse = apiImplementor3.handleApiAction(string4, jSONObject);
                            }
                            switch (format) {
                                case JSON: {
                                    string3 = apiResponse.toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    string3 = this.getJsonpWrapper(apiResponse.toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    string3 = this.responseToXml(string4, apiResponse);
                                    break block10;
                                }
                                case HTML: {
                                    string3 = this.responseToHtml(string4, apiResponse);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case view: {
                            ApiResponse apiResponse;
                            List<String> list;
                            ApiView apiView = apiImplementor3.getApiView(string4);
                            if (apiView != null && (list = apiView.getMandatoryParamNames()) != null) {
                                for (String string7 : list) {
                                    if (jSONObject.has(string7) && jSONObject.getString(string7).length() != 0) continue;
                                    throw new ApiException(ApiException.Type.MISSING_PARAMETER, string7);
                                }
                            }
                            if ((apiResponse = apiImplementor3.handleApiOptionView(string4, jSONObject)) == null) {
                                apiResponse = apiImplementor3.handleApiView(string4, jSONObject);
                            }
                            switch (format) {
                                case JSON: {
                                    string3 = apiResponse.toJSON().toString();
                                    break block10;
                                }
                                case JSONP: {
                                    string3 = this.getJsonpWrapper(apiResponse.toJSON().toString());
                                    break block10;
                                }
                                case XML: {
                                    string3 = this.responseToXml(string4, apiResponse);
                                    break block10;
                                }
                                case HTML: {
                                    string3 = this.responseToHtml(string4, apiResponse);
                                    break block10;
                                }
                            }
                            break;
                        }
                        case other: {
                            ApiOther apiOther = apiImplementor3.getApiOther(string4);
                            if (apiOther != null) {
                                if (!(string5 == null || string5.length() <= 0 || !apiOther.isRequiresApiKey() || jSONObject.has(API_KEY_PARAM) && string5.equals(jSONObject.getString(API_KEY_PARAM)))) {
                                    throw new ApiException(ApiException.Type.BAD_API_KEY);
                                }
                                List<String> list = apiOther.getMandatoryParamNames();
                                if (list != null) {
                                    for (String string8 : list) {
                                        if (jSONObject.has(string8) && jSONObject.getString(string8).length() != 0) continue;
                                        throw new ApiException(ApiException.Type.MISSING_PARAMETER, string8);
                                    }
                                }
                            }
                            object = apiImplementor3.handleApiOther((HttpMessage)object, string4, jSONObject);
                        }
                    }
                } else {
                    string3 = this.webUI.handleRequest(httpRequestHeader.getURI(), this.isEnabled());
                    format = Format.UI;
                    string2 = "text/html; charset=UTF-8";
                }
            }
            logger.debug((Object)("handleApiRequest returning: " + string3));
        }
        catch (Exception exception) {
            API.handleException((HttpMessage)object, format, string2, exception);
            bl2 = true;
        }
        if (!bl2 && !format.equals((Object)Format.OTHER) && apiImplementor2 == null) {
            ((HttpMessage)object).setResponseHeader(API.getDefaultResponseHeader(string2));
            ((HttpMessage)object).setResponseBody(string3);
            ((HttpMessage)object).getResponseHeader().setContentLength(((HttpMessage)object).getResponseBody().length());
        }
        if (apiImplementor3 != null) {
            apiImplementor3.addCustomHeaders(string4, requestType, (HttpMessage)object);
        }
        httpOutputStream.write(((HttpMessage)object).getResponseHeader());
        httpOutputStream.write(((HttpMessage)object).getResponseBody().getBytes());
        httpOutputStream.flush();
        httpOutputStream.close();
        httpInputStream.close();
        return true;
    }

    public String getBaseURL(Format format, String string, RequestType requestType, String string2, boolean bl) {
        String string3 = this.getApiKey();
        String string4 = API_URL;
        if (this.getOptionsParamApi().isSecureOnly()) {
            string4 = API_URL_S;
        }
        if (!bl) {
            ProxyParam proxyParam = Model.getSingleton().getOptionsParam().getProxyParam();
            string4 = this.getOptionsParamApi().isSecureOnly() ? "https://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/" : "http://" + proxyParam.getProxyIp() + ":" + proxyParam.getProxyPort() + "/";
        }
        if (!RequestType.view.equals((Object)requestType) && string3.length() > 0) {
            return string4 + format.name() + "/" + string + "/" + requestType.name() + "/" + string2 + "/?" + API_KEY_PARAM + "=" + string3 + "&";
        }
        return string4 + format.name() + "/" + string + "/" + requestType.name() + "/" + string2 + "/?";
    }

    private String responseToHtml(String string, ApiResponse apiResponse) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<head>\n");
        stringBuilder.append("</head>\n");
        stringBuilder.append("<body>\n");
        apiResponse.toHTML(stringBuilder);
        stringBuilder.append("</body>\n");
        return stringBuilder.toString();
    }

    private String responseToXml(String string, ApiResponse apiResponse) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement(string);
            document.appendChild(element);
            apiResponse.toXML(document, element);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource dOMSource = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            transformer.transform(dOMSource, streamResult);
            return stringWriter.toString();
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
            return "";
        }
    }

    public static JSONObject getParams(String string) throws ApiException {
        JSONObject jSONObject = new JSONObject();
        if (string == null || string.length() == 0) {
            return jSONObject;
        }
        String[] stringArray = patternParam.split(string);
        String string2 = null;
        String string3 = null;
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = null;
            n = stringArray[i].indexOf(61);
            if (n > 0) {
                try {
                    string2 = URLDecoder.decode(stringArray[i].substring(0, n), "UTF-8");
                    string3 = URLDecoder.decode(stringArray[i].substring(n + 1), "UTF-8");
                    jSONObject.put((Object)string2, (Object)string3);
                }
                catch (UnsupportedEncodingException | IllegalArgumentException exception) {
                    ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, string, exception);
                    logger.error((Object)apiException.getMessage(), (Throwable)apiException);
                }
                continue;
            }
            ApiException apiException = new ApiException(ApiException.Type.ILLEGAL_PARAMETER, string);
            logger.error((Object)apiException.getMessage(), (Throwable)apiException);
        }
        return jSONObject;
    }

    private String getJsonpWrapper(String string) {
        return "zapJsonpResult (" + string + " )";
    }

    public Map<String, ApiImplementor> getImplementors() {
        return Collections.unmodifiableMap(this.implementors);
    }

    public String getCallBackUrl(ApiImplementor apiImplementor, String string) {
        String string2 = string + CALL_BACK_URL + this.random.nextLong();
        this.callBacks.put(string2, apiImplementor);
        return string2;
    }

    public String getApiKey() {
        return API.getOptionsParamApi().getKey();
    }

    public static String getDefaultResponseHeader(String string) {
        return API.getDefaultResponseHeader(string, 0);
    }

    public static String getDefaultResponseHeader(String string, int n) {
        return API.getDefaultResponseHeader(STATUS_OK, string, n);
    }

    public static String getDefaultResponseHeader(String string, String string2, int n) {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("HTTP/1.1 ").append(string).append("\r\n");
        stringBuilder.append("Pragma: no-cache\r\n");
        stringBuilder.append("Cache-Control: no-cache\r\n");
        stringBuilder.append("Access-Control-Allow-Methods: GET,POST,OPTIONS\r\n");
        stringBuilder.append("Access-Control-Allow-Headers: ZAP-Header\r\n");
        stringBuilder.append("X-Clacks-Overhead: GNU Terry Pratchett\r\n");
        stringBuilder.append("Content-Length: ").append(n).append("\r\n");
        stringBuilder.append("Content-Type: ").append(string2).append("\r\n");
        return stringBuilder.toString();
    }

    private static void handleException(HttpMessage httpMessage, Format format, String string, Exception exception) {
        String string2 = STATUS_INTERNAL_SERVER_ERROR;
        if (format == Format.OTHER) {
            logger.error((Object)"API 'other' endpoint didn't handle exception:", (Throwable)exception);
        } else {
            ApiException apiException;
            if (exception instanceof ApiException) {
                apiException = (ApiException)exception;
                if (!ApiException.Type.INTERNAL_ERROR.equals((Object)apiException.getType())) {
                    string2 = STATUS_BAD_REQUEST;
                    logger.warn((Object)"ApiException while handling API request:", (Throwable)exception);
                }
            } else {
                apiException = new ApiException(ApiException.Type.INTERNAL_ERROR, (Throwable)exception);
                logger.error((Object)"Exception while handling API request:", (Throwable)exception);
            }
            String string3 = apiException.toString(format, API.getOptionsParamApi().isIncErrorDetails());
            httpMessage.setResponseBody(string3);
        }
        try {
            httpMessage.setResponseHeader(API.getDefaultResponseHeader(string2, string, httpMessage.getResponseBody().length()));
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            logger.warn((Object)"Failed to build API error response:", (Throwable)httpMalformedHeaderException);
        }
    }

    public static enum RequestType {
        action,
        view,
        other;

    }

    public static enum Format {
        XML,
        HTML,
        JSON,
        JSONP,
        UI,
        OTHER;

    }
}

