/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.zaproxy.zap.extension.api.API;
import org.zaproxy.zap.extension.api.ApiElement;
import org.zaproxy.zap.extension.api.ApiGeneratorUtils;
import org.zaproxy.zap.extension.api.ApiImplementor;

public class PhpAPIGenerator {
    private File dir;
    private boolean optional = false;
    private final String HEADER = "<?php\n/**\n * Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n";
    private final String OPTIONAL_MASSAGE = "This component is optional and therefore the API will only work if it is installed";
    private ResourceBundle msgs = ResourceBundle.getBundle("lang.Messages", Locale.ENGLISH, ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES));
    private static final Map<String, String> nameMap;

    public PhpAPIGenerator() {
        this.dir = new File("php/api/zapv2/src/Zap");
    }

    public PhpAPIGenerator(String string, boolean bl) {
        this.dir = new File(string);
        this.optional = bl;
    }

    public void generatePhpFiles(List<ApiImplementor> list) throws IOException {
        for (ApiImplementor apiImplementor : list) {
            this.generatePhpComponent(apiImplementor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void generatePhpElement(ApiElement apiElement, String string, String string2, Writer writer) throws IOException {
        void var9_15;
        String string32;
        String string4;
        boolean bl;
        block32: {
            bl = apiElement.getMandatoryParamNames() != null && apiElement.getMandatoryParamNames().size() > 0 || apiElement.getOptionalParamNames() != null && apiElement.getOptionalParamNames().size() > 0;
            String string5 = apiElement.getDescriptionTag();
            if (string5 == null) {
                string5 = string + ".api." + string2 + "." + apiElement.getName();
            }
            try {
                string4 = this.msgs.getString(string5);
                writer.write("\t/**\n");
                writer.write("\t * " + string4 + "\n");
                if (this.optional) {
                    writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                }
                writer.write("\t */\n");
            }
            catch (Exception exception) {
                System.out.println("No i18n for: " + string5);
                if (!this.optional) break block32;
                writer.write("\t/**\n");
                writer.write("\t * This component is optional and therefore the API will only work if it is installed\n");
                writer.write("\t */\n");
            }
        }
        writer.write("\tpublic function " + PhpAPIGenerator.createMethodName(apiElement.getName()) + "(");
        string4 = "";
        if (apiElement.getMandatoryParamNames() != null) {
            for (String object2 : apiElement.getMandatoryParamNames()) {
                if (string4 != "") {
                    string4 = string4 + ", ";
                }
                string4 = string4 + "$" + object2.toLowerCase();
            }
            writer.write(string4);
        }
        Object object3 = "";
        if (apiElement.getOptionalParamNames() != null) {
            for (String string32 : apiElement.getOptionalParamNames()) {
                if (string4 != "" || object3 != "") {
                    object3 = (String)object3 + ", ";
                }
                object3 = (String)object3 + "$" + string32.toLowerCase() + "=''";
            }
            writer.write((String)object3);
        }
        if (string2.equals("action") || string2.equals("other")) {
            if (bl) {
                writer.write(", ");
            }
            writer.write("$" + API.API_KEY_PARAM + "=''");
            bl = true;
        }
        writer.write(") {\n");
        String string5 = "request";
        string32 = "base";
        if (string2.equals("other")) {
            String string6 = string5 + "other";
            string32 = string32 + "other";
        }
        writer.write("\t\treturn $this->zap->" + (String)var9_15 + "($this->zap->" + string32 + " . '" + string + "/" + string2 + "/" + apiElement.getName() + "/'");
        if (bl) {
            writer.write(", array(");
            boolean bl2 = true;
            if (apiElement.getMandatoryParamNames() != null) {
                for (String string7 : apiElement.getMandatoryParamNames()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        writer.write(", ");
                    }
                    writer.write("'" + string7 + "' => $" + string7.toLowerCase());
                }
            }
            if (apiElement.getOptionalParamNames() != null) {
                for (String string7 : apiElement.getOptionalParamNames()) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        writer.write(", ");
                    }
                    writer.write("'" + string7 + "' => $" + string7.toLowerCase());
                }
            }
            if (string2.equals("action") || string2.equals("other")) {
                if (bl2) {
                    bl2 = false;
                } else {
                    writer.write(", ");
                }
                writer.write("'" + API.API_KEY_PARAM + "' => $" + API.API_KEY_PARAM);
            }
            writer.write("))");
            if (string2.equals("view")) {
                writer.write("->{'" + apiElement.getName() + "'};\n");
            } else {
                writer.write(";\n");
            }
        } else if (!string2.equals("other")) {
            if (apiElement.getName().startsWith("option")) {
                writer.write(")->{'" + apiElement.getName().substring(6) + "'};\n");
            } else {
                writer.write(")->{'" + apiElement.getName() + "'};\n");
            }
        } else {
            writer.write(");\n");
        }
        writer.write("\t}\n\n");
    }

    private static String createMethodName(String string) {
        if (nameMap.containsKey(string)) {
            string = nameMap.get(string);
        }
        return PhpAPIGenerator.removeAllFullStopCharacters(string);
    }

    private static String removeAllFullStopCharacters(String string) {
        return string.replaceAll("\\.", "");
    }

    private void generatePhpComponent(ApiImplementor apiImplementor) throws IOException {
        String string = PhpAPIGenerator.safeName(apiImplementor.getPrefix().substring(0, 1).toUpperCase() + apiImplementor.getPrefix().substring(1));
        File file = new File(this.dir, string + ".php");
        System.out.println("Generating " + file.getAbsolutePath());
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write("<?php\n/**\n * Zed Attack Proxy (ZAP) and its related class files.\n *\n * ZAP is an HTTP/HTTPS proxy for assessing web application security.\n *\n * Copyright the ZAP development team\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n\n");
        fileWriter.write("namespace Zap;\n\n");
        fileWriter.write("\n");
        fileWriter.write("/**\n");
        fileWriter.write(" * This file was automatically generated.\n");
        fileWriter.write(" */\n");
        fileWriter.write("class " + string + " {\n\n");
        fileWriter.write("\tpublic function __construct ($zap) {\n");
        fileWriter.write("\t\t$this->zap = $zap;\n");
        fileWriter.write("\t}\n\n");
        for (ApiElement apiElement : apiImplementor.getApiViews()) {
            this.generatePhpElement(apiElement, apiImplementor.getPrefix(), "view", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiActions()) {
            this.generatePhpElement(apiElement, apiImplementor.getPrefix(), "action", fileWriter);
        }
        for (ApiElement apiElement : apiImplementor.getApiOthers()) {
            this.generatePhpElement(apiElement, apiImplementor.getPrefix(), "other", fileWriter);
        }
        fileWriter.write("}\n");
        fileWriter.close();
    }

    private static String safeName(String string) {
        if (nameMap.containsKey(string)) {
            return nameMap.get(string);
        }
        return string;
    }

    public static void main(String[] stringArray) throws Exception {
        PhpAPIGenerator phpAPIGenerator = new PhpAPIGenerator();
        phpAPIGenerator.generatePhpFiles(ApiGeneratorUtils.getAllImplementors());
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("Break", "Brk");
        hashMap.put("break", "brk");
        nameMap = Collections.unmodifiableMap(hashMap);
    }
}

