/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.dynssl;

import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.security.SslCertificateService;
import org.parosproxy.paros.security.SslCertificateServiceImpl;
import org.zaproxy.zap.extension.dynssl.DynSSLParam;
import org.zaproxy.zap.extension.dynssl.DynamicSSLPanel;
import org.zaproxy.zap.extension.dynssl.SslCertificateUtils;

public class ExtensionDynSSL
extends ExtensionAdaptor {
    public static final String EXTENSION_ID = "ExtensionDynSSL";
    private DynSSLParam params;
    private DynamicSSLPanel optionsPanel;
    private final Logger logger = Logger.getLogger(ExtensionDynSSL.class);

    public ExtensionDynSSL() {
        this.setName(EXTENSION_ID);
        this.setOrder(54);
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookView().addOptionPanel(this.getOptionsPanel());
        }
        extensionHook.addOptionsParamSet(this.getParams());
    }

    @Override
    public void postInit() {
        if (this.getParams().getRootca() == null) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ExtensionDynSSL.this.createNewRootCa();
                    }
                    catch (Exception exception) {
                        ExtensionDynSSL.this.logger.error((Object)exception.getMessage(), (Throwable)exception);
                    }
                }
            }).start();
        }
    }

    @Override
    public void start() {
        SslCertificateService sslCertificateService = SslCertificateServiceImpl.getService();
        try {
            KeyStore keyStore = this.getParams().getRootca();
            sslCertificateService.initializeRootCA(keyStore);
        }
        catch (Exception exception) {
            this.logger.error((Object)"Couldn't initialize Root CA", (Throwable)exception);
        }
    }

    public void createNewRootCa() throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        this.logger.info((Object)"Creating new root CA");
        KeyStore keyStore = SslCertificateUtils.createRootCA();
        this.setRootCa(keyStore);
        this.getParams().setRootca(keyStore);
    }

    private DynamicSSLPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new DynamicSSLPanel(this);
        }
        return this.optionsPanel;
    }

    public DynSSLParam getParams() {
        if (this.params == null) {
            this.params = new DynSSLParam();
        }
        return this.params;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("dynssl.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public void setRootCa(KeyStore keyStore) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        SslCertificateServiceImpl.getService().initializeRootCA(keyStore);
    }

    public Certificate getRootCA() throws KeyStoreException {
        if (this.getParams().getRootca() == null) {
            return null;
        }
        return this.getParams().getRootca().getCertificate("owasp_zap_root_ca");
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

